@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EcsDeploymentSet].
 */
@PulumiTagMarker
public class EcsDeploymentSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsDeploymentSetArgs = EcsDeploymentSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsDeploymentSetArgsBuilder.() -> Unit) {
        val builder = EcsDeploymentSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsDeploymentSet {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsDeploymentSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsDeploymentSet(builtJavaResource)
    }
}

/**
 * Provides a ECS Deployment Set resource.
 * For information about ECS Deployment Set and how to use it, see [What is Deployment Set](https://www.alibabacloud.com/help/en/doc-detail/91269.htm).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsDeploymentSet("default", {
 *     strategy: "Availability",
 *     domain: "Default",
 *     granularity: "Host",
 *     deploymentSetName: "example_value",
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsDeploymentSet("default",
 *     strategy="Availability",
 *     domain="Default",
 *     granularity="Host",
 *     deployment_set_name="example_value",
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsDeploymentSet("default", new()
 *     {
 *         Strategy = "Availability",
 *         Domain = "Default",
 *         Granularity = "Host",
 *         DeploymentSetName = "example_value",
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsDeploymentSet(ctx, "default", &ecs.EcsDeploymentSetArgs{
 * 			Strategy:          pulumi.String("Availability"),
 * 			Domain:            pulumi.String("Default"),
 * 			Granularity:       pulumi.String("Host"),
 * 			DeploymentSetName: pulumi.String("example_value"),
 * 			Description:       pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsDeploymentSet;
 * import com.pulumi.alicloud.ecs.EcsDeploymentSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsDeploymentSet("default", EcsDeploymentSetArgs.builder()
 *             .strategy("Availability")
 *             .domain("Default")
 *             .granularity("Host")
 *             .deploymentSetName("example_value")
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsDeploymentSet
 *     properties:
 *       strategy: Availability
 *       domain: Default
 *       granularity: Host
 *       deploymentSetName: example_value
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Deployment Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDeploymentSet:EcsDeploymentSet example <id>
 * ```
 */
public class EcsDeploymentSet internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsDeploymentSet,
) : KotlinCustomResource(javaResource, EcsDeploymentSetMapper) {
    /**
     * The name of the deployment set. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
     */
    public val deploymentSetName: Output<String>?
        get() = javaResource.deploymentSetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the deployment set. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The deployment domain. Valid values: `Default`.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The deployment granularity. Valid values: `Host`.
     */
    public val granularity: Output<String>?
        get() = javaResource.granularity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The on unable to redeploy failed instance. Valid values: `CancelMembershipAndStart`, `KeepStopped`.
     * * `CancelMembershipAndStart` - Removes the instances from the deployment set and restarts the instances immediately after the failover is complete.
     * * `KeepStopped`- Keeps the instances in the abnormal state and restarts them after ECS resources are replenished.
     */
    public val onUnableToRedeployFailedInstance: Output<String>?
        get() = javaResource.onUnableToRedeployFailedInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The deployment strategy. Valid values: `Availability`(Default), `AvailabilityGroup`, `LowLatency`.
     */
    public val strategy: Output<String>?
        get() = javaResource.strategy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EcsDeploymentSetMapper : ResourceMapper<EcsDeploymentSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsDeploymentSet::class == javaResource::class

    override fun map(javaResource: Resource): EcsDeploymentSet = EcsDeploymentSet(
        javaResource as
            com.pulumi.alicloud.ecs.EcsDeploymentSet,
    )
}

/**
 * @see [EcsDeploymentSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsDeploymentSet].
 */
public suspend fun ecsDeploymentSet(
    name: String,
    block: suspend EcsDeploymentSetResourceBuilder.() -> Unit,
): EcsDeploymentSet {
    val builder = EcsDeploymentSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsDeploymentSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsDeploymentSet(name: String): EcsDeploymentSet {
    val builder = EcsDeploymentSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
