@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsDeploymentSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Deployment Set resource.
 * For information about ECS Deployment Set and how to use it, see [What is Deployment Set](https://www.alibabacloud.com/help/en/doc-detail/91269.htm).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsDeploymentSet("default", {
 *     strategy: "Availability",
 *     domain: "Default",
 *     granularity: "Host",
 *     deploymentSetName: "example_value",
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsDeploymentSet("default",
 *     strategy="Availability",
 *     domain="Default",
 *     granularity="Host",
 *     deployment_set_name="example_value",
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsDeploymentSet("default", new()
 *     {
 *         Strategy = "Availability",
 *         Domain = "Default",
 *         Granularity = "Host",
 *         DeploymentSetName = "example_value",
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsDeploymentSet(ctx, "default", &ecs.EcsDeploymentSetArgs{
 * 			Strategy:          pulumi.String("Availability"),
 * 			Domain:            pulumi.String("Default"),
 * 			Granularity:       pulumi.String("Host"),
 * 			DeploymentSetName: pulumi.String("example_value"),
 * 			Description:       pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsDeploymentSet;
 * import com.pulumi.alicloud.ecs.EcsDeploymentSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsDeploymentSet("default", EcsDeploymentSetArgs.builder()
 *             .strategy("Availability")
 *             .domain("Default")
 *             .granularity("Host")
 *             .deploymentSetName("example_value")
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsDeploymentSet
 *     properties:
 *       strategy: Availability
 *       domain: Default
 *       granularity: Host
 *       deploymentSetName: example_value
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Deployment Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDeploymentSet:EcsDeploymentSet example <id>
 * ```
 * @property deploymentSetName The name of the deployment set. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
 * @property description The description of the deployment set. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
 * @property domain The deployment domain. Valid values: `Default`.
 * @property granularity The deployment granularity. Valid values: `Host`.
 * @property onUnableToRedeployFailedInstance The on unable to redeploy failed instance. Valid values: `CancelMembershipAndStart`, `KeepStopped`.
 * * `CancelMembershipAndStart` - Removes the instances from the deployment set and restarts the instances immediately after the failover is complete.
 * * `KeepStopped`- Keeps the instances in the abnormal state and restarts them after ECS resources are replenished.
 * @property strategy The deployment strategy. Valid values: `Availability`(Default), `AvailabilityGroup`, `LowLatency`.
 */
public data class EcsDeploymentSetArgs(
    public val deploymentSetName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val granularity: Output<String>? = null,
    public val onUnableToRedeployFailedInstance: Output<String>? = null,
    public val strategy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsDeploymentSetArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsDeploymentSetArgs =
        com.pulumi.alicloud.ecs.EcsDeploymentSetArgs.builder()
            .deploymentSetName(deploymentSetName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .granularity(granularity?.applyValue({ args0 -> args0 }))
            .onUnableToRedeployFailedInstance(onUnableToRedeployFailedInstance?.applyValue({ args0 -> args0 }))
            .strategy(strategy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsDeploymentSetArgs].
 */
@PulumiTagMarker
public class EcsDeploymentSetArgsBuilder internal constructor() {
    private var deploymentSetName: Output<String>? = null

    private var description: Output<String>? = null

    private var domain: Output<String>? = null

    private var granularity: Output<String>? = null

    private var onUnableToRedeployFailedInstance: Output<String>? = null

    private var strategy: Output<String>? = null

    /**
     * @param value The name of the deployment set. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
     */
    @JvmName("ejhxycrqxoiucxcu")
    public suspend fun deploymentSetName(`value`: Output<String>) {
        this.deploymentSetName = value
    }

    /**
     * @param value The description of the deployment set. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("bmlfsaiqvwslebit")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The deployment domain. Valid values: `Default`.
     */
    @JvmName("ewgsciwfeusdwhsu")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The deployment granularity. Valid values: `Host`.
     */
    @JvmName("qtkvfjfbwjivegek")
    public suspend fun granularity(`value`: Output<String>) {
        this.granularity = value
    }

    /**
     * @param value The on unable to redeploy failed instance. Valid values: `CancelMembershipAndStart`, `KeepStopped`.
     * * `CancelMembershipAndStart` - Removes the instances from the deployment set and restarts the instances immediately after the failover is complete.
     * * `KeepStopped`- Keeps the instances in the abnormal state and restarts them after ECS resources are replenished.
     */
    @JvmName("qvtuddkqeechvfwt")
    public suspend fun onUnableToRedeployFailedInstance(`value`: Output<String>) {
        this.onUnableToRedeployFailedInstance = value
    }

    /**
     * @param value The deployment strategy. Valid values: `Availability`(Default), `AvailabilityGroup`, `LowLatency`.
     */
    @JvmName("teegrkrijytlgdws")
    public suspend fun strategy(`value`: Output<String>) {
        this.strategy = value
    }

    /**
     * @param value The name of the deployment set. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
     */
    @JvmName("rgkhyouutvoljslk")
    public suspend fun deploymentSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetName = mapped
    }

    /**
     * @param value The description of the deployment set. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("roiefhvcsavavntq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The deployment domain. Valid values: `Default`.
     */
    @JvmName("sesihpingihovtxe")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The deployment granularity. Valid values: `Host`.
     */
    @JvmName("ikyahxvasmwfyxsq")
    public suspend fun granularity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The on unable to redeploy failed instance. Valid values: `CancelMembershipAndStart`, `KeepStopped`.
     * * `CancelMembershipAndStart` - Removes the instances from the deployment set and restarts the instances immediately after the failover is complete.
     * * `KeepStopped`- Keeps the instances in the abnormal state and restarts them after ECS resources are replenished.
     */
    @JvmName("ecexpwsumrykgber")
    public suspend fun onUnableToRedeployFailedInstance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUnableToRedeployFailedInstance = mapped
    }

    /**
     * @param value The deployment strategy. Valid values: `Availability`(Default), `AvailabilityGroup`, `LowLatency`.
     */
    @JvmName("qmsoqxsfqfvrvldh")
    public suspend fun strategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    internal fun build(): EcsDeploymentSetArgs = EcsDeploymentSetArgs(
        deploymentSetName = deploymentSetName,
        description = description,
        domain = domain,
        granularity = granularity,
        onUnableToRedeployFailedInstance = onUnableToRedeployFailedInstance,
        strategy = strategy,
    )
}
