@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EcsDisk].
 */
@PulumiTagMarker
public class EcsDiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsDiskArgs = EcsDiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsDiskArgsBuilder.() -> Unit) {
        val builder = EcsDiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsDisk {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsDisk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsDisk(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * ECS Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDisk:EcsDisk example d-abcd12345
 * ```
 */
public class EcsDisk internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsDisk,
) : KotlinCustomResource(javaResource, EcsDiskMapper) {
    public val advancedFeatures: Output<String>?
        get() = javaResource.advancedFeatures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`. Default is `cloud_efficiency`.
     */
    public val category: Output<String>?
        get() = javaResource.category().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the automatic snapshot is deleted when the disk is released. Default value: `false`.
     */
    public val deleteAutoSnapshot: Output<Boolean>?
        get() = javaResource.deleteAutoSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the disk is released together with the instance. Default value: `false`.
     */
    public val deleteWithInstance: Output<Boolean>
        get() = javaResource.deleteWithInstance().applyValue({ args0 -> args0 })

    /**
     * Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with `http://` or `https://`. Default value is `null`.
     */
    public val diskName: Output<String>
        get() = javaResource.diskName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether to enable creating snapshot automatically.
     */
    public val enableAutoSnapshot: Output<Boolean>
        get() = javaResource.enableAutoSnapshot().applyValue({ args0 -> args0 })

    public val encryptAlgorithm: Output<String>?
        get() = javaResource.encryptAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the instance to which the created subscription disk is automatically attached.
     * * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
     * * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Payment method for disk. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`. If you want to change the disk payment type, the `instance_id` is required.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Specifies the performance level of an ESSD when you create the ESSD. Valid values:
     * * `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    public val performanceLevel: Output<String>
        get() = javaResource.performanceLevel().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the disk belongs. This attribute only supports adding or updating, not destroying.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    public val size: Output<Int>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The disk status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the storage set.
     */
    public val storageSetId: Output<String>?
        get() = javaResource.storageSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of partitions in the storage set.
     */
    public val storageSetPartitionNumber: Output<Int>?
        get() = javaResource.storageSetPartitionNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object EcsDiskMapper : ResourceMapper<EcsDisk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsDisk::class == javaResource::class

    override fun map(javaResource: Resource): EcsDisk = EcsDisk(
        javaResource as
            com.pulumi.alicloud.ecs.EcsDisk,
    )
}

/**
 * @see [EcsDisk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsDisk].
 */
public suspend fun ecsDisk(name: String, block: suspend EcsDiskResourceBuilder.() -> Unit): EcsDisk {
    val builder = EcsDiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsDisk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsDisk(name: String): EcsDisk {
    val builder = EcsDiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
