@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * ECS Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDisk:EcsDisk example d-abcd12345
 * ```
 * @property advancedFeatures
 * @property availabilityZone Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
 * @property category Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`. Default is `cloud_efficiency`.
 * @property deleteAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released. Default value: `false`.
 * @property deleteWithInstance Indicates whether the disk is released together with the instance. Default value: `false`.
 * @property description Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property diskName Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with `http://` or `https://`. Default value is `null`.
 * @property dryRun Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
 * @property enableAutoSnapshot Indicates whether to enable creating snapshot automatically.
 * @property encryptAlgorithm
 * @property encrypted If true, the disk will be encrypted, conflict with `snapshot_id`.
 * @property instanceId The ID of the instance to which the created subscription disk is automatically attached.
 * * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
 * * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
 * @property kmsKeyId The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
 * @property name Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
 * @property paymentType Payment method for disk. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`. If you want to change the disk payment type, the `instance_id` is required.
 * @property performanceLevel Specifies the performance level of an ESSD when you create the ESSD. Valid values:
 * * `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
 * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
 * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
 * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
 * @property resourceGroupId The Id of resource group which the disk belongs. This attribute only supports adding or updating, not destroying.
 * @property size The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
 * @property snapshotId A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
 * @property storageSetId The ID of the storage set.
 * @property storageSetPartitionNumber The number of partitions in the storage set.
 * @property tags A mapping of tags to assign to the resource.
 * @property type The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
 * @property zoneId ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
 */
public data class EcsDiskArgs(
    public val advancedFeatures: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val category: Output<String>? = null,
    public val deleteAutoSnapshot: Output<Boolean>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val diskName: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val enableAutoSnapshot: Output<Boolean>? = null,
    public val encryptAlgorithm: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val storageSetId: Output<String>? = null,
    public val storageSetPartitionNumber: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsDiskArgs =
        com.pulumi.alicloud.ecs.EcsDiskArgs.builder()
            .advancedFeatures(advancedFeatures?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteAutoSnapshot(deleteAutoSnapshot?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .enableAutoSnapshot(enableAutoSnapshot?.applyValue({ args0 -> args0 }))
            .encryptAlgorithm(encryptAlgorithm?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .storageSetId(storageSetId?.applyValue({ args0 -> args0 }))
            .storageSetPartitionNumber(storageSetPartitionNumber?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsDiskArgs].
 */
@PulumiTagMarker
public class EcsDiskArgsBuilder internal constructor() {
    private var advancedFeatures: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var category: Output<String>? = null

    private var deleteAutoSnapshot: Output<Boolean>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var diskName: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var enableAutoSnapshot: Output<Boolean>? = null

    private var encryptAlgorithm: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var storageSetId: Output<String>? = null

    private var storageSetPartitionNumber: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pwduubmlolyxfqoq")
    public suspend fun advancedFeatures(`value`: Output<String>) {
        this.advancedFeatures = value
    }

    /**
     * @param value Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("cgjevpthmksbregc")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`. Default is `cloud_efficiency`.
     */
    @JvmName("dxjjulcpbhasaaqy")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released. Default value: `false`.
     */
    @JvmName("ryvfbpfvscmpbdmv")
    public suspend fun deleteAutoSnapshot(`value`: Output<Boolean>) {
        this.deleteAutoSnapshot = value
    }

    /**
     * @param value Indicates whether the disk is released together with the instance. Default value: `false`.
     */
    @JvmName("dugsegtsuiolsihc")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("yjhpluadfyhidryw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with `http://` or `https://`. Default value is `null`.
     */
    @JvmName("qtrdafofbkyjyucm")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
     */
    @JvmName("xokugeisecocjhdc")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Indicates whether to enable creating snapshot automatically.
     */
    @JvmName("nojsdbtekkeeasja")
    public suspend fun enableAutoSnapshot(`value`: Output<Boolean>) {
        this.enableAutoSnapshot = value
    }

    /**
     * @param value
     */
    @JvmName("gtydduopfqvvdylh")
    public suspend fun encryptAlgorithm(`value`: Output<String>) {
        this.encryptAlgorithm = value
    }

    /**
     * @param value If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    @JvmName("xogoyhbtcimrwgre")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The ID of the instance to which the created subscription disk is automatically attached.
     * * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
     * * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    @JvmName("lsruylpqxnficdsm")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    @JvmName("evvmajtvedohaqgd")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    @JvmName("yntyoapytrpbcaqe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Payment method for disk. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`. If you want to change the disk payment type, the `instance_id` is required.
     */
    @JvmName("omhlncllvwtwfpxh")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Specifies the performance level of an ESSD when you create the ESSD. Valid values:
     * * `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    @JvmName("vphlijqgjlbymtpg")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The Id of resource group which the disk belongs. This attribute only supports adding or updating, not destroying.
     */
    @JvmName("wlajqnhrlglyvntw")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    @JvmName("ogiwgdbompqlgtpf")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    @JvmName("hwnruxwqrcdqipdx")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The ID of the storage set.
     */
    @JvmName("thxjgoicsmljlsyc")
    public suspend fun storageSetId(`value`: Output<String>) {
        this.storageSetId = value
    }

    /**
     * @param value The number of partitions in the storage set.
     */
    @JvmName("tdswrrxjrpuwwyfs")
    public suspend fun storageSetPartitionNumber(`value`: Output<Int>) {
        this.storageSetPartitionNumber = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("gnvsewjyqbgdcsft")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
     */
    @JvmName("jdybyhmmufqdmwun")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    @JvmName("mycrwmtedxkixdei")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value
     */
    @JvmName("nuqnuuukefgnubib")
    public suspend fun advancedFeatures(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedFeatures = mapped
    }

    /**
     * @param value Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("vbfxqppwhcsvdsus")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Category of the disk. Valid values are `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`. Default is `cloud_efficiency`.
     */
    @JvmName("daciygbgxcllxivq")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released. Default value: `false`.
     */
    @JvmName("jvjmktgfrvykaokv")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value Indicates whether the disk is released together with the instance. Default value: `false`.
     */
    @JvmName("hiswmqlrhxocxcfe")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value Description of the disk. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("ljmwqdijekdwjwve")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the ECS disk. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with `http://` or `https://`. Default value is `null`.
     */
    @JvmName("ctbvqtuouysmetfx")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
     */
    @JvmName("ovrleheowftvbnbe")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Indicates whether to enable creating snapshot automatically.
     */
    @JvmName("gejykxctkovqikyh")
    public suspend fun enableAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoSnapshot = mapped
    }

    /**
     * @param value
     */
    @JvmName("ogmyasylqatqtpbv")
    public suspend fun encryptAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptAlgorithm = mapped
    }

    /**
     * @param value If true, the disk will be encrypted, conflict with `snapshot_id`.
     */
    @JvmName("evuifephyvpcimtt")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The ID of the instance to which the created subscription disk is automatically attached.
     * * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
     * * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    @JvmName("ujiuygnbtntyuoct")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the KMS key corresponding to the data disk, The specified parameter `Encrypted` must be `true` when KmsKeyId is not empty.
     */
    @JvmName("rknmgypufpxnacmd")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.122.0. New field 'disk_name' instead.
  """,
    )
    @JvmName("rqxxfnlefcuokmfg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Payment method for disk. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`. If you want to change the disk payment type, the `instance_id` is required.
     */
    @JvmName("isyhxkkndppjmxmu")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Specifies the performance level of an ESSD when you create the ESSD. Valid values:
     * * `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
     */
    @JvmName("mrkevbpiibdasahn")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The Id of resource group which the disk belongs. This attribute only supports adding or updating, not destroying.
     */
    @JvmName("nqwumdclltylmmwq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The size of the disk in GiBs. When resize the disk, the new size must be greater than the former value, or you would get an error `InvalidDiskSize.TooSmall`.
     */
    @JvmName("cdwhbtsrntkpbxjg")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value A snapshot to base the disk off of. If the disk size required by snapshot is greater than `size`, the `size` will be ignored, conflict with `encrypted`.
     */
    @JvmName("gbosmevahsdoqvfr")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The ID of the storage set.
     */
    @JvmName("pvuwwwtpxkboqutf")
    public suspend fun storageSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSetId = mapped
    }

    /**
     * @param value The number of partitions in the storage set.
     */
    @JvmName("fkceybxumaygmpyn")
    public suspend fun storageSetPartitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSetPartitionNumber = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("fvtexdajchgrvxnj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("tuopvvexielsghvd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
     */
    @JvmName("woicnqwkxfurkhfe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
     */
    @JvmName("kcscbhfbusdxupeu")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): EcsDiskArgs = EcsDiskArgs(
        advancedFeatures = advancedFeatures,
        availabilityZone = availabilityZone,
        category = category,
        deleteAutoSnapshot = deleteAutoSnapshot,
        deleteWithInstance = deleteWithInstance,
        description = description,
        diskName = diskName,
        dryRun = dryRun,
        enableAutoSnapshot = enableAutoSnapshot,
        encryptAlgorithm = encryptAlgorithm,
        encrypted = encrypted,
        instanceId = instanceId,
        kmsKeyId = kmsKeyId,
        name = name,
        paymentType = paymentType,
        performanceLevel = performanceLevel,
        resourceGroupId = resourceGroupId,
        size = size,
        snapshotId = snapshotId,
        storageSetId = storageSetId,
        storageSetPartitionNumber = storageSetPartitionNumber,
        tags = tags,
        type = type,
        zoneId = zoneId,
    )
}
