@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EcsDiskAttachment].
 */
@PulumiTagMarker
public class EcsDiskAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsDiskAttachmentArgs = EcsDiskAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsDiskAttachmentArgsBuilder.() -> Unit) {
        val builder = EcsDiskAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsDiskAttachment {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsDiskAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsDiskAttachment(builtJavaResource)
    }
}

/**
 * Provides an Alicloud ECS Disk Attachment as a resource, to attach and detach disks from ECS Instances.
 * For information about ECS Disk Attachment and how to use it, see [What is Disk Attachment](https://www.alibabacloud.com/help/en/doc-detail/25515.htm).
 * > **NOTE:** Available since v1.122.0+.
 * ## Example Usage
 * Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     instanceTypeFamily: "ecs.sn1ne",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.4.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: "tf-example",
 *     description: "New security group",
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: name,
 *     hostName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 * });
 * const disk = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultEcsDisk = new alicloud.ecs.EcsDisk("default", {
 *     zoneId: disk.then(disk => disk.zones?.[0]?.id),
 *     category: "cloud_efficiency",
 *     deleteAutoSnapshot: true,
 *     description: "Test For Terraform",
 *     diskName: name,
 *     enableAutoSnapshot: true,
 *     encrypted: true,
 *     size: 500,
 *     tags: {
 *         Created: "TF",
 *         Environment: "Acceptance-test",
 *     },
 * });
 * const defaultEcsDiskAttachment = new alicloud.ecs.EcsDiskAttachment("default", {
 *     diskId: defaultEcsDisk.id,
 *     instanceId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     instance_type_family="ecs.sn1ne")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="10.4.0.0/24",
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name="tf-example",
 *     description="New security group",
 *     vpc_id=default_network.id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name=name,
 *     host_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id)
 * disk = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_ecs_disk = alicloud.ecs.EcsDisk("default",
 *     zone_id=disk.zones[0].id,
 *     category="cloud_efficiency",
 *     delete_auto_snapshot=True,
 *     description="Test For Terraform",
 *     disk_name=name,
 *     enable_auto_snapshot=True,
 *     encrypted=True,
 *     size=500,
 *     tags={
 *         "Created": "TF",
 *         "Environment": "Acceptance-test",
 *     })
 * default_ecs_disk_attachment = alicloud.ecs.EcsDiskAttachment("default",
 *     disk_id=default_ecs_disk.id,
 *     instance_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         InstanceTypeFamily = "ecs.sn1ne",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.4.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "tf-example",
 *         Description = "New security group",
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = name,
 *         HostName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var disk = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultEcsDisk = new AliCloud.Ecs.EcsDisk("default", new()
 *     {
 *         ZoneId = disk.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Category = "cloud_efficiency",
 *         DeleteAutoSnapshot = true,
 *         Description = "Test For Terraform",
 *         DiskName = name,
 *         EnableAutoSnapshot = true,
 *         Encrypted = true,
 *         Size = 500,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "Environment", "Acceptance-test" },
 *         },
 *     });
 *     var defaultEcsDiskAttachment = new AliCloud.Ecs.EcsDiskAttachment("default", new()
 *     {
 *         DiskId = defaultEcsDisk.Id,
 *         InstanceId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.sn1ne"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:     defaultNetwork.ID(),
 * 			CidrBlock: pulumi.String("10.4.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String("tf-example"),
 * 			Description: pulumi.String("New security group"),
 * 			VpcId:       defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			HostName:         pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId: defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		disk, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcsDisk, err := ecs.NewEcsDisk(ctx, "default", &ecs.EcsDiskArgs{
 * 			ZoneId:             pulumi.String(disk.Zones[0].Id),
 * 			Category:           pulumi.String("cloud_efficiency"),
 * 			DeleteAutoSnapshot: pulumi.Bool(true),
 * 			Description:        pulumi.String("Test For Terraform"),
 * 			DiskName:           pulumi.String(name),
 * 			EnableAutoSnapshot: pulumi.Bool(true),
 * 			Encrypted:          pulumi.Bool(true),
 * 			Size:               pulumi.Int(500),
 * 			Tags: pulumi.StringMap{
 * 				"Created":     pulumi.String("TF"),
 * 				"Environment": pulumi.String("Acceptance-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsDiskAttachment(ctx, "default", &ecs.EcsDiskAttachmentArgs{
 * 			DiskId:     defaultEcsDisk.ID(),
 * 			InstanceId: defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.EcsDisk;
 * import com.pulumi.alicloud.ecs.EcsDiskArgs;
 * import com.pulumi.alicloud.ecs.EcsDiskAttachment;
 * import com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceTypeFamily("ecs.sn1ne")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.4.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name("tf-example")
 *             .description("New security group")
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName(name)
 *             .hostName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         final var disk = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultEcsDisk = new EcsDisk("defaultEcsDisk", EcsDiskArgs.builder()
 *             .zoneId(disk.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .category("cloud_efficiency")
 *             .deleteAutoSnapshot("true")
 *             .description("Test For Terraform")
 *             .diskName(name)
 *             .enableAutoSnapshot("true")
 *             .encrypted("true")
 *             .size("500")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("Environment", "Acceptance-test")
 *             ))
 *             .build());
 *         var defaultEcsDiskAttachment = new EcsDiskAttachment("defaultEcsDiskAttachment", EcsDiskAttachmentArgs.builder()
 *             .diskId(defaultEcsDisk.id())
 *             .instanceId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   # Create a new ECS disk-attachment and use it attach one disk to a new instance.
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.4.0.0/24
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: tf-example
 *       description: New security group
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: ${name}
 *       hostName: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *   defaultEcsDisk:
 *     type: alicloud:ecs:EcsDisk
 *     name: default
 *     properties:
 *       zoneId: ${disk.zones[0].id}
 *       category: cloud_efficiency
 *       deleteAutoSnapshot: 'true'
 *       description: Test For Terraform
 *       diskName: ${name}
 *       enableAutoSnapshot: 'true'
 *       encrypted: 'true'
 *       size: '500'
 *       tags:
 *         Created: TF
 *         Environment: Acceptance-test
 *   defaultEcsDiskAttachment:
 *     type: alicloud:ecs:EcsDiskAttachment
 *     name: default
 *     properties:
 *       diskId: ${defaultEcsDisk.id}
 *       instanceId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         instanceTypeFamily: ecs.sn1ne
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 *   disk:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The disk attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDiskAttachment:EcsDiskAttachment example d-abc12345678:i-abc12355
 * ```
 */
public class EcsDiskAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsDiskAttachment,
) : KotlinCustomResource(javaResource, EcsDiskAttachmentMapper) {
    /**
     * Whether to mount as a system disk. Default to: `false`.
     */
    public val bootable: Output<Boolean>?
        get() = javaResource.bootable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the disk is released together with the instance. Default to: `false`.
     */
    public val deleteWithInstance: Output<Boolean>?
        get() = javaResource.deleteWithInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the cloud disk device.
     */
    public val device: Output<String>
        get() = javaResource.device().applyValue({ args0 -> args0 })

    /**
     * ID of the Disk to be attached.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * ID of the Instance to attach to.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The name of key pair
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When mounting the system disk, setting the user name and password of the instance is only effective for the administrator and root user names, and other user names are not effective.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EcsDiskAttachmentMapper : ResourceMapper<EcsDiskAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsDiskAttachment::class == javaResource::class

    override fun map(javaResource: Resource): EcsDiskAttachment = EcsDiskAttachment(
        javaResource as
            com.pulumi.alicloud.ecs.EcsDiskAttachment,
    )
}

/**
 * @see [EcsDiskAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsDiskAttachment].
 */
public suspend fun ecsDiskAttachment(
    name: String,
    block: suspend EcsDiskAttachmentResourceBuilder.() -> Unit,
): EcsDiskAttachment {
    val builder = EcsDiskAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsDiskAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsDiskAttachment(name: String): EcsDiskAttachment {
    val builder = EcsDiskAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
