@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Alicloud ECS Disk Attachment as a resource, to attach and detach disks from ECS Instances.
 * For information about ECS Disk Attachment and how to use it, see [What is Disk Attachment](https://www.alibabacloud.com/help/en/doc-detail/25515.htm).
 * > **NOTE:** Available since v1.122.0+.
 * ## Example Usage
 * Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     instanceTypeFamily: "ecs.sn1ne",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.4.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: "tf-example",
 *     description: "New security group",
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: name,
 *     hostName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 * });
 * const disk = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultEcsDisk = new alicloud.ecs.EcsDisk("default", {
 *     zoneId: disk.then(disk => disk.zones?.[0]?.id),
 *     category: "cloud_efficiency",
 *     deleteAutoSnapshot: true,
 *     description: "Test For Terraform",
 *     diskName: name,
 *     enableAutoSnapshot: true,
 *     encrypted: true,
 *     size: 500,
 *     tags: {
 *         Created: "TF",
 *         Environment: "Acceptance-test",
 *     },
 * });
 * const defaultEcsDiskAttachment = new alicloud.ecs.EcsDiskAttachment("default", {
 *     diskId: defaultEcsDisk.id,
 *     instanceId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     instance_type_family="ecs.sn1ne")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="10.4.0.0/24",
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name="tf-example",
 *     description="New security group",
 *     vpc_id=default_network.id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name=name,
 *     host_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id)
 * disk = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_ecs_disk = alicloud.ecs.EcsDisk("default",
 *     zone_id=disk.zones[0].id,
 *     category="cloud_efficiency",
 *     delete_auto_snapshot=True,
 *     description="Test For Terraform",
 *     disk_name=name,
 *     enable_auto_snapshot=True,
 *     encrypted=True,
 *     size=500,
 *     tags={
 *         "Created": "TF",
 *         "Environment": "Acceptance-test",
 *     })
 * default_ecs_disk_attachment = alicloud.ecs.EcsDiskAttachment("default",
 *     disk_id=default_ecs_disk.id,
 *     instance_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         InstanceTypeFamily = "ecs.sn1ne",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.4.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "tf-example",
 *         Description = "New security group",
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = name,
 *         HostName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var disk = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultEcsDisk = new AliCloud.Ecs.EcsDisk("default", new()
 *     {
 *         ZoneId = disk.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Category = "cloud_efficiency",
 *         DeleteAutoSnapshot = true,
 *         Description = "Test For Terraform",
 *         DiskName = name,
 *         EnableAutoSnapshot = true,
 *         Encrypted = true,
 *         Size = 500,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "Environment", "Acceptance-test" },
 *         },
 *     });
 *     var defaultEcsDiskAttachment = new AliCloud.Ecs.EcsDiskAttachment("default", new()
 *     {
 *         DiskId = defaultEcsDisk.Id,
 *         InstanceId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.sn1ne"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:     defaultNetwork.ID(),
 * 			CidrBlock: pulumi.String("10.4.0.0/24"),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String("tf-example"),
 * 			Description: pulumi.String("New security group"),
 * 			VpcId:       defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			HostName:         pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId: defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		disk, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcsDisk, err := ecs.NewEcsDisk(ctx, "default", &ecs.EcsDiskArgs{
 * 			ZoneId:             pulumi.String(disk.Zones[0].Id),
 * 			Category:           pulumi.String("cloud_efficiency"),
 * 			DeleteAutoSnapshot: pulumi.Bool(true),
 * 			Description:        pulumi.String("Test For Terraform"),
 * 			DiskName:           pulumi.String(name),
 * 			EnableAutoSnapshot: pulumi.Bool(true),
 * 			Encrypted:          pulumi.Bool(true),
 * 			Size:               pulumi.Int(500),
 * 			Tags: pulumi.StringMap{
 * 				"Created":     pulumi.String("TF"),
 * 				"Environment": pulumi.String("Acceptance-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsDiskAttachment(ctx, "default", &ecs.EcsDiskAttachmentArgs{
 * 			DiskId:     defaultEcsDisk.ID(),
 * 			InstanceId: defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.EcsDisk;
 * import com.pulumi.alicloud.ecs.EcsDiskArgs;
 * import com.pulumi.alicloud.ecs.EcsDiskAttachment;
 * import com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceTypeFamily("ecs.sn1ne")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.4.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name("tf-example")
 *             .description("New security group")
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName(name)
 *             .hostName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         final var disk = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultEcsDisk = new EcsDisk("defaultEcsDisk", EcsDiskArgs.builder()
 *             .zoneId(disk.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .category("cloud_efficiency")
 *             .deleteAutoSnapshot("true")
 *             .description("Test For Terraform")
 *             .diskName(name)
 *             .enableAutoSnapshot("true")
 *             .encrypted("true")
 *             .size("500")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("Environment", "Acceptance-test")
 *             ))
 *             .build());
 *         var defaultEcsDiskAttachment = new EcsDiskAttachment("defaultEcsDiskAttachment", EcsDiskAttachmentArgs.builder()
 *             .diskId(defaultEcsDisk.id())
 *             .instanceId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   # Create a new ECS disk-attachment and use it attach one disk to a new instance.
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.4.0.0/24
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: tf-example
 *       description: New security group
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: ${name}
 *       hostName: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *   defaultEcsDisk:
 *     type: alicloud:ecs:EcsDisk
 *     name: default
 *     properties:
 *       zoneId: ${disk.zones[0].id}
 *       category: cloud_efficiency
 *       deleteAutoSnapshot: 'true'
 *       description: Test For Terraform
 *       diskName: ${name}
 *       enableAutoSnapshot: 'true'
 *       encrypted: 'true'
 *       size: '500'
 *       tags:
 *         Created: TF
 *         Environment: Acceptance-test
 *   defaultEcsDiskAttachment:
 *     type: alicloud:ecs:EcsDiskAttachment
 *     name: default
 *     properties:
 *       diskId: ${defaultEcsDisk.id}
 *       instanceId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         instanceTypeFamily: ecs.sn1ne
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 *   disk:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The disk attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsDiskAttachment:EcsDiskAttachment example d-abc12345678:i-abc12355
 * ```
 * @property bootable Whether to mount as a system disk. Default to: `false`.
 * @property deleteWithInstance Indicates whether the disk is released together with the instance. Default to: `false`.
 * @property diskId ID of the Disk to be attached.
 * @property instanceId ID of the Instance to attach to.
 * @property keyPairName The name of key pair
 * @property password When mounting the system disk, setting the user name and password of the instance is only effective for the administrator and root user names, and other user names are not effective.
 */
public data class EcsDiskAttachmentArgs(
    public val bootable: Output<Boolean>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val diskId: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val password: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs =
        com.pulumi.alicloud.ecs.EcsDiskAttachmentArgs.builder()
            .bootable(bootable?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsDiskAttachmentArgs].
 */
@PulumiTagMarker
public class EcsDiskAttachmentArgsBuilder internal constructor() {
    private var bootable: Output<Boolean>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var diskId: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var password: Output<String>? = null

    /**
     * @param value Whether to mount as a system disk. Default to: `false`.
     */
    @JvmName("aljipwarmwksjpin")
    public suspend fun bootable(`value`: Output<Boolean>) {
        this.bootable = value
    }

    /**
     * @param value Indicates whether the disk is released together with the instance. Default to: `false`.
     */
    @JvmName("adgnneodtgjvjfia")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value ID of the Disk to be attached.
     */
    @JvmName("giyrpkywlyvxelqe")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value ID of the Instance to attach to.
     */
    @JvmName("vttqbypkcptmoxhk")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of key pair
     */
    @JvmName("ufureqiajuetsknc")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value When mounting the system disk, setting the user name and password of the instance is only effective for the administrator and root user names, and other user names are not effective.
     */
    @JvmName("bricmasuuktqcqun")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Whether to mount as a system disk. Default to: `false`.
     */
    @JvmName("dmfljxcxmksjgrhx")
    public suspend fun bootable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootable = mapped
    }

    /**
     * @param value Indicates whether the disk is released together with the instance. Default to: `false`.
     */
    @JvmName("rtbiuectbtjtterp")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value ID of the Disk to be attached.
     */
    @JvmName("jmtdqfclfgrnohws")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value ID of the Instance to attach to.
     */
    @JvmName("qcvmpayhnabnnduv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of key pair
     */
    @JvmName("duaqljfxoulddnbw")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value When mounting the system disk, setting the user name and password of the instance is only effective for the administrator and root user names, and other user names are not effective.
     */
    @JvmName("qowxarkjlgnnagha")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    internal fun build(): EcsDiskAttachmentArgs = EcsDiskAttachmentArgs(
        bootable = bootable,
        deleteWithInstance = deleteWithInstance,
        diskId = diskId,
        instanceId = instanceId,
        keyPairName = keyPairName,
        password = password,
    )
}
