@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsFunctions.getActivationsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getAutoSnapshotPoliciesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getCapacityReservationsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getCommandsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getDedicatedHostsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getDisksPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsDedicatedHostClustersPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsDeploymentSetsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsDisksPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsImageComponentsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsImagePipelinePlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsInvocationsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsKeyPairsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsLaunchTemplatesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsNetworkInterfacePermissionsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsNetworkInterfacesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsPrefixListsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsSnapshotGroupsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsSnapshotsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEcsStorageCapacityUnitsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEipAddressesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getEipsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getElasticityAssurancesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getHpcClustersPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getImagesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getInstanceKeywordsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getInstanceTypeFamiliesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getInstanceTypesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getInstancesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getKeyPairsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getNetworkInterfacesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getSecurityGroupRulesPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getSecurityGroupsPlain
import com.pulumi.alicloud.ecs.EcsFunctions.getSnapshotsPlain
import com.pulumi.alicloud.ecs.kotlin.inputs.GetActivationsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetActivationsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetAutoSnapshotPoliciesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetAutoSnapshotPoliciesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetCapacityReservationsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetCapacityReservationsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetCommandsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetCommandsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDedicatedHostsOperationLock
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDedicatedHostsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDedicatedHostsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDisksOperationLock
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDisksPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetDisksPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDedicatedHostClustersPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDedicatedHostClustersPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDeploymentSetsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDeploymentSetsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDisksOperationLock
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDisksPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsDisksPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsImageComponentsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsImageComponentsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsImagePipelinePlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsImagePipelinePlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsInvocationsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsInvocationsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsKeyPairsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsKeyPairsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsLaunchTemplatesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsLaunchTemplatesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsNetworkInterfacePermissionsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsNetworkInterfacePermissionsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsNetworkInterfacesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsNetworkInterfacesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsPrefixListsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsPrefixListsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsSnapshotGroupsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsSnapshotGroupsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsSnapshotsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsStorageCapacityUnitsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEcsStorageCapacityUnitsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEipAddressesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEipAddressesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEipsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetEipsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetElasticityAssurancesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetElasticityAssurancesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetHpcClustersPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetHpcClustersPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetImagesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetImagesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceKeywordsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceKeywordsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceTypeFamiliesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceTypeFamiliesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceTypesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstanceTypesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetKeyPairsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetKeyPairsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetNetworkInterfacesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetNetworkInterfacesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSecurityGroupRulesPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSecurityGroupRulesPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSecurityGroupsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSecurityGroupsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSnapshotsPlainArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.GetSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.outputs.GetActivationsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetAutoSnapshotPoliciesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetCapacityReservationsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetCommandsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDedicatedHostClustersResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDeploymentSetsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDisksResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsImageComponentsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsImagePipelineResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsInvocationsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsKeyPairsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacePermissionsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsPrefixListsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsSnapshotGroupsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsSnapshotsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsStorageCapacityUnitsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEipAddressesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEipsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetElasticityAssurancesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetHpcClustersResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetImagesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceKeywordsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypeFamiliesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetKeyPairsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetNetworkInterfacesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSecurityGroupRulesResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSecurityGroupsResult
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSnapshotsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ecs.kotlin.outputs.GetActivationsResult.Companion.toKotlin as getActivationsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetAutoSnapshotPoliciesResult.Companion.toKotlin as getAutoSnapshotPoliciesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetCapacityReservationsResult.Companion.toKotlin as getCapacityReservationsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetCommandsResult.Companion.toKotlin as getCommandsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetDedicatedHostsResult.Companion.toKotlin as getDedicatedHostsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetDisksResult.Companion.toKotlin as getDisksResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDedicatedHostClustersResult.Companion.toKotlin as getEcsDedicatedHostClustersResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDeploymentSetsResult.Companion.toKotlin as getEcsDeploymentSetsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsDisksResult.Companion.toKotlin as getEcsDisksResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsImageComponentsResult.Companion.toKotlin as getEcsImageComponentsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsImagePipelineResult.Companion.toKotlin as getEcsImagePipelineResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsInvocationsResult.Companion.toKotlin as getEcsInvocationsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsKeyPairsResult.Companion.toKotlin as getEcsKeyPairsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsLaunchTemplatesResult.Companion.toKotlin as getEcsLaunchTemplatesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacePermissionsResult.Companion.toKotlin as getEcsNetworkInterfacePermissionsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsNetworkInterfacesResult.Companion.toKotlin as getEcsNetworkInterfacesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsPrefixListsResult.Companion.toKotlin as getEcsPrefixListsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsSnapshotGroupsResult.Companion.toKotlin as getEcsSnapshotGroupsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsSnapshotsResult.Companion.toKotlin as getEcsSnapshotsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEcsStorageCapacityUnitsResult.Companion.toKotlin as getEcsStorageCapacityUnitsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEipAddressesResult.Companion.toKotlin as getEipAddressesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetEipsResult.Companion.toKotlin as getEipsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetElasticityAssurancesResult.Companion.toKotlin as getElasticityAssurancesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetHpcClustersResult.Companion.toKotlin as getHpcClustersResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetImagesResult.Companion.toKotlin as getImagesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceKeywordsResult.Companion.toKotlin as getInstanceKeywordsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypeFamiliesResult.Companion.toKotlin as getInstanceTypeFamiliesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstanceTypesResult.Companion.toKotlin as getInstanceTypesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetKeyPairsResult.Companion.toKotlin as getKeyPairsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetNetworkInterfacesResult.Companion.toKotlin as getNetworkInterfacesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSecurityGroupRulesResult.Companion.toKotlin as getSecurityGroupRulesResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSecurityGroupsResult.Companion.toKotlin as getSecurityGroupsResultToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.GetSnapshotsResult.Companion.toKotlin as getSnapshotsResultToKotlin

public object EcsFunctions {
    /**
     * This data source provides the Ecs Activations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.177.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getActivations({});
     * export const ecsActivationId1 = ids.then(ids => ids.activations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_activations()
     * pulumi.export("ecsActivationId1", ids.activations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetActivations.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsActivationId1"] = ids&#46;Apply(getActivationsResult => getActivationsResult&#46;Activations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetActivations(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsActivationId1", ids.Activations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetActivationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getActivations();
     *         ctx.export("ecsActivationId1", ids.applyValue(getActivationsResult -> getActivationsResult.activations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getActivations
     *       Arguments: {}
     * outputs:
     *   ecsActivationId1: ${ids.activations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getActivations.
     * @return A collection of values returned by getActivations.
     */
    public suspend fun getActivations(argument: GetActivationsPlainArgs): GetActivationsResult =
        getActivationsResultToKotlin(getActivationsPlain(argument.toJava()).await())

    /**
     * @see [getActivations].
     * @param ids A list of Activation IDs.
     * @param instanceName The default prefix of the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getActivations.
     */
    public suspend fun getActivations(
        ids: List<String>? = null,
        instanceName: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetActivationsResult {
        val argument = GetActivationsPlainArgs(
            ids = ids,
            instanceName = instanceName,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getActivationsResultToKotlin(getActivationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getActivations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetActivationsPlainArgs].
     * @return A collection of values returned by getActivations.
     */
    public suspend fun getActivations(argument: suspend GetActivationsPlainArgsBuilder.() -> Unit): GetActivationsResult {
        val builder = GetActivationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActivationsResultToKotlin(getActivationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Auto Snapshot Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.117.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getAutoSnapshotPolicies({
     *     ids: ["sp-bp14e66xxxxxxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstEcsAutoSnapshotPolicyId = example.then(example => example.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_auto_snapshot_policies(ids=["sp-bp14e66xxxxxxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstEcsAutoSnapshotPolicyId", example.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetAutoSnapshotPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "sp-bp14e66xxxxxxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsAutoSnapshotPolicyId"] = example&#46;Apply(getAutoSnapshotPoliciesResult => getAutoSnapshotPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetAutoSnapshotPolicies(ctx, &ecs.GetAutoSnapshotPoliciesArgs{
     * 			Ids: []string{
     * 				"sp-bp14e66xxxxxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsAutoSnapshotPolicyId", example.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetAutoSnapshotPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getAutoSnapshotPolicies(GetAutoSnapshotPoliciesArgs.builder()
     *             .ids("sp-bp14e66xxxxxxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstEcsAutoSnapshotPolicyId", example.applyValue(getAutoSnapshotPoliciesResult -> getAutoSnapshotPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getAutoSnapshotPolicies
     *       Arguments:
     *         ids:
     *           - sp-bp14e66xxxxxxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstEcsAutoSnapshotPolicyId: ${example.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAutoSnapshotPolicies.
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(argument: GetAutoSnapshotPoliciesPlainArgs): GetAutoSnapshotPoliciesResult =
        getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getAutoSnapshotPolicies].
     * @param ids A list of Auto Snapshot Policy IDs.
     * @param nameRegex A regex string to filter results by Auto Snapshot Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Auto Snapshot Policy. Valid Values: `Expire`, `Normal`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetAutoSnapshotPoliciesResult {
        val argument = GetAutoSnapshotPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutoSnapshotPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetAutoSnapshotPoliciesPlainArgs].
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(argument: suspend GetAutoSnapshotPoliciesPlainArgsBuilder.() -> Unit): GetAutoSnapshotPoliciesResult {
        val builder = GetAutoSnapshotPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Ecs Capacity Reservation available to the user.
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecs.getCapacityReservations({
     *     ids: [defaultAlicloudEcsCapacityReservation&#46;id],
     *     nameRegex: defaultAlicloudEcsCapacityReservation.name,
     *     instanceType: "ecs.c6.large",
     *     platform: "linux",
     * });
     * export const alicloudEcsCapacityReservationExampleId = _default.then(_default => _default.reservations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecs.get_capacity_reservations(ids=[default_alicloud_ecs_capacity_reservation["id"]],
     *     name_regex=default_alicloud_ecs_capacity_reservation["name"],
     *     instance_type="ecs.c6.large",
     *     platform="linux")
     * pulumi.export("alicloudEcsCapacityReservationExampleId", default.reservations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecs.GetCapacityReservations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudEcsCapacityReservation.Id,
     *         },
     *         NameRegex = defaultAlicloudEcsCapacityReservation.Name,
     *         InstanceType = "ecs.c6.large",
     *         Platform = "linux",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEcsCapacityReservationExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getCapacityReservationsResult => getCapacityReservationsResult&#46;Reservations[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := ecs.GetCapacityReservations(ctx, &ecs.GetCapacityReservationsArgs{
     * Ids: interface{}{
     * defaultAlicloudEcsCapacityReservation.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudEcsCapacityReservation.Name),
     * InstanceType: pulumi.StringRef("ecs.c6.large"),
     * Platform: pulumi.StringRef("linux"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudEcsCapacityReservationExampleId", _default.Reservations[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetCapacityReservationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcsFunctions.getCapacityReservations(GetCapacityReservationsArgs.builder()
     *             .ids(defaultAlicloudEcsCapacityReservation.id())
     *             .nameRegex(defaultAlicloudEcsCapacityReservation.name())
     *             .instanceType("ecs.c6.large")
     *             .platform("linux")
     *             .build());
     *         ctx.export("alicloudEcsCapacityReservationExampleId", default_.reservations()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getCapacityReservations
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudEcsCapacityReservation.id}
     *         nameRegex: ${defaultAlicloudEcsCapacityReservation.name}
     *         instanceType: ecs.c6.large
     *         platform: linux
     * outputs:
     *   alicloudEcsCapacityReservationExampleId: ${default.reservations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCapacityReservations.
     * @return A collection of values returned by getCapacityReservations.
     */
    public suspend fun getCapacityReservations(argument: GetCapacityReservationsPlainArgs): GetCapacityReservationsResult =
        getCapacityReservationsResultToKotlin(getCapacityReservationsPlain(argument.toJava()).await())

    /**
     * @see [getCapacityReservations].
     * @param capacityReservationIds
     * @param ids A list of Capacity Reservation IDs.
     * @param instanceType Instance type. Currently, you can only set the capacity reservation service for one instance type.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType The payment type of the resource. value range `PostPaid`, `PrePaid`.
     * @param platform platform of the capacity reservation , value range `windows`, `linux`, `all`.
     * @param resourceGroupId The resource group id.
     * @param status The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
     * @param tags The tag of the resource.
     * @return A collection of values returned by getCapacityReservations.
     */
    public suspend fun getCapacityReservations(
        capacityReservationIds: List<String>? = null,
        ids: List<String>? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        platform: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetCapacityReservationsResult {
        val argument = GetCapacityReservationsPlainArgs(
            capacityReservationIds = capacityReservationIds,
            ids = ids,
            instanceType = instanceType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            platform = platform,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
        )
        return getCapacityReservationsResultToKotlin(getCapacityReservationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityReservations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetCapacityReservationsPlainArgs].
     * @return A collection of values returned by getCapacityReservations.
     */
    public suspend fun getCapacityReservations(argument: suspend GetCapacityReservationsPlainArgsBuilder.() -> Unit): GetCapacityReservationsResult {
        val builder = GetCapacityReservationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityReservationsResultToKotlin(getCapacityReservationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Commands of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.116.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getCommands({
     *     ids: ["E2RY53-xxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstEcsCommandId = example.then(example => example.commands?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_commands(ids=["E2RY53-xxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstEcsCommandId", example.commands[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetCommands.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "E2RY53-xxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsCommandId"] = example&#46;Apply(getCommandsResult => getCommandsResult&#46;Commands[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetCommands(ctx, &ecs.GetCommandsArgs{
     * 			Ids: []string{
     * 				"E2RY53-xxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsCommandId", example.Commands[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetCommandsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getCommands(GetCommandsArgs.builder()
     *             .ids("E2RY53-xxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstEcsCommandId", example.applyValue(getCommandsResult -> getCommandsResult.commands()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getCommands
     *       Arguments:
     *         ids:
     *           - E2RY53-xxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstEcsCommandId: ${example.commands[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCommands.
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(argument: GetCommandsPlainArgs): GetCommandsResult =
        getCommandsResultToKotlin(getCommandsPlain(argument.toJava()).await())

    /**
     * @see [getCommands].
     * @param commandProvider Public order provider.
     * @param contentEncoding The Base64-encoded content of the command.
     * @param description The description of command.
     * @param ids A list of Command IDs.
     * @param name The name of the command.
     * @param nameRegex A regex string to filter results by Command name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param type The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(
        commandProvider: String? = null,
        contentEncoding: String? = null,
        description: String? = null,
        ids: List<String>? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        type: String? = null,
    ): GetCommandsResult {
        val argument = GetCommandsPlainArgs(
            commandProvider = commandProvider,
            contentEncoding = contentEncoding,
            description = description,
            ids = ids,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            type = type,
        )
        return getCommandsResultToKotlin(getCommandsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommands].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetCommandsPlainArgs].
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(argument: suspend GetCommandsPlainArgsBuilder.() -> Unit): GetCommandsResult {
        val builder = GetCommandsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommandsResultToKotlin(getCommandsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ECS Dedicated Hosts in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.91.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const dedicatedHostsDs = alicloud.ecs.getDedicatedHosts({
     *     nameRegex: "tf-testAcc",
     *     dedicatedHostType: "ddh.g5",
     *     status: "Available",
     * });
     * export const firstDedicatedHostsId = dedicatedHostsDs.then(dedicatedHostsDs => dedicatedHostsDs.hosts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * dedicated_hosts_ds = alicloud.ecs.get_dedicated_hosts(name_regex="tf-testAcc",
     *     dedicated_host_type="ddh.g5",
     *     status="Available")
     * pulumi.export("firstDedicatedHostsId", dedicated_hosts_ds.hosts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var dedicatedHostsDs = AliCloud.Ecs.GetDedicatedHosts.Invoke(new()
     *     {
     *         NameRegex = "tf-testAcc",
     *         DedicatedHostType = "ddh.g5",
     *         Status = "Available",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDedicatedHostsId"] = dedicatedHostsDs&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		dedicatedHostsDs, err := ecs.GetDedicatedHosts(ctx, &ecs.GetDedicatedHostsArgs{
     * 			NameRegex:         pulumi.StringRef("tf-testAcc"),
     * 			DedicatedHostType: pulumi.StringRef("ddh.g5"),
     * 			Status:            pulumi.StringRef("Available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDedicatedHostsId", dedicatedHostsDs.Hosts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var dedicatedHostsDs = EcsFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .nameRegex("tf-testAcc")
     *             .dedicatedHostType("ddh.g5")
     *             .status("Available")
     *             .build());
     *         ctx.export("firstDedicatedHostsId", dedicatedHostsDs.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   dedicatedHostsDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getDedicatedHosts
     *       Arguments:
     *         nameRegex: tf-testAcc
     *         dedicatedHostType: ddh.g5
     *         status: Available
     * outputs:
     *   firstDedicatedHostsId: ${dedicatedHostsDs.hosts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedHosts.
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(argument: GetDedicatedHostsPlainArgs): GetDedicatedHostsResult =
        getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHosts].
     * @param dedicatedHostId The ID of ECS Dedicated Host.
     * @param dedicatedHostName The name of ECS Dedicated Host.
     * @param dedicatedHostType The type of the dedicated host.
     * @param ids A list of ECS Dedicated Host ids.
     * @param nameRegex A regex string to filter results by the ECS Dedicated Host name.
     * @param operationLocks The reason why the dedicated host resource is locked.
     * @param outputFile Save the result to the file.
     * @param resourceGroupId The ID of the resource group to which the ECS Dedicated Host belongs.
     * @param status The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
     * @param tags A mapping of tags to assign to the resource.
     * @param zoneId The zone ID of the ECS Dedicated Host.
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(
        dedicatedHostId: String? = null,
        dedicatedHostName: String? = null,
        dedicatedHostType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        operationLocks: List<GetDedicatedHostsOperationLock>? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        zoneId: String? = null,
    ): GetDedicatedHostsResult {
        val argument = GetDedicatedHostsPlainArgs(
            dedicatedHostId = dedicatedHostId,
            dedicatedHostName = dedicatedHostName,
            dedicatedHostType = dedicatedHostType,
            ids = ids,
            nameRegex = nameRegex,
            operationLocks = operationLocks,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            zoneId = zoneId,
        )
        return getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHosts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetDedicatedHostsPlainArgs].
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(argument: suspend GetDedicatedHostsPlainArgsBuilder.() -> Unit): GetDedicatedHostsResult {
        val builder = GetDedicatedHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** This datasource has been renamed to alicloud.ecs.getEcsDisks from version 1.122.0.
     * This data source provides the disks of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const disksDs = alicloud.ecs.getDisks({
     *     nameRegex: "sample_disk",
     * });
     * export const firstDiskId = disksDs.then(disksDs => disksDs.disks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * disks_ds = alicloud.ecs.get_disks(name_regex="sample_disk")
     * pulumi.export("firstDiskId", disks_ds.disks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
     *     {
     *         NameRegex = "sample_disk",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDiskId"] = disksDs&#46;Apply(getDisksResult => getDisksResult&#46;Disks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		disksDs, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
     * 			NameRegex: pulumi.StringRef("sample_disk"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDiskId", disksDs.Disks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
     *             .nameRegex("sample_disk")
     *             .build());
     *         ctx.export("firstDiskId", disksDs.applyValue(getDisksResult -> getDisksResult.disks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   disksDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getDisks
     *       Arguments:
     *         nameRegex: sample_disk
     * outputs:
     *   firstDiskId: ${disksDs.disks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDisks.
     * @return A collection of values returned by getDisks.
     */
    public suspend fun getDisks(argument: GetDisksPlainArgs): GetDisksResult =
        getDisksResultToKotlin(getDisksPlain(argument.toJava()).await())

    /**
     * @see [getDisks].
     * @param additionalAttributes
     * @param autoSnapshotPolicyId
     * @param availabilityZone Availability zone of the disk.
     * @param category Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk), `cloud_essd_entry`.
     * @param deleteAutoSnapshot
     * @param deleteWithInstance
     * @param diskName
     * @param diskType
     * @param dryRun
     * @param enableAutoSnapshot
     * @param enableAutomatedSnapshotPolicy
     * @param enableShared
     * @param encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
     * @param ids A list of disks IDs.
     * @param instanceId Filter the results by the specified ECS instance ID.
     * @param kmsKeyId
     * @param nameRegex A regex string to filter results by disk name.
     * @param operationLocks
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param paymentType
     * @param portable
     * @param resourceGroupId The Id of resource group which the disk belongs.
     * @param snapshotId Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
     * @param status Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
     * @param tags A map of tags assigned to the disks. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const disksDs = alicloud.ecs.getDisks({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * disks_ds = alicloud.ecs.get_disks(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   disksDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getDisks
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param type Disk type. Possible values: `system` and `data`.
     * @param zoneId
     * @return A collection of values returned by getDisks.
     */
    public suspend fun getDisks(
        additionalAttributes: List<String>? = null,
        autoSnapshotPolicyId: String? = null,
        availabilityZone: String? = null,
        category: String? = null,
        deleteAutoSnapshot: Boolean? = null,
        deleteWithInstance: Boolean? = null,
        diskName: String? = null,
        diskType: String? = null,
        dryRun: Boolean? = null,
        enableAutoSnapshot: Boolean? = null,
        enableAutomatedSnapshotPolicy: Boolean? = null,
        enableShared: Boolean? = null,
        encrypted: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        kmsKeyId: String? = null,
        nameRegex: String? = null,
        operationLocks: List<GetDisksOperationLock>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        paymentType: String? = null,
        portable: Boolean? = null,
        resourceGroupId: String? = null,
        snapshotId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        zoneId: String? = null,
    ): GetDisksResult {
        val argument = GetDisksPlainArgs(
            additionalAttributes = additionalAttributes,
            autoSnapshotPolicyId = autoSnapshotPolicyId,
            availabilityZone = availabilityZone,
            category = category,
            deleteAutoSnapshot = deleteAutoSnapshot,
            deleteWithInstance = deleteWithInstance,
            diskName = diskName,
            diskType = diskType,
            dryRun = dryRun,
            enableAutoSnapshot = enableAutoSnapshot,
            enableAutomatedSnapshotPolicy = enableAutomatedSnapshotPolicy,
            enableShared = enableShared,
            encrypted = encrypted,
            ids = ids,
            instanceId = instanceId,
            kmsKeyId = kmsKeyId,
            nameRegex = nameRegex,
            operationLocks = operationLocks,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            paymentType = paymentType,
            portable = portable,
            resourceGroupId = resourceGroupId,
            snapshotId = snapshotId,
            status = status,
            tags = tags,
            type = type,
            zoneId = zoneId,
        )
        return getDisksResultToKotlin(getDisksPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetDisksPlainArgs].
     * @return A collection of values returned by getDisks.
     */
    public suspend fun getDisks(argument: suspend GetDisksPlainArgsBuilder.() -> Unit): GetDisksResult {
        val builder = GetDisksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDisksResultToKotlin(getDisksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Dedicated Host Clusters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsDedicatedHostClusters({
     *     ids: ["example_id"],
     * });
     * export const ecsDedicatedHostClusterId1 = ids.then(ids => ids.clusters?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsDedicatedHostClusters({
     *     nameRegex: "^my-DedicatedHostCluster",
     * });
     * export const ecsDedicatedHostClusterId2 = nameRegex.then(nameRegex => nameRegex.clusters?.[0]?.id);
     * const zoneId = alicloud.ecs.getEcsDedicatedHostClusters({
     *     zoneId: "example_value",
     * });
     * export const ecsDedicatedHostClusterId3 = zoneId.then(zoneId => zoneId.clusters?.[0]?.id);
     * const clusterName = alicloud.ecs.getEcsDedicatedHostClusters({
     *     dedicatedHostClusterName: "example_value",
     * });
     * export const ecsDedicatedHostClusterId4 = clusterName.then(clusterName => clusterName.clusters?.[0]?.id);
     * const clusterIds = alicloud.ecs.getEcsDedicatedHostClusters({
     *     dedicatedHostClusterIds: ["example_id"],
     * });
     * export const ecsDedicatedHostClusterId5 = clusterIds.then(clusterIds => clusterIds.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_dedicated_host_clusters(ids=["example_id"])
     * pulumi.export("ecsDedicatedHostClusterId1", ids.clusters[0].id)
     * name_regex = alicloud.ecs.get_ecs_dedicated_host_clusters(name_regex="^my-DedicatedHostCluster")
     * pulumi.export("ecsDedicatedHostClusterId2", name_regex.clusters[0].id)
     * zone_id = alicloud.ecs.get_ecs_dedicated_host_clusters(zone_id="example_value")
     * pulumi.export("ecsDedicatedHostClusterId3", zone_id.clusters[0].id)
     * cluster_name = alicloud.ecs.get_ecs_dedicated_host_clusters(dedicated_host_cluster_name="example_value")
     * pulumi.export("ecsDedicatedHostClusterId4", cluster_name.clusters[0].id)
     * cluster_ids = alicloud.ecs.get_ecs_dedicated_host_clusters(dedicated_host_cluster_ids=["example_id"])
     * pulumi.export("ecsDedicatedHostClusterId5", cluster_ids.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsDedicatedHostClusters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ecs.GetEcsDedicatedHostClusters.Invoke(new()
     *     {
     *         NameRegex = "^my-DedicatedHostCluster",
     *     });
     *     var zoneId = AliCloud.Ecs.GetEcsDedicatedHostClusters.Invoke(new()
     *     {
     *         ZoneId = "example_value",
     *     });
     *     var clusterName = AliCloud.Ecs.GetEcsDedicatedHostClusters.Invoke(new()
     *     {
     *         DedicatedHostClusterName = "example_value",
     *     });
     *     var clusterIds = AliCloud.Ecs.GetEcsDedicatedHostClusters.Invoke(new()
     *     {
     *         DedicatedHostClusterIds = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsDedicatedHostClusterId1"] = ids&#46;Apply(getEcsDedicatedHostClustersResult => getEcsDedicatedHostClustersResult&#46;Clusters[0]?.Id),
     *         ["ecsDedicatedHostClusterId2"] = nameRegex&#46;Apply(getEcsDedicatedHostClustersResult => getEcsDedicatedHostClustersResult&#46;Clusters[0]?.Id),
     *         ["ecsDedicatedHostClusterId3"] = zoneId&#46;Apply(getEcsDedicatedHostClustersResult => getEcsDedicatedHostClustersResult&#46;Clusters[0]?.Id),
     *         ["ecsDedicatedHostClusterId4"] = clusterName&#46;Apply(getEcsDedicatedHostClustersResult => getEcsDedicatedHostClustersResult&#46;Clusters[0]?.Id),
     *         ["ecsDedicatedHostClusterId5"] = clusterIds&#46;Apply(getEcsDedicatedHostClustersResult => getEcsDedicatedHostClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsDedicatedHostClusters(ctx, &ecs.GetEcsDedicatedHostClustersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDedicatedHostClusterId1", ids.Clusters[0].Id)
     * 		nameRegex, err := ecs.GetEcsDedicatedHostClusters(ctx, &ecs.GetEcsDedicatedHostClustersArgs{
     * 			NameRegex: pulumi.StringRef("^my-DedicatedHostCluster"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDedicatedHostClusterId2", nameRegex.Clusters[0].Id)
     * 		zoneId, err := ecs.GetEcsDedicatedHostClusters(ctx, &ecs.GetEcsDedicatedHostClustersArgs{
     * 			ZoneId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDedicatedHostClusterId3", zoneId.Clusters[0].Id)
     * 		clusterName, err := ecs.GetEcsDedicatedHostClusters(ctx, &ecs.GetEcsDedicatedHostClustersArgs{
     * 			DedicatedHostClusterName: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDedicatedHostClusterId4", clusterName.Clusters[0].Id)
     * 		clusterIds, err := ecs.GetEcsDedicatedHostClusters(ctx, &ecs.GetEcsDedicatedHostClustersArgs{
     * 			DedicatedHostClusterIds: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDedicatedHostClusterId5", clusterIds.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsDedicatedHostClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsDedicatedHostClusters(GetEcsDedicatedHostClustersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecsDedicatedHostClusterId1", ids.applyValue(getEcsDedicatedHostClustersResult -> getEcsDedicatedHostClustersResult.clusters()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsDedicatedHostClusters(GetEcsDedicatedHostClustersArgs.builder()
     *             .nameRegex("^my-DedicatedHostCluster")
     *             .build());
     *         ctx.export("ecsDedicatedHostClusterId2", nameRegex.applyValue(getEcsDedicatedHostClustersResult -> getEcsDedicatedHostClustersResult.clusters()[0].id()));
     *         final var zoneId = EcsFunctions.getEcsDedicatedHostClusters(GetEcsDedicatedHostClustersArgs.builder()
     *             .zoneId("example_value")
     *             .build());
     *         ctx.export("ecsDedicatedHostClusterId3", zoneId.applyValue(getEcsDedicatedHostClustersResult -> getEcsDedicatedHostClustersResult.clusters()[0].id()));
     *         final var clusterName = EcsFunctions.getEcsDedicatedHostClusters(GetEcsDedicatedHostClustersArgs.builder()
     *             .dedicatedHostClusterName("example_value")
     *             .build());
     *         ctx.export("ecsDedicatedHostClusterId4", clusterName.applyValue(getEcsDedicatedHostClustersResult -> getEcsDedicatedHostClustersResult.clusters()[0].id()));
     *         final var clusterIds = EcsFunctions.getEcsDedicatedHostClusters(GetEcsDedicatedHostClustersArgs.builder()
     *             .dedicatedHostClusterIds("example_id")
     *             .build());
     *         ctx.export("ecsDedicatedHostClusterId5", clusterIds.applyValue(getEcsDedicatedHostClustersResult -> getEcsDedicatedHostClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDedicatedHostClusters
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDedicatedHostClusters
     *       Arguments:
     *         nameRegex: ^my-DedicatedHostCluster
     *   zoneId:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDedicatedHostClusters
     *       Arguments:
     *         zoneId: example_value
     *   clusterName:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDedicatedHostClusters
     *       Arguments:
     *         dedicatedHostClusterName: example_value
     *   clusterIds:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDedicatedHostClusters
     *       Arguments:
     *         dedicatedHostClusterIds:
     *           - example_id
     * outputs:
     *   ecsDedicatedHostClusterId1: ${ids.clusters[0].id}
     *   ecsDedicatedHostClusterId2: ${nameRegex.clusters[0].id}
     *   ecsDedicatedHostClusterId3: ${zoneId.clusters[0].id}
     *   ecsDedicatedHostClusterId4: ${clusterName.clusters[0].id}
     *   ecsDedicatedHostClusterId5: ${clusterIds.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsDedicatedHostClusters.
     * @return A collection of values returned by getEcsDedicatedHostClusters.
     */
    public suspend fun getEcsDedicatedHostClusters(argument: GetEcsDedicatedHostClustersPlainArgs): GetEcsDedicatedHostClustersResult =
        getEcsDedicatedHostClustersResultToKotlin(getEcsDedicatedHostClustersPlain(argument.toJava()).await())

    /**
     * @see [getEcsDedicatedHostClusters].
     * @param dedicatedHostClusterIds The IDs of dedicated host clusters.
     * @param dedicatedHostClusterName The name of the dedicated host cluster.
     * @param ids A list of Dedicated Host Cluster IDs.
     * @param nameRegex A regex string to filter results by Dedicated Host Cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A mapping of tags to assign to the resource.
     * @param zoneId The zone ID of the dedicated host cluster.
     * @return A collection of values returned by getEcsDedicatedHostClusters.
     */
    public suspend fun getEcsDedicatedHostClusters(
        dedicatedHostClusterIds: List<String>? = null,
        dedicatedHostClusterName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
        zoneId: String? = null,
    ): GetEcsDedicatedHostClustersResult {
        val argument = GetEcsDedicatedHostClustersPlainArgs(
            dedicatedHostClusterIds = dedicatedHostClusterIds,
            dedicatedHostClusterName = dedicatedHostClusterName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
            zoneId = zoneId,
        )
        return getEcsDedicatedHostClustersResultToKotlin(getEcsDedicatedHostClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsDedicatedHostClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsDedicatedHostClustersPlainArgs].
     * @return A collection of values returned by getEcsDedicatedHostClusters.
     */
    public suspend fun getEcsDedicatedHostClusters(argument: suspend GetEcsDedicatedHostClustersPlainArgsBuilder.() -> Unit): GetEcsDedicatedHostClustersResult {
        val builder = GetEcsDedicatedHostClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsDedicatedHostClustersResultToKotlin(getEcsDedicatedHostClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Deployment Sets of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsDeploymentSets({
     *     ids: ["example_id"],
     * });
     * export const ecsDeploymentSetId1 = ids.then(ids => ids.sets?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsDeploymentSets({
     *     nameRegex: "^my-DeploymentSet",
     * });
     * export const ecsDeploymentSetId2 = nameRegex.then(nameRegex => nameRegex.sets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_deployment_sets(ids=["example_id"])
     * pulumi.export("ecsDeploymentSetId1", ids.sets[0].id)
     * name_regex = alicloud.ecs.get_ecs_deployment_sets(name_regex="^my-DeploymentSet")
     * pulumi.export("ecsDeploymentSetId2", name_regex.sets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsDeploymentSets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ecs.GetEcsDeploymentSets.Invoke(new()
     *     {
     *         NameRegex = "^my-DeploymentSet",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsDeploymentSetId1"] = ids&#46;Apply(getEcsDeploymentSetsResult => getEcsDeploymentSetsResult&#46;Sets[0]?.Id),
     *         ["ecsDeploymentSetId2"] = nameRegex&#46;Apply(getEcsDeploymentSetsResult => getEcsDeploymentSetsResult&#46;Sets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsDeploymentSets(ctx, &ecs.GetEcsDeploymentSetsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDeploymentSetId1", ids.Sets[0].Id)
     * 		nameRegex, err := ecs.GetEcsDeploymentSets(ctx, &ecs.GetEcsDeploymentSetsArgs{
     * 			NameRegex: pulumi.StringRef("^my-DeploymentSet"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsDeploymentSetId2", nameRegex.Sets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsDeploymentSetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsDeploymentSets(GetEcsDeploymentSetsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecsDeploymentSetId1", ids.applyValue(getEcsDeploymentSetsResult -> getEcsDeploymentSetsResult.sets()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsDeploymentSets(GetEcsDeploymentSetsArgs.builder()
     *             .nameRegex("^my-DeploymentSet")
     *             .build());
     *         ctx.export("ecsDeploymentSetId2", nameRegex.applyValue(getEcsDeploymentSetsResult -> getEcsDeploymentSetsResult.sets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDeploymentSets
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDeploymentSets
     *       Arguments:
     *         nameRegex: ^my-DeploymentSet
     * outputs:
     *   ecsDeploymentSetId1: ${ids.sets[0].id}
     *   ecsDeploymentSetId2: ${nameRegex.sets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsDeploymentSets.
     * @return A collection of values returned by getEcsDeploymentSets.
     */
    public suspend fun getEcsDeploymentSets(argument: GetEcsDeploymentSetsPlainArgs): GetEcsDeploymentSetsResult =
        getEcsDeploymentSetsResultToKotlin(getEcsDeploymentSetsPlain(argument.toJava()).await())

    /**
     * @see [getEcsDeploymentSets].
     * @param deploymentSetName The name of the deployment set.
     * @param ids A list of Deployment Set IDs.
     * @param nameRegex A regex string to filter results by Deployment Set name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param strategy The deployment strategy. Valid values: `Availability`.
     * @return A collection of values returned by getEcsDeploymentSets.
     */
    public suspend fun getEcsDeploymentSets(
        deploymentSetName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        strategy: String? = null,
    ): GetEcsDeploymentSetsResult {
        val argument = GetEcsDeploymentSetsPlainArgs(
            deploymentSetName = deploymentSetName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            strategy = strategy,
        )
        return getEcsDeploymentSetsResultToKotlin(getEcsDeploymentSetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsDeploymentSets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsDeploymentSetsPlainArgs].
     * @return A collection of values returned by getEcsDeploymentSets.
     */
    public suspend fun getEcsDeploymentSets(argument: suspend GetEcsDeploymentSetsPlainArgsBuilder.() -> Unit): GetEcsDeploymentSetsResult {
        val builder = GetEcsDeploymentSetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsDeploymentSetsResultToKotlin(getEcsDeploymentSetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Disks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.122.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsDisks({
     *     ids: ["d-artgdsvdvxxxx"],
     *     nameRegex: "tf-test",
     * });
     * export const firstEcsDiskId = example.then(example => example.disks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_disks(ids=["d-artgdsvdvxxxx"],
     *     name_regex="tf-test")
     * pulumi.export("firstEcsDiskId", example.disks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsDisks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "d-artgdsvdvxxxx",
     *         },
     *         NameRegex = "tf-test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsDiskId"] = example&#46;Apply(getEcsDisksResult => getEcsDisksResult&#46;Disks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsDisks(ctx, &ecs.GetEcsDisksArgs{
     * 			Ids: []string{
     * 				"d-artgdsvdvxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsDiskId", example.Disks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsDisks(GetEcsDisksArgs.builder()
     *             .ids("d-artgdsvdvxxxx")
     *             .nameRegex("tf-test")
     *             .build());
     *         ctx.export("firstEcsDiskId", example.applyValue(getEcsDisksResult -> getEcsDisksResult.disks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsDisks
     *       Arguments:
     *         ids:
     *           - d-artgdsvdvxxxx
     *         nameRegex: tf-test
     * outputs:
     *   firstEcsDiskId: ${example.disks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsDisks.
     * @return A collection of values returned by getEcsDisks.
     */
    public suspend fun getEcsDisks(argument: GetEcsDisksPlainArgs): GetEcsDisksResult =
        getEcsDisksResultToKotlin(getEcsDisksPlain(argument.toJava()).await())

    /**
     * @see [getEcsDisks].
     * @param additionalAttributes Other attribute values. Currently, only the incoming value of IOPS is supported, which means to query the IOPS upper limit of the current disk.
     * @param autoSnapshotPolicyId Query cloud disks based on the automatic snapshot policy ID.
     * @param availabilityZone Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
     * @param category Disk category. Valid values: `cloud`, `cloud_efficiency`, `cloud_essd`, `cloud_ssd`, `ephemeral_ssd`, `cloud_auto`, `cloud_essd_entry`.
     * @param deleteAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released.
     * @param deleteWithInstance Indicates whether the disk is released together with the instance.
     * @param diskName The disk name.
     * @param diskType The disk type.
     * @param dryRun Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
     * @param enableAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released.
     * @param enableAutomatedSnapshotPolicy Whether the cloud disk has an automatic snapshot policy
     * @param enableShared Whether it is shared block storage.
     * @param encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
     * @param ids A list of Disk IDs.
     * @param instanceId Filter the results by the specified ECS instance ID.
     * @param kmsKeyId The kms key id.
     * @param nameRegex A regex string to filter results by Disk name.
     * @param operationLocks
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param paymentType Payment method for disk. Valid Values: `PayAsYouGo`, `Subscription`.
     * @param portable Whether the cloud disk or local disk supports uninstallation.
     * @param resourceGroupId The Id of resource group which the disk belongs.
     * @param snapshotId The source snapshot id.
     * @param status The status of disk.
     * @param tags A map of tags assigned to the disks.
     * @param type Field `type` has been deprecated from provider version 1.122.0. New field `disk_type` instead.
     * @param zoneId ID of the free zone to which the disk belongs.
     * @return A collection of values returned by getEcsDisks.
     */
    public suspend fun getEcsDisks(
        additionalAttributes: List<String>? = null,
        autoSnapshotPolicyId: String? = null,
        availabilityZone: String? = null,
        category: String? = null,
        deleteAutoSnapshot: Boolean? = null,
        deleteWithInstance: Boolean? = null,
        diskName: String? = null,
        diskType: String? = null,
        dryRun: Boolean? = null,
        enableAutoSnapshot: Boolean? = null,
        enableAutomatedSnapshotPolicy: Boolean? = null,
        enableShared: Boolean? = null,
        encrypted: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        kmsKeyId: String? = null,
        nameRegex: String? = null,
        operationLocks: List<GetEcsDisksOperationLock>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        paymentType: String? = null,
        portable: Boolean? = null,
        resourceGroupId: String? = null,
        snapshotId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        zoneId: String? = null,
    ): GetEcsDisksResult {
        val argument = GetEcsDisksPlainArgs(
            additionalAttributes = additionalAttributes,
            autoSnapshotPolicyId = autoSnapshotPolicyId,
            availabilityZone = availabilityZone,
            category = category,
            deleteAutoSnapshot = deleteAutoSnapshot,
            deleteWithInstance = deleteWithInstance,
            diskName = diskName,
            diskType = diskType,
            dryRun = dryRun,
            enableAutoSnapshot = enableAutoSnapshot,
            enableAutomatedSnapshotPolicy = enableAutomatedSnapshotPolicy,
            enableShared = enableShared,
            encrypted = encrypted,
            ids = ids,
            instanceId = instanceId,
            kmsKeyId = kmsKeyId,
            nameRegex = nameRegex,
            operationLocks = operationLocks,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            paymentType = paymentType,
            portable = portable,
            resourceGroupId = resourceGroupId,
            snapshotId = snapshotId,
            status = status,
            tags = tags,
            type = type,
            zoneId = zoneId,
        )
        return getEcsDisksResultToKotlin(getEcsDisksPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsDisks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsDisksPlainArgs].
     * @return A collection of values returned by getEcsDisks.
     */
    public suspend fun getEcsDisks(argument: suspend GetEcsDisksPlainArgsBuilder.() -> Unit): GetEcsDisksResult {
        val builder = GetEcsDisksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsDisksResultToKotlin(getEcsDisksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Image Components of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.159.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsImageComponents({
     *     ids: ["example_id"],
     * });
     * export const ecsImageComponentId1 = ids.then(ids => ids.components?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsImageComponents({
     *     nameRegex: "^my-ImageComponent",
     * });
     * export const ecsImageComponentId2 = nameRegex.then(nameRegex => nameRegex.components?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_image_components(ids=["example_id"])
     * pulumi.export("ecsImageComponentId1", ids.components[0].id)
     * name_regex = alicloud.ecs.get_ecs_image_components(name_regex="^my-ImageComponent")
     * pulumi.export("ecsImageComponentId2", name_regex.components[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsImageComponents.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ecs.GetEcsImageComponents.Invoke(new()
     *     {
     *         NameRegex = "^my-ImageComponent",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsImageComponentId1"] = ids&#46;Apply(getEcsImageComponentsResult => getEcsImageComponentsResult&#46;Components[0]?.Id),
     *         ["ecsImageComponentId2"] = nameRegex&#46;Apply(getEcsImageComponentsResult => getEcsImageComponentsResult&#46;Components[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsImageComponents(ctx, &ecs.GetEcsImageComponentsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsImageComponentId1", ids.Components[0].Id)
     * 		nameRegex, err := ecs.GetEcsImageComponents(ctx, &ecs.GetEcsImageComponentsArgs{
     * 			NameRegex: pulumi.StringRef("^my-ImageComponent"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsImageComponentId2", nameRegex.Components[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsImageComponentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsImageComponents(GetEcsImageComponentsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecsImageComponentId1", ids.applyValue(getEcsImageComponentsResult -> getEcsImageComponentsResult.components()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsImageComponents(GetEcsImageComponentsArgs.builder()
     *             .nameRegex("^my-ImageComponent")
     *             .build());
     *         ctx.export("ecsImageComponentId2", nameRegex.applyValue(getEcsImageComponentsResult -> getEcsImageComponentsResult.components()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsImageComponents
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsImageComponents
     *       Arguments:
     *         nameRegex: ^my-ImageComponent
     * outputs:
     *   ecsImageComponentId1: ${ids.components[0].id}
     *   ecsImageComponentId2: ${nameRegex.components[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsImageComponents.
     * @return A collection of values returned by getEcsImageComponents.
     */
    public suspend fun getEcsImageComponents(argument: GetEcsImageComponentsPlainArgs): GetEcsImageComponentsResult =
        getEcsImageComponentsResultToKotlin(getEcsImageComponentsPlain(argument.toJava()).await())

    /**
     * @see [getEcsImageComponents].
     * @param ids A list of Image Component IDs.
     * @param imageComponentName The name of the component.
     * @param nameRegex A regex string to filter results by Image Component name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param owner Mirror component type. Valid values: `SELF` or `ALIYUN`. Possible values:
     * - SELF: The custom image component you created.
     * - ALIYUN: System components provided by Alibaba Cloud.
     * @param resourceGroupId The ID of the resource group.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getEcsImageComponents.
     */
    public suspend fun getEcsImageComponents(
        ids: List<String>? = null,
        imageComponentName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        owner: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetEcsImageComponentsResult {
        val argument = GetEcsImageComponentsPlainArgs(
            ids = ids,
            imageComponentName = imageComponentName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            owner = owner,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getEcsImageComponentsResultToKotlin(getEcsImageComponentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsImageComponents].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsImageComponentsPlainArgs].
     * @return A collection of values returned by getEcsImageComponents.
     */
    public suspend fun getEcsImageComponents(argument: suspend GetEcsImageComponentsPlainArgsBuilder.() -> Unit): GetEcsImageComponentsResult {
        val builder = GetEcsImageComponentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsImageComponentsResultToKotlin(getEcsImageComponentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Image Pipelines of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.163.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsImagePipeline({
     *     ids: ["example_value"],
     * });
     * export const ecsImagePipelineId1 = ids.then(ids => ids.pipelines?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsImagePipeline({
     *     nameRegex: "^my-ImagePipeline",
     * });
     * export const ecsImagePipelineId2 = nameRegex.then(nameRegex => nameRegex.pipelines?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_image_pipeline(ids=["example_value"])
     * pulumi.export("ecsImagePipelineId1", ids.pipelines[0].id)
     * name_regex = alicloud.ecs.get_ecs_image_pipeline(name_regex="^my-ImagePipeline")
     * pulumi.export("ecsImagePipelineId2", name_regex.pipelines[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsImagePipeline.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ecs.GetEcsImagePipeline.Invoke(new()
     *     {
     *         NameRegex = "^my-ImagePipeline",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsImagePipelineId1"] = ids&#46;Apply(getEcsImagePipelineResult => getEcsImagePipelineResult&#46;Pipelines[0]?.Id),
     *         ["ecsImagePipelineId2"] = nameRegex&#46;Apply(getEcsImagePipelineResult => getEcsImagePipelineResult&#46;Pipelines[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.LookupEcsImagePipeline(ctx, &ecs.LookupEcsImagePipelineArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsImagePipelineId1", ids.Pipelines[0].Id)
     * 		nameRegex, err := ecs.LookupEcsImagePipeline(ctx, &ecs.LookupEcsImagePipelineArgs{
     * 			NameRegex: pulumi.StringRef("^my-ImagePipeline"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsImagePipelineId2", nameRegex.Pipelines[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsImagePipelineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsImagePipeline(GetEcsImagePipelineArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("ecsImagePipelineId1", ids.applyValue(getEcsImagePipelineResult -> getEcsImagePipelineResult.pipelines()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsImagePipeline(GetEcsImagePipelineArgs.builder()
     *             .nameRegex("^my-ImagePipeline")
     *             .build());
     *         ctx.export("ecsImagePipelineId2", nameRegex.applyValue(getEcsImagePipelineResult -> getEcsImagePipelineResult.pipelines()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsImagePipeline
     *       Arguments:
     *         ids:
     *           - example_value
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsImagePipeline
     *       Arguments:
     *         nameRegex: ^my-ImagePipeline
     * outputs:
     *   ecsImagePipelineId1: ${ids.pipelines[0].id}
     *   ecsImagePipelineId2: ${nameRegex.pipelines[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsImagePipeline.
     * @return A collection of values returned by getEcsImagePipeline.
     */
    public suspend fun getEcsImagePipeline(argument: GetEcsImagePipelinePlainArgs): GetEcsImagePipelineResult =
        getEcsImagePipelineResultToKotlin(getEcsImagePipelinePlain(argument.toJava()).await())

    /**
     * @see [getEcsImagePipeline].
     * @param ids A list of Image Pipeline ids.
     * @param name The name of the image template.
     * @param nameRegex A regex string to filter results by Image Pipeline name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group to which the image template belongs.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getEcsImagePipeline.
     */
    public suspend fun getEcsImagePipeline(
        ids: List<String>? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetEcsImagePipelineResult {
        val argument = GetEcsImagePipelinePlainArgs(
            ids = ids,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getEcsImagePipelineResultToKotlin(getEcsImagePipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsImagePipeline].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsImagePipelinePlainArgs].
     * @return A collection of values returned by getEcsImagePipeline.
     */
    public suspend fun getEcsImagePipeline(argument: suspend GetEcsImagePipelinePlainArgsBuilder.() -> Unit): GetEcsImagePipelineResult {
        val builder = GetEcsImagePipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsImagePipelineResultToKotlin(getEcsImagePipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Invocations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.168.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsInvocations({
     *     ids: ["example-id"],
     * });
     * export const ecsInvocationId1 = ids.then(ids => ids.invocations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_invocations(ids=["example-id"])
     * pulumi.export("ecsInvocationId1", ids.invocations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsInvocations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example-id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsInvocationId1"] = ids&#46;Apply(getEcsInvocationsResult => getEcsInvocationsResult&#46;Invocations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsInvocations(ctx, &ecs.GetEcsInvocationsArgs{
     * 			Ids: []string{
     * 				"example-id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsInvocationId1", ids.Invocations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsInvocationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsInvocations(GetEcsInvocationsArgs.builder()
     *             .ids("example-id")
     *             .build());
     *         ctx.export("ecsInvocationId1", ids.applyValue(getEcsInvocationsResult -> getEcsInvocationsResult.invocations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsInvocations
     *       Arguments:
     *         ids:
     *           - example-id
     * outputs:
     *   ecsInvocationId1: ${ids.invocations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsInvocations.
     * @return A collection of values returned by getEcsInvocations.
     */
    public suspend fun getEcsInvocations(argument: GetEcsInvocationsPlainArgs): GetEcsInvocationsResult =
        getEcsInvocationsResultToKotlin(getEcsInvocationsPlain(argument.toJava()).await())

    /**
     * @see [getEcsInvocations].
     * @param commandId The execution ID of the command.
     * @param contentEncoding The encoding mode of the CommandContent and Output response parameters. Valid values: `PlainText`, `Base64`.
     * @param ids A list of Invocation IDs.
     * @param invokeStatus The overall execution state of the command. The value of this parameter depends on the execution states on all the involved instances. Valid values: `Running`, `Finished`, `Failed`, `PartialFailed`, `Stopped`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getEcsInvocations.
     */
    public suspend fun getEcsInvocations(
        commandId: String? = null,
        contentEncoding: String? = null,
        ids: List<String>? = null,
        invokeStatus: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetEcsInvocationsResult {
        val argument = GetEcsInvocationsPlainArgs(
            commandId = commandId,
            contentEncoding = contentEncoding,
            ids = ids,
            invokeStatus = invokeStatus,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getEcsInvocationsResultToKotlin(getEcsInvocationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsInvocations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsInvocationsPlainArgs].
     * @return A collection of values returned by getEcsInvocations.
     */
    public suspend fun getEcsInvocations(argument: suspend GetEcsInvocationsPlainArgsBuilder.() -> Unit): GetEcsInvocationsResult {
        val builder = GetEcsInvocationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsInvocationsResultToKotlin(getEcsInvocationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Key Pairs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.121.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsKeyPairs({
     *     ids: ["key_pair_name"],
     *     nameRegex: "key_pair_name",
     * });
     * export const firstEcsKeyPairId = example.then(example => example.pairs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_key_pairs(ids=["key_pair_name"],
     *     name_regex="key_pair_name")
     * pulumi.export("firstEcsKeyPairId", example.pairs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsKeyPairs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "key_pair_name",
     *         },
     *         NameRegex = "key_pair_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsKeyPairId"] = example&#46;Apply(getEcsKeyPairsResult => getEcsKeyPairsResult&#46;Pairs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsKeyPairs(ctx, &ecs.GetEcsKeyPairsArgs{
     * 			Ids: []string{
     * 				"key_pair_name",
     * 			},
     * 			NameRegex: pulumi.StringRef("key_pair_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsKeyPairId", example.Pairs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsKeyPairsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsKeyPairs(GetEcsKeyPairsArgs.builder()
     *             .ids("key_pair_name")
     *             .nameRegex("key_pair_name")
     *             .build());
     *         ctx.export("firstEcsKeyPairId", example.applyValue(getEcsKeyPairsResult -> getEcsKeyPairsResult.pairs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsKeyPairs
     *       Arguments:
     *         ids:
     *           - key_pair_name
     *         nameRegex: key_pair_name
     * outputs:
     *   firstEcsKeyPairId: ${example.pairs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsKeyPairs.
     * @return A collection of values returned by getEcsKeyPairs.
     */
    public suspend fun getEcsKeyPairs(argument: GetEcsKeyPairsPlainArgs): GetEcsKeyPairsResult =
        getEcsKeyPairsResultToKotlin(getEcsKeyPairsPlain(argument.toJava()).await())

    /**
     * @see [getEcsKeyPairs].
     * @param fingerPrint The finger print of the key pair.
     * @param ids A list of Key Pair IDs.
     * @param nameRegex A regex string to filter results by Key Pair name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The resource group Id.
     * @param tags
     * @return A collection of values returned by getEcsKeyPairs.
     */
    public suspend fun getEcsKeyPairs(
        fingerPrint: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetEcsKeyPairsResult {
        val argument = GetEcsKeyPairsPlainArgs(
            fingerPrint = fingerPrint,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getEcsKeyPairsResultToKotlin(getEcsKeyPairsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsKeyPairs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsKeyPairsPlainArgs].
     * @return A collection of values returned by getEcsKeyPairs.
     */
    public suspend fun getEcsKeyPairs(argument: suspend GetEcsKeyPairsPlainArgsBuilder.() -> Unit): GetEcsKeyPairsResult {
        val builder = GetEcsKeyPairsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsKeyPairsResultToKotlin(getEcsKeyPairsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Launch Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsLaunchTemplates({
     *     ids: ["lt-bp1a469uxxxxxx"],
     *     nameRegex: "your_launch_name",
     * });
     * export const firstEcsLaunchTemplateId = example.then(example => example.templates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_launch_templates(ids=["lt-bp1a469uxxxxxx"],
     *     name_regex="your_launch_name")
     * pulumi.export("firstEcsLaunchTemplateId", example.templates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsLaunchTemplates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "lt-bp1a469uxxxxxx",
     *         },
     *         NameRegex = "your_launch_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsLaunchTemplateId"] = example&#46;Apply(getEcsLaunchTemplatesResult => getEcsLaunchTemplatesResult&#46;Templates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsLaunchTemplates(ctx, &ecs.GetEcsLaunchTemplatesArgs{
     * 			Ids: []string{
     * 				"lt-bp1a469uxxxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("your_launch_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsLaunchTemplateId", example.Templates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsLaunchTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsLaunchTemplates(GetEcsLaunchTemplatesArgs.builder()
     *             .ids("lt-bp1a469uxxxxxx")
     *             .nameRegex("your_launch_name")
     *             .build());
     *         ctx.export("firstEcsLaunchTemplateId", example.applyValue(getEcsLaunchTemplatesResult -> getEcsLaunchTemplatesResult.templates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsLaunchTemplates
     *       Arguments:
     *         ids:
     *           - lt-bp1a469uxxxxxx
     *         nameRegex: your_launch_name
     * outputs:
     *   firstEcsLaunchTemplateId: ${example.templates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsLaunchTemplates.
     * @return A collection of values returned by getEcsLaunchTemplates.
     */
    public suspend fun getEcsLaunchTemplates(argument: GetEcsLaunchTemplatesPlainArgs): GetEcsLaunchTemplatesResult =
        getEcsLaunchTemplatesResultToKotlin(getEcsLaunchTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getEcsLaunchTemplates].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Launch Template IDs.
     * @param launchTemplateName The Launch Template Name.
     * @param nameRegex A regex string to filter results by Launch Template name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param templateResourceGroupId The template resource group id.
     * @param templateTags
     * @return A collection of values returned by getEcsLaunchTemplates.
     */
    public suspend fun getEcsLaunchTemplates(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        launchTemplateName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        templateResourceGroupId: String? = null,
        templateTags: Map<String, String>? = null,
    ): GetEcsLaunchTemplatesResult {
        val argument = GetEcsLaunchTemplatesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            launchTemplateName = launchTemplateName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            templateResourceGroupId = templateResourceGroupId,
            templateTags = templateTags,
        )
        return getEcsLaunchTemplatesResultToKotlin(getEcsLaunchTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsLaunchTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsLaunchTemplatesPlainArgs].
     * @return A collection of values returned by getEcsLaunchTemplates.
     */
    public suspend fun getEcsLaunchTemplates(argument: suspend GetEcsLaunchTemplatesPlainArgsBuilder.() -> Unit): GetEcsLaunchTemplatesResult {
        val builder = GetEcsLaunchTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsLaunchTemplatesResultToKotlin(getEcsLaunchTemplatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Network Interface Permissions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.166.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsNetworkInterfacePermissions({
     *     ids: ["example_value"],
     *     networkInterfaceId: "example_value",
     * });
     * export const ecsNetworkInterfacePermissionId1 = ids.then(ids => ids.permissions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_network_interface_permissions(ids=["example_value"],
     *     network_interface_id="example_value")
     * pulumi.export("ecsNetworkInterfacePermissionId1", ids.permissions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsNetworkInterfacePermissions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NetworkInterfaceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsNetworkInterfacePermissionId1"] = ids&#46;Apply(getEcsNetworkInterfacePermissionsResult => getEcsNetworkInterfacePermissionsResult&#46;Permissions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsNetworkInterfacePermissions(ctx, &ecs.GetEcsNetworkInterfacePermissionsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NetworkInterfaceId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsNetworkInterfacePermissionId1", ids.Permissions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacePermissionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsNetworkInterfacePermissions(GetEcsNetworkInterfacePermissionsArgs.builder()
     *             .ids("example_value")
     *             .networkInterfaceId("example_value")
     *             .build());
     *         ctx.export("ecsNetworkInterfacePermissionId1", ids.applyValue(getEcsNetworkInterfacePermissionsResult -> getEcsNetworkInterfacePermissionsResult.permissions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsNetworkInterfacePermissions
     *       Arguments:
     *         ids:
     *           - example_value
     *         networkInterfaceId: example_value
     * outputs:
     *   ecsNetworkInterfacePermissionId1: ${ids.permissions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsNetworkInterfacePermissions.
     * @return A collection of values returned by getEcsNetworkInterfacePermissions.
     */
    public suspend fun getEcsNetworkInterfacePermissions(argument: GetEcsNetworkInterfacePermissionsPlainArgs): GetEcsNetworkInterfacePermissionsResult =
        getEcsNetworkInterfacePermissionsResultToKotlin(getEcsNetworkInterfacePermissionsPlain(argument.toJava()).await())

    /**
     * @see [getEcsNetworkInterfacePermissions].
     * @param ids A list of Network Interface Permission IDs.
     * @param networkInterfaceId The ID of the network interface.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The Status of the Network Interface Permissions. Valid values: `Granted`, `Pending`, `Revoked`, `Revoking`.
     * @return A collection of values returned by getEcsNetworkInterfacePermissions.
     */
    public suspend fun getEcsNetworkInterfacePermissions(
        ids: List<String>? = null,
        networkInterfaceId: String,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetEcsNetworkInterfacePermissionsResult {
        val argument = GetEcsNetworkInterfacePermissionsPlainArgs(
            ids = ids,
            networkInterfaceId = networkInterfaceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getEcsNetworkInterfacePermissionsResultToKotlin(getEcsNetworkInterfacePermissionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsNetworkInterfacePermissions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsNetworkInterfacePermissionsPlainArgs].
     * @return A collection of values returned by getEcsNetworkInterfacePermissions.
     */
    public suspend fun getEcsNetworkInterfacePermissions(argument: suspend GetEcsNetworkInterfacePermissionsPlainArgsBuilder.() -> Unit): GetEcsNetworkInterfacePermissionsResult {
        val builder = GetEcsNetworkInterfacePermissionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsNetworkInterfacePermissionsResultToKotlin(getEcsNetworkInterfacePermissionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Network Interfaces of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.123.1.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsNetworkInterfaces({
     *     nameRegex: "eni-ipv6",
     * });
     * export const firstEcsNetworkInterfaceId = example.then(example => example.interfaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_network_interfaces(name_regex="eni-ipv6")
     * pulumi.export("firstEcsNetworkInterfaceId", example.interfaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsNetworkInterfaces.Invoke(new()
     *     {
     *         NameRegex = "eni-ipv6",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsNetworkInterfaceId"] = example&#46;Apply(getEcsNetworkInterfacesResult => getEcsNetworkInterfacesResult&#46;Interfaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsNetworkInterfaces(ctx, &ecs.GetEcsNetworkInterfacesArgs{
     * 			NameRegex: pulumi.StringRef("eni-ipv6"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsNetworkInterfaceId", example.Interfaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsNetworkInterfaces(GetEcsNetworkInterfacesArgs.builder()
     *             .nameRegex("eni-ipv6")
     *             .build());
     *         ctx.export("firstEcsNetworkInterfaceId", example.applyValue(getEcsNetworkInterfacesResult -> getEcsNetworkInterfacesResult.interfaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsNetworkInterfaces
     *       Arguments:
     *         nameRegex: eni-ipv6
     * outputs:
     *   firstEcsNetworkInterfaceId: ${example.interfaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsNetworkInterfaces.
     * @return A collection of values returned by getEcsNetworkInterfaces.
     */
    public suspend fun getEcsNetworkInterfaces(argument: GetEcsNetworkInterfacesPlainArgs): GetEcsNetworkInterfacesResult =
        getEcsNetworkInterfacesResultToKotlin(getEcsNetworkInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getEcsNetworkInterfaces].
     * @param ids A list of Network Interface IDs.
     * @param instanceId The instance id.
     * @param name Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
     * @param nameRegex A regex string to filter results by Network Interface name.
     * @param networkInterfaceName The network interface name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param primaryIpAddress The primary private IP address of the ENI.
     * @param privateIp Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
     * @param resourceGroupId The resource group id.
     * @param securityGroupId The security group id.
     * @param serviceManaged Whether the user of the elastic network card is a cloud product or a virtual vendor.
     * @param status The status of ENI. Valid Values: `Attaching`, `Available`, `CreateFailed`, `Creating`, `Deleting`, `Detaching`, `InUse`, `Linked`, `Linking`, `Unlinking`.
     * @param tags A map of tags assigned to ENIs.
     * @param type The type of ENI. Valid Values: `Primary`, `Secondary`.
     * @param vpcId The vpc id.
     * @param vswitchId The vswitch id.
     * @return A collection of values returned by getEcsNetworkInterfaces.
     */
    public suspend fun getEcsNetworkInterfaces(
        ids: List<String>? = null,
        instanceId: String? = null,
        name: String? = null,
        nameRegex: String? = null,
        networkInterfaceName: String? = null,
        outputFile: String? = null,
        primaryIpAddress: String? = null,
        privateIp: String? = null,
        resourceGroupId: String? = null,
        securityGroupId: String? = null,
        serviceManaged: Boolean? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetEcsNetworkInterfacesResult {
        val argument = GetEcsNetworkInterfacesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            name = name,
            nameRegex = nameRegex,
            networkInterfaceName = networkInterfaceName,
            outputFile = outputFile,
            primaryIpAddress = primaryIpAddress,
            privateIp = privateIp,
            resourceGroupId = resourceGroupId,
            securityGroupId = securityGroupId,
            serviceManaged = serviceManaged,
            status = status,
            tags = tags,
            type = type,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getEcsNetworkInterfacesResultToKotlin(getEcsNetworkInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsNetworkInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsNetworkInterfacesPlainArgs].
     * @return A collection of values returned by getEcsNetworkInterfaces.
     */
    public suspend fun getEcsNetworkInterfaces(argument: suspend GetEcsNetworkInterfacesPlainArgsBuilder.() -> Unit): GetEcsNetworkInterfacesResult {
        val builder = GetEcsNetworkInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsNetworkInterfacesResultToKotlin(getEcsNetworkInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Prefix Lists of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsPrefixLists({
     *     ids: ["E2RY53-xxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const outputId = example.then(example => example.lists?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_prefix_lists(ids=["E2RY53-xxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("outputId", example.lists[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsPrefixLists.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "E2RY53-xxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["outputId"] = example&#46;Apply(getEcsPrefixListsResult => getEcsPrefixListsResult&#46;Lists[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsPrefixLists(ctx, &ecs.GetEcsPrefixListsArgs{
     * 			Ids: []string{
     * 				"E2RY53-xxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("outputId", example.Lists[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsPrefixListsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsPrefixLists(GetEcsPrefixListsArgs.builder()
     *             .ids("E2RY53-xxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("outputId", example.applyValue(getEcsPrefixListsResult -> getEcsPrefixListsResult.lists()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsPrefixLists
     *       Arguments:
     *         ids:
     *           - E2RY53-xxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   outputId: ${example.lists[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsPrefixLists.
     * @return A collection of values returned by getEcsPrefixLists.
     */
    public suspend fun getEcsPrefixLists(argument: GetEcsPrefixListsPlainArgs): GetEcsPrefixListsResult =
        getEcsPrefixListsResultToKotlin(getEcsPrefixListsPlain(argument.toJava()).await())

    /**
     * @see [getEcsPrefixLists].
     * @param addressFamily The address family of the prefix list. Valid values: `IPv4`,`IPv6`. This parameter is empty by default, which indicates that all prefix lists are to be queried.
     * @param enableDetails
     * @param ids A list of Prefix List IDs.
     * @param nameRegex A regex string to filter results by `prefix_list_name`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEcsPrefixLists.
     */
    public suspend fun getEcsPrefixLists(
        addressFamily: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetEcsPrefixListsResult {
        val argument = GetEcsPrefixListsPlainArgs(
            addressFamily = addressFamily,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getEcsPrefixListsResultToKotlin(getEcsPrefixListsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsPrefixLists].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsPrefixListsPlainArgs].
     * @return A collection of values returned by getEcsPrefixLists.
     */
    public suspend fun getEcsPrefixLists(argument: suspend GetEcsPrefixListsPlainArgsBuilder.() -> Unit): GetEcsPrefixListsResult {
        val builder = GetEcsPrefixListsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsPrefixListsResultToKotlin(getEcsPrefixListsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Snapshot Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.160.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsSnapshotGroups({
     *     ids: ["example-id"],
     * });
     * export const ecsSnapshotGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsSnapshotGroups({
     *     nameRegex: "^my-SnapshotGroup",
     * });
     * export const ecsSnapshotGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * const status = alicloud.ecs.getEcsSnapshotGroups({
     *     status: "accomplished",
     * });
     * export const ecsSnapshotGroupId3 = status.then(status => status.groups?.[0]?.id);
     * const instanceId = alicloud.ecs.getEcsSnapshotGroups({
     *     instanceId: "example-instance_id",
     * });
     * export const ecsSnapshotGroupId4 = instanceId.then(instanceId => instanceId.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_snapshot_groups(ids=["example-id"])
     * pulumi.export("ecsSnapshotGroupId1", ids.groups[0].id)
     * name_regex = alicloud.ecs.get_ecs_snapshot_groups(name_regex="^my-SnapshotGroup")
     * pulumi.export("ecsSnapshotGroupId2", name_regex.groups[0].id)
     * status = alicloud.ecs.get_ecs_snapshot_groups(status="accomplished")
     * pulumi.export("ecsSnapshotGroupId3", status.groups[0].id)
     * instance_id = alicloud.ecs.get_ecs_snapshot_groups(instance_id="example-instance_id")
     * pulumi.export("ecsSnapshotGroupId4", instance_id.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsSnapshotGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example-id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ecs.GetEcsSnapshotGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-SnapshotGroup",
     *     });
     *     var status = AliCloud.Ecs.GetEcsSnapshotGroups.Invoke(new()
     *     {
     *         Status = "accomplished",
     *     });
     *     var instanceId = AliCloud.Ecs.GetEcsSnapshotGroups.Invoke(new()
     *     {
     *         InstanceId = "example-instance_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsSnapshotGroupId1"] = ids&#46;Apply(getEcsSnapshotGroupsResult => getEcsSnapshotGroupsResult&#46;Groups[0]?.Id),
     *         ["ecsSnapshotGroupId2"] = nameRegex&#46;Apply(getEcsSnapshotGroupsResult => getEcsSnapshotGroupsResult&#46;Groups[0]?.Id),
     *         ["ecsSnapshotGroupId3"] = status&#46;Apply(getEcsSnapshotGroupsResult => getEcsSnapshotGroupsResult&#46;Groups[0]?.Id),
     *         ["ecsSnapshotGroupId4"] = instanceId&#46;Apply(getEcsSnapshotGroupsResult => getEcsSnapshotGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsSnapshotGroups(ctx, &ecs.GetEcsSnapshotGroupsArgs{
     * 			Ids: []string{
     * 				"example-id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsSnapshotGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := ecs.GetEcsSnapshotGroups(ctx, &ecs.GetEcsSnapshotGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-SnapshotGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsSnapshotGroupId2", nameRegex.Groups[0].Id)
     * 		status, err := ecs.GetEcsSnapshotGroups(ctx, &ecs.GetEcsSnapshotGroupsArgs{
     * 			Status: pulumi.StringRef("accomplished"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsSnapshotGroupId3", status.Groups[0].Id)
     * 		instanceId, err := ecs.GetEcsSnapshotGroups(ctx, &ecs.GetEcsSnapshotGroupsArgs{
     * 			InstanceId: pulumi.StringRef("example-instance_id"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsSnapshotGroupId4", instanceId.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsSnapshotGroups(GetEcsSnapshotGroupsArgs.builder()
     *             .ids("example-id")
     *             .build());
     *         ctx.export("ecsSnapshotGroupId1", ids.applyValue(getEcsSnapshotGroupsResult -> getEcsSnapshotGroupsResult.groups()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsSnapshotGroups(GetEcsSnapshotGroupsArgs.builder()
     *             .nameRegex("^my-SnapshotGroup")
     *             .build());
     *         ctx.export("ecsSnapshotGroupId2", nameRegex.applyValue(getEcsSnapshotGroupsResult -> getEcsSnapshotGroupsResult.groups()[0].id()));
     *         final var status = EcsFunctions.getEcsSnapshotGroups(GetEcsSnapshotGroupsArgs.builder()
     *             .status("accomplished")
     *             .build());
     *         ctx.export("ecsSnapshotGroupId3", status.applyValue(getEcsSnapshotGroupsResult -> getEcsSnapshotGroupsResult.groups()[0].id()));
     *         final var instanceId = EcsFunctions.getEcsSnapshotGroups(GetEcsSnapshotGroupsArgs.builder()
     *             .instanceId("example-instance_id")
     *             .build());
     *         ctx.export("ecsSnapshotGroupId4", instanceId.applyValue(getEcsSnapshotGroupsResult -> getEcsSnapshotGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsSnapshotGroups
     *       Arguments:
     *         ids:
     *           - example-id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsSnapshotGroups
     *       Arguments:
     *         nameRegex: ^my-SnapshotGroup
     *   status:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsSnapshotGroups
     *       Arguments:
     *         status: accomplished
     *   instanceId:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsSnapshotGroups
     *       Arguments:
     *         instanceId: example-instance_id
     * outputs:
     *   ecsSnapshotGroupId1: ${ids.groups[0].id}
     *   ecsSnapshotGroupId2: ${nameRegex.groups[0].id}
     *   ecsSnapshotGroupId3: ${status.groups[0].id}
     *   ecsSnapshotGroupId4: ${instanceId.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsSnapshotGroups.
     * @return A collection of values returned by getEcsSnapshotGroups.
     */
    public suspend fun getEcsSnapshotGroups(argument: GetEcsSnapshotGroupsPlainArgs): GetEcsSnapshotGroupsResult =
        getEcsSnapshotGroupsResultToKotlin(getEcsSnapshotGroupsPlain(argument.toJava()).await())

    /**
     * @see [getEcsSnapshotGroups].
     * @param ids A list of Snapshot Group IDs.
     * @param instanceId The ID of the instance.
     * @param nameRegex A regex string to filter results by Snapshot Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param snapshotGroupName The name of the snapshot-consistent group.
     * @param status The state of snapshot-consistent group. Valid Values: `accomplished`, `failed` and `progressing`.
     * @param tags A mapping of tags to assign to the snapshot group.
     * @return A collection of values returned by getEcsSnapshotGroups.
     */
    public suspend fun getEcsSnapshotGroups(
        ids: List<String>? = null,
        instanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        snapshotGroupName: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetEcsSnapshotGroupsResult {
        val argument = GetEcsSnapshotGroupsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            snapshotGroupName = snapshotGroupName,
            status = status,
            tags = tags,
        )
        return getEcsSnapshotGroupsResultToKotlin(getEcsSnapshotGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsSnapshotGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsSnapshotGroupsPlainArgs].
     * @return A collection of values returned by getEcsSnapshotGroups.
     */
    public suspend fun getEcsSnapshotGroups(argument: suspend GetEcsSnapshotGroupsPlainArgsBuilder.() -> Unit): GetEcsSnapshotGroupsResult {
        val builder = GetEcsSnapshotGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsSnapshotGroupsResultToKotlin(getEcsSnapshotGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEcsSnapshots({
     *     ids: ["s-bp1fvuxxxxxxxx"],
     *     nameRegex: "tf-test",
     * });
     * export const firstEcsSnapshotId = example.then(example => example.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_ecs_snapshots(ids=["s-bp1fvuxxxxxxxx"],
     *     name_regex="tf-test")
     * pulumi.export("firstEcsSnapshotId", example.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEcsSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "s-bp1fvuxxxxxxxx",
     *         },
     *         NameRegex = "tf-test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsSnapshotId"] = example&#46;Apply(getEcsSnapshotsResult => getEcsSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEcsSnapshots(ctx, &ecs.GetEcsSnapshotsArgs{
     * 			Ids: []string{
     * 				"s-bp1fvuxxxxxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsSnapshotId", example.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEcsSnapshots(GetEcsSnapshotsArgs.builder()
     *             .ids("s-bp1fvuxxxxxxxx")
     *             .nameRegex("tf-test")
     *             .build());
     *         ctx.export("firstEcsSnapshotId", example.applyValue(getEcsSnapshotsResult -> getEcsSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsSnapshots
     *       Arguments:
     *         ids:
     *           - s-bp1fvuxxxxxxxx
     *         nameRegex: tf-test
     * outputs:
     *   firstEcsSnapshotId: ${example.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsSnapshots.
     * @return A collection of values returned by getEcsSnapshots.
     */
    public suspend fun getEcsSnapshots(argument: GetEcsSnapshotsPlainArgs): GetEcsSnapshotsResult =
        getEcsSnapshotsResultToKotlin(getEcsSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getEcsSnapshots].
     * @param category The category of the snapshot. Valid Values: `flash` and `standard`.
     * @param dryRun Specifies whether to check the validity of the request without actually making the request.
     * @param encrypted Specifies whether the snapshot is encrypted.
     * @param ids A list of Snapshot IDs.
     * @param kmsKeyId The kms key id.
     * @param nameRegex A regex string to filter results by Snapshot name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The resource group id.
     * @param snapshotLinkId The snapshot link id.
     * @param snapshotName The name of the snapshot.
     * @param snapshotType The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
     * @param sourceDiskType The type of the disk for which the snapshot was created. Valid Values: `System`, `Data`.
     * @param status The status of the snapshot. Valid Values: `accomplished`, `failed`, `progressing` and `all`.
     * @param tags A mapping of tags to assign to the snapshot.
     * @param type
     * @param usage A resource type that has a reference relationship. Valid Values: `image`, `disk`, `image_disk` and `none`.
     * @return A collection of values returned by getEcsSnapshots.
     */
    public suspend fun getEcsSnapshots(
        category: String? = null,
        dryRun: Boolean? = null,
        encrypted: Boolean? = null,
        ids: List<String>? = null,
        kmsKeyId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        snapshotLinkId: String? = null,
        snapshotName: String? = null,
        snapshotType: String? = null,
        sourceDiskType: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        usage: String? = null,
    ): GetEcsSnapshotsResult {
        val argument = GetEcsSnapshotsPlainArgs(
            category = category,
            dryRun = dryRun,
            encrypted = encrypted,
            ids = ids,
            kmsKeyId = kmsKeyId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            snapshotLinkId = snapshotLinkId,
            snapshotName = snapshotName,
            snapshotType = snapshotType,
            sourceDiskType = sourceDiskType,
            status = status,
            tags = tags,
            type = type,
            usage = usage,
        )
        return getEcsSnapshotsResultToKotlin(getEcsSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsSnapshotsPlainArgs].
     * @return A collection of values returned by getEcsSnapshots.
     */
    public suspend fun getEcsSnapshots(argument: suspend GetEcsSnapshotsPlainArgsBuilder.() -> Unit): GetEcsSnapshotsResult {
        val builder = GetEcsSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsSnapshotsResultToKotlin(getEcsSnapshotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Storage Capacity Units of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.155.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ecs.getEcsStorageCapacityUnits({});
     * export const ecsStorageCapacityUnitId1 = ids.then(ids => ids.units?.[0]?.id);
     * const nameRegex = alicloud.ecs.getEcsStorageCapacityUnits({
     *     nameRegex: "^my-StorageCapacityUnit",
     * });
     * export const ecsStorageCapacityUnitId2 = nameRegex.then(nameRegex => nameRegex.units?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ecs.get_ecs_storage_capacity_units()
     * pulumi.export("ecsStorageCapacityUnitId1", ids.units[0].id)
     * name_regex = alicloud.ecs.get_ecs_storage_capacity_units(name_regex="^my-StorageCapacityUnit")
     * pulumi.export("ecsStorageCapacityUnitId2", name_regex.units[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ecs.GetEcsStorageCapacityUnits.Invoke();
     *     var nameRegex = AliCloud.Ecs.GetEcsStorageCapacityUnits.Invoke(new()
     *     {
     *         NameRegex = "^my-StorageCapacityUnit",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecsStorageCapacityUnitId1"] = ids&#46;Apply(getEcsStorageCapacityUnitsResult => getEcsStorageCapacityUnitsResult&#46;Units[0]?.Id),
     *         ["ecsStorageCapacityUnitId2"] = nameRegex&#46;Apply(getEcsStorageCapacityUnitsResult => getEcsStorageCapacityUnitsResult&#46;Units[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ecs.GetEcsStorageCapacityUnits(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsStorageCapacityUnitId1", ids.Units[0].Id)
     * 		nameRegex, err := ecs.GetEcsStorageCapacityUnits(ctx, &ecs.GetEcsStorageCapacityUnitsArgs{
     * 			NameRegex: pulumi.StringRef("^my-StorageCapacityUnit"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecsStorageCapacityUnitId2", nameRegex.Units[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEcsStorageCapacityUnitsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EcsFunctions.getEcsStorageCapacityUnits();
     *         ctx.export("ecsStorageCapacityUnitId1", ids.applyValue(getEcsStorageCapacityUnitsResult -> getEcsStorageCapacityUnitsResult.units()[0].id()));
     *         final var nameRegex = EcsFunctions.getEcsStorageCapacityUnits(GetEcsStorageCapacityUnitsArgs.builder()
     *             .nameRegex("^my-StorageCapacityUnit")
     *             .build());
     *         ctx.export("ecsStorageCapacityUnitId2", nameRegex.applyValue(getEcsStorageCapacityUnitsResult -> getEcsStorageCapacityUnitsResult.units()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsStorageCapacityUnits
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEcsStorageCapacityUnits
     *       Arguments:
     *         nameRegex: ^my-StorageCapacityUnit
     * outputs:
     *   ecsStorageCapacityUnitId1: ${ids.units[0].id}
     *   ecsStorageCapacityUnitId2: ${nameRegex.units[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsStorageCapacityUnits.
     * @return A collection of values returned by getEcsStorageCapacityUnits.
     */
    public suspend fun getEcsStorageCapacityUnits(argument: GetEcsStorageCapacityUnitsPlainArgs): GetEcsStorageCapacityUnitsResult =
        getEcsStorageCapacityUnitsResultToKotlin(getEcsStorageCapacityUnitsPlain(argument.toJava()).await())

    /**
     * @see [getEcsStorageCapacityUnits].
     * @param ids A list of Storage Capacity Unit IDs.
     * @param nameRegex A regex string to filter results by Storage Capacity Unit name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Storage Capacity Unit. Valid values: `Active`, `Creating`, `Expired`, `Pending`.
     * @return A collection of values returned by getEcsStorageCapacityUnits.
     */
    public suspend fun getEcsStorageCapacityUnits(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetEcsStorageCapacityUnitsResult {
        val argument = GetEcsStorageCapacityUnitsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getEcsStorageCapacityUnitsResultToKotlin(getEcsStorageCapacityUnitsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsStorageCapacityUnits].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEcsStorageCapacityUnitsPlainArgs].
     * @return A collection of values returned by getEcsStorageCapacityUnits.
     */
    public suspend fun getEcsStorageCapacityUnits(argument: suspend GetEcsStorageCapacityUnitsPlainArgsBuilder.() -> Unit): GetEcsStorageCapacityUnitsResult {
        val builder = GetEcsStorageCapacityUnitsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsStorageCapacityUnitsResultToKotlin(getEcsStorageCapacityUnitsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Eip Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.126.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getEipAddresses({
     *     ids: ["eip-bp1jvx5ki6c********"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstEipAddressId = example.then(example => example.addresses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_eip_addresses(ids=["eip-bp1jvx5ki6c********"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstEipAddressId", example.addresses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetEipAddresses.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "eip-bp1jvx5ki6c********",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEipAddressId"] = example&#46;Apply(getEipAddressesResult => getEipAddressesResult&#46;Addresses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetEipAddresses(ctx, &ecs.GetEipAddressesArgs{
     * 			Ids: []string{
     * 				"eip-bp1jvx5ki6c********",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEipAddressId", example.Addresses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEipAddressesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getEipAddresses(GetEipAddressesArgs.builder()
     *             .ids("eip-bp1jvx5ki6c********")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstEipAddressId", example.applyValue(getEipAddressesResult -> getEipAddressesResult.addresses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEipAddresses
     *       Arguments:
     *         ids:
     *           - eip-bp1jvx5ki6c********
     *         nameRegex: the_resource_name
     * outputs:
     *   firstEipAddressId: ${example.addresses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEipAddresses.
     * @return A collection of values returned by getEipAddresses.
     */
    public suspend fun getEipAddresses(argument: GetEipAddressesPlainArgs): GetEipAddressesResult =
        getEipAddressesResultToKotlin(getEipAddressesPlain(argument.toJava()).await())

    /**
     * @see [getEipAddresses].
     * @param addressName The eip name.
     * @param associatedInstanceId The associated instance id.
     * @param associatedInstanceType The associated instance type.
     * @param dryRun The dry run.
     * @param enableDetails Default to `true`. Set it to `false` can hide the `tags` to output.
     * @param ids A list of Address IDs.
     * @param includeReservationData The include reservation data. Valid values: `BGP` and `BGP_PRO`.
     * @param ipAddress The eip address.
     * @param ipAddresses
     * @param isp The Internet service provider (ISP). Valid values `BGP` and `BGP_PRO`.
     * @param lockReason The lock reason.
     * @param nameRegex A regex string to filter results by Address name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`.
     * @param resourceGroupId The ID of the resource group.
     * @param segmentInstanceId The IDs of the contiguous EIPs.  This value is returned only when contiguous EIPs are specified.
     * @param status The status of the EIP. Valid values:  `Associating`: The EIP is being associated. `Unassociating`: The EIP is being disassociated. `InUse`: The EIP is allocated. `Available`:The EIP is available.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getEipAddresses.
     */
    public suspend fun getEipAddresses(
        addressName: String? = null,
        associatedInstanceId: String? = null,
        associatedInstanceType: String? = null,
        dryRun: Boolean? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        ipAddress: String? = null,
        ipAddresses: List<String>? = null,
        isp: String? = null,
        lockReason: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        segmentInstanceId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetEipAddressesResult {
        val argument = GetEipAddressesPlainArgs(
            addressName = addressName,
            associatedInstanceId = associatedInstanceId,
            associatedInstanceType = associatedInstanceType,
            dryRun = dryRun,
            enableDetails = enableDetails,
            ids = ids,
            includeReservationData = includeReservationData,
            ipAddress = ipAddress,
            ipAddresses = ipAddresses,
            isp = isp,
            lockReason = lockReason,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            segmentInstanceId = segmentInstanceId,
            status = status,
            tags = tags,
        )
        return getEipAddressesResultToKotlin(getEipAddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEipAddresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEipAddressesPlainArgs].
     * @return A collection of values returned by getEipAddresses.
     */
    public suspend fun getEipAddresses(argument: suspend GetEipAddressesPlainArgsBuilder.() -> Unit): GetEipAddressesResult {
        val builder = GetEipAddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEipAddressesResultToKotlin(getEipAddressesPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.126.0`. Please use new datasource alicloud_eip_addresses.
     * This data source provides a list of EIPs (Elastic IP address) owned by an Alibaba Cloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const eipsDs = alicloud.ecs.getEips({});
     * export const firstEipId = eipsDs.then(eipsDs => eipsDs.eips?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * eips_ds = alicloud.ecs.get_eips()
     * pulumi.export("firstEipId", eips_ds.eips[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var eipsDs = AliCloud.Ecs.GetEips.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEipId"] = eipsDs&#46;Apply(getEipsResult => getEipsResult&#46;Eips[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		eipsDs, err := ecs.GetEips(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEipId", eipsDs.Eips[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetEipsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var eipsDs = EcsFunctions.getEips();
     *         ctx.export("firstEipId", eipsDs.applyValue(getEipsResult -> getEipsResult.eips()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   eipsDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getEips
     *       Arguments: {}
     * outputs:
     *   firstEipId: ${eipsDs.eips[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEips.
     * @return A collection of values returned by getEips.
     */
    @Deprecated(
        message = """
  This function has been deprecated in favour of the getEipAddresses function
  """,
    )
    public suspend fun getEips(argument: GetEipsPlainArgs): GetEipsResult =
        getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())

    /**
     * @see [getEips].
     * @param addressName
     * @param associatedInstanceId
     * @param associatedInstanceType
     * @param dryRun
     * @param enableDetails
     * @param ids A list of EIP IDs.
     * @param includeReservationData
     * @param ipAddress Public IP Address of the the EIP.
     * @param ipAddresses A list of EIP public IP addresses.
     * @param isp
     * @param lockReason
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType
     * @param resourceGroupId The Id of resource group which the eips belongs.
     * @param segmentInstanceId
     * @param status EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getEips.
     */
    @Deprecated(
        message = """
  This function has been deprecated in favour of the getEipAddresses function
  """,
    )
    public suspend fun getEips(
        addressName: String? = null,
        associatedInstanceId: String? = null,
        associatedInstanceType: String? = null,
        dryRun: Boolean? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        ipAddress: String? = null,
        ipAddresses: List<String>? = null,
        isp: String? = null,
        lockReason: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        segmentInstanceId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetEipsResult {
        val argument = GetEipsPlainArgs(
            addressName = addressName,
            associatedInstanceId = associatedInstanceId,
            associatedInstanceType = associatedInstanceType,
            dryRun = dryRun,
            enableDetails = enableDetails,
            ids = ids,
            includeReservationData = includeReservationData,
            ipAddress = ipAddress,
            ipAddresses = ipAddresses,
            isp = isp,
            lockReason = lockReason,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            segmentInstanceId = segmentInstanceId,
            status = status,
            tags = tags,
        )
        return getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEips].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetEipsPlainArgs].
     * @return A collection of values returned by getEips.
     */
    @Deprecated(
        message = """
  This function has been deprecated in favour of the getEipAddresses function
  """,
    )
    public suspend fun getEips(argument: suspend GetEipsPlainArgsBuilder.() -> Unit): GetEipsResult {
        val builder = GetEipsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEipsResultToKotlin(getEipsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Ecs Elasticity Assurance available to the user.
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecs.getElasticityAssurances({
     *     ids: [defaultAlicloudEcsElasticityAssurance&#46;id],
     * });
     * export const alicloudEcsElasticityAssuranceExampleId = _default.then(_default => _default.assurances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecs.get_elasticity_assurances(ids=[default_alicloud_ecs_elasticity_assurance["id"]])
     * pulumi.export("alicloudEcsElasticityAssuranceExampleId", default.assurances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecs.GetElasticityAssurances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudEcsElasticityAssurance.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEcsElasticityAssuranceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getElasticityAssurancesResult => getElasticityAssurancesResult&#46;Assurances[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := ecs.GetElasticityAssurances(ctx, &ecs.GetElasticityAssurancesArgs{
     * Ids: interface{}{
     * defaultAlicloudEcsElasticityAssurance.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudEcsElasticityAssuranceExampleId", _default.Assurances[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetElasticityAssurancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcsFunctions.getElasticityAssurances(GetElasticityAssurancesArgs.builder()
     *             .ids(defaultAlicloudEcsElasticityAssurance.id())
     *             .build());
     *         ctx.export("alicloudEcsElasticityAssuranceExampleId", default_.assurances()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getElasticityAssurances
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudEcsElasticityAssurance.id}
     * outputs:
     *   alicloudEcsElasticityAssuranceExampleId: ${default.assurances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getElasticityAssurances.
     * @return A collection of values returned by getElasticityAssurances.
     */
    public suspend fun getElasticityAssurances(argument: GetElasticityAssurancesPlainArgs): GetElasticityAssurancesResult =
        getElasticityAssurancesResultToKotlin(getElasticityAssurancesPlain(argument.toJava()).await())

    /**
     * @see [getElasticityAssurances].
     * @param ids A list of Elasticity Assurance IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param privatePoolOptionsIds The ID of the elastic protection service.
     * @param resourceGroupId The ID of the resource group.
     * @param status The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
     * @param tags The tag key-value pair information bound by the elastic guarantee service.
     * @return A collection of values returned by getElasticityAssurances.
     */
    public suspend fun getElasticityAssurances(
        ids: List<String>? = null,
        outputFile: String? = null,
        privatePoolOptionsIds: List<String>? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetElasticityAssurancesResult {
        val argument = GetElasticityAssurancesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            privatePoolOptionsIds = privatePoolOptionsIds,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
        )
        return getElasticityAssurancesResultToKotlin(getElasticityAssurancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getElasticityAssurances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetElasticityAssurancesPlainArgs].
     * @return A collection of values returned by getElasticityAssurances.
     */
    public suspend fun getElasticityAssurances(argument: suspend GetElasticityAssurancesPlainArgsBuilder.() -> Unit): GetElasticityAssurancesResult {
        val builder = GetElasticityAssurancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getElasticityAssurancesResultToKotlin(getElasticityAssurancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecs Hpc Clusters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.116.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ecs.getHpcClusters({
     *     ids: ["hpc-bp1i09xxxxxxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstEcsHpcClusterId = example.then(example => example.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ecs.get_hpc_clusters(ids=["hpc-bp1i09xxxxxxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstEcsHpcClusterId", example.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ecs.GetHpcClusters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "hpc-bp1i09xxxxxxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEcsHpcClusterId"] = example&#46;Apply(getHpcClustersResult => getHpcClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ecs.GetHpcClusters(ctx, &ecs.GetHpcClustersArgs{
     * 			Ids: []string{
     * 				"hpc-bp1i09xxxxxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEcsHpcClusterId", example.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetHpcClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EcsFunctions.getHpcClusters(GetHpcClustersArgs.builder()
     *             .ids("hpc-bp1i09xxxxxxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstEcsHpcClusterId", example.applyValue(getHpcClustersResult -> getHpcClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ecs:getHpcClusters
     *       Arguments:
     *         ids:
     *           - hpc-bp1i09xxxxxxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstEcsHpcClusterId: ${example.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHpcClusters.
     * @return A collection of values returned by getHpcClusters.
     */
    public suspend fun getHpcClusters(argument: GetHpcClustersPlainArgs): GetHpcClustersResult =
        getHpcClustersResultToKotlin(getHpcClustersPlain(argument.toJava()).await())

    /**
     * @see [getHpcClusters].
     * @param ids A list of Hpc Cluster IDs.
     * @param nameRegex A regex string to filter results by Hpc Cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHpcClusters.
     */
    public suspend fun getHpcClusters(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetHpcClustersResult {
        val argument = GetHpcClustersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getHpcClustersResultToKotlin(getHpcClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getHpcClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetHpcClustersPlainArgs].
     * @return A collection of values returned by getHpcClusters.
     */
    public suspend fun getHpcClusters(argument: suspend GetHpcClustersPlainArgsBuilder.() -> Unit): GetHpcClustersResult {
        val builder = GetHpcClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHpcClustersResultToKotlin(getHpcClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available image resources. It contains user's private images, system images provided by Alibaba Cloud,
     * other public images and the ones available on the image market.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const imagesDs = alicloud.ecs.getImages({
     *     owners: "system",
     *     nameRegex: "^centos_6",
     * });
     * export const firstImageId = imagesDs.then(imagesDs => imagesDs.images?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * images_ds = alicloud.ecs.get_images(owners="system",
     *     name_regex="^centos_6")
     * pulumi.export("firstImageId", images_ds.images[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var imagesDs = AliCloud.Ecs.GetImages.Invoke(new()
     *     {
     *         Owners = "system",
     *         NameRegex = "^centos_6",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstImageId"] = imagesDs&#46;Apply(getImagesResult => getImagesResult&#46;Images[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		imagesDs, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
     * 			Owners:    pulumi.StringRef("system"),
     * 			NameRegex: pulumi.StringRef("^centos_6"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstImageId", imagesDs.Images[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var imagesDs = EcsFunctions.getImages(GetImagesArgs.builder()
     *             .owners("system")
     *             .nameRegex("^centos_6")
     *             .build());
     *         ctx.export("firstImageId", imagesDs.applyValue(getImagesResult -> getImagesResult.images()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   imagesDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getImages
     *       Arguments:
     *         owners: system
     *         nameRegex: ^centos_6
     * outputs:
     *   firstImageId: ${imagesDs.images[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getImages.
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: GetImagesPlainArgs): GetImagesResult =
        getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())

    /**
     * @see [getImages].
     * @param actionType The scenario in which the image will be used. Default value: `CreateEcs`. Valid values:
     * * `CreateEcs`: instance creation.
     * * `ChangeOS`: replacement of the system disk or operating system.
     * @param architecture The image architecture. Valid values: `i386` and `x86_64`.
     * @param dryRun Specifies whether the image is running on an ECS instance. Default value: `false`. Valid values:
     * @param imageFamily The name of the image family. You can set this parameter to query images of the specified image family. This parameter is empty by default.
     * @param imageId The ID of the image.
     * @param imageName The name of the image.
     * @param imageOwnerId The ID of the Alibaba Cloud account to which the image belongs. This parameter takes effect only when you query shared images or community images.
     * @param instanceType The instance type for which the image can be used.
     * @param isSupportCloudInit Specifies whether the image supports cloud-init.
     * @param isSupportIoOptimized Specifies whether the image can be used on I/O optimized instances.
     * @param mostRecent If more than one result are returned, select the most recent one.
     * @param nameRegex A regex string to filter resulting images by name.
     * @param osType The operating system type of the image. Valid values: `windows` and `linux`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** At least one of the `name_regex`, `most_recent` and `owners` must be set.
     * @param owners Filter results by a specific image owner. Valid items are `system`, `self`, `others`, `marketplace`.
     * @param resourceGroupId The ID of the resource group to which the custom image belongs.
     * @param snapshotId The ID of the snapshot used to create the custom image.
     * @param status The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
     * * `Creating`: The image is being created.
     * * `Waiting`: The image is waiting to be processed.
     * * `Available`: The image is available.
     * * `UnAvailable`: The image is unavailable.
     * * `CreateFailed`: The image failed to be created.
     * * `Deprecated`: The image is discontinued.
     * @param tags A mapping of tags to assign to the resource.
     * @param usage Specifies whether to check the validity of the request without actually making the request. Valid values:
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(
        actionType: String? = null,
        architecture: String? = null,
        dryRun: Boolean? = null,
        imageFamily: String? = null,
        imageId: String? = null,
        imageName: String? = null,
        imageOwnerId: String? = null,
        instanceType: String? = null,
        isSupportCloudInit: Boolean? = null,
        isSupportIoOptimized: Boolean? = null,
        mostRecent: Boolean? = null,
        nameRegex: String? = null,
        osType: String? = null,
        outputFile: String? = null,
        owners: String? = null,
        resourceGroupId: String? = null,
        snapshotId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        usage: String? = null,
    ): GetImagesResult {
        val argument = GetImagesPlainArgs(
            actionType = actionType,
            architecture = architecture,
            dryRun = dryRun,
            imageFamily = imageFamily,
            imageId = imageId,
            imageName = imageName,
            imageOwnerId = imageOwnerId,
            instanceType = instanceType,
            isSupportCloudInit = isSupportCloudInit,
            isSupportIoOptimized = isSupportIoOptimized,
            mostRecent = mostRecent,
            nameRegex = nameRegex,
            osType = osType,
            outputFile = outputFile,
            owners = owners,
            resourceGroupId = resourceGroupId,
            snapshotId = snapshotId,
            status = status,
            tags = tags,
            usage = usage,
        )
        return getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetImagesPlainArgs].
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: suspend GetImagesPlainArgsBuilder.() -> Unit): GetImagesResult {
        val builder = GetImagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImagesResultToKotlin(getImagesPlain(builtArgument.toJava()).await())
    }

    /**
     * Operation to query the reserved keywords of an ApsaraDB RDS instance. The reserved keywords cannot be used for the usernames of accounts or the names of databases.
     * > **NOTE:** Available in v1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const resources = alicloud.ecs.getInstanceKeywords({
     *     key: "account",
     *     outputFile: "./classes.txt",
     * });
     * export const accountKeywords = resources.then(resources => resources.keywords?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * resources = alicloud.ecs.get_instance_keywords(key="account",
     *     output_file="./classes.txt")
     * pulumi.export("accountKeywords", resources.keywords[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var resources = AliCloud.Ecs.GetInstanceKeywords.Invoke(new()
     *     {
     *         Key = "account",
     *         OutputFile = "./classes.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["accountKeywords"] = resources&#46;Apply(getInstanceKeywordsResult => getInstanceKeywordsResult&#46;Keywords[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		resources, err := ecs.GetInstanceKeywords(ctx, &ecs.GetInstanceKeywordsArgs{
     * 			Key:        "account",
     * 			OutputFile: pulumi.StringRef("./classes.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("accountKeywords", resources.Keywords[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstanceKeywordsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var resources = EcsFunctions.getInstanceKeywords(GetInstanceKeywordsArgs.builder()
     *             .key("account")
     *             .outputFile("./classes.txt")
     *             .build());
     *         ctx.export("accountKeywords", resources.applyValue(getInstanceKeywordsResult -> getInstanceKeywordsResult.keywords()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   resources:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstanceKeywords
     *       Arguments:
     *         key: account
     *         outputFile: ./classes.txt
     * outputs:
     *   accountKeywords: ${resources.keywords[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceKeywords.
     * @return A collection of values returned by getInstanceKeywords.
     */
    public suspend fun getInstanceKeywords(argument: GetInstanceKeywordsPlainArgs): GetInstanceKeywordsResult =
        getInstanceKeywordsResultToKotlin(getInstanceKeywordsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceKeywords].
     * @param key The type of reserved keyword to query. Valid values: `account`, `database`.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @return A collection of values returned by getInstanceKeywords.
     */
    public suspend fun getInstanceKeywords(key: String, outputFile: String? = null): GetInstanceKeywordsResult {
        val argument = GetInstanceKeywordsPlainArgs(
            key = key,
            outputFile = outputFile,
        )
        return getInstanceKeywordsResultToKotlin(getInstanceKeywordsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceKeywords].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetInstanceKeywordsPlainArgs].
     * @return A collection of values returned by getInstanceKeywords.
     */
    public suspend fun getInstanceKeywords(argument: suspend GetInstanceKeywordsPlainArgsBuilder.() -> Unit): GetInstanceKeywordsResult {
        val builder = GetInstanceKeywordsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceKeywordsResultToKotlin(getInstanceKeywordsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ECS instance type families of Alibaba Cloud.
     * > **NOTE:** Available in 1.54.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecs.getInstanceTypeFamilies({
     *     instanceChargeType: "PrePaid",
     * });
     * export const firstInstanceTypeFamilyId = _default.then(_default => _default.families?.[0]?.id);
     * export const instanceIds = _default.then(_default => _default.ids);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecs.get_instance_type_families(instance_charge_type="PrePaid")
     * pulumi.export("firstInstanceTypeFamilyId", default.families[0].id)
     * pulumi.export("instanceIds", default.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecs.GetInstanceTypeFamilies.Invoke(new()
     *     {
     *         InstanceChargeType = "PrePaid",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceTypeFamilyId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstanceTypeFamiliesResult => getInstanceTypeFamiliesResult&#46;Families[0]?.Id)),
     *         ["instanceIds"] = @default.Apply(@default => @default.Apply(getInstanceTypeFamiliesResult => getInstanceTypeFamiliesResult.Ids)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ecs.GetInstanceTypeFamilies(ctx, &ecs.GetInstanceTypeFamiliesArgs{
     * 			InstanceChargeType: pulumi.StringRef("PrePaid"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceTypeFamilyId", _default.Families[0].Id)
     * 		ctx.Export("instanceIds", _default.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypeFamiliesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcsFunctions.getInstanceTypeFamilies(GetInstanceTypeFamiliesArgs.builder()
     *             .instanceChargeType("PrePaid")
     *             .build());
     *         ctx.export("firstInstanceTypeFamilyId", default_.families()[0].id());
     *         ctx.export("instanceIds", default_.ids());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstanceTypeFamilies
     *       Arguments:
     *         instanceChargeType: PrePaid
     * outputs:
     *   firstInstanceTypeFamilyId: ${default.families[0].id}
     *   instanceIds: ${default.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypeFamilies.
     * @return A collection of values returned by getInstanceTypeFamilies.
     */
    public suspend fun getInstanceTypeFamilies(argument: GetInstanceTypeFamiliesPlainArgs): GetInstanceTypeFamiliesResult =
        getInstanceTypeFamiliesResultToKotlin(getInstanceTypeFamiliesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeFamilies].
     * @param generation The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
     * @param instanceChargeType Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param spotStrategy Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     * @param zoneId The Zone to launch the instance.
     * @return A collection of values returned by getInstanceTypeFamilies.
     */
    public suspend fun getInstanceTypeFamilies(
        generation: String? = null,
        instanceChargeType: String? = null,
        outputFile: String? = null,
        spotStrategy: String? = null,
        zoneId: String? = null,
    ): GetInstanceTypeFamiliesResult {
        val argument = GetInstanceTypeFamiliesPlainArgs(
            generation = generation,
            instanceChargeType = instanceChargeType,
            outputFile = outputFile,
            spotStrategy = spotStrategy,
            zoneId = zoneId,
        )
        return getInstanceTypeFamiliesResultToKotlin(getInstanceTypeFamiliesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeFamilies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetInstanceTypeFamiliesPlainArgs].
     * @return A collection of values returned by getInstanceTypeFamilies.
     */
    public suspend fun getInstanceTypeFamilies(argument: suspend GetInstanceTypeFamiliesPlainArgsBuilder.() -> Unit): GetInstanceTypeFamiliesResult {
        val builder = GetInstanceTypeFamiliesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeFamiliesResultToKotlin(getInstanceTypeFamiliesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ECS instance types of Alibaba Cloud.
     * > **NOTE:** By default, only the upgraded instance types are returned. If you want to get outdated instance types, you must set `is_outdated` to true.
     * > **NOTE:** If one instance type is sold out, it will not be exported.
     * > **NOTE:** Available since v1.0.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "terraform-example";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * // Declare the data source
     * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
     *     availabilityZone: _default.zones?.[0]?.id,
     *     instanceTypeFamily: "ecs.sn1ne",
     * }));
     * const defaultGetImages = alicloud.ecs.getImages({
     *     nameRegex: "^ubuntu_[0-9]+_[0-9]+_x64*",
     *     mostRecent: true,
     *     owners: "system",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     vpcName: name,
     *     cidrBlock: "192.168.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vswitchName: name,
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "192.168.192.0/24",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     * });
     * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
     *     name: name,
     *     vpcId: defaultNetwork.id,
     * });
     * const defaultEcsNetworkInterface = new alicloud.ecs.EcsNetworkInterface("default", {
     *     networkInterfaceName: name,
     *     vswitchId: defaultSwitch.id,
     *     securityGroupIds: [defaultSecurityGroup&#46;id],
     * });
     * const defaultInstance: alicloud.ecs.Instance[] = [];
     * for (const range = {value: 0}; range.value < 14; range.value++) {
     *     defaultInstance.push(new alicloud.ecs.Instance(`default-${range.value}`, {
     *         imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
     *         instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
     *         instanceName: name,
     *         securityGroups: [defaultSecurityGroup].map(__item => __item.id),
     *         internetChargeType: "PayByTraffic",
     *         internetMaxBandwidthOut: 10,
     *         availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     *         instanceChargeType: "PostPaid",
     *         systemDiskCategory: "cloud_efficiency",
     *         vswitchId: defaultSwitch.id,
     *     }));
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "terraform-example"
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * # Declare the data source
     * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
     *     instance_type_family="ecs.sn1ne")
     * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
     *     most_recent=True,
     *     owners="system")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name=name,
     *     cidr_block="192.168.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vswitch_name=name,
     *     vpc_id=default_network.id,
     *     cidr_block="192.168.192.0/24",
     *     zone_id=default.zones[0].id)
     * default_security_group = alicloud.ecs.SecurityGroup("default",
     *     name=name,
     *     vpc_id=default_network.id)
     * default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
     *     network_interface_name=name,
     *     vswitch_id=default_switch.id,
     *     security_group_ids=[default_security_group&#46;id])
     * default_instance = []
     * for range in [{"value": i} for i in range(0, 14)]:
     *     default_instance.append(alicloud.ecs.Instance(f"default-{range['value']}",
     *         image_id=default_get_images.images[0].id,
     *         instance_type=default_get_instance_types.instance_types[0].id,
     *         instance_name=name,
     *         security_groups=[__item&#46;id for __item in [default_security_group]],
     *         internet_charge_type="PayByTraffic",
     *         internet_max_bandwidth_out=10,
     *         availability_zone=default.zones[0].id,
     *         instance_charge_type="PostPaid",
     *         system_disk_category="cloud_efficiency",
     *         vswitch_id=default_switch.id))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "terraform-example";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     // Declare the data source
     *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
     *     {
     *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *         InstanceTypeFamily = "ecs.sn1ne",
     *     });
     *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
     *     {
     *         NameRegex = "^ubuntu_[0-9]+_[0-9]+_x64*",
     *         MostRecent = true,
     *         Owners = "system",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = name,
     *         CidrBlock = "192.168.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VswitchName = name,
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "192.168.192.0/24",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *     });
     *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
     *     {
     *         Name = name,
     *         VpcId = defaultNetwork.Id,
     *     });
     *     var defaultEcsNetworkInterface = new AliCloud.Ecs.EcsNetworkInterface("default", new()
     *     {
     *         NetworkInterfaceName = name,
     *         VswitchId = defaultSwitch.Id,
     *         SecurityGroupIds = new[]
     *         {
     *             defaultSecurityGroup.Id,
     *         },
     *     });
     *     var defaultInstance = new List<AliCloud.Ecs.Instance>();
     *     for (var rangeIndex = 0; rangeIndex < 14; rangeIndex++)
     *     {
     *         var range = new { Value = rangeIndex };
     *         defaultInstance.Add(new AliCloud.Ecs.Instance($"default-{range.Value}", new()
     *         {
     *             ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
     *             InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
     *             InstanceName = name,
     *             SecurityGroups = new[]
     *             {
     *                 defaultSecurityGroup,
     *             }.Select(__item => __item.Id).ToList(),
     *             InternetChargeType = "PayByTraffic",
     *             InternetMaxBandwidthOut = 10,
     *             AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *             InstanceChargeType = "PostPaid",
     *             SystemDiskCategory = "cloud_efficiency",
     *             VswitchId = defaultSwitch.Id,
     *         }));
     *     }
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "terraform-example";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * // Declare the data source
     * defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
     * AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
     * InstanceTypeFamily: pulumi.StringRef("ecs.sn1ne"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
     * NameRegex: pulumi.StringRef("^ubuntu_[0-9]+_[0-9]+_x64*"),
     * MostRecent: pulumi.BoolRef(true),
     * Owners: pulumi.StringRef("system"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * VpcName: pulumi.String(name),
     * CidrBlock: pulumi.String("192.168.0.0/16"),
     * })
     * if err != nil {
     * return err
     * }
     * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * VswitchName: pulumi.String(name),
     * VpcId: defaultNetwork.ID(),
     * CidrBlock: pulumi.String("192.168.192.0/24"),
     * ZoneId: pulumi.String(_default.Zones[0].Id),
     * })
     * if err != nil {
     * return err
     * }
     * defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
     * Name: pulumi.String(name),
     * VpcId: defaultNetwork.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * _, err = ecs.NewEcsNetworkInterface(ctx, "default", &ecs.EcsNetworkInterfaceArgs{
     * NetworkInterfaceName: pulumi.String(name),
     * VswitchId: defaultSwitch.ID(),
     * SecurityGroupIds: pulumi.StringArray{
     * defaultSecurityGroup.ID(),
     * },
     * })
     * if err != nil {
     * return err
     * }
     * var splat0 pulumi.StringArray
     * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
     * splat0 = append(splat0, val0.ID())
     * }
     * var defaultInstance []*ecs.Instance
     * for index := 0; index < 14; index++ {
     *     key0 := index
     *     _ := index
     * __res, err := ecs.NewInstance(ctx, fmt.Sprintf("default-%v", key0), &ecs.InstanceArgs{
     * ImageId: pulumi.String(defaultGetImages.Images[0].Id),
     * InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
     * InstanceName: pulumi.String(name),
     * SecurityGroups: splat0,
     * InternetChargeType: pulumi.String("PayByTraffic"),
     * InternetMaxBandwidthOut: pulumi.Int(10),
     * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * InstanceChargeType: pulumi.String("PostPaid"),
     * SystemDiskCategory: pulumi.String("cloud_efficiency"),
     * VswitchId: defaultSwitch.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * defaultInstance = append(defaultInstance, __res)
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
     * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.ecs.EcsNetworkInterface;
     * import com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs;
     * import com.pulumi.alicloud.ecs.Instance;
     * import com.pulumi.alicloud.ecs.InstanceArgs;
     * import com.pulumi.codegen.internal.KeyedValue;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("terraform-example");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         // Declare the data source
     *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
     *             .availabilityZone(default_.zones()[0].id())
     *             .instanceTypeFamily("ecs.sn1ne")
     *             .build());
     *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
     *             .nameRegex("^ubuntu_[0-9]+_[0-9]+_x64*")
     *             .mostRecent(true)
     *             .owners("system")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName(name)
     *             .cidrBlock("192.168.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vswitchName(name)
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("192.168.192.0/24")
     *             .zoneId(default_.zones()[0].id())
     *             .build());
     *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
     *             .name(name)
     *             .vpcId(defaultNetwork.id())
     *             .build());
     *         var defaultEcsNetworkInterface = new EcsNetworkInterface("defaultEcsNetworkInterface", EcsNetworkInterfaceArgs.builder()
     *             .networkInterfaceName(name)
     *             .vswitchId(defaultSwitch.id())
     *             .securityGroupIds(defaultSecurityGroup.id())
     *             .build());
     *         for (var i = 0; i < 14; i++) {
     *             new Instance("defaultInstance-" + i, InstanceArgs.builder()
     *                 .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
     *                 .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
     *                 .instanceName(name)
     *                 .securityGroups(defaultSecurityGroup.stream().map(element -> element.id()).collect(toList()))
     *                 .internetChargeType("PayByTraffic")
     *                 .internetMaxBandwidthOut("10")
     *                 .availabilityZone(default_.zones()[0].id())
     *                 .instanceChargeType("PostPaid")
     *                 .systemDiskCategory("cloud_efficiency")
     *                 .vswitchId(defaultSwitch.id())
     *                 .build());
     * }
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypes.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: GetInstanceTypesPlainArgs): GetInstanceTypesResult =
        getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypes].
     * @param availabilityZone The zone where instance types are supported.
     * @param cpuCoreCount Filter the results to a specific number of cpu cores.
     * @param eniAmount Filter the result whose network interface number is no more than `eni_amount`.
     * @param gpuAmount The GPU amount of an instance type.
     * @param gpuSpec The GPU spec of an instance type.
     * @param imageId The ID of the image.
     * @param instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     * @param instanceType Instance specifications. For more information, see instance Specification Family, or you can call the describe instance types interface to get the latest specification table.
     * @param instanceTypeFamily Filter the results based on their family name. For example: 'ecs.n4'.
     * @param isOutdated If true, outdated instance types are included in the results. Default to false.
     * @param kubernetesNodeRole Filter the result which is used to create a kubernetes cluster
     * and managed kubernetes cluster. Optional Values: `Master` and `Worker`.
     * @param memorySize Filter the results to a specific memory size in GB.
     * @param minimumEniIpv6AddressQuantity The minimum number of IPv6 addresses per ENI. **Note:** If an instance type supports fewer IPv6 addresses per ENI than the specified value, information about the instance type is not queried.
     * @param minimumEniPrivateIpAddressQuantity The minimum expected IPv4 address upper limit of a single ENI when querying instance specifications. **Note:** If an instance type supports fewer IPv4 addresses per ENI than the specified value, information about the instance type is not queried.
     * @param networkType Filter the results by network type. Valid values: `Classic` and `Vpc`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param sortedBy Sort mode, valid values: `CPU`, `Memory`, `Price`.
     * @param spotStrategy Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     * @param systemDiskCategory Filter the results by system disk category. Valid values: `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd_entry`, `cloud_auto`.
     * **NOTE**: Its default value `cloud_efficiency` has been removed from the version v1.150.0.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(
        availabilityZone: String? = null,
        cpuCoreCount: Int? = null,
        eniAmount: Int? = null,
        gpuAmount: Int? = null,
        gpuSpec: String? = null,
        imageId: String? = null,
        instanceChargeType: String? = null,
        instanceType: String? = null,
        instanceTypeFamily: String? = null,
        isOutdated: Boolean? = null,
        kubernetesNodeRole: String? = null,
        memorySize: Double? = null,
        minimumEniIpv6AddressQuantity: Int? = null,
        minimumEniPrivateIpAddressQuantity: Int? = null,
        networkType: String? = null,
        outputFile: String? = null,
        sortedBy: String? = null,
        spotStrategy: String? = null,
        systemDiskCategory: String? = null,
    ): GetInstanceTypesResult {
        val argument = GetInstanceTypesPlainArgs(
            availabilityZone = availabilityZone,
            cpuCoreCount = cpuCoreCount,
            eniAmount = eniAmount,
            gpuAmount = gpuAmount,
            gpuSpec = gpuSpec,
            imageId = imageId,
            instanceChargeType = instanceChargeType,
            instanceType = instanceType,
            instanceTypeFamily = instanceTypeFamily,
            isOutdated = isOutdated,
            kubernetesNodeRole = kubernetesNodeRole,
            memorySize = memorySize,
            minimumEniIpv6AddressQuantity = minimumEniIpv6AddressQuantity,
            minimumEniPrivateIpAddressQuantity = minimumEniPrivateIpAddressQuantity,
            networkType = networkType,
            outputFile = outputFile,
            sortedBy = sortedBy,
            spotStrategy = spotStrategy,
            systemDiskCategory = systemDiskCategory,
        )
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetInstanceTypesPlainArgs].
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: suspend GetInstanceTypesPlainArgsBuilder.() -> Unit): GetInstanceTypesResult {
        val builder = GetInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * The Instances data source list ECS instance resources according to their ID, name regex, image id, status and other fields.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ecs.getInstances({
     *     nameRegex: "web_server",
     *     status: "Running",
     * });
     * export const firstInstanceId = instancesDs.then(instancesDs => instancesDs.instances?.[0]?.id);
     * export const instanceIds = instancesDs.then(instancesDs => instancesDs.ids);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ecs.get_instances(name_regex="web_server",
     *     status="Running")
     * pulumi.export("firstInstanceId", instances_ds.instances[0].id)
     * pulumi.export("instanceIds", instances_ds.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ecs.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "web_server",
     *         Status = "Running",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = instancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *         ["instanceIds"] = instancesDs.Apply(getInstancesResult => getInstancesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		instancesDs, err := ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("web_server"),
     * 			Status:    pulumi.StringRef("Running"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceId", instancesDs.Instances[0].Id)
     * 		ctx.Export("instanceIds", instancesDs.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = EcsFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("web_server")
     *             .status("Running")
     *             .build());
     *         ctx.export("firstInstanceId", instancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         ctx.export("instanceIds", instancesDs.applyValue(getInstancesResult -> getInstancesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstances
     *       Arguments:
     *         nameRegex: web_server
     *         status: Running
     * outputs:
     *   firstInstanceId: ${instancesDs.instances[0].id}
     *   instanceIds: ${instancesDs.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param availabilityZone Availability zone where instances are located.
     * @param enableDetails Default to `true`. If false, the attributes `ram_role_name` and `disk_device_mappings` will not be fetched and output.
     * @param ids A list of ECS instance IDs.
     * @param imageId The image ID of some ECS instance used.
     * @param instanceName The name of the instance. Fuzzy search with the asterisk (*) wildcard characters is supported.
     * @param nameRegex A regex string to filter results by instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param ramRoleName The RAM role name which the instance attaches.
     * @param resourceGroupId The ID of resource group which the instance belongs.
     * @param status Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
     * @param tags A map of tags assigned to the ECS instances. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const taggedInstances = alicloud.ecs.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tagged_instances = alicloud.ecs.get_instances(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var taggedInstances = AliCloud.Ecs.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var taggedInstances = EcsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   taggedInstances:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param vpcId ID of the VPC linked to the instances.
     * @param vswitchId ID of the vSwitch linked to the instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        availabilityZone: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        imageId: String? = null,
        instanceName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        ramRoleName: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            availabilityZone = availabilityZone,
            enableDetails = enableDetails,
            ids = ids,
            imageId = imageId,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            ramRoleName = ramRoleName,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** This datasource has been renamed to alicloud.ecs.getEcsKeyPairs from version 1.121.0.
     * This data source provides a list of key pairs in an Alibaba Cloud account according to the specified filters.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const defaultKeyPair = new alicloud.ecs.KeyPair("default", {keyName: "keyPairDatasource"});
     * const default = alicloud.ecs.getKeyPairsOutput({
     *     nameRegex: defaultKeyPair.keyName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * default_key_pair = alicloud.ecs.KeyPair("default", key_name="keyPairDatasource")
     * default = alicloud.ecs.get_key_pairs_output(name_regex=default_key_pair.key_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var defaultKeyPair = new AliCloud.Ecs.KeyPair("default", new()
     *     {
     *         KeyName = "keyPairDatasource",
     *     });
     *     var @default = AliCloud.Ecs.GetKeyPairs.Invoke(new()
     *     {
     *         NameRegex = defaultKeyPair.KeyName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		defaultKeyPair, err := ecs.NewKeyPair(ctx, "default", &ecs.KeyPairArgs{
     * 			KeyName: pulumi.String("keyPairDatasource"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = ecs.GetKeyPairsOutput(ctx, ecs.GetKeyPairsOutputArgs{
     * 			NameRegex: defaultKeyPair.KeyName,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.KeyPair;
     * import com.pulumi.alicloud.ecs.KeyPairArgs;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetKeyPairsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         var defaultKeyPair = new KeyPair("defaultKeyPair", KeyPairArgs.builder()
     *             .keyName("keyPairDatasource")
     *             .build());
     *         final var default = EcsFunctions.getKeyPairs(GetKeyPairsArgs.builder()
     *             .nameRegex(defaultKeyPair.keyName())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Declare the data source
     *   defaultKeyPair:
     *     type: alicloud:ecs:KeyPair
     *     name: default
     *     properties:
     *       keyName: keyPairDatasource
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getKeyPairs
     *       Arguments:
     *         nameRegex: ${defaultKeyPair.keyName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeyPairs.
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: GetKeyPairsPlainArgs): GetKeyPairsResult =
        getKeyPairsResultToKotlin(getKeyPairsPlain(argument.toJava()).await())

    /**
     * @see [getKeyPairs].
     * @param fingerPrint A finger print used to retrieve specified key pair.
     * @param ids A list of key pair IDs.
     * @param nameRegex A regex string to apply to the resulting key pairs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which the key pair belongs.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(
        fingerPrint: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetKeyPairsResult {
        val argument = GetKeyPairsPlainArgs(
            fingerPrint = fingerPrint,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getKeyPairsResultToKotlin(getKeyPairsPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyPairs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetKeyPairsPlainArgs].
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: suspend GetKeyPairsPlainArgsBuilder.() -> Unit): GetKeyPairsResult {
        val builder = GetKeyPairsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyPairsResultToKotlin(getKeyPairsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** This datasource has been renamed to alicloud.ecs.getEcsNetworkInterfaces from version 1.123.1.
     * Use this data source to get a list of elastic network interfaces according to the specified filters in an Alibaba Cloud account.
     * For information about elastic network interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "networkInterfacesName";
     * const vpc = new alicloud.vpc.Network("vpc", {
     *     vpcName: name,
     *     cidrBlock: "192.168.0.0/24",
     * });
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const vswitch = new alicloud.vpc.Switch("vswitch", {
     *     vswitchName: name,
     *     cidrBlock: "192.168.0.0/24",
     *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     *     vpcId: vpc.id,
     * });
     * const group = new alicloud.ecs.SecurityGroup("group", {
     *     name: name,
     *     vpcId: vpc.id,
     * });
     * const _interface = new alicloud.vpc.NetworkInterface("interface", {
     *     name: `${name}%d`,
     *     vswitchId: vswitch.id,
     *     securityGroups: [group&#46;id],
     *     description: "Basic test",
     *     privateIp: "192.168.0.2",
     *     tags: {
     *         "TF-VER": "0.11.3",
     *     },
     * });
     * const instance = new alicloud.ecs.Instance("instance", {
     *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
     *     securityGroups: [group&#46;id],
     *     instanceType: "ecs.e3.xlarge",
     *     systemDiskCategory: "cloud_efficiency",
     *     imageId: "centos_7_04_64_20G_alibase_201701015.vhd",
     *     instanceName: name,
     *     vswitchId: vswitch.id,
     *     internetMaxBandwidthOut: 10,
     * });
     * const attachment = new alicloud.vpc.NetworkInterfaceAttachment("attachment", {
     *     instanceId: instance.id,
     *     networkInterfaceId: _interface.id,
     * });
     * const defaultGetNetworkInterfaces = alicloud.ecs.getNetworkInterfacesOutput({
     *     ids: [attachment&#46;networkInterfaceId],
     *     nameRegex: name,
     *     tags: {
     *         "TF-VER": "0.11.3",
     *     },
     *     vpcId: vpc.id,
     *     vswitchId: vswitch.id,
     *     privateIp: "192.168.0.2",
     *     securityGroupId: group.id,
     *     type: "Secondary",
     *     instanceId: instance.id,
     * });
     * export const eni0Name = defaultGetNetworkInterfaces.apply(defaultGetNetworkInterfaces => defaultGetNetworkInterfaces.interfaces?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "networkInterfacesName"
     * vpc = alicloud.vpc.Network("vpc",
     *     vpc_name=name,
     *     cidr_block="192.168.0.0/24")
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * vswitch = alicloud.vpc.Switch("vswitch",
     *     vswitch_name=name,
     *     cidr_block="192.168.0.0/24",
     *     availability_zone=default.zones[0].id,
     *     vpc_id=vpc.id)
     * group = alicloud.ecs.SecurityGroup("group",
     *     name=name,
     *     vpc_id=vpc.id)
     * interface = alicloud.vpc.NetworkInterface("interface",
     *     name=f"{name}%d",
     *     vswitch_id=vswitch.id,
     *     security_groups=[group&#46;id],
     *     description="Basic test",
     *     private_ip="192.168.0.2",
     *     tags={
     *         "TF-VER": "0.11.3",
     *     })
     * instance = alicloud.ecs.Instance("instance",
     *     availability_zone=default.zones[0].id,
     *     security_groups=[group&#46;id],
     *     instance_type="ecs.e3.xlarge",
     *     system_disk_category="cloud_efficiency",
     *     image_id="centos_7_04_64_20G_alibase_201701015.vhd",
     *     instance_name=name,
     *     vswitch_id=vswitch.id,
     *     internet_max_bandwidth_out=10)
     * attachment = alicloud.vpc.NetworkInterfaceAttachment("attachment",
     *     instance_id=instance.id,
     *     network_interface_id=interface.id)
     * default_get_network_interfaces = alicloud.ecs.get_network_interfaces_output(ids=[attachment&#46;network_interface_id],
     *     name_regex=name,
     *     tags={
     *         "TF-VER": "0.11.3",
     *     },
     *     vpc_id=vpc.id,
     *     vswitch_id=vswitch.id,
     *     private_ip="192.168.0.2",
     *     security_group_id=group.id,
     *     type="Secondary",
     *     instance_id=instance.id)
     * pulumi.export("eni0Name", default_get_network_interfaces.interfaces[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "networkInterfacesName";
     *     var vpc = new AliCloud.Vpc.Network("vpc", new()
     *     {
     *         VpcName = name,
     *         CidrBlock = "192.168.0.0/24",
     *     });
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
     *     {
     *         VswitchName = name,
     *         CidrBlock = "192.168.0.0/24",
     *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VpcId = vpc.Id,
     *     });
     *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
     *     {
     *         Name = name,
     *         VpcId = vpc.Id,
     *     });
     *     var @interface = new AliCloud.Vpc.NetworkInterface("interface", new()
     *     {
     *         Name = $"{name}%d",
     *         VswitchId = vswitch.Id,
     *         SecurityGroups = new[]
     *         {
     *             @group.Id,
     *         },
     *         Description = "Basic test",
     *         PrivateIp = "192.168.0.2",
     *         Tags =
     *         {
     *             { "TF-VER", "0.11.3" },
     *         },
     *     });
     *     var instance = new AliCloud.Ecs.Instance("instance", new()
     *     {
     *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         SecurityGroups = new[]
     *         {
     *             @group.Id,
     *         },
     *         InstanceType = "ecs.e3.xlarge",
     *         SystemDiskCategory = "cloud_efficiency",
     *         ImageId = "centos_7_04_64_20G_alibase_201701015.vhd",
     *         InstanceName = name,
     *         VswitchId = vswitch.Id,
     *         InternetMaxBandwidthOut = 10,
     *     });
     *     var attachment = new AliCloud.Vpc.NetworkInterfaceAttachment("attachment", new()
     *     {
     *         InstanceId = instance.Id,
     *         NetworkInterfaceId = @interface.Id,
     *     });
     *     var defaultGetNetworkInterfaces = AliCloud.Ecs.GetNetworkInterfaces.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             attachment.NetworkInterfaceId,
     *         },
     *         NameRegex = name,
     *         Tags =
     *         {
     *             { "TF-VER", "0.11.3" },
     *         },
     *         VpcId = vpc.Id,
     *         VswitchId = vswitch.Id,
     *         PrivateIp = "192.168.0.2",
     *         SecurityGroupId = @group.Id,
     *         Type = "Secondary",
     *         InstanceId = instance.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["eni0Name"] = defaultGetNetworkInterfaces&#46;Apply(getNetworkInterfacesResult => getNetworkInterfacesResult&#46;Interfaces[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "networkInterfacesName";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
     * VpcName: pulumi.String(name),
     * CidrBlock: pulumi.String("192.168.0.0/24"),
     * })
     * if err != nil {
     * return err
     * }
     * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
     * VswitchName: pulumi.String(name),
     * CidrBlock: pulumi.String("192.168.0.0/24"),
     * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * VpcId: vpc.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
     * Name: pulumi.String(name),
     * VpcId: vpc.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * interface, err := vpc.NewNetworkInterface(ctx, "interface", &vpc.NetworkInterfaceArgs{
     * Name: pulumi.Sprintf("%v%v", name, "%d"),
     * VswitchId: vswitch.ID(),
     * SecurityGroups: pulumi.StringArray{
     * group.ID(),
     * },
     * Description: pulumi.String("Basic test"),
     * PrivateIp: pulumi.String("192.168.0.2"),
     * Tags: pulumi.StringMap{
     * "TF-VER": pulumi.String("0.11.3"),
     * },
     * })
     * if err != nil {
     * return err
     * }
     * instance, err := ecs.NewInstance(ctx, "instance", &ecs.InstanceArgs{
     * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
     * SecurityGroups: pulumi.StringArray{
     * group.ID(),
     * },
     * InstanceType: pulumi.String("ecs.e3.xlarge"),
     * SystemDiskCategory: pulumi.String("cloud_efficiency"),
     * ImageId: pulumi.String("centos_7_04_64_20G_alibase_201701015.vhd"),
     * InstanceName: pulumi.String(name),
     * VswitchId: vswitch.ID(),
     * InternetMaxBandwidthOut: pulumi.Int(10),
     * })
     * if err != nil {
     * return err
     * }
     * attachment, err := vpc.NewNetworkInterfaceAttachment(ctx, "attachment", &vpc.NetworkInterfaceAttachmentArgs{
     * InstanceId: instance.ID(),
     * NetworkInterfaceId: interface.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * defaultGetNetworkInterfaces := ecs.GetNetworkInterfacesOutput(ctx, ecs.GetNetworkInterfacesOutputArgs{
     * Ids: pulumi.StringArray{
     * attachment.NetworkInterfaceId,
     * },
     * NameRegex: pulumi.String(name),
     * Tags: pulumi.StringMap{
     * "TF-VER": pulumi.String("0.11.3"),
     * },
     * VpcId: vpc.ID(),
     * VswitchId: vswitch.ID(),
     * PrivateIp: pulumi.String("192.168.0.2"),
     * SecurityGroupId: group.ID(),
     * Type: pulumi.String("Secondary"),
     * InstanceId: instance.ID(),
     * }, nil);
     * ctx.Export("eni0Name", defaultGetNetworkInterfaces.ApplyT(func(defaultGetNetworkInterfaces ecs.GetNetworkInterfacesResult) (*string, error) {
     * return &defaultGetNetworkInterfaces.Interfaces[0].Name, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.ecs.SecurityGroup;
     * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
     * import com.pulumi.alicloud.vpc.NetworkInterface;
     * import com.pulumi.alicloud.vpc.NetworkInterfaceArgs;
     * import com.pulumi.alicloud.ecs.Instance;
     * import com.pulumi.alicloud.ecs.InstanceArgs;
     * import com.pulumi.alicloud.vpc.NetworkInterfaceAttachment;
     * import com.pulumi.alicloud.vpc.NetworkInterfaceAttachmentArgs;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("networkInterfacesName");
     *         var vpc = new Network("vpc", NetworkArgs.builder()
     *             .vpcName(name)
     *             .cidrBlock("192.168.0.0/24")
     *             .build());
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
     *             .vswitchName(name)
     *             .cidrBlock("192.168.0.0/24")
     *             .availabilityZone(default_.zones()[0].id())
     *             .vpcId(vpc.id())
     *             .build());
     *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
     *             .name(name)
     *             .vpcId(vpc.id())
     *             .build());
     *         var interface_ = new NetworkInterface("interface", NetworkInterfaceArgs.builder()
     *             .name(String.format("%s%d", name))
     *             .vswitchId(vswitch.id())
     *             .securityGroups(group.id())
     *             .description("Basic test")
     *             .privateIp("192.168.0.2")
     *             .tags(Map.of("TF-VER", "0.11.3"))
     *             .build());
     *         var instance = new Instance("instance", InstanceArgs.builder()
     *             .availabilityZone(default_.zones()[0].id())
     *             .securityGroups(group.id())
     *             .instanceType("ecs.e3.xlarge")
     *             .systemDiskCategory("cloud_efficiency")
     *             .imageId("centos_7_04_64_20G_alibase_201701015.vhd")
     *             .instanceName(name)
     *             .vswitchId(vswitch.id())
     *             .internetMaxBandwidthOut(10)
     *             .build());
     *         var attachment = new NetworkInterfaceAttachment("attachment", NetworkInterfaceAttachmentArgs.builder()
     *             .instanceId(instance.id())
     *             .networkInterfaceId(interface_.id())
     *             .build());
     *         final var defaultGetNetworkInterfaces = EcsFunctions.getNetworkInterfaces(GetNetworkInterfacesArgs.builder()
     *             .ids(attachment.networkInterfaceId())
     *             .nameRegex(name)
     *             .tags(Map.of("TF-VER", "0.11.3"))
     *             .vpcId(vpc.id())
     *             .vswitchId(vswitch.id())
     *             .privateIp("192.168.0.2")
     *             .securityGroupId(group.id())
     *             .type("Secondary")
     *             .instanceId(instance.id())
     *             .build());
     *         ctx.export("eni0Name", defaultGetNetworkInterfaces.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult).applyValue(defaultGetNetworkInterfaces -> defaultGetNetworkInterfaces.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult.interfaces()[0].name())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: networkInterfacesName
     * resources:
     *   vpc:
     *     type: alicloud:vpc:Network
     *     properties:
     *       vpcName: ${name}
     *       cidrBlock: 192.168.0.0/24
     *   vswitch:
     *     type: alicloud:vpc:Switch
     *     properties:
     *       vswitchName: ${name}
     *       cidrBlock: 192.168.0.0/24
     *       availabilityZone: ${default.zones[0].id}
     *       vpcId: ${vpc.id}
     *   group:
     *     type: alicloud:ecs:SecurityGroup
     *     properties:
     *       name: ${name}
     *       vpcId: ${vpc.id}
     *   interface:
     *     type: alicloud:vpc:NetworkInterface
     *     properties:
     *       name: ${name}%d
     *       vswitchId: ${vswitch.id}
     *       securityGroups:
     *         - ${group.id}
     *       description: Basic test
     *       privateIp: 192.168.0.2
     *       tags:
     *         TF-VER: 0.11.3
     *   instance:
     *     type: alicloud:ecs:Instance
     *     properties:
     *       availabilityZone: ${default.zones[0].id}
     *       securityGroups:
     *         - ${group.id}
     *       instanceType: ecs.e3.xlarge
     *       systemDiskCategory: cloud_efficiency
     *       imageId: centos_7_04_64_20G_alibase_201701015.vhd
     *       instanceName: ${name}
     *       vswitchId: ${vswitch.id}
     *       internetMaxBandwidthOut: 10
     *   attachment:
     *     type: alicloud:vpc:NetworkInterfaceAttachment
     *     properties:
     *       instanceId: ${instance.id}
     *       networkInterfaceId: ${interface.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   defaultGetNetworkInterfaces:
     *     fn::invoke:
     *       Function: alicloud:ecs:getNetworkInterfaces
     *       Arguments:
     *         ids:
     *           - ${attachment.networkInterfaceId}
     *         nameRegex: ${name}
     *         tags:
     *           TF-VER: 0.11.3
     *         vpcId: ${vpc.id}
     *         vswitchId: ${vswitch.id}
     *         privateIp: 192.168.0.2
     *         securityGroupId: ${group.id}
     *         type: Secondary
     *         instanceId: ${instance.id}
     * outputs:
     *   eni0Name: ${defaultGetNetworkInterfaces.interfaces[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * ##  Argument Reference
     * The following arguments are supported:
     * * `ids` - (Optional)  A list of ENI IDs.
     * * `name_regex` - (Optional) A regex string to filter results by ENI name.
     * * `vpc_id` - (Optional) The VPC ID linked to ENIs.
     * * `vswitch_id` - (Optional) The vSwitch ID linked to ENIs.
     * * `private_ip` - (Optional) The primary private IP address of the ENI.
     * * `security_group_id` - (Optional) The security group ID linked to ENIs.
     * * `name` - (Optional) The name of the ENIs.
     * * `type` - (Optional) The type of ENIs, Only support for "Primary" or "Secondary".
     * * `instance_id` - (Optional) The ECS instance ID that the ENI is attached to.
     * * `tags` - (Optional) A map of tags assigned to ENIs.
     * * `output_file` - (Optional) The name of output file that saves the filter results.
     * * `resource_group_id` - (Optional, ForceNew, Available in 1.57.0+) The Id of resource group which the network interface belongs.
     * @param argument A collection of arguments for invoking getNetworkInterfaces.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(argument: GetNetworkInterfacesPlainArgs): GetNetworkInterfacesResult =
        getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterfaces].
     * @param ids
     * @param instanceId ID of the instance that the ENI is attached to.
     * @param name Name of the ENI.
     * @param nameRegex
     * @param networkInterfaceName
     * @param outputFile
     * @param primaryIpAddress
     * @param privateIp Primary private IP of the ENI.
     * @param resourceGroupId The Id of resource group.
     * @param securityGroupId
     * @param serviceManaged
     * @param status Current status of the ENI.
     * @param tags A map of tags assigned to the ENI.
     * @param type
     * @param vpcId ID of the VPC that the ENI belongs to.
     * @param vswitchId ID of the vSwitch that the ENI is linked to.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(
        ids: List<String>? = null,
        instanceId: String? = null,
        name: String? = null,
        nameRegex: String? = null,
        networkInterfaceName: String? = null,
        outputFile: String? = null,
        primaryIpAddress: String? = null,
        privateIp: String? = null,
        resourceGroupId: String? = null,
        securityGroupId: String? = null,
        serviceManaged: Boolean? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetNetworkInterfacesResult {
        val argument = GetNetworkInterfacesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            name = name,
            nameRegex = nameRegex,
            networkInterfaceName = networkInterfaceName,
            outputFile = outputFile,
            primaryIpAddress = primaryIpAddress,
            privateIp = privateIp,
            resourceGroupId = resourceGroupId,
            securityGroupId = securityGroupId,
            serviceManaged = serviceManaged,
            status = status,
            tags = tags,
            type = type,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetNetworkInterfacesPlainArgs].
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(argument: suspend GetNetworkInterfacesPlainArgsBuilder.() -> Unit): GetNetworkInterfacesResult {
        val builder = GetNetworkInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.ecs.getSecurityGroupRules` data source provides a collection of security permissions of a specific security group.
     * Each collection item represents a single `ingress` or `egress` permission rule.
     * The ID of the security group can be provided via a variable or the result from the other data source `alicloud.ecs.getSecurityGroups`.
     * ## Example Usage
     * The following example shows how to obtain details about a security group rule and how to pass its data to an instance at launch time.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const securityGroupId = config.requireObject("securityGroupId");
     * // Or get it from the alicloud_security_groups data source.
     * // Please note that the data source arguments must be enough to filter results to one security group.
     * const groupsDs = alicloud.ecs.getSecurityGroups({
     *     nameRegex: "api",
     * });
     * // Filter the security group rule by group
     * const ingressRulesDs = groupsDs.then(groupsDs => alicloud.ecs.getSecurityGroupRules({
     *     groupId: groupsDs.groups?.[0]?.id,
     *     nicType: "internet",
     *     direction: "ingress",
     *     ipProtocol: "tcp",
     * }));
     * // Pass port_range to the backend service
     * const backend = new alicloud.ecs.Instance("backend", {userData: ingressRulesDs.then(ingressRulesDs => `config_service.sh --portrange=${ingressRulesDs.rules?.[0]?.portRange}`)});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * security_group_id = config.require_object("securityGroupId")
     * # Or get it from the alicloud_security_groups data source.
     * # Please note that the data source arguments must be enough to filter results to one security group.
     * groups_ds = alicloud.ecs.get_security_groups(name_regex="api")
     * # Filter the security group rule by group
     * ingress_rules_ds = alicloud.ecs.get_security_group_rules(group_id=groups_ds.groups[0].id,
     *     nic_type="internet",
     *     direction="ingress",
     *     ip_protocol="tcp")
     * # Pass port_range to the backend service
     * backend = alicloud.ecs.Instance("backend", user_data=f"config_service.sh --portrange={ingress_rules_ds.rules[0].port_range}")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var securityGroupId = config.RequireObject<dynamic>("securityGroupId");
     *     // Or get it from the alicloud_security_groups data source.
     *     // Please note that the data source arguments must be enough to filter results to one security group.
     *     var groupsDs = AliCloud.Ecs.GetSecurityGroups.Invoke(new()
     *     {
     *         NameRegex = "api",
     *     });
     *     // Filter the security group rule by group
     *     var ingressRulesDs = AliCloud.Ecs.GetSecurityGroupRules.Invoke(new()
     *     {
     *         GroupId = groupsDs.Apply(getSecurityGroupsResult => getSecurityGroupsResult.Groups[0]?.Id),
     *         NicType = "internet",
     *         Direction = "ingress",
     *         IpProtocol = "tcp",
     *     });
     *     // Pass port_range to the backend service
     *     var backend = new AliCloud.Ecs.Instance("backend", new()
     *     {
     *         UserData = $"config_service.sh --portrange={ingressRulesDs.Apply(getSecurityGroupRulesResult => getSecurityGroupRulesResult.Rules[0]?.PortRange)}",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		securityGroupId := cfg.RequireObject("securityGroupId")
     * 		// Or get it from the alicloud_security_groups data source.
     * 		// Please note that the data source arguments must be enough to filter results to one security group.
     * 		groupsDs, err := ecs.GetSecurityGroups(ctx, &ecs.GetSecurityGroupsArgs{
     * 			NameRegex: pulumi.StringRef("api"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Filter the security group rule by group
     * 		ingressRulesDs, err := ecs.GetSecurityGroupRules(ctx, &ecs.GetSecurityGroupRulesArgs{
     * 			GroupId:    groupsDs.Groups[0].Id,
     * 			NicType:    pulumi.StringRef("internet"),
     * 			Direction:  pulumi.StringRef("ingress"),
     * 			IpProtocol: pulumi.StringRef("tcp"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Pass port_range to the backend service
     * 		_, err = ecs.NewInstance(ctx, "backend", &ecs.InstanceArgs{
     * 			UserData: pulumi.Sprintf("config_service.sh --portrange=%v", ingressRulesDs.Rules[0].PortRange),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupsArgs;
     * import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupRulesArgs;
     * import com.pulumi.alicloud.ecs.Instance;
     * import com.pulumi.alicloud.ecs.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var securityGroupId = config.get("securityGroupId");
     *         // Or get it from the alicloud_security_groups data source.
     *         // Please note that the data source arguments must be enough to filter results to one security group.
     *         final var groupsDs = EcsFunctions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .nameRegex("api")
     *             .build());
     *         // Filter the security group rule by group
     *         final var ingressRulesDs = EcsFunctions.getSecurityGroupRules(GetSecurityGroupRulesArgs.builder()
     *             .groupId(groupsDs.applyValue(getSecurityGroupsResult -> getSecurityGroupsResult.groups()[0].id()))
     *             .nicType("internet")
     *             .direction("ingress")
     *             .ipProtocol("tcp")
     *             .build());
     *         // Pass port_range to the backend service
     *         var backend = new Instance("backend", InstanceArgs.builder()
     *             .userData(String.format("config_service.sh --portrange=%s", ingressRulesDs.applyValue(getSecurityGroupRulesResult -> getSecurityGroupRulesResult.rules()[0].portRange())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   # Get the security group id from a variable
     *   securityGroupId:
     *     type: dynamic
     * resources:
     *   # Pass port_range to the backend service
     *   backend:
     *     type: alicloud:ecs:Instance
     *     properties:
     *       userData: config_service.sh --portrange=${ingressRulesDs.rules[0].portRange}
     * variables:
     *   # Or get it from the alicloud_security_groups data source.
     *   # Please note that the data source arguments must be enough to filter results to one security group.
     *   groupsDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSecurityGroups
     *       Arguments:
     *         nameRegex: api
     *   # Filter the security group rule by group
     *   ingressRulesDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSecurityGroupRules
     *       Arguments:
     *         groupId: ${groupsDs.groups[0].id}
     *         nicType: internet
     *         direction: ingress
     *         ipProtocol: tcp
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroupRules.
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(argument: GetSecurityGroupRulesPlainArgs): GetSecurityGroupRulesResult =
        getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroupRules].
     * @param direction Authorization direction. Valid values are: `ingress` or `egress`.
     * @param groupId The ID of the security group that owns the rules.
     * @param ipProtocol The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
     * @param nicType Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policy Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(
        direction: String? = null,
        groupId: String,
        ipProtocol: String? = null,
        nicType: String? = null,
        outputFile: String? = null,
        policy: String? = null,
    ): GetSecurityGroupRulesResult {
        val argument = GetSecurityGroupRulesPlainArgs(
            direction = direction,
            groupId = groupId,
            ipProtocol = ipProtocol,
            nicType = nicType,
            outputFile = outputFile,
            policy = policy,
        )
        return getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroupRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetSecurityGroupRulesPlainArgs].
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(argument: suspend GetSecurityGroupRulesPlainArgsBuilder.() -> Unit): GetSecurityGroupRulesResult {
        val builder = GetSecurityGroupRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Security Groups in an Alibaba Cloud account according to the specified filters.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Filter security groups and print the results into a file
     * const secGroupsDs = alicloud.ecs.getSecurityGroups({
     *     nameRegex: "^web-",
     *     outputFile: "web_access.json",
     * });
     * // In conjunction with a VPC
     * const primaryVpcDs = new alicloud.vpc.Network("primary_vpc_ds", {});
     * const primarySecGroupsDs = alicloud.ecs.getSecurityGroupsOutput({
     *     vpcId: primaryVpcDs.id,
     * });
     * export const firstGroupId = primarySecGroupsDs.apply(primarySecGroupsDs => primarySecGroupsDs.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Filter security groups and print the results into a file
     * sec_groups_ds = alicloud.ecs.get_security_groups(name_regex="^web-",
     *     output_file="web_access.json")
     * # In conjunction with a VPC
     * primary_vpc_ds = alicloud.vpc.Network("primary_vpc_ds")
     * primary_sec_groups_ds = alicloud.ecs.get_security_groups_output(vpc_id=primary_vpc_ds.id)
     * pulumi.export("firstGroupId", primary_sec_groups_ds.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Filter security groups and print the results into a file
     *     var secGroupsDs = AliCloud.Ecs.GetSecurityGroups.Invoke(new()
     *     {
     *         NameRegex = "^web-",
     *         OutputFile = "web_access.json",
     *     });
     *     // In conjunction with a VPC
     *     var primaryVpcDs = new AliCloud.Vpc.Network("primary_vpc_ds");
     *     var primarySecGroupsDs = AliCloud.Ecs.GetSecurityGroups.Invoke(new()
     *     {
     *         VpcId = primaryVpcDs.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGroupId"] = primarySecGroupsDs&#46;Apply(getSecurityGroupsResult => getSecurityGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Filter security groups and print the results into a file
     * 		_, err := ecs.GetSecurityGroups(ctx, &ecs.GetSecurityGroupsArgs{
     * 			NameRegex:  pulumi.StringRef("^web-"),
     * 			OutputFile: pulumi.StringRef("web_access.json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// In conjunction with a VPC
     * 		primaryVpcDs, err := vpc.NewNetwork(ctx, "primary_vpc_ds", nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		primarySecGroupsDs := ecs.GetSecurityGroupsOutput(ctx, ecs.GetSecurityGroupsOutputArgs{
     * 			VpcId: primaryVpcDs.ID(),
     * 		}, nil)
     * 		ctx.Export("firstGroupId", primarySecGroupsDs.ApplyT(func(primarySecGroupsDs ecs.GetSecurityGroupsResult) (*string, error) {
     * 			return &primarySecGroupsDs.Groups[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupsArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Filter security groups and print the results into a file
     *         final var secGroupsDs = EcsFunctions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .nameRegex("^web-")
     *             .outputFile("web_access.json")
     *             .build());
     *         // In conjunction with a VPC
     *         var primaryVpcDs = new Network("primaryVpcDs");
     *         final var primarySecGroupsDs = EcsFunctions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .vpcId(primaryVpcDs.id())
     *             .build());
     *         ctx.export("firstGroupId", primarySecGroupsDs.applyValue(getSecurityGroupsResult -> getSecurityGroupsResult).applyValue(primarySecGroupsDs -> primarySecGroupsDs.applyValue(getSecurityGroupsResult -> getSecurityGroupsResult.groups()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # In conjunction with a VPC
     *   primaryVpcDs:
     *     type: alicloud:vpc:Network
     *     name: primary_vpc_ds
     * variables:
     *   # Filter security groups and print the results into a file
     *   secGroupsDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSecurityGroups
     *       Arguments:
     *         nameRegex: ^web-
     *         outputFile: web_access.json
     *   primarySecGroupsDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSecurityGroups
     *       Arguments:
     *         vpcId: ${primaryVpcDs.id}
     * outputs:
     *   firstGroupId: ${primarySecGroupsDs.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroups.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(argument: GetSecurityGroupsPlainArgs): GetSecurityGroupsResult =
        getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroups].
     * @param enableDetails
     * @param ids A list of Security Group IDs.
     * @param nameRegex A regex string to filter the resulting security groups by their names.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The Id of resource group which the security_group belongs.
     * @param tags A map of tags assigned to the ECS instances. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const taggedSecurityGroups = alicloud.ecs.getSecurityGroups({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tagged_security_groups = alicloud.ecs.get_security_groups(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var taggedSecurityGroups = AliCloud.Ecs.GetSecurityGroups.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetSecurityGroups(ctx, &ecs.GetSecurityGroupsArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var taggedSecurityGroups = EcsFunctions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   taggedSecurityGroups:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSecurityGroups
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param vpcId Used to retrieve security groups that belong to the specified VPC ID.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetSecurityGroupsResult {
        val argument = GetSecurityGroupsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            tags = tags,
            vpcId = vpcId,
        )
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetSecurityGroupsPlainArgs].
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(argument: suspend GetSecurityGroupsPlainArgsBuilder.() -> Unit): GetSecurityGroupsResult {
        val builder = GetSecurityGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** This datasource has been renamed to alicloud.ecs.getEcsSnapshots from version 1.120.0.
     * Use this data source to get a list of snapshot according to the specified filters in an Alibaba Cloud account.
     * For information about snapshot and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).
     * > **NOTE:**  Available in 1.40.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const snapshots = alicloud.ecs.getSnapshots({
     *     ids: ["s-123456890abcdef"],
     *     nameRegex: "tf-testAcc-snapshot",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * snapshots = alicloud.ecs.get_snapshots(ids=["s-123456890abcdef"],
     *     name_regex="tf-testAcc-snapshot")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var snapshots = AliCloud.Ecs.GetSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "s-123456890abcdef",
     *         },
     *         NameRegex = "tf-testAcc-snapshot",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetSnapshots(ctx, &ecs.GetSnapshotsArgs{
     * 			Ids: []string{
     * 				"s-123456890abcdef",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc-snapshot"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var snapshots = EcsFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .ids("s-123456890abcdef")
     *             .nameRegex("tf-testAcc-snapshot")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   snapshots:
     *     fn::invoke:
     *       Function: alicloud:ecs:getSnapshots
     *       Arguments:
     *         ids:
     *           - s-123456890abcdef
     *         nameRegex: tf-testAcc-snapshot
     * ```
     * <!--End PulumiCodeChooser -->
     * ##  Argument Reference
     * The following arguments are supported:
     * * `instance_id` - (Optional) The specified instance ID.
     * * `disk_id` - (Optional) The specified disk ID.
     * * `encrypted` - (Optional) Queries the encrypted snapshots. Optional values: `true`: Encrypted snapshots. `false`: No encryption attribute limit. Default value: `false`.
     * * `ids` - (Optional)  A list of snapshot IDs.
     * * `name_regex` - (Optional) A regex string to filter results by snapshot name.
     * * `status` - (Optional) The specified snapshot status. Default value: `all`. Optional values:
     *   * progressing: The snapshots are being created.
     *   * accomplished: The snapshots are ready to use.
     *   * failed: The snapshot creation failed.
     *   * all: All status.
     * * `type` - (Optional) The snapshot category. Default value: `all`. Optional values:
     *   * auto: Auto snapshots.
     *   * user: Manual snapshots.
     *   * all: Auto and manual snapshots.
     * * `source_disk_type` - (Optional) The type of source disk:
     *   * System: The snapshots are created for system disks.
     *   * Data: The snapshots are created for data disks.
     * * `usage` - (Optional) The usage of the snapshot:
     *   * image: The snapshots are used to create custom images.
     *   * disk: The snapshots are used to CreateDisk.
     *   * mage_disk: The snapshots are used to create custom images and data disks.
     *   * none: The snapshots are not used yet.
     * * `tags` - (Optional) A map of tags assigned to snapshots.
     * * `output_file` - (Optional) The name of output file that saves the filter results.
     * @param argument A collection of arguments for invoking getSnapshots.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: GetSnapshotsPlainArgs): GetSnapshotsResult =
        getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshots].
     * @param category
     * @param dryRun
     * @param encrypted Whether the snapshot is encrypted or not.
     * @param ids A list of snapshot IDs.
     * @param kmsKeyId
     * @param nameRegex
     * @param outputFile
     * @param resourceGroupId
     * @param snapshotLinkId
     * @param snapshotName
     * @param snapshotType
     * @param sourceDiskType Source disk attribute. Value range: `System`,`Data`.
     * @param status The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
     * @param tags A map of tags assigned to the snapshot.
     * @param type
     * @param usage Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(
        category: String? = null,
        dryRun: Boolean? = null,
        encrypted: Boolean? = null,
        ids: List<String>? = null,
        kmsKeyId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        snapshotLinkId: String? = null,
        snapshotName: String? = null,
        snapshotType: String? = null,
        sourceDiskType: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
        usage: String? = null,
    ): GetSnapshotsResult {
        val argument = GetSnapshotsPlainArgs(
            category = category,
            dryRun = dryRun,
            encrypted = encrypted,
            ids = ids,
            kmsKeyId = kmsKeyId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            snapshotLinkId = snapshotLinkId,
            snapshotName = snapshotName,
            snapshotType = snapshotType,
            sourceDiskType = sourceDiskType,
            status = status,
            tags = tags,
            type = type,
            usage = usage,
        )
        return getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ecs&#46;kotlin&#46;inputs&#46;GetSnapshotsPlainArgs].
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: suspend GetSnapshotsPlainArgsBuilder.() -> Unit): GetSnapshotsResult {
        val builder = GetSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotsResultToKotlin(getSnapshotsPlain(builtArgument.toJava()).await())
    }
}
