@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EcsImageComponent].
 */
@PulumiTagMarker
public class EcsImageComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsImageComponentArgs = EcsImageComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsImageComponentArgsBuilder.() -> Unit) {
        val builder = EcsImageComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsImageComponent {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsImageComponent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsImageComponent(builtJavaResource)
    }
}

/**
 * Provides a Ecs Image Component resource.
 * For information about Ecs Image Component and how to use it, see [What is Image Component](https://www.alibabacloud.com/help/en/doc-detail/200424.htm).
 * > **NOTE:** Available since v1.159.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     nameRegex: "default",
 * });
 * const example = new alicloud.ecs.EcsImageComponent("example", {
 *     componentType: "Build",
 *     content: "RUN yum update -y",
 *     description: "example_value",
 *     imageComponentName: "example_value",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     systemType: "Linux",
 *     tags: {
 *         Created: "TF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
 * example = alicloud.ecs.EcsImageComponent("example",
 *     component_type="Build",
 *     content="RUN yum update -y",
 *     description="example_value",
 *     image_component_name="example_value",
 *     resource_group_id=default.groups[0].id,
 *     system_type="Linux",
 *     tags={
 *         "Created": "TF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         NameRegex = "default",
 *     });
 *     var example = new AliCloud.Ecs.EcsImageComponent("example", new()
 *     {
 *         ComponentType = "Build",
 *         Content = "RUN yum update -y",
 *         Description = "example_value",
 *         ImageComponentName = "example_value",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         SystemType = "Linux",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			NameRegex: pulumi.StringRef("default"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsImageComponent(ctx, "example", &ecs.EcsImageComponentArgs{
 * 			ComponentType:      pulumi.String("Build"),
 * 			Content:            pulumi.String("RUN yum update -y"),
 * 			Description:        pulumi.String("example_value"),
 * 			ImageComponentName: pulumi.String("example_value"),
 * 			ResourceGroupId:    pulumi.String(_default.Groups[0].Id),
 * 			SystemType:         pulumi.String("Linux"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.EcsImageComponent;
 * import com.pulumi.alicloud.ecs.EcsImageComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .nameRegex("default")
 *             .build());
 *         var example = new EcsImageComponent("example", EcsImageComponentArgs.builder()
 *             .componentType("Build")
 *             .content("RUN yum update -y")
 *             .description("example_value")
 *             .imageComponentName("example_value")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .systemType("Linux")
 *             .tags(Map.of("Created", "TF"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:EcsImageComponent
 *     properties:
 *       componentType: Build
 *       content: RUN yum update -y
 *       description: example_value
 *       imageComponentName: example_value
 *       resourceGroupId: ${default.groups[0].id}
 *       systemType: Linux
 *       tags:
 *         Created: TF
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         nameRegex: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Image Component can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsImageComponent:EcsImageComponent example <id>
 * ```
 */
public class EcsImageComponent internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsImageComponent,
) : KotlinCustomResource(javaResource, EcsImageComponentMapper) {
    /**
     * The component type. Currently, only mirror build components are supported. Value: Build.  Default value: Build.
     */
    public val componentType: Output<String>
        get() = javaResource.componentType().applyValue({ args0 -> args0 })

    /**
     * Component content.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * Component creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Describe the information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The component name. The name must be 2 to 128 characters in length and must start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).  Note: If Name is not set, the return value of ImageComponentId is used by default.
     */
    public val imageComponentName: Output<String>
        get() = javaResource.imageComponentName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The operating system supported by the component. Currently, only Linux systems are supported. Value: Linux.  Default value: Linux.
     */
    public val systemType: Output<String>
        get() = javaResource.systemType().applyValue({ args0 -> args0 })

    /**
     * List of label key-value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object EcsImageComponentMapper : ResourceMapper<EcsImageComponent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsImageComponent::class == javaResource::class

    override fun map(javaResource: Resource): EcsImageComponent = EcsImageComponent(
        javaResource as
            com.pulumi.alicloud.ecs.EcsImageComponent,
    )
}

/**
 * @see [EcsImageComponent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsImageComponent].
 */
public suspend fun ecsImageComponent(
    name: String,
    block: suspend EcsImageComponentResourceBuilder.() -> Unit,
): EcsImageComponent {
    val builder = EcsImageComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsImageComponent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsImageComponent(name: String): EcsImageComponent {
    val builder = EcsImageComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
