@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsImageComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Ecs Image Component resource.
 * For information about Ecs Image Component and how to use it, see [What is Image Component](https://www.alibabacloud.com/help/en/doc-detail/200424.htm).
 * > **NOTE:** Available since v1.159.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     nameRegex: "default",
 * });
 * const example = new alicloud.ecs.EcsImageComponent("example", {
 *     componentType: "Build",
 *     content: "RUN yum update -y",
 *     description: "example_value",
 *     imageComponentName: "example_value",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     systemType: "Linux",
 *     tags: {
 *         Created: "TF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
 * example = alicloud.ecs.EcsImageComponent("example",
 *     component_type="Build",
 *     content="RUN yum update -y",
 *     description="example_value",
 *     image_component_name="example_value",
 *     resource_group_id=default.groups[0].id,
 *     system_type="Linux",
 *     tags={
 *         "Created": "TF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         NameRegex = "default",
 *     });
 *     var example = new AliCloud.Ecs.EcsImageComponent("example", new()
 *     {
 *         ComponentType = "Build",
 *         Content = "RUN yum update -y",
 *         Description = "example_value",
 *         ImageComponentName = "example_value",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         SystemType = "Linux",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			NameRegex: pulumi.StringRef("default"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsImageComponent(ctx, "example", &ecs.EcsImageComponentArgs{
 * 			ComponentType:      pulumi.String("Build"),
 * 			Content:            pulumi.String("RUN yum update -y"),
 * 			Description:        pulumi.String("example_value"),
 * 			ImageComponentName: pulumi.String("example_value"),
 * 			ResourceGroupId:    pulumi.String(_default.Groups[0].Id),
 * 			SystemType:         pulumi.String("Linux"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.EcsImageComponent;
 * import com.pulumi.alicloud.ecs.EcsImageComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .nameRegex("default")
 *             .build());
 *         var example = new EcsImageComponent("example", EcsImageComponentArgs.builder()
 *             .componentType("Build")
 *             .content("RUN yum update -y")
 *             .description("example_value")
 *             .imageComponentName("example_value")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .systemType("Linux")
 *             .tags(Map.of("Created", "TF"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:EcsImageComponent
 *     properties:
 *       componentType: Build
 *       content: RUN yum update -y
 *       description: example_value
 *       imageComponentName: example_value
 *       resourceGroupId: ${default.groups[0].id}
 *       systemType: Linux
 *       tags:
 *         Created: TF
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         nameRegex: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Image Component can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsImageComponent:EcsImageComponent example <id>
 * ```
 * @property componentType The component type. Currently, only mirror build components are supported. Value: Build.  Default value: Build.
 * @property content Component content.
 * @property description Describe the information.
 * @property imageComponentName The component name. The name must be 2 to 128 characters in length and must start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).  Note: If Name is not set, the return value of ImageComponentId is used by default.
 * @property resourceGroupId The ID of the resource group.
 * @property systemType The operating system supported by the component. Currently, only Linux systems are supported. Value: Linux.  Default value: Linux.
 * @property tags List of label key-value pairs.
 */
public data class EcsImageComponentArgs(
    public val componentType: Output<String>? = null,
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val imageComponentName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val systemType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsImageComponentArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsImageComponentArgs =
        com.pulumi.alicloud.ecs.EcsImageComponentArgs.builder()
            .componentType(componentType?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .imageComponentName(imageComponentName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .systemType(systemType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EcsImageComponentArgs].
 */
@PulumiTagMarker
public class EcsImageComponentArgsBuilder internal constructor() {
    private var componentType: Output<String>? = null

    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var imageComponentName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var systemType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The component type. Currently, only mirror build components are supported. Value: Build.  Default value: Build.
     */
    @JvmName("asrufgqbimaatxbt")
    public suspend fun componentType(`value`: Output<String>) {
        this.componentType = value
    }

    /**
     * @param value Component content.
     */
    @JvmName("yhbvmdqyiirfansm")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Describe the information.
     */
    @JvmName("pmyyaspkoccurbtr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The component name. The name must be 2 to 128 characters in length and must start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).  Note: If Name is not set, the return value of ImageComponentId is used by default.
     */
    @JvmName("ckxboittfwyhppsb")
    public suspend fun imageComponentName(`value`: Output<String>) {
        this.imageComponentName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("nwlewurrctsptemc")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The operating system supported by the component. Currently, only Linux systems are supported. Value: Linux.  Default value: Linux.
     */
    @JvmName("juxqspeigfhdyxwt")
    public suspend fun systemType(`value`: Output<String>) {
        this.systemType = value
    }

    /**
     * @param value List of label key-value pairs.
     */
    @JvmName("plnpyeastaqsxpek")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The component type. Currently, only mirror build components are supported. Value: Build.  Default value: Build.
     */
    @JvmName("muvpppcghqwhymsf")
    public suspend fun componentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Component content.
     */
    @JvmName("gwteepksschkyywl")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Describe the information.
     */
    @JvmName("cvdcfnopqdrajjcm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The component name. The name must be 2 to 128 characters in length and must start with an uppercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-length colons (:), underscores (_), half-length periods (.), or dashes (-).  Note: If Name is not set, the return value of ImageComponentId is used by default.
     */
    @JvmName("vhmsmgiefescgkio")
    public suspend fun imageComponentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageComponentName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("xkuojyaccoykjfkh")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The operating system supported by the component. Currently, only Linux systems are supported. Value: Linux.  Default value: Linux.
     */
    @JvmName("abgwlaigrxumrvbl")
    public suspend fun systemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemType = mapped
    }

    /**
     * @param value List of label key-value pairs.
     */
    @JvmName("stghnuqkbvoorqdk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values List of label key-value pairs.
     */
    @JvmName("bcqyqnqdgipvlpfp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EcsImageComponentArgs = EcsImageComponentArgs(
        componentType = componentType,
        content = content,
        description = description,
        imageComponentName = imageComponentName,
        resourceGroupId = resourceGroupId,
        systemType = systemType,
        tags = tags,
    )
}
