@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetDataDisk
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetExcludeInstanceFilter
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetNetworkInterface
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetDataDisk.Companion.toKotlin as ecsInstanceSetDataDiskToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetExcludeInstanceFilter.Companion.toKotlin as ecsInstanceSetExcludeInstanceFilterToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsInstanceSetNetworkInterface.Companion.toKotlin as ecsInstanceSetNetworkInterfaceToKotlin

/**
 * Builder for [EcsInstanceSet].
 */
@PulumiTagMarker
public class EcsInstanceSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsInstanceSetArgs = EcsInstanceSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsInstanceSetArgsBuilder.() -> Unit) {
        val builder = EcsInstanceSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsInstanceSet {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsInstanceSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsInstanceSet(builtJavaResource)
    }
}

/**
 * Provides a ECS Instance Set resource.
 * For information about ECS Instance Set and how to use it, see [What is Instance Set](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/runinstances).
 * > **NOTE:** Available since v1.173.0.
 * > **NOTE:** This resource is used to batch create a group of instance resources with the same configuration. However, this resource is not recommended. `alicloud.ecs.Instance` is preferred.
 * > **NOTE:** In the instances managed by this resource, names are automatically generated based on `instance_name` and `unique_suffix`.
 * > **NOTE:** Only `tags` support batch modification.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const beijingK = new alicloud.ecs.EcsInstanceSet("beijing_k", {
 *     amount: 10,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     instanceName: name,
 *     instanceChargeType: "PostPaid",
 *     systemDiskPerformanceLevel: "PL0",
 *     systemDiskCategory: "cloud_efficiency",
 *     systemDiskSize: 200,
 *     vswitchId: defaultSwitch.id,
 *     securityGroupIds: [defaultSecurityGroup].map(__item => __item.id),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * beijing_k = alicloud.ecs.EcsInstanceSet("beijing_k",
 *     amount=10,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     instance_name=name,
 *     instance_charge_type="PostPaid",
 *     system_disk_performance_level="PL0",
 *     system_disk_category="cloud_efficiency",
 *     system_disk_size=200,
 *     vswitch_id=default_switch.id,
 *     security_group_ids=[__item&#46;id for __item in [default_security_group]],
 *     zone_id=default.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var beijingK = new AliCloud.Ecs.EcsInstanceSet("beijing_k", new()
 *     {
 *         Amount = 10,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InstanceName = name,
 *         InstanceChargeType = "PostPaid",
 *         SystemDiskPerformanceLevel = "PL0",
 *         SystemDiskCategory = "cloud_efficiency",
 *         SystemDiskSize = 200,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup,
 *         }.Select(__item => __item.Id).ToList(),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "terraform-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * CpuCoreCount: pulumi.IntRef(1),
 * MemorySize: pulumi.Float64Ref(2),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * MostRecent: pulumi.BoolRef(true),
 * Owners: pulumi.StringRef("system"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * VpcName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * VswitchName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * VpcId: defaultNetwork.ID(),
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(name),
 * VpcId: defaultNetwork.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * _, err = ecs.NewEcsInstanceSet(ctx, "beijing_k", &ecs.EcsInstanceSetArgs{
 * Amount: pulumi.Int(10),
 * ImageId: pulumi.String(defaultGetImages.Images[0].Id),
 * InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * InstanceName: pulumi.String(name),
 * InstanceChargeType: pulumi.String("PostPaid"),
 * SystemDiskPerformanceLevel: pulumi.String("PL0"),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * SystemDiskSize: pulumi.Int(200),
 * VswitchId: defaultSwitch.ID(),
 * SecurityGroupIds: splat0,
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsInstanceSet;
 * import com.pulumi.alicloud.ecs.EcsInstanceSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var beijingK = new EcsInstanceSet("beijingK", EcsInstanceSetArgs.builder()
 *             .amount(10)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .instanceName(name)
 *             .instanceChargeType("PostPaid")
 *             .systemDiskPerformanceLevel("PL0")
 *             .systemDiskCategory("cloud_efficiency")
 *             .systemDiskSize(200)
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroupIds(defaultSecurityGroup.stream().map(element -> element.id()).collect(toList()))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class EcsInstanceSet internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsInstanceSet,
) : KotlinCustomResource(javaResource, EcsInstanceSetMapper) {
    /**
     * The number of instances that you want to create. Valid values: `1` to `100`.
     */
    public val amount: Output<Int>?
        get() = javaResource.amount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The automatic release time of the `PostPaid` instance.
     */
    public val autoReleaseTime: Output<String>?
        get() = javaResource.autoReleaseTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicate how to check instance ready to use.
     */
    public val bootCheckOsWithAssistant: Output<Boolean>?
        get() = javaResource.bootCheckOsWithAssistant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of data disks created with instance. See `data_disks` below..
     */
    public val dataDisks: Output<List<EcsInstanceSetDataDisk>>?
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ecsInstanceSetDataDiskToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
     */
    public val dedicatedHostId: Output<String>?
        get() = javaResource.dedicatedHostId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable release protection for the instance.
     */
    public val deletionProtection: Output<Boolean>
        get() = javaResource.deletionProtection().applyValue({ args0 -> args0 })

    /**
     * The ID of the deployment set to which to deploy the instance.
     */
    public val deploymentSetId: Output<String>?
        get() = javaResource.deploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
     */
    public val excludeInstanceFilter: Output<EcsInstanceSetExcludeInstanceFilter>?
        get() = javaResource.excludeInstanceFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ecsInstanceSetExcludeInstanceFilterToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hostname of instance.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    public val hpcClusterId: Output<String>?
        get() = javaResource.hpcClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Image to use for the instance.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of ECS Instance ID.
     */
    public val instanceIds: Output<List<String>>
        get() = javaResource.instanceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of instance to start.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
     */
    public val internetMaxBandwidthOut: Output<Int>
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 -> args0 })

    /**
     * The name of key pair that can login ECS instance successfully without password.
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the launch template.
     */
    public val launchTemplateId: Output<String>?
        get() = javaResource.launchTemplateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    public val launchTemplateName: Output<String>?
        get() = javaResource.launchTemplateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the launch template.
     */
    public val launchTemplateVersion: Output<String>?
        get() = javaResource.launchTemplateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of NetworkInterface. See `network_interfaces` below..
     */
    public val networkInterfaces: Output<List<EcsInstanceSetNetworkInterface>>?
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ecsInstanceSetNetworkInterfaceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to use the password preset in the image.
     */
    public val passwordInherit: Output<Boolean>?
        get() = javaResource.passwordInherit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Instance RAM role name.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of resource group which the instance belongs.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The security enhancement strategy.
     * - `Active`: Enable security enhancement strategy, it only works on system images.
     * - `Deactive`: Disable security enhancement strategy, it works on all images.
     */
    public val securityEnhancementStrategy: Output<String>?
        get() = javaResource.securityEnhancementStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of security group ids to associate with.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    public val spotPriceLimit: Output<Double>
        get() = javaResource.spotPriceLimit().applyValue({ args0 -> args0 })

    /**
     * The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
     * - `NoSpot`: A regular Pay-As-You-Go instance.
     * - `SpotWithPriceLimit`: A price threshold for a spot instance.
     * - `SpotAsPriceGo`: A price that is based on the highest Pay-As-You-Go instance
     */
    public val spotStrategy: Output<String>
        get() = javaResource.spotStrategy().applyValue({ args0 -> args0 })

    /**
     * The ID of the automatic snapshot policy applied to the system disk.
     */
    public val systemDiskAutoSnapshotPolicyId: Output<String>?
        get() = javaResource.systemDiskAutoSnapshotPolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
     */
    public val systemDiskCategory: Output<String>
        get() = javaResource.systemDiskCategory().applyValue({ args0 -> args0 })

    /**
     * The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    public val systemDiskDescription: Output<String>?
        get() = javaResource.systemDiskDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the system disk.
     */
    public val systemDiskName: Output<String>?
        get() = javaResource.systemDiskName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    public val systemDiskPerformanceLevel: Output<String>
        get() = javaResource.systemDiskPerformanceLevel().applyValue({ args0 -> args0 })

    /**
     * The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
     */
    public val systemDiskSize: Output<Int>
        get() = javaResource.systemDiskSize().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
     */
    public val uniqueSuffix: Output<Boolean>?
        get() = javaResource.uniqueSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual switch ID to launch in VPC.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the zone in which to create the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object EcsInstanceSetMapper : ResourceMapper<EcsInstanceSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsInstanceSet::class == javaResource::class

    override fun map(javaResource: Resource): EcsInstanceSet = EcsInstanceSet(
        javaResource as
            com.pulumi.alicloud.ecs.EcsInstanceSet,
    )
}

/**
 * @see [EcsInstanceSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsInstanceSet].
 */
public suspend fun ecsInstanceSet(
    name: String,
    block: suspend EcsInstanceSetResourceBuilder.() -> Unit,
): EcsInstanceSet {
    val builder = EcsInstanceSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsInstanceSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsInstanceSet(name: String): EcsInstanceSet {
    val builder = EcsInstanceSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
