@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsInstanceSetArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetDataDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetDataDiskArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetExcludeInstanceFilterArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetExcludeInstanceFilterArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetNetworkInterfaceArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsInstanceSetNetworkInterfaceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Instance Set resource.
 * For information about ECS Instance Set and how to use it, see [What is Instance Set](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/runinstances).
 * > **NOTE:** Available since v1.173.0.
 * > **NOTE:** This resource is used to batch create a group of instance resources with the same configuration. However, this resource is not recommended. `alicloud.ecs.Instance` is preferred.
 * > **NOTE:** In the instances managed by this resource, names are automatically generated based on `instance_name` and `unique_suffix`.
 * > **NOTE:** Only `tags` support batch modification.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const beijingK = new alicloud.ecs.EcsInstanceSet("beijing_k", {
 *     amount: 10,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     instanceName: name,
 *     instanceChargeType: "PostPaid",
 *     systemDiskPerformanceLevel: "PL0",
 *     systemDiskCategory: "cloud_efficiency",
 *     systemDiskSize: 200,
 *     vswitchId: defaultSwitch.id,
 *     securityGroupIds: [defaultSecurityGroup].map(__item => __item.id),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * beijing_k = alicloud.ecs.EcsInstanceSet("beijing_k",
 *     amount=10,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     instance_name=name,
 *     instance_charge_type="PostPaid",
 *     system_disk_performance_level="PL0",
 *     system_disk_category="cloud_efficiency",
 *     system_disk_size=200,
 *     vswitch_id=default_switch.id,
 *     security_group_ids=[__item&#46;id for __item in [default_security_group]],
 *     zone_id=default.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var beijingK = new AliCloud.Ecs.EcsInstanceSet("beijing_k", new()
 *     {
 *         Amount = 10,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InstanceName = name,
 *         InstanceChargeType = "PostPaid",
 *         SystemDiskPerformanceLevel = "PL0",
 *         SystemDiskCategory = "cloud_efficiency",
 *         SystemDiskSize = 200,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup,
 *         }.Select(__item => __item.Id).ToList(),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "terraform-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * CpuCoreCount: pulumi.IntRef(1),
 * MemorySize: pulumi.Float64Ref(2),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * MostRecent: pulumi.BoolRef(true),
 * Owners: pulumi.StringRef("system"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * VpcName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * VswitchName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * VpcId: defaultNetwork.ID(),
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(name),
 * VpcId: defaultNetwork.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * _, err = ecs.NewEcsInstanceSet(ctx, "beijing_k", &ecs.EcsInstanceSetArgs{
 * Amount: pulumi.Int(10),
 * ImageId: pulumi.String(defaultGetImages.Images[0].Id),
 * InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * InstanceName: pulumi.String(name),
 * InstanceChargeType: pulumi.String("PostPaid"),
 * SystemDiskPerformanceLevel: pulumi.String("PL0"),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * SystemDiskSize: pulumi.Int(200),
 * VswitchId: defaultSwitch.ID(),
 * SecurityGroupIds: splat0,
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsInstanceSet;
 * import com.pulumi.alicloud.ecs.EcsInstanceSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var beijingK = new EcsInstanceSet("beijingK", EcsInstanceSetArgs.builder()
 *             .amount(10)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .instanceName(name)
 *             .instanceChargeType("PostPaid")
 *             .systemDiskPerformanceLevel("PL0")
 *             .systemDiskCategory("cloud_efficiency")
 *             .systemDiskSize(200)
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroupIds(defaultSecurityGroup.stream().map(element -> element.id()).collect(toList()))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * @property amount The number of instances that you want to create. Valid values: `1` to `100`.
 * @property autoReleaseTime The automatic release time of the `PostPaid` instance.
 * @property autoRenew Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
 * @property autoRenewPeriod Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
 * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
 * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
 * @property bootCheckOsWithAssistant Indicate how to check instance ready to use.
 * @property dataDisks The list of data disks created with instance. See `data_disks` below..
 * @property dedicatedHostId The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
 * @property deletionProtection Whether to enable release protection for the instance.
 * @property deploymentSetId The ID of the deployment set to which to deploy the instance.
 * @property description The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
 * @property excludeInstanceFilter The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
 * @property hostName The hostname of instance.
 * @property hpcClusterId The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
 * @property imageId The Image to use for the instance.
 * @property instanceChargeType The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
 * @property instanceName The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
 * @property instanceType The type of instance to start.
 * @property internetChargeType The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
 * @property internetMaxBandwidthOut The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
 * @property keyPairName The name of key pair that can login ECS instance successfully without password.
 * @property launchTemplateId The ID of the launch template.
 * @property launchTemplateName The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
 * @property launchTemplateVersion The version of the launch template.
 * @property networkInterfaces A list of NetworkInterface. See `network_interfaces` below..
 * @property password The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
 * @property passwordInherit Whether to use the password preset in the image.
 * @property period The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
 * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
 * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
 * @property periodUnit The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
 * @property ramRoleName The Instance RAM role name.
 * @property resourceGroupId The ID of resource group which the instance belongs.
 * @property securityEnhancementStrategy The security enhancement strategy.
 * - `Active`: Enable security enhancement strategy, it only works on system images.
 * - `Deactive`: Disable security enhancement strategy, it works on all images.
 * @property securityGroupIds A list of security group ids to associate with.
 * @property spotPriceLimit The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
 * @property spotStrategy The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
 * - `NoSpot`: A regular Pay-As-You-Go instance.
 * - `SpotWithPriceLimit`: A price threshold for a spot instance.
 * - `SpotAsPriceGo`: A price that is based on the highest Pay-As-You-Go instance
 * @property systemDiskAutoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property systemDiskCategory The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
 * @property systemDiskDescription The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
 * @property systemDiskName The name of the system disk.
 * @property systemDiskPerformanceLevel The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property systemDiskSize The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
 * @property tags A mapping of tags to assign to the resource.
 * @property uniqueSuffix Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
 * @property vswitchId The virtual switch ID to launch in VPC.
 * @property zoneId The ID of the zone in which to create the instance.
 */
public data class EcsInstanceSetArgs(
    public val amount: Output<Int>? = null,
    public val autoReleaseTime: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val bootCheckOsWithAssistant: Output<Boolean>? = null,
    public val dataDisks: Output<List<EcsInstanceSetDataDiskArgs>>? = null,
    public val dedicatedHostId: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val deploymentSetId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val excludeInstanceFilter: Output<EcsInstanceSetExcludeInstanceFilterArgs>? = null,
    public val hostName: Output<String>? = null,
    public val hpcClusterId: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val keyPairName: Output<String>? = null,
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val launchTemplateVersion: Output<String>? = null,
    public val networkInterfaces: Output<List<EcsInstanceSetNetworkInterfaceArgs>>? = null,
    public val password: Output<String>? = null,
    public val passwordInherit: Output<Boolean>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val ramRoleName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityEnhancementStrategy: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val systemDiskAutoSnapshotPolicyId: Output<String>? = null,
    public val systemDiskCategory: Output<String>? = null,
    public val systemDiskDescription: Output<String>? = null,
    public val systemDiskName: Output<String>? = null,
    public val systemDiskPerformanceLevel: Output<String>? = null,
    public val systemDiskSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uniqueSuffix: Output<Boolean>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsInstanceSetArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsInstanceSetArgs =
        com.pulumi.alicloud.ecs.EcsInstanceSetArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .autoReleaseTime(autoReleaseTime?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .bootCheckOsWithAssistant(bootCheckOsWithAssistant?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dedicatedHostId(dedicatedHostId?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .deploymentSetId(deploymentSetId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .excludeInstanceFilter(
                excludeInstanceFilter?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .hpcClusterId(hpcClusterId?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .launchTemplateVersion(launchTemplateVersion?.applyValue({ args0 -> args0 }))
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityEnhancementStrategy(securityEnhancementStrategy?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .systemDiskAutoSnapshotPolicyId(systemDiskAutoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskDescription(systemDiskDescription?.applyValue({ args0 -> args0 }))
            .systemDiskName(systemDiskName?.applyValue({ args0 -> args0 }))
            .systemDiskPerformanceLevel(systemDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uniqueSuffix(uniqueSuffix?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsInstanceSetArgs].
 */
@PulumiTagMarker
public class EcsInstanceSetArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var autoReleaseTime: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var bootCheckOsWithAssistant: Output<Boolean>? = null

    private var dataDisks: Output<List<EcsInstanceSetDataDiskArgs>>? = null

    private var dedicatedHostId: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var deploymentSetId: Output<String>? = null

    private var description: Output<String>? = null

    private var excludeInstanceFilter: Output<EcsInstanceSetExcludeInstanceFilterArgs>? = null

    private var hostName: Output<String>? = null

    private var hpcClusterId: Output<String>? = null

    private var imageId: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var keyPairName: Output<String>? = null

    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var launchTemplateVersion: Output<String>? = null

    private var networkInterfaces: Output<List<EcsInstanceSetNetworkInterfaceArgs>>? = null

    private var password: Output<String>? = null

    private var passwordInherit: Output<Boolean>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var ramRoleName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityEnhancementStrategy: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var systemDiskAutoSnapshotPolicyId: Output<String>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskDescription: Output<String>? = null

    private var systemDiskName: Output<String>? = null

    private var systemDiskPerformanceLevel: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uniqueSuffix: Output<Boolean>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The number of instances that you want to create. Valid values: `1` to `100`.
     */
    @JvmName("ownbasorppusawbn")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value The automatic release time of the `PostPaid` instance.
     */
    @JvmName("qsjwjmtlqmmlssfg")
    public suspend fun autoReleaseTime(`value`: Output<String>) {
        this.autoReleaseTime = value
    }

    /**
     * @param value Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
     */
    @JvmName("prtcuxksolbpiasw")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    @JvmName("jrxqeiblwhemmehe")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Indicate how to check instance ready to use.
     */
    @JvmName("vfrqgaaffarxklay")
    public suspend fun bootCheckOsWithAssistant(`value`: Output<Boolean>) {
        this.bootCheckOsWithAssistant = value
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("ucbltpadkbfyjxlq")
    public suspend fun dataDisks(`value`: Output<List<EcsInstanceSetDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("wxvdnmkweupdpwbc")
    public suspend fun dataDisks(vararg values: Output<EcsInstanceSetDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("rjylpurpdpwvofva")
    public suspend fun dataDisks(values: List<Output<EcsInstanceSetDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
     */
    @JvmName("ydbmvqeykfeadytd")
    public suspend fun dedicatedHostId(`value`: Output<String>) {
        this.dedicatedHostId = value
    }

    /**
     * @param value Whether to enable release protection for the instance.
     */
    @JvmName("hveplwnskvkbjfts")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The ID of the deployment set to which to deploy the instance.
     */
    @JvmName("ikvmdnugvfohwyye")
    public suspend fun deploymentSetId(`value`: Output<String>) {
        this.deploymentSetId = value
    }

    /**
     * @param value The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
     */
    @JvmName("fhdovkkuqphtpyne")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
     */
    @JvmName("avvocldfdfjvmgnt")
    public suspend fun excludeInstanceFilter(`value`: Output<EcsInstanceSetExcludeInstanceFilterArgs>) {
        this.excludeInstanceFilter = value
    }

    /**
     * @param value The hostname of instance.
     */
    @JvmName("vqdrjtipnwkwnpub")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    @JvmName("jvoxrxeemdygwlii")
    public suspend fun hpcClusterId(`value`: Output<String>) {
        this.hpcClusterId = value
    }

    /**
     * @param value The Image to use for the instance.
     */
    @JvmName("copfafcecytqnoms")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
     */
    @JvmName("sfrfwrlojmpxuknf")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
     */
    @JvmName("irwlriposenfiopn")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The type of instance to start.
     */
    @JvmName("vbxftdaxpfvwihui")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
     */
    @JvmName("acwwojbjxtoiagnn")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
     */
    @JvmName("scfacjxmpngsfbwr")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password.
     */
    @JvmName("kbomjpdgpvcffasv")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The ID of the launch template.
     */
    @JvmName("wcaijytsapticfmy")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    @JvmName("kbkycaocbfjlfrgw")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value The version of the launch template.
     */
    @JvmName("kvlmuhmdqalvexxj")
    public suspend fun launchTemplateVersion(`value`: Output<String>) {
        this.launchTemplateVersion = value
    }

    /**
     * @param value A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("cjsrktjgpbrdbptm")
    public suspend fun networkInterfaces(`value`: Output<List<EcsInstanceSetNetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("hhitsmbxttjxoahe")
    public suspend fun networkInterfaces(vararg values: Output<EcsInstanceSetNetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("owxviqnfjrvresbi")
    public suspend fun networkInterfaces(values: List<Output<EcsInstanceSetNetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
     */
    @JvmName("ovqjfvahbukfqqcg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Whether to use the password preset in the image.
     */
    @JvmName("mwisxikpvpyynrtv")
    public suspend fun passwordInherit(`value`: Output<Boolean>) {
        this.passwordInherit = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    @JvmName("agquouxppxdevitq")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
     */
    @JvmName("dxvhlbnlejsoibap")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The Instance RAM role name.
     */
    @JvmName("vfxdthgkorywbbvs")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value The ID of resource group which the instance belongs.
     */
    @JvmName("xyjwtaogjsujykgq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The security enhancement strategy.
     * - `Active`: Enable security enhancement strategy, it only works on system images.
     * - `Deactive`: Disable security enhancement strategy, it works on all images.
     */
    @JvmName("mixuaxhkuwmsqbpu")
    public suspend fun securityEnhancementStrategy(`value`: Output<String>) {
        this.securityEnhancementStrategy = value
    }

    /**
     * @param value A list of security group ids to associate with.
     */
    @JvmName("rglqddfpytprvbwk")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("aawxsqamerfatqhj")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group ids to associate with.
     */
    @JvmName("dmrtjxtmikfdihpk")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    @JvmName("xiqydvqojadquymg")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
     * - `NoSpot`: A regular Pay-As-You-Go instance.
     * - `SpotWithPriceLimit`: A price threshold for a spot instance.
     * - `SpotAsPriceGo`: A price that is based on the highest Pay-As-You-Go instance
     */
    @JvmName("apiawkcdxgwhdnby")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("mipaqjjblghpjyyi")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: Output<String>) {
        this.systemDiskAutoSnapshotPolicyId = value
    }

    /**
     * @param value The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
     */
    @JvmName("wqgopjlcrmaueqnp")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("uviopasgkotmqupn")
    public suspend fun systemDiskDescription(`value`: Output<String>) {
        this.systemDiskDescription = value
    }

    /**
     * @param value The name of the system disk.
     */
    @JvmName("fhcnxgcyipjrhkmm")
    public suspend fun systemDiskName(`value`: Output<String>) {
        this.systemDiskName = value
    }

    /**
     * @param value The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("vjhfljietjpkemgy")
    public suspend fun systemDiskPerformanceLevel(`value`: Output<String>) {
        this.systemDiskPerformanceLevel = value
    }

    /**
     * @param value The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
     */
    @JvmName("wvskcvvvcuvexydi")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nmutqkddxsavidkn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
     */
    @JvmName("yxxaqghaahdxigwc")
    public suspend fun uniqueSuffix(`value`: Output<Boolean>) {
        this.uniqueSuffix = value
    }

    /**
     * @param value The virtual switch ID to launch in VPC.
     */
    @JvmName("bucjwypxxmgfxbql")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone in which to create the instance.
     */
    @JvmName("eebehponecovsvhd")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The number of instances that you want to create. Valid values: `1` to `100`.
     */
    @JvmName("nsborkckehxlgaas")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value The automatic release time of the `PostPaid` instance.
     */
    @JvmName("hrnlxujdknifaxeg")
    public suspend fun autoReleaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReleaseTime = mapped
    }

    /**
     * @param value Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
     */
    @JvmName("ybtgrdpqkfalkwqd")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    @JvmName("urydvjkhufcpoake")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Indicate how to check instance ready to use.
     */
    @JvmName("rpjonjmiqnhtjfho")
    public suspend fun bootCheckOsWithAssistant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootCheckOsWithAssistant = mapped
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("motndvvhbtmtvdpn")
    public suspend fun dataDisks(`value`: List<EcsInstanceSetDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("rhgkcnyphfalaqyd")
    public suspend fun dataDisks(argument: List<suspend EcsInstanceSetDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcsInstanceSetDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("nvthjnjedskgbyhu")
    public suspend fun dataDisks(vararg argument: suspend EcsInstanceSetDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcsInstanceSetDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("ndjhyibbtkunfoww")
    public suspend fun dataDisks(argument: suspend EcsInstanceSetDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EcsInstanceSetDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below..
     */
    @JvmName("gkdymjsphrboiuhk")
    public suspend fun dataDisks(vararg values: EcsInstanceSetDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
     */
    @JvmName("sujchpiahjyqftmv")
    public suspend fun dedicatedHostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostId = mapped
    }

    /**
     * @param value Whether to enable release protection for the instance.
     */
    @JvmName("gktairdxnkgnoxce")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The ID of the deployment set to which to deploy the instance.
     */
    @JvmName("biewavgvwkolneyf")
    public suspend fun deploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetId = mapped
    }

    /**
     * @param value The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
     */
    @JvmName("nkjupvpkoewtsucq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
     */
    @JvmName("vboelqfdhjtwjehu")
    public suspend fun excludeInstanceFilter(`value`: EcsInstanceSetExcludeInstanceFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeInstanceFilter = mapped
    }

    /**
     * @param argument The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
     */
    @JvmName("vxpynhvysqitqhcj")
    public suspend fun excludeInstanceFilter(argument: suspend EcsInstanceSetExcludeInstanceFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EcsInstanceSetExcludeInstanceFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.excludeInstanceFilter = mapped
    }

    /**
     * @param value The hostname of instance.
     */
    @JvmName("uykonkldletidhei")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    @JvmName("lrftbbttontjwwye")
    public suspend fun hpcClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hpcClusterId = mapped
    }

    /**
     * @param value The Image to use for the instance.
     */
    @JvmName("lethjjfysoiicasf")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
     */
    @JvmName("urcrnginqfvgrkeq")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
     */
    @JvmName("jgryruipuatilmrv")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The type of instance to start.
     */
    @JvmName("cojpytiubjilplpx")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
     */
    @JvmName("cdjweiyjupfjcekq")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
     */
    @JvmName("yrojihlttgxjjpvh")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password.
     */
    @JvmName("jctbtgekviqaqccg")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The ID of the launch template.
     */
    @JvmName("hmghytguvmlgetbp")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    @JvmName("vbxphfdmoaunuaio")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value The version of the launch template.
     */
    @JvmName("unhudbtawyiyjgdr")
    public suspend fun launchTemplateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateVersion = mapped
    }

    /**
     * @param value A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("iusmhpxepwjhpwqq")
    public suspend fun networkInterfaces(`value`: List<EcsInstanceSetNetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("evdmaqknmkdwdcun")
    public suspend fun networkInterfaces(argument: List<suspend EcsInstanceSetNetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcsInstanceSetNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("lcewyuhdcnuoptdl")
    public suspend fun networkInterfaces(vararg argument: suspend EcsInstanceSetNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcsInstanceSetNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("knmekfitprlidsqn")
    public suspend fun networkInterfaces(argument: suspend EcsInstanceSetNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EcsInstanceSetNetworkInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values A list of NetworkInterface. See `network_interfaces` below..
     */
    @JvmName("xprdeohyxwbcooyf")
    public suspend fun networkInterfaces(vararg values: EcsInstanceSetNetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
     */
    @JvmName("oyrmoqbsipcoiypf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Whether to use the password preset in the image.
     */
    @JvmName("yilwuxujnyoavvwl")
    public suspend fun passwordInherit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
     * - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     * - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
     */
    @JvmName("kdjusfbemflpfsmd")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
     */
    @JvmName("bbxkynjpfhqyoulo")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The Instance RAM role name.
     */
    @JvmName("buhtldqsntomsgfn")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value The ID of resource group which the instance belongs.
     */
    @JvmName("gxmucbynywdeshwg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security enhancement strategy.
     * - `Active`: Enable security enhancement strategy, it only works on system images.
     * - `Deactive`: Disable security enhancement strategy, it works on all images.
     */
    @JvmName("lwpsljqscrqltryq")
    public suspend fun securityEnhancementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityEnhancementStrategy = mapped
    }

    /**
     * @param value A list of security group ids to associate with.
     */
    @JvmName("fpnkjdfipywtsnrh")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security group ids to associate with.
     */
    @JvmName("gffgdvgepylrqixr")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    @JvmName("wpqmarsrahforubs")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
     * - `NoSpot`: A regular Pay-As-You-Go instance.
     * - `SpotWithPriceLimit`: A price threshold for a spot instance.
     * - `SpotAsPriceGo`: A price that is based on the highest Pay-As-You-Go instance
     */
    @JvmName("fxnacvogfmeibofp")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("bvgafksdethbgnbh")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskAutoSnapshotPolicyId = mapped
    }

    /**
     * @param value The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
     */
    @JvmName("guobcrwysiiyxvin")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("miclcqessgpmkyfd")
    public suspend fun systemDiskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskDescription = mapped
    }

    /**
     * @param value The name of the system disk.
     */
    @JvmName("pgeenfiajaydbyij")
    public suspend fun systemDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskName = mapped
    }

    /**
     * @param value The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("hfusdbawovqnbrqh")
    public suspend fun systemDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskPerformanceLevel = mapped
    }

    /**
     * @param value The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
     */
    @JvmName("wcxqopwouedamjbu")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("dfhnspceocxmihxx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("jxxcjkjyuglafuyr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
     */
    @JvmName("lrafobrmedqvrxdc")
    public suspend fun uniqueSuffix(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueSuffix = mapped
    }

    /**
     * @param value The virtual switch ID to launch in VPC.
     */
    @JvmName("ifcdqnavovurjtlg")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone in which to create the instance.
     */
    @JvmName("hwbucivufynakwio")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): EcsInstanceSetArgs = EcsInstanceSetArgs(
        amount = amount,
        autoReleaseTime = autoReleaseTime,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        bootCheckOsWithAssistant = bootCheckOsWithAssistant,
        dataDisks = dataDisks,
        dedicatedHostId = dedicatedHostId,
        deletionProtection = deletionProtection,
        deploymentSetId = deploymentSetId,
        description = description,
        excludeInstanceFilter = excludeInstanceFilter,
        hostName = hostName,
        hpcClusterId = hpcClusterId,
        imageId = imageId,
        instanceChargeType = instanceChargeType,
        instanceName = instanceName,
        instanceType = instanceType,
        internetChargeType = internetChargeType,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        keyPairName = keyPairName,
        launchTemplateId = launchTemplateId,
        launchTemplateName = launchTemplateName,
        launchTemplateVersion = launchTemplateVersion,
        networkInterfaces = networkInterfaces,
        password = password,
        passwordInherit = passwordInherit,
        period = period,
        periodUnit = periodUnit,
        ramRoleName = ramRoleName,
        resourceGroupId = resourceGroupId,
        securityEnhancementStrategy = securityEnhancementStrategy,
        securityGroupIds = securityGroupIds,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        systemDiskAutoSnapshotPolicyId = systemDiskAutoSnapshotPolicyId,
        systemDiskCategory = systemDiskCategory,
        systemDiskDescription = systemDiskDescription,
        systemDiskName = systemDiskName,
        systemDiskPerformanceLevel = systemDiskPerformanceLevel,
        systemDiskSize = systemDiskSize,
        tags = tags,
        uniqueSuffix = uniqueSuffix,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
