@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EcsKeyPair].
 */
@PulumiTagMarker
public class EcsKeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsKeyPairArgs = EcsKeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsKeyPairArgsBuilder.() -> Unit) {
        val builder = EcsKeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsKeyPair {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsKeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsKeyPair(builtJavaResource)
    }
}

/**
 * Provides a ECS Key Pair resource.
 * For information about ECS Key Pair and how to use it, see [What is Key Pair](https://www.alibabacloud.com/help/en/doc-detail/51771.htm).
 * > **NOTE:** Available in v1.121.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.EcsKeyPair("example", {keyPairName: "key_pair_name"});
 * // Using name prefix to build key pair
 * const prefix = new alicloud.ecs.EcsKeyPair("prefix", {keyNamePrefix: "terraform-test-key-pair-prefix"});
 * // Import an existing public key to build a alicloud key pair
 * const publickey = new alicloud.ecs.EcsKeyPair("publickey", {
 *     keyPairName: "my_public_key",
 *     publicKey: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.EcsKeyPair("example", key_pair_name="key_pair_name")
 * # Using name prefix to build key pair
 * prefix = alicloud.ecs.EcsKeyPair("prefix", key_name_prefix="terraform-test-key-pair-prefix")
 * # Import an existing public key to build a alicloud key pair
 * publickey = alicloud.ecs.EcsKeyPair("publickey",
 *     key_pair_name="my_public_key",
 *     public_key="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.EcsKeyPair("example", new()
 *     {
 *         KeyPairName = "key_pair_name",
 *     });
 *     // Using name prefix to build key pair
 *     var prefix = new AliCloud.Ecs.EcsKeyPair("prefix", new()
 *     {
 *         KeyNamePrefix = "terraform-test-key-pair-prefix",
 *     });
 *     // Import an existing public key to build a alicloud key pair
 *     var publickey = new AliCloud.Ecs.EcsKeyPair("publickey", new()
 *     {
 *         KeyPairName = "my_public_key",
 *         PublicKey = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsKeyPair(ctx, "example", &ecs.EcsKeyPairArgs{
 * 			KeyPairName: pulumi.String("key_pair_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Using name prefix to build key pair
 * 		_, err = ecs.NewEcsKeyPair(ctx, "prefix", &ecs.EcsKeyPairArgs{
 * 			KeyNamePrefix: pulumi.String("terraform-test-key-pair-prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Import an existing public key to build a alicloud key pair
 * 		_, err = ecs.NewEcsKeyPair(ctx, "publickey", &ecs.EcsKeyPairArgs{
 * 			KeyPairName: pulumi.String("my_public_key"),
 * 			PublicKey:   pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsKeyPair;
 * import com.pulumi.alicloud.ecs.EcsKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EcsKeyPair("example", EcsKeyPairArgs.builder()
 *             .keyPairName("key_pair_name")
 *             .build());
 *         // Using name prefix to build key pair
 *         var prefix = new EcsKeyPair("prefix", EcsKeyPairArgs.builder()
 *             .keyNamePrefix("terraform-test-key-pair-prefix")
 *             .build());
 *         // Import an existing public key to build a alicloud key pair
 *         var publickey = new EcsKeyPair("publickey", EcsKeyPairArgs.builder()
 *             .keyPairName("my_public_key")
 *             .publicKey("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyPairName: key_pair_name
 *   # Using name prefix to build key pair
 *   prefix:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyNamePrefix: terraform-test-key-pair-prefix
 *   # Import an existing public key to build a alicloud key pair
 *   publickey:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyPairName: my_public_key
 *       publicKey: ssh-rsa AAAAB3Nza12345678qwertyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsKeyPair:EcsKeyPair example <key_name>
 * ```
 */
public class EcsKeyPair internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsKeyPair,
) : KotlinCustomResource(javaResource, EcsKeyPairMapper) {
    /**
     * The finger print of the key pair.
     */
    public val fingerPrint: Output<String>
        get() = javaResource.fingerPrint().applyValue({ args0 -> args0 })

    /**
     * The key file.
     */
    public val keyFile: Output<String>?
        get() = javaResource.keyFile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Field `key_name` has been deprecated from provider version 1.121.0. New field `key_pair_name` instead.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    public val keyNamePrefix: Output<String>?
        get() = javaResource.keyNamePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key pair's name. It is the only in one Alicloud account, the key pair's name. must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    public val keyPairName: Output<String>
        get() = javaResource.keyPairName().applyValue({ args0 -> args0 })

    /**
     * You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Id of resource group which the key pair belongs.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object EcsKeyPairMapper : ResourceMapper<EcsKeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsKeyPair::class == javaResource::class

    override fun map(javaResource: Resource): EcsKeyPair = EcsKeyPair(
        javaResource as
            com.pulumi.alicloud.ecs.EcsKeyPair,
    )
}

/**
 * @see [EcsKeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsKeyPair].
 */
public suspend fun ecsKeyPair(name: String, block: suspend EcsKeyPairResourceBuilder.() -> Unit): EcsKeyPair {
    val builder = EcsKeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsKeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsKeyPair(name: String): EcsKeyPair {
    val builder = EcsKeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
