@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsKeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Key Pair resource.
 * For information about ECS Key Pair and how to use it, see [What is Key Pair](https://www.alibabacloud.com/help/en/doc-detail/51771.htm).
 * > **NOTE:** Available in v1.121.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.EcsKeyPair("example", {keyPairName: "key_pair_name"});
 * // Using name prefix to build key pair
 * const prefix = new alicloud.ecs.EcsKeyPair("prefix", {keyNamePrefix: "terraform-test-key-pair-prefix"});
 * // Import an existing public key to build a alicloud key pair
 * const publickey = new alicloud.ecs.EcsKeyPair("publickey", {
 *     keyPairName: "my_public_key",
 *     publicKey: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.EcsKeyPair("example", key_pair_name="key_pair_name")
 * # Using name prefix to build key pair
 * prefix = alicloud.ecs.EcsKeyPair("prefix", key_name_prefix="terraform-test-key-pair-prefix")
 * # Import an existing public key to build a alicloud key pair
 * publickey = alicloud.ecs.EcsKeyPair("publickey",
 *     key_pair_name="my_public_key",
 *     public_key="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.EcsKeyPair("example", new()
 *     {
 *         KeyPairName = "key_pair_name",
 *     });
 *     // Using name prefix to build key pair
 *     var prefix = new AliCloud.Ecs.EcsKeyPair("prefix", new()
 *     {
 *         KeyNamePrefix = "terraform-test-key-pair-prefix",
 *     });
 *     // Import an existing public key to build a alicloud key pair
 *     var publickey = new AliCloud.Ecs.EcsKeyPair("publickey", new()
 *     {
 *         KeyPairName = "my_public_key",
 *         PublicKey = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsKeyPair(ctx, "example", &ecs.EcsKeyPairArgs{
 * 			KeyPairName: pulumi.String("key_pair_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Using name prefix to build key pair
 * 		_, err = ecs.NewEcsKeyPair(ctx, "prefix", &ecs.EcsKeyPairArgs{
 * 			KeyNamePrefix: pulumi.String("terraform-test-key-pair-prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Import an existing public key to build a alicloud key pair
 * 		_, err = ecs.NewEcsKeyPair(ctx, "publickey", &ecs.EcsKeyPairArgs{
 * 			KeyPairName: pulumi.String("my_public_key"),
 * 			PublicKey:   pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsKeyPair;
 * import com.pulumi.alicloud.ecs.EcsKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EcsKeyPair("example", EcsKeyPairArgs.builder()
 *             .keyPairName("key_pair_name")
 *             .build());
 *         // Using name prefix to build key pair
 *         var prefix = new EcsKeyPair("prefix", EcsKeyPairArgs.builder()
 *             .keyNamePrefix("terraform-test-key-pair-prefix")
 *             .build());
 *         // Import an existing public key to build a alicloud key pair
 *         var publickey = new EcsKeyPair("publickey", EcsKeyPairArgs.builder()
 *             .keyPairName("my_public_key")
 *             .publicKey("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyPairName: key_pair_name
 *   # Using name prefix to build key pair
 *   prefix:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyNamePrefix: terraform-test-key-pair-prefix
 *   # Import an existing public key to build a alicloud key pair
 *   publickey:
 *     type: alicloud:ecs:EcsKeyPair
 *     properties:
 *       keyPairName: my_public_key
 *       publicKey: ssh-rsa AAAAB3Nza12345678qwertyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsKeyPair:EcsKeyPair example <key_name>
 * ```
 * @property keyFile The key file.
 * @property keyName Field `key_name` has been deprecated from provider version 1.121.0. New field `key_pair_name` instead.
 * @property keyNamePrefix
 * @property keyPairName The key pair's name. It is the only in one Alicloud account, the key pair's name. must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 * @property publicKey You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
 * @property resourceGroupId The Id of resource group which the key pair belongs.
 * @property tags
 */
public data class EcsKeyPairArgs(
    public val keyFile: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>? = null,
    public val keyNamePrefix: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsKeyPairArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsKeyPairArgs =
        com.pulumi.alicloud.ecs.EcsKeyPairArgs.builder()
            .keyFile(keyFile?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyNamePrefix(keyNamePrefix?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EcsKeyPairArgs].
 */
@PulumiTagMarker
public class EcsKeyPairArgsBuilder internal constructor() {
    private var keyFile: Output<String>? = null

    private var keyName: Output<String>? = null

    private var keyNamePrefix: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The key file.
     */
    @JvmName("bwmvmrbtvgjbssri")
    public suspend fun keyFile(`value`: Output<String>) {
        this.keyFile = value
    }

    /**
     * @param value Field `key_name` has been deprecated from provider version 1.121.0. New field `key_pair_name` instead.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("keuwunminrpquacx")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value
     */
    @JvmName("qotrhvwjoyluhwyt")
    public suspend fun keyNamePrefix(`value`: Output<String>) {
        this.keyNamePrefix = value
    }

    /**
     * @param value The key pair's name. It is the only in one Alicloud account, the key pair's name. must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("itlbbpmtcehurpoy")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    @JvmName("hprnlwksjqcnncdb")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The Id of resource group which the key pair belongs.
     */
    @JvmName("jjkjocqjvoltcnts")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("oldivtcgsfyjqciw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The key file.
     */
    @JvmName("aftnudekxqkosvde")
    public suspend fun keyFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFile = mapped
    }

    /**
     * @param value Field `key_name` has been deprecated from provider version 1.121.0. New field `key_pair_name` instead.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("mfikqloqfbkpcmbf")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ehkotlgsyksdjtsn")
    public suspend fun keyNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyNamePrefix = mapped
    }

    /**
     * @param value The key pair's name. It is the only in one Alicloud account, the key pair's name. must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("jlvmcspfrnpwfcjn")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    @JvmName("ifvwnalmtrtuwcxf")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The Id of resource group which the key pair belongs.
     */
    @JvmName("wgjqaumpkmbnovgm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("pnnbplvbglgbhtdi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("shqegfurnvlssawt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EcsKeyPairArgs = EcsKeyPairArgs(
        keyFile = keyFile,
        keyName = keyName,
        keyNamePrefix = keyNamePrefix,
        keyPairName = keyPairName,
        publicKey = publicKey,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
