@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateDataDisk
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateNetworkInterfaces
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateSystemDisk
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateDataDisk.Companion.toKotlin as ecsLaunchTemplateDataDiskToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateNetworkInterfaces.Companion.toKotlin as ecsLaunchTemplateNetworkInterfacesToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsLaunchTemplateSystemDisk.Companion.toKotlin as ecsLaunchTemplateSystemDiskToKotlin

/**
 * Builder for [EcsLaunchTemplate].
 */
@PulumiTagMarker
public class EcsLaunchTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsLaunchTemplateArgs = EcsLaunchTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsLaunchTemplateArgsBuilder.() -> Unit) {
        val builder = EcsLaunchTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsLaunchTemplate {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsLaunchTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsLaunchTemplate(builtJavaResource)
    }
}

/**
 * Provides a ECS Launch Template resource.
 * For information about ECS Launch Template and how to use it, see [What is Launch Template](https://www.alibabacloud.com/help/en/doc-detail/74686.htm).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: "terraform-example",
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultEcsLaunchTemplate = new alicloud.ecs.EcsLaunchTemplate("default", {
 *     launchTemplateName: "terraform-example",
 *     description: "terraform-example",
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     hostName: "terraform-example",
 *     instanceChargeType: "PrePaid",
 *     instanceName: "terraform-example",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     internetChargeType: "PayByBandwidth",
 *     internetMaxBandwidthIn: 5,
 *     internetMaxBandwidthOut: 5,
 *     ioOptimized: "optimized",
 *     keyPairName: "key_pair_name",
 *     ramRoleName: "ram_role_name",
 *     networkType: "vpc",
 *     securityEnhancementStrategy: "Active",
 *     spotPriceLimit: 5,
 *     spotStrategy: "SpotWithPriceLimit",
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 *     systemDisk: {
 *         category: "cloud_ssd",
 *         description: "Test For Terraform",
 *         name: "terraform-example",
 *         size: 40,
 *         deleteWithInstance: false,
 *     },
 *     userData: "xxxxxxx",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     templateTags: {
 *         Create: "Terraform",
 *         For: "example",
 *     },
 *     networkInterfaces: {
 *         name: "eth0",
 *         description: "hello1",
 *         primaryIp: "10.0.0.2",
 *         securityGroupId: defaultSecurityGroup.id,
 *         vswitchId: defaultSwitch.id,
 *     },
 *     dataDisks: [
 *         {
 *             name: "disk1",
 *             description: "description",
 *             deleteWithInstance: true,
 *             category: "cloud",
 *             encrypted: false,
 *             performanceLevel: "PL0",
 *             size: 20,
 *         },
 *         {
 *             name: "disk2",
 *             description: "description2",
 *             deleteWithInstance: true,
 *             category: "cloud",
 *             encrypted: false,
 *             performanceLevel: "PL0",
 *             size: 20,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name="terraform-example",
 *     vpc_id=default_network.id)
 * default_ecs_launch_template = alicloud.ecs.EcsLaunchTemplate("default",
 *     launch_template_name="terraform-example",
 *     description="terraform-example",
 *     image_id=default_get_images.images[0].id,
 *     host_name="terraform-example",
 *     instance_charge_type="PrePaid",
 *     instance_name="terraform-example",
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     internet_charge_type="PayByBandwidth",
 *     internet_max_bandwidth_in=5,
 *     internet_max_bandwidth_out=5,
 *     io_optimized="optimized",
 *     key_pair_name="key_pair_name",
 *     ram_role_name="ram_role_name",
 *     network_type="vpc",
 *     security_enhancement_strategy="Active",
 *     spot_price_limit=5,
 *     spot_strategy="SpotWithPriceLimit",
 *     security_group_ids=[default_security_group&#46;id],
 *     system_disk={
 *         "category": "cloud_ssd",
 *         "description": "Test For Terraform",
 *         "name": "terraform-example",
 *         "size": 40,
 *         "delete_with_instance": False,
 *     },
 *     user_data="xxxxxxx",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id,
 *     template_tags={
 *         "Create": "Terraform",
 *         "For": "example",
 *     },
 *     network_interfaces={
 *         "name": "eth0",
 *         "description": "hello1",
 *         "primary_ip": "10.0.0.2",
 *         "security_group_id": default_security_group.id,
 *         "vswitch_id": default_switch.id,
 *     },
 *     data_disks=[
 *         {
 *             "name": "disk1",
 *             "description": "description",
 *             "delete_with_instance": True,
 *             "category": "cloud",
 *             "encrypted": False,
 *             "performance_level": "PL0",
 *             "size": 20,
 *         },
 *         {
 *             "name": "disk2",
 *             "description": "description2",
 *             "delete_with_instance": True,
 *             "category": "cloud",
 *             "encrypted": False,
 *             "performance_level": "PL0",
 *             "size": 20,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultEcsLaunchTemplate = new AliCloud.Ecs.EcsLaunchTemplate("default", new()
 *     {
 *         LaunchTemplateName = "terraform-example",
 *         Description = "terraform-example",
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         HostName = "terraform-example",
 *         InstanceChargeType = "PrePaid",
 *         InstanceName = "terraform-example",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InternetChargeType = "PayByBandwidth",
 *         InternetMaxBandwidthIn = 5,
 *         InternetMaxBandwidthOut = 5,
 *         IoOptimized = "optimized",
 *         KeyPairName = "key_pair_name",
 *         RamRoleName = "ram_role_name",
 *         NetworkType = "vpc",
 *         SecurityEnhancementStrategy = "Active",
 *         SpotPriceLimit = 5,
 *         SpotStrategy = "SpotWithPriceLimit",
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         SystemDisk = new AliCloud.Ecs.Inputs.EcsLaunchTemplateSystemDiskArgs
 *         {
 *             Category = "cloud_ssd",
 *             Description = "Test For Terraform",
 *             Name = "terraform-example",
 *             Size = 40,
 *             DeleteWithInstance = false,
 *         },
 *         UserData = "xxxxxxx",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         TemplateTags =
 *         {
 *             { "Create", "Terraform" },
 *             { "For", "example" },
 *         },
 *         NetworkInterfaces = new AliCloud.Ecs.Inputs.EcsLaunchTemplateNetworkInterfacesArgs
 *         {
 *             Name = "eth0",
 *             Description = "hello1",
 *             PrimaryIp = "10.0.0.2",
 *             SecurityGroupId = defaultSecurityGroup.Id,
 *             VswitchId = defaultSwitch.Id,
 *         },
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.EcsLaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk1",
 *                 Description = "description",
 *                 DeleteWithInstance = true,
 *                 Category = "cloud",
 *                 Encrypted = false,
 *                 PerformanceLevel = "PL0",
 *                 Size = 20,
 *             },
 *             new AliCloud.Ecs.Inputs.EcsLaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Description = "description2",
 *                 DeleteWithInstance = true,
 *                 Category = "cloud",
 *                 Encrypted = false,
 *                 PerformanceLevel = "PL0",
 *                 Size = 20,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsLaunchTemplate(ctx, "default", &ecs.EcsLaunchTemplateArgs{
 * 			LaunchTemplateName:          pulumi.String("terraform-example"),
 * 			Description:                 pulumi.String("terraform-example"),
 * 			ImageId:                     pulumi.String(defaultGetImages.Images[0].Id),
 * 			HostName:                    pulumi.String("terraform-example"),
 * 			InstanceChargeType:          pulumi.String("PrePaid"),
 * 			InstanceName:                pulumi.String("terraform-example"),
 * 			InstanceType:                pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			InternetChargeType:          pulumi.String("PayByBandwidth"),
 * 			InternetMaxBandwidthIn:      pulumi.Int(5),
 * 			InternetMaxBandwidthOut:     pulumi.Int(5),
 * 			IoOptimized:                 pulumi.String("optimized"),
 * 			KeyPairName:                 pulumi.String("key_pair_name"),
 * 			RamRoleName:                 pulumi.String("ram_role_name"),
 * 			NetworkType:                 pulumi.String("vpc"),
 * 			SecurityEnhancementStrategy: pulumi.String("Active"),
 * 			SpotPriceLimit:              pulumi.Float64(5),
 * 			SpotStrategy:                pulumi.String("SpotWithPriceLimit"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			SystemDisk: &ecs.EcsLaunchTemplateSystemDiskArgs{
 * 				Category:           pulumi.String("cloud_ssd"),
 * 				Description:        pulumi.String("Test For Terraform"),
 * 				Name:               pulumi.String("terraform-example"),
 * 				Size:               pulumi.Int(40),
 * 				DeleteWithInstance: pulumi.Bool(false),
 * 			},
 * 			UserData:  pulumi.String("xxxxxxx"),
 * 			VswitchId: defaultSwitch.ID(),
 * 			VpcId:     defaultNetwork.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			TemplateTags: pulumi.StringMap{
 * 				"Create": pulumi.String("Terraform"),
 * 				"For":    pulumi.String("example"),
 * 			},
 * 			NetworkInterfaces: &ecs.EcsLaunchTemplateNetworkInterfacesArgs{
 * 				Name:            pulumi.String("eth0"),
 * 				Description:     pulumi.String("hello1"),
 * 				PrimaryIp:       pulumi.String("10.0.0.2"),
 * 				SecurityGroupId: defaultSecurityGroup.ID(),
 * 				VswitchId:       defaultSwitch.ID(),
 * 			},
 * 			DataDisks: ecs.EcsLaunchTemplateDataDiskArray{
 * 				&ecs.EcsLaunchTemplateDataDiskArgs{
 * 					Name:               pulumi.String("disk1"),
 * 					Description:        pulumi.String("description"),
 * 					DeleteWithInstance: pulumi.Bool(true),
 * 					Category:           pulumi.String("cloud"),
 * 					Encrypted:          pulumi.Bool(false),
 * 					PerformanceLevel:   pulumi.String("PL0"),
 * 					Size:               pulumi.Int(20),
 * 				},
 * 				&ecs.EcsLaunchTemplateDataDiskArgs{
 * 					Name:               pulumi.String("disk2"),
 * 					Description:        pulumi.String("description2"),
 * 					DeleteWithInstance: pulumi.Bool(true),
 * 					Category:           pulumi.String("cloud"),
 * 					Encrypted:          pulumi.Bool(false),
 * 					PerformanceLevel:   pulumi.String("PL0"),
 * 					Size:               pulumi.Int(20),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplate;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateNetworkInterfacesArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultEcsLaunchTemplate = new EcsLaunchTemplate("defaultEcsLaunchTemplate", EcsLaunchTemplateArgs.builder()
 *             .launchTemplateName("terraform-example")
 *             .description("terraform-example")
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .hostName("terraform-example")
 *             .instanceChargeType("PrePaid")
 *             .instanceName("terraform-example")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .internetChargeType("PayByBandwidth")
 *             .internetMaxBandwidthIn("5")
 *             .internetMaxBandwidthOut("5")
 *             .ioOptimized("optimized")
 *             .keyPairName("key_pair_name")
 *             .ramRoleName("ram_role_name")
 *             .networkType("vpc")
 *             .securityEnhancementStrategy("Active")
 *             .spotPriceLimit("5")
 *             .spotStrategy("SpotWithPriceLimit")
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .systemDisk(EcsLaunchTemplateSystemDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .description("Test For Terraform")
 *                 .name("terraform-example")
 *                 .size("40")
 *                 .deleteWithInstance("false")
 *                 .build())
 *             .userData("xxxxxxx")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .templateTags(Map.ofEntries(
 *                 Map.entry("Create", "Terraform"),
 *                 Map.entry("For", "example")
 *             ))
 *             .networkInterfaces(EcsLaunchTemplateNetworkInterfacesArgs.builder()
 *                 .name("eth0")
 *                 .description("hello1")
 *                 .primaryIp("10.0.0.2")
 *                 .securityGroupId(defaultSecurityGroup.id())
 *                 .vswitchId(defaultSwitch.id())
 *                 .build())
 *             .dataDisks(
 *                 EcsLaunchTemplateDataDiskArgs.builder()
 *                     .name("disk1")
 *                     .description("description")
 *                     .deleteWithInstance("true")
 *                     .category("cloud")
 *                     .encrypted("false")
 *                     .performanceLevel("PL0")
 *                     .size("20")
 *                     .build(),
 *                 EcsLaunchTemplateDataDiskArgs.builder()
 *                     .name("disk2")
 *                     .description("description2")
 *                     .deleteWithInstance("true")
 *                     .category("cloud")
 *                     .encrypted("false")
 *                     .performanceLevel("PL0")
 *                     .size("20")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: terraform-example
 *       vpcId: ${defaultNetwork.id}
 *   defaultEcsLaunchTemplate:
 *     type: alicloud:ecs:EcsLaunchTemplate
 *     name: default
 *     properties:
 *       launchTemplateName: terraform-example
 *       description: terraform-example
 *       imageId: ${defaultGetImages.images[0].id}
 *       hostName: terraform-example
 *       instanceChargeType: PrePaid
 *       instanceName: terraform-example
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       internetChargeType: PayByBandwidth
 *       internetMaxBandwidthIn: '5'
 *       internetMaxBandwidthOut: '5'
 *       ioOptimized: optimized
 *       keyPairName: key_pair_name
 *       ramRoleName: ram_role_name
 *       networkType: vpc
 *       securityEnhancementStrategy: Active
 *       spotPriceLimit: '5'
 *       spotStrategy: SpotWithPriceLimit
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *       systemDisk:
 *         category: cloud_ssd
 *         description: Test For Terraform
 *         name: terraform-example
 *         size: '40'
 *         deleteWithInstance: 'false'
 *       userData: xxxxxxx
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *       templateTags:
 *         Create: Terraform
 *         For: example
 *       networkInterfaces:
 *         name: eth0
 *         description: hello1
 *         primaryIp: 10.0.0.2
 *         securityGroupId: ${defaultSecurityGroup.id}
 *         vswitchId: ${defaultSwitch.id}
 *       dataDisks:
 *         - name: disk1
 *           description: description
 *           deleteWithInstance: 'true'
 *           category: cloud
 *           encrypted: 'false'
 *           performanceLevel: PL0
 *           size: '20'
 *         - name: disk2
 *           description: description2
 *           deleteWithInstance: 'true'
 *           category: cloud
 *           encrypted: 'false'
 *           performanceLevel: PL0
 *           size: '20'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Launch Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsLaunchTemplate:EcsLaunchTemplate example <id>
 * ```
 */
public class EcsLaunchTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsLaunchTemplate,
) : KotlinCustomResource(javaResource, EcsLaunchTemplateMapper) {
    /**
     * Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    public val autoReleaseTime: Output<String>?
        get() = javaResource.autoReleaseTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable auto-renewal for the instance. This parameter is valid only if `internet_charge_type` is set to `PrePaid`.
     */
    public val autoRenew: Output<Boolean>
        get() = javaResource.autoRenew().applyValue({ args0 -> args0 })

    /**
     * The auto-renewal period of the instance. Valid values when `period_unit` is set to `Month`: 1, 2, 3, 6, 12, 24, 36, 48, and 60. Default value: 1.
     */
    public val autoRenewPeriod: Output<Int>
        get() = javaResource.autoRenewPeriod().applyValue({ args0 -> args0 })

    /**
     * The list of data disks created with instance. See `data_disks` below.
     */
    public val dataDisks: Output<List<EcsLaunchTemplateDataDisk>>?
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ecsLaunchTemplateDataDiskToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The Deployment Set Id.
     */
    public val deploymentSetId: Output<String>?
        get() = javaResource.deploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable the instance operating system configuration.
     */
    public val enableVmOsConfig: Output<Boolean>?
        get() = javaResource.enableVmOsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    public val hostName: Output<String>?
        get() = javaResource.hostName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Image ID.
     */
    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Mirror source. Valid values: `system`, `self`, `others`, `marketplace`, `""`. Default to: `""`.
     */
    public val imageOwnerAlias: Output<String>?
        get() = javaResource.imageOwnerAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Billing methods. Valid values: `PostPaid`, `PrePaid`.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the instance. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), periods (.), commas (,), brackets ([]), and hyphens (-).
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Internet bandwidth billing method. Valid values: `PayByTraffic`, `PayByBandwidth`.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    public val internetMaxBandwidthIn: Output<Int>
        get() = javaResource.internetMaxBandwidthIn().applyValue({ args0 -> args0 })

    /**
     * Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    public val internetMaxBandwidthOut: Output<Int>?
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether it is an I/O-optimized instance or not. Valid values: `none`, `optimized`.
     */
    public val ioOptimized: Output<String>?
        get() = javaResource.ioOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of Launch Template.
     */
    public val launchTemplateName: Output<String>
        get() = javaResource.launchTemplateName().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.120.0, and use field `launch_template_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of network interfaces created with instance. See `network_interfaces` below.
     */
    public val networkInterfaces: Output<EcsLaunchTemplateNetworkInterfaces>?
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ecsLaunchTemplateNetworkInterfacesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Network type of the instance. Valid values: `classic`, `vpc`.
     */
    public val networkType: Output<String>?
        get() = javaResource.networkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to use the password preset by the mirror.
     */
    public val passwordInherit: Output<Boolean>?
        get() = javaResource.passwordInherit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscription period of the instance. Unit: months. This parameter takes effect and is required only when InstanceChargeType is set to PrePaid. If the DedicatedHostId parameter is specified, the value of the Period parameter must be within the subscription period of the dedicated host.
     * - When the PeriodUnit parameter is set to `Week`, the valid values of the Period parameter are `1`, `2`, `3`, and `4`.
     * - When the PeriodUnit parameter is set to `Month`, the valid values of the Period parameter are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, and `60`.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The unit of the subscription period. Valid values: `Month` (default).
     */
    public val periodUnit: Output<String>
        get() = javaResource.periodUnit().applyValue({ args0 -> args0 })

    /**
     * The private IP address of the instance.
     */
    public val privateIpAddress: Output<String>?
        get() = javaResource.privateIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not to activate the security enhancement feature and install network security software free of charge. Valid values: `Active`, `Deactive`.
     */
    public val securityEnhancementStrategy: Output<String>?
        get() = javaResource.securityEnhancementStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The security group ID.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of security group N to which to assign the instance.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The protection period of the preemptible instance. Unit: hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, and `6`. Default to: `1`.
     */
    public val spotDuration: Output<String>?
        get() = javaResource.spotDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    public val spotPriceLimit: Output<Double>?
        get() = javaResource.spotPriceLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
     */
    public val spotStrategy: Output<String>?
        get() = javaResource.spotStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The System Disk. See `system_disk` below.
     */
    public val systemDisk: Output<EcsLaunchTemplateSystemDisk>
        get() = javaResource.systemDisk().applyValue({ args0 ->
            args0.let({ args0 ->
                ecsLaunchTemplateSystemDiskToKotlin(args0)
            })
        })

    /**
     * It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskCategory: Output<String>
        get() = javaResource.systemDiskCategory().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskDescription: Output<String>
        get() = javaResource.systemDiskDescription().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskName: Output<String>
        get() = javaResource.systemDiskName().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskSize: Output<Int>
        get() = javaResource.systemDiskSize().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to instance, block storage, and elastic network.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The template resource group id.
     */
    public val templateResourceGroupId: Output<String>?
        get() = javaResource.templateResourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the launch template.
     */
    public val templateTags: Output<Map<String, String>>?
        get() = javaResource.templateTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The User Data.
     */
    public val userData: Output<String>
        get() = javaResource.userData().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.120.0, and use field `user_data` instead.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    public val userdata: Output<String>
        get() = javaResource.userdata().applyValue({ args0 -> args0 })

    /**
     * The description of the launch template version. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    public val versionDescription: Output<String>?
        get() = javaResource.versionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The zone ID of the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object EcsLaunchTemplateMapper : ResourceMapper<EcsLaunchTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsLaunchTemplate::class == javaResource::class

    override fun map(javaResource: Resource): EcsLaunchTemplate = EcsLaunchTemplate(
        javaResource as
            com.pulumi.alicloud.ecs.EcsLaunchTemplate,
    )
}

/**
 * @see [EcsLaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsLaunchTemplate].
 */
public suspend fun ecsLaunchTemplate(
    name: String,
    block: suspend EcsLaunchTemplateResourceBuilder.() -> Unit,
): EcsLaunchTemplate {
    val builder = EcsLaunchTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsLaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsLaunchTemplate(name: String): EcsLaunchTemplate {
    val builder = EcsLaunchTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
