@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateDataDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateDataDiskArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateNetworkInterfacesArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateNetworkInterfacesArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateSystemDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsLaunchTemplateSystemDiskArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Launch Template resource.
 * For information about ECS Launch Template and how to use it, see [What is Launch Template](https://www.alibabacloud.com/help/en/doc-detail/74686.htm).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: "terraform-example",
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultEcsLaunchTemplate = new alicloud.ecs.EcsLaunchTemplate("default", {
 *     launchTemplateName: "terraform-example",
 *     description: "terraform-example",
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     hostName: "terraform-example",
 *     instanceChargeType: "PrePaid",
 *     instanceName: "terraform-example",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     internetChargeType: "PayByBandwidth",
 *     internetMaxBandwidthIn: 5,
 *     internetMaxBandwidthOut: 5,
 *     ioOptimized: "optimized",
 *     keyPairName: "key_pair_name",
 *     ramRoleName: "ram_role_name",
 *     networkType: "vpc",
 *     securityEnhancementStrategy: "Active",
 *     spotPriceLimit: 5,
 *     spotStrategy: "SpotWithPriceLimit",
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 *     systemDisk: {
 *         category: "cloud_ssd",
 *         description: "Test For Terraform",
 *         name: "terraform-example",
 *         size: 40,
 *         deleteWithInstance: false,
 *     },
 *     userData: "xxxxxxx",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     templateTags: {
 *         Create: "Terraform",
 *         For: "example",
 *     },
 *     networkInterfaces: {
 *         name: "eth0",
 *         description: "hello1",
 *         primaryIp: "10.0.0.2",
 *         securityGroupId: defaultSecurityGroup.id,
 *         vswitchId: defaultSwitch.id,
 *     },
 *     dataDisks: [
 *         {
 *             name: "disk1",
 *             description: "description",
 *             deleteWithInstance: true,
 *             category: "cloud",
 *             encrypted: false,
 *             performanceLevel: "PL0",
 *             size: 20,
 *         },
 *         {
 *             name: "disk2",
 *             description: "description2",
 *             deleteWithInstance: true,
 *             category: "cloud",
 *             encrypted: false,
 *             performanceLevel: "PL0",
 *             size: 20,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name="terraform-example",
 *     vpc_id=default_network.id)
 * default_ecs_launch_template = alicloud.ecs.EcsLaunchTemplate("default",
 *     launch_template_name="terraform-example",
 *     description="terraform-example",
 *     image_id=default_get_images.images[0].id,
 *     host_name="terraform-example",
 *     instance_charge_type="PrePaid",
 *     instance_name="terraform-example",
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     internet_charge_type="PayByBandwidth",
 *     internet_max_bandwidth_in=5,
 *     internet_max_bandwidth_out=5,
 *     io_optimized="optimized",
 *     key_pair_name="key_pair_name",
 *     ram_role_name="ram_role_name",
 *     network_type="vpc",
 *     security_enhancement_strategy="Active",
 *     spot_price_limit=5,
 *     spot_strategy="SpotWithPriceLimit",
 *     security_group_ids=[default_security_group&#46;id],
 *     system_disk={
 *         "category": "cloud_ssd",
 *         "description": "Test For Terraform",
 *         "name": "terraform-example",
 *         "size": 40,
 *         "delete_with_instance": False,
 *     },
 *     user_data="xxxxxxx",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id,
 *     template_tags={
 *         "Create": "Terraform",
 *         "For": "example",
 *     },
 *     network_interfaces={
 *         "name": "eth0",
 *         "description": "hello1",
 *         "primary_ip": "10.0.0.2",
 *         "security_group_id": default_security_group.id,
 *         "vswitch_id": default_switch.id,
 *     },
 *     data_disks=[
 *         {
 *             "name": "disk1",
 *             "description": "description",
 *             "delete_with_instance": True,
 *             "category": "cloud",
 *             "encrypted": False,
 *             "performance_level": "PL0",
 *             "size": 20,
 *         },
 *         {
 *             "name": "disk2",
 *             "description": "description2",
 *             "delete_with_instance": True,
 *             "category": "cloud",
 *             "encrypted": False,
 *             "performance_level": "PL0",
 *             "size": 20,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultEcsLaunchTemplate = new AliCloud.Ecs.EcsLaunchTemplate("default", new()
 *     {
 *         LaunchTemplateName = "terraform-example",
 *         Description = "terraform-example",
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         HostName = "terraform-example",
 *         InstanceChargeType = "PrePaid",
 *         InstanceName = "terraform-example",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InternetChargeType = "PayByBandwidth",
 *         InternetMaxBandwidthIn = 5,
 *         InternetMaxBandwidthOut = 5,
 *         IoOptimized = "optimized",
 *         KeyPairName = "key_pair_name",
 *         RamRoleName = "ram_role_name",
 *         NetworkType = "vpc",
 *         SecurityEnhancementStrategy = "Active",
 *         SpotPriceLimit = 5,
 *         SpotStrategy = "SpotWithPriceLimit",
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         SystemDisk = new AliCloud.Ecs.Inputs.EcsLaunchTemplateSystemDiskArgs
 *         {
 *             Category = "cloud_ssd",
 *             Description = "Test For Terraform",
 *             Name = "terraform-example",
 *             Size = 40,
 *             DeleteWithInstance = false,
 *         },
 *         UserData = "xxxxxxx",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         TemplateTags =
 *         {
 *             { "Create", "Terraform" },
 *             { "For", "example" },
 *         },
 *         NetworkInterfaces = new AliCloud.Ecs.Inputs.EcsLaunchTemplateNetworkInterfacesArgs
 *         {
 *             Name = "eth0",
 *             Description = "hello1",
 *             PrimaryIp = "10.0.0.2",
 *             SecurityGroupId = defaultSecurityGroup.Id,
 *             VswitchId = defaultSwitch.Id,
 *         },
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.EcsLaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk1",
 *                 Description = "description",
 *                 DeleteWithInstance = true,
 *                 Category = "cloud",
 *                 Encrypted = false,
 *                 PerformanceLevel = "PL0",
 *                 Size = 20,
 *             },
 *             new AliCloud.Ecs.Inputs.EcsLaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Description = "description2",
 *                 DeleteWithInstance = true,
 *                 Category = "cloud",
 *                 Encrypted = false,
 *                 PerformanceLevel = "PL0",
 *                 Size = 20,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsLaunchTemplate(ctx, "default", &ecs.EcsLaunchTemplateArgs{
 * 			LaunchTemplateName:          pulumi.String("terraform-example"),
 * 			Description:                 pulumi.String("terraform-example"),
 * 			ImageId:                     pulumi.String(defaultGetImages.Images[0].Id),
 * 			HostName:                    pulumi.String("terraform-example"),
 * 			InstanceChargeType:          pulumi.String("PrePaid"),
 * 			InstanceName:                pulumi.String("terraform-example"),
 * 			InstanceType:                pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			InternetChargeType:          pulumi.String("PayByBandwidth"),
 * 			InternetMaxBandwidthIn:      pulumi.Int(5),
 * 			InternetMaxBandwidthOut:     pulumi.Int(5),
 * 			IoOptimized:                 pulumi.String("optimized"),
 * 			KeyPairName:                 pulumi.String("key_pair_name"),
 * 			RamRoleName:                 pulumi.String("ram_role_name"),
 * 			NetworkType:                 pulumi.String("vpc"),
 * 			SecurityEnhancementStrategy: pulumi.String("Active"),
 * 			SpotPriceLimit:              pulumi.Float64(5),
 * 			SpotStrategy:                pulumi.String("SpotWithPriceLimit"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			SystemDisk: &ecs.EcsLaunchTemplateSystemDiskArgs{
 * 				Category:           pulumi.String("cloud_ssd"),
 * 				Description:        pulumi.String("Test For Terraform"),
 * 				Name:               pulumi.String("terraform-example"),
 * 				Size:               pulumi.Int(40),
 * 				DeleteWithInstance: pulumi.Bool(false),
 * 			},
 * 			UserData:  pulumi.String("xxxxxxx"),
 * 			VswitchId: defaultSwitch.ID(),
 * 			VpcId:     defaultNetwork.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			TemplateTags: pulumi.StringMap{
 * 				"Create": pulumi.String("Terraform"),
 * 				"For":    pulumi.String("example"),
 * 			},
 * 			NetworkInterfaces: &ecs.EcsLaunchTemplateNetworkInterfacesArgs{
 * 				Name:            pulumi.String("eth0"),
 * 				Description:     pulumi.String("hello1"),
 * 				PrimaryIp:       pulumi.String("10.0.0.2"),
 * 				SecurityGroupId: defaultSecurityGroup.ID(),
 * 				VswitchId:       defaultSwitch.ID(),
 * 			},
 * 			DataDisks: ecs.EcsLaunchTemplateDataDiskArray{
 * 				&ecs.EcsLaunchTemplateDataDiskArgs{
 * 					Name:               pulumi.String("disk1"),
 * 					Description:        pulumi.String("description"),
 * 					DeleteWithInstance: pulumi.Bool(true),
 * 					Category:           pulumi.String("cloud"),
 * 					Encrypted:          pulumi.Bool(false),
 * 					PerformanceLevel:   pulumi.String("PL0"),
 * 					Size:               pulumi.Int(20),
 * 				},
 * 				&ecs.EcsLaunchTemplateDataDiskArgs{
 * 					Name:               pulumi.String("disk2"),
 * 					Description:        pulumi.String("description2"),
 * 					DeleteWithInstance: pulumi.Bool(true),
 * 					Category:           pulumi.String("cloud"),
 * 					Encrypted:          pulumi.Bool(false),
 * 					PerformanceLevel:   pulumi.String("PL0"),
 * 					Size:               pulumi.Int(20),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplate;
 * import com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateNetworkInterfacesArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultEcsLaunchTemplate = new EcsLaunchTemplate("defaultEcsLaunchTemplate", EcsLaunchTemplateArgs.builder()
 *             .launchTemplateName("terraform-example")
 *             .description("terraform-example")
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .hostName("terraform-example")
 *             .instanceChargeType("PrePaid")
 *             .instanceName("terraform-example")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .internetChargeType("PayByBandwidth")
 *             .internetMaxBandwidthIn("5")
 *             .internetMaxBandwidthOut("5")
 *             .ioOptimized("optimized")
 *             .keyPairName("key_pair_name")
 *             .ramRoleName("ram_role_name")
 *             .networkType("vpc")
 *             .securityEnhancementStrategy("Active")
 *             .spotPriceLimit("5")
 *             .spotStrategy("SpotWithPriceLimit")
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .systemDisk(EcsLaunchTemplateSystemDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .description("Test For Terraform")
 *                 .name("terraform-example")
 *                 .size("40")
 *                 .deleteWithInstance("false")
 *                 .build())
 *             .userData("xxxxxxx")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .templateTags(Map.ofEntries(
 *                 Map.entry("Create", "Terraform"),
 *                 Map.entry("For", "example")
 *             ))
 *             .networkInterfaces(EcsLaunchTemplateNetworkInterfacesArgs.builder()
 *                 .name("eth0")
 *                 .description("hello1")
 *                 .primaryIp("10.0.0.2")
 *                 .securityGroupId(defaultSecurityGroup.id())
 *                 .vswitchId(defaultSwitch.id())
 *                 .build())
 *             .dataDisks(
 *                 EcsLaunchTemplateDataDiskArgs.builder()
 *                     .name("disk1")
 *                     .description("description")
 *                     .deleteWithInstance("true")
 *                     .category("cloud")
 *                     .encrypted("false")
 *                     .performanceLevel("PL0")
 *                     .size("20")
 *                     .build(),
 *                 EcsLaunchTemplateDataDiskArgs.builder()
 *                     .name("disk2")
 *                     .description("description2")
 *                     .deleteWithInstance("true")
 *                     .category("cloud")
 *                     .encrypted("false")
 *                     .performanceLevel("PL0")
 *                     .size("20")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: terraform-example
 *       vpcId: ${defaultNetwork.id}
 *   defaultEcsLaunchTemplate:
 *     type: alicloud:ecs:EcsLaunchTemplate
 *     name: default
 *     properties:
 *       launchTemplateName: terraform-example
 *       description: terraform-example
 *       imageId: ${defaultGetImages.images[0].id}
 *       hostName: terraform-example
 *       instanceChargeType: PrePaid
 *       instanceName: terraform-example
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       internetChargeType: PayByBandwidth
 *       internetMaxBandwidthIn: '5'
 *       internetMaxBandwidthOut: '5'
 *       ioOptimized: optimized
 *       keyPairName: key_pair_name
 *       ramRoleName: ram_role_name
 *       networkType: vpc
 *       securityEnhancementStrategy: Active
 *       spotPriceLimit: '5'
 *       spotStrategy: SpotWithPriceLimit
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *       systemDisk:
 *         category: cloud_ssd
 *         description: Test For Terraform
 *         name: terraform-example
 *         size: '40'
 *         deleteWithInstance: 'false'
 *       userData: xxxxxxx
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *       templateTags:
 *         Create: Terraform
 *         For: example
 *       networkInterfaces:
 *         name: eth0
 *         description: hello1
 *         primaryIp: 10.0.0.2
 *         securityGroupId: ${defaultSecurityGroup.id}
 *         vswitchId: ${defaultSwitch.id}
 *       dataDisks:
 *         - name: disk1
 *           description: description
 *           deleteWithInstance: 'true'
 *           category: cloud
 *           encrypted: 'false'
 *           performanceLevel: PL0
 *           size: '20'
 *         - name: disk2
 *           description: description2
 *           deleteWithInstance: 'true'
 *           category: cloud
 *           encrypted: 'false'
 *           performanceLevel: PL0
 *           size: '20'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Launch Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsLaunchTemplate:EcsLaunchTemplate example <id>
 * ```
 * @property autoReleaseTime Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
 * @property autoRenew Specifies whether to enable auto-renewal for the instance. This parameter is valid only if `internet_charge_type` is set to `PrePaid`.
 * @property autoRenewPeriod The auto-renewal period of the instance. Valid values when `period_unit` is set to `Month`: 1, 2, 3, 6, 12, 24, 36, 48, and 60. Default value: 1.
 * @property dataDisks The list of data disks created with instance. See `data_disks` below.
 * @property deploymentSetId The Deployment Set Id.
 * @property description Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
 * @property enableVmOsConfig Whether to enable the instance operating system configuration.
 * @property hostName Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
 * @property imageId The Image ID.
 * @property imageOwnerAlias Mirror source. Valid values: `system`, `self`, `others`, `marketplace`, `""`. Default to: `""`.
 * @property instanceChargeType Billing methods. Valid values: `PostPaid`, `PrePaid`.
 * @property instanceName The name of the instance. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), periods (.), commas (,), brackets ([]), and hyphens (-).
 * @property instanceType Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
 * @property internetChargeType Internet bandwidth billing method. Valid values: `PayByTraffic`, `PayByBandwidth`.
 * @property internetMaxBandwidthIn The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
 * @property internetMaxBandwidthOut Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
 * @property ioOptimized Whether it is an I/O-optimized instance or not. Valid values: `none`, `optimized`.
 * @property keyPairName The name of the key pair.
 * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
 * - The password logon method for Linux instances is set to forbidden upon initialization.
 * @property launchTemplateName The name of Launch Template.
 * @property name It has been deprecated from version 1.120.0, and use field `launch_template_name` instead.
 * @property networkInterfaces The list of network interfaces created with instance. See `network_interfaces` below.
 * @property networkType Network type of the instance. Valid values: `classic`, `vpc`.
 * @property passwordInherit Whether to use the password preset by the mirror.
 * @property period The subscription period of the instance. Unit: months. This parameter takes effect and is required only when InstanceChargeType is set to PrePaid. If the DedicatedHostId parameter is specified, the value of the Period parameter must be within the subscription period of the dedicated host.
 * - When the PeriodUnit parameter is set to `Week`, the valid values of the Period parameter are `1`, `2`, `3`, and `4`.
 * - When the PeriodUnit parameter is set to `Month`, the valid values of the Period parameter are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, and `60`.
 * @property periodUnit The unit of the subscription period. Valid values: `Month` (default).
 * @property privateIpAddress The private IP address of the instance.
 * @property ramRoleName The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
 * @property resourceGroupId The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
 * @property securityEnhancementStrategy Whether or not to activate the security enhancement feature and install network security software free of charge. Valid values: `Active`, `Deactive`.
 * @property securityGroupId The security group ID.
 * @property securityGroupIds The ID of security group N to which to assign the instance.
 * @property spotDuration The protection period of the preemptible instance. Unit: hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, and `6`. Default to: `1`.
 * @property spotPriceLimit Sets the maximum hourly instance price. Supports up to three decimal places.
 * @property spotStrategy The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
 * @property systemDisk The System Disk. See `system_disk` below.
 * @property systemDiskCategory It has been deprecated from version 1.120.0, and use field `system_disk` instead.
 * @property systemDiskDescription It has been deprecated from version 1.120.0, and use field `system_disk` instead.
 * @property systemDiskName It has been deprecated from version 1.120.0, and use field `system_disk` instead.
 * @property systemDiskSize It has been deprecated from version 1.120.0, and use field `system_disk` instead.
 * @property tags A mapping of tags to assign to instance, block storage, and elastic network.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property templateResourceGroupId The template resource group id.
 * @property templateTags A mapping of tags to assign to the launch template.
 * @property userData The User Data.
 * @property userdata It has been deprecated from version 1.120.0, and use field `user_data` instead.
 * @property versionDescription The description of the launch template version. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property vpcId The ID of the VPC.
 * @property vswitchId When creating a VPC-Connected instance, you must specify its VSwitch ID.
 * @property zoneId The zone ID of the instance.
 */
public data class EcsLaunchTemplateArgs(
    public val autoReleaseTime: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val dataDisks: Output<List<EcsLaunchTemplateDataDiskArgs>>? = null,
    public val deploymentSetId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableVmOsConfig: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val imageOwnerAlias: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthIn: Output<Int>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val ioOptimized: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val networkInterfaces: Output<EcsLaunchTemplateNetworkInterfacesArgs>? = null,
    public val networkType: Output<String>? = null,
    public val passwordInherit: Output<Boolean>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val ramRoleName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityEnhancementStrategy: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val spotDuration: Output<String>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val systemDisk: Output<EcsLaunchTemplateSystemDiskArgs>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskCategory: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskDescription: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateResourceGroupId: Output<String>? = null,
    public val templateTags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    public val userdata: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs =
        com.pulumi.alicloud.ecs.EcsLaunchTemplateArgs.builder()
            .autoReleaseTime(autoReleaseTime?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentSetId(deploymentSetId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableVmOsConfig(enableVmOsConfig?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageOwnerAlias(imageOwnerAlias?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthIn(internetMaxBandwidthIn?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .ioOptimized(ioOptimized?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterfaces(networkInterfaces?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityEnhancementStrategy(securityEnhancementStrategy?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotDuration(spotDuration?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .systemDisk(systemDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskDescription(systemDiskDescription?.applyValue({ args0 -> args0 }))
            .systemDiskName(systemDiskName?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateResourceGroupId(templateResourceGroupId?.applyValue({ args0 -> args0 }))
            .templateTags(
                templateTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .userData(userData?.applyValue({ args0 -> args0 }))
            .userdata(userdata?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsLaunchTemplateArgs].
 */
@PulumiTagMarker
public class EcsLaunchTemplateArgsBuilder internal constructor() {
    private var autoReleaseTime: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var dataDisks: Output<List<EcsLaunchTemplateDataDiskArgs>>? = null

    private var deploymentSetId: Output<String>? = null

    private var description: Output<String>? = null

    private var enableVmOsConfig: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var imageId: Output<String>? = null

    private var imageOwnerAlias: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthIn: Output<Int>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var ioOptimized: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var name: Output<String>? = null

    private var networkInterfaces: Output<EcsLaunchTemplateNetworkInterfacesArgs>? = null

    private var networkType: Output<String>? = null

    private var passwordInherit: Output<Boolean>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var ramRoleName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityEnhancementStrategy: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var spotDuration: Output<String>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var systemDisk: Output<EcsLaunchTemplateSystemDiskArgs>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskDescription: Output<String>? = null

    private var systemDiskName: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateResourceGroupId: Output<String>? = null

    private var templateTags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var userdata: Output<String>? = null

    private var versionDescription: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    @JvmName("xgtjjvqpvdalrapm")
    public suspend fun autoReleaseTime(`value`: Output<String>) {
        this.autoReleaseTime = value
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the instance. This parameter is valid only if `internet_charge_type` is set to `PrePaid`.
     */
    @JvmName("slemvckkxvhvqajg")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The auto-renewal period of the instance. Valid values when `period_unit` is set to `Month`: 1, 2, 3, 6, 12, 24, 36, 48, and 60. Default value: 1.
     */
    @JvmName("jfeyqjivngkxpvgx")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("lylbjqhmvhyimtun")
    public suspend fun dataDisks(`value`: Output<List<EcsLaunchTemplateDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("pbwdnlxpivoppoiw")
    public suspend fun dataDisks(vararg values: Output<EcsLaunchTemplateDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("tjbthjggehtwankw")
    public suspend fun dataDisks(values: List<Output<EcsLaunchTemplateDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The Deployment Set Id.
     */
    @JvmName("rgnwtffntvngiydu")
    public suspend fun deploymentSetId(`value`: Output<String>) {
        this.deploymentSetId = value
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("xxcaxrorypbveajb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to enable the instance operating system configuration.
     */
    @JvmName("ebxcmgdrjlfkxjin")
    public suspend fun enableVmOsConfig(`value`: Output<Boolean>) {
        this.enableVmOsConfig = value
    }

    /**
     * @param value Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    @JvmName("fjwurmkakqdekikm")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The Image ID.
     */
    @JvmName("eqqxyxlsjowrhdkr")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Mirror source. Valid values: `system`, `self`, `others`, `marketplace`, `""`. Default to: `""`.
     */
    @JvmName("rjmplttcbubmsbih")
    public suspend fun imageOwnerAlias(`value`: Output<String>) {
        this.imageOwnerAlias = value
    }

    /**
     * @param value Billing methods. Valid values: `PostPaid`, `PrePaid`.
     */
    @JvmName("gibqifujetpaeber")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The name of the instance. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), periods (.), commas (,), brackets ([]), and hyphens (-).
     */
    @JvmName("kigohsxfjiqbrgqv")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    @JvmName("fvljuyvhlrlrqwtx")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Internet bandwidth billing method. Valid values: `PayByTraffic`, `PayByBandwidth`.
     */
    @JvmName("rpwduurckowosknt")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    @JvmName("daciwiqjlhxksnmd")
    public suspend fun internetMaxBandwidthIn(`value`: Output<Int>) {
        this.internetMaxBandwidthIn = value
    }

    /**
     * @param value Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    @JvmName("lrduwhavigddvqmf")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value Whether it is an I/O-optimized instance or not. Valid values: `none`, `optimized`.
     */
    @JvmName("yrdpfbechwqsnwqn")
    public suspend fun ioOptimized(`value`: Output<String>) {
        this.ioOptimized = value
    }

    /**
     * @param value The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    @JvmName("mapeoqqtbjgqppvw")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The name of Launch Template.
     */
    @JvmName("bsnttkolhtuountp")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `launch_template_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    @JvmName("padpdcayvpihddod")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("xjjdcilonkxkbmbx")
    public suspend fun networkInterfaces(`value`: Output<EcsLaunchTemplateNetworkInterfacesArgs>) {
        this.networkInterfaces = value
    }

    /**
     * @param value Network type of the instance. Valid values: `classic`, `vpc`.
     */
    @JvmName("tswryiehpjvrljbl")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value Whether to use the password preset by the mirror.
     */
    @JvmName("ltmhseotbvytfnvb")
    public suspend fun passwordInherit(`value`: Output<Boolean>) {
        this.passwordInherit = value
    }

    /**
     * @param value The subscription period of the instance. Unit: months. This parameter takes effect and is required only when InstanceChargeType is set to PrePaid. If the DedicatedHostId parameter is specified, the value of the Period parameter must be within the subscription period of the dedicated host.
     * - When the PeriodUnit parameter is set to `Week`, the valid values of the Period parameter are `1`, `2`, `3`, and `4`.
     * - When the PeriodUnit parameter is set to `Month`, the valid values of the Period parameter are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, and `60`.
     */
    @JvmName("fyacvayrkhyvmdqt")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The unit of the subscription period. Valid values: `Month` (default).
     */
    @JvmName("qhtawmjxowlhvisn")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The private IP address of the instance.
     */
    @JvmName("kvpcajqxpdwhqmex")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    @JvmName("xkkbieparheseiai")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
     */
    @JvmName("aloowufcwsttnvpg")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Whether or not to activate the security enhancement feature and install network security software free of charge. Valid values: `Active`, `Deactive`.
     */
    @JvmName("fmnygjdiskqcfjoy")
    public suspend fun securityEnhancementStrategy(`value`: Output<String>) {
        this.securityEnhancementStrategy = value
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("iwnioetndwbwdhpv")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of security group N to which to assign the instance.
     */
    @JvmName("vwdijnvndtcgisie")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("jpxkrewbkfbpeocg")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of security group N to which to assign the instance.
     */
    @JvmName("dxxvfrjimrcwryng")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The protection period of the preemptible instance. Unit: hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, and `6`. Default to: `1`.
     */
    @JvmName("scpaapmfndaknjay")
    public suspend fun spotDuration(`value`: Output<String>) {
        this.spotDuration = value
    }

    /**
     * @param value Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    @JvmName("mroavnrelwjtmute")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
     */
    @JvmName("lbchosbujxmkhaun")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value The System Disk. See `system_disk` below.
     */
    @JvmName("yqbqmjohfhywutwk")
    public suspend fun systemDisk(`value`: Output<EcsLaunchTemplateSystemDiskArgs>) {
        this.systemDisk = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("pruqvouhqyvoojtu")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("vunwyeoufmcacxrd")
    public suspend fun systemDiskDescription(`value`: Output<String>) {
        this.systemDiskDescription = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("totvuehukeqgricc")
    public suspend fun systemDiskName(`value`: Output<String>) {
        this.systemDiskName = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("suqqdjkmravbdqxd")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value A mapping of tags to assign to instance, block storage, and elastic network.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("anidflaocgjaafwh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The template resource group id.
     */
    @JvmName("fbrposmeukedhalv")
    public suspend fun templateResourceGroupId(`value`: Output<String>) {
        this.templateResourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the launch template.
     */
    @JvmName("ocuatdqbnuhtcbib")
    public suspend fun templateTags(`value`: Output<Map<String, String>>) {
        this.templateTags = value
    }

    /**
     * @param value The User Data.
     */
    @JvmName("ycqgfovchjcvoowf")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `user_data` instead.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    @JvmName("qhtghrdufxemtjed")
    public suspend fun userdata(`value`: Output<String>) {
        this.userdata = value
    }

    /**
     * @param value The description of the launch template version. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("kbfuckhldsuqjcco")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("hrerfracvpnfhqin")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    @JvmName("hgtgcgjfmatdsijl")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("vuurvnwyymfuvgha")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    @JvmName("bgjmddferruablcg")
    public suspend fun autoReleaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReleaseTime = mapped
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the instance. This parameter is valid only if `internet_charge_type` is set to `PrePaid`.
     */
    @JvmName("xrgmheonoopfqixg")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The auto-renewal period of the instance. Valid values when `period_unit` is set to `Month`: 1, 2, 3, 6, 12, 24, 36, 48, and 60. Default value: 1.
     */
    @JvmName("xelipoyksgthwadg")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("anoaycpjjyrduqud")
    public suspend fun dataDisks(`value`: List<EcsLaunchTemplateDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("xpfxabgdnusbplin")
    public suspend fun dataDisks(argument: List<suspend EcsLaunchTemplateDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcsLaunchTemplateDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("usgekiocguaimave")
    public suspend fun dataDisks(vararg argument: suspend EcsLaunchTemplateDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcsLaunchTemplateDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("fxmoatdasyufessn")
    public suspend fun dataDisks(argument: suspend EcsLaunchTemplateDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EcsLaunchTemplateDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("aivnoycfvvoeghyk")
    public suspend fun dataDisks(vararg values: EcsLaunchTemplateDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The Deployment Set Id.
     */
    @JvmName("txoebogiaqqrpllh")
    public suspend fun deploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetId = mapped
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("qbixenulmgvxhjgs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to enable the instance operating system configuration.
     */
    @JvmName("vahwmhlkbfuuabfp")
    public suspend fun enableVmOsConfig(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVmOsConfig = mapped
    }

    /**
     * @param value Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    @JvmName("qmrrdpcgostpnavw")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The Image ID.
     */
    @JvmName("qwuqdqmuclqniosr")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Mirror source. Valid values: `system`, `self`, `others`, `marketplace`, `""`. Default to: `""`.
     */
    @JvmName("gubqqitwldoagamx")
    public suspend fun imageOwnerAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageOwnerAlias = mapped
    }

    /**
     * @param value Billing methods. Valid values: `PostPaid`, `PrePaid`.
     */
    @JvmName("dhsihexdwnwfjvxq")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The name of the instance. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), periods (.), commas (,), brackets ([]), and hyphens (-).
     */
    @JvmName("bebhhwyxpvufjoin")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    @JvmName("ptdmvwoacqvrhnjr")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Internet bandwidth billing method. Valid values: `PayByTraffic`, `PayByBandwidth`.
     */
    @JvmName("gnosbfjfyubpifim")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    @JvmName("aemymhpfawkgndof")
    public suspend fun internetMaxBandwidthIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthIn = mapped
    }

    /**
     * @param value Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    @JvmName("ggueyjcubkqmhawh")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value Whether it is an I/O-optimized instance or not. Valid values: `none`, `optimized`.
     */
    @JvmName("frutrbhjisrstuti")
    public suspend fun ioOptimized(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioOptimized = mapped
    }

    /**
     * @param value The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    @JvmName("hpivvbhtyxkksgyl")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The name of Launch Template.
     */
    @JvmName("vuveojbsxhtbwyda")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `launch_template_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    @JvmName("xeshgonvtatxgjtt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("rnavdtiuokcigrwg")
    public suspend fun networkInterfaces(`value`: EcsLaunchTemplateNetworkInterfacesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("rlvbhlxkgyfkhnuj")
    public suspend fun networkInterfaces(argument: suspend EcsLaunchTemplateNetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped = EcsLaunchTemplateNetworkInterfacesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param value Network type of the instance. Valid values: `classic`, `vpc`.
     */
    @JvmName("fbslxmgouiftixwf")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Whether to use the password preset by the mirror.
     */
    @JvmName("rbboxhfjeueeacyq")
    public suspend fun passwordInherit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value The subscription period of the instance. Unit: months. This parameter takes effect and is required only when InstanceChargeType is set to PrePaid. If the DedicatedHostId parameter is specified, the value of the Period parameter must be within the subscription period of the dedicated host.
     * - When the PeriodUnit parameter is set to `Week`, the valid values of the Period parameter are `1`, `2`, `3`, and `4`.
     * - When the PeriodUnit parameter is set to `Month`, the valid values of the Period parameter are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, and `60`.
     */
    @JvmName("wxuebjhthfpbskuh")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The unit of the subscription period. Valid values: `Month` (default).
     */
    @JvmName("wvctxtjeeyuifuay")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The private IP address of the instance.
     */
    @JvmName("nrxqcpvvbkaggyhn")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    @JvmName("vjcxyhwogrucxxhy")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
     */
    @JvmName("skcivrsultcrahwk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Whether or not to activate the security enhancement feature and install network security software free of charge. Valid values: `Active`, `Deactive`.
     */
    @JvmName("yropjwlklgekuduc")
    public suspend fun securityEnhancementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityEnhancementStrategy = mapped
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("ybcogkqouxeofjkw")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of security group N to which to assign the instance.
     */
    @JvmName("ultojgaxwulyfykv")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of security group N to which to assign the instance.
     */
    @JvmName("jwvbfdybflooants")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The protection period of the preemptible instance. Unit: hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, and `6`. Default to: `1`.
     */
    @JvmName("tpuldpgwkbtgnsee")
    public suspend fun spotDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotDuration = mapped
    }

    /**
     * @param value Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    @JvmName("lymrpyyisiisounq")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
     */
    @JvmName("ctyjjmcwucmefehh")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value The System Disk. See `system_disk` below.
     */
    @JvmName("ctltcevtepeeoalo")
    public suspend fun systemDisk(`value`: EcsLaunchTemplateSystemDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDisk = mapped
    }

    /**
     * @param argument The System Disk. See `system_disk` below.
     */
    @JvmName("jcwqysvoidjtdsmy")
    public suspend fun systemDisk(argument: suspend EcsLaunchTemplateSystemDiskArgsBuilder.() -> Unit) {
        val toBeMapped = EcsLaunchTemplateSystemDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemDisk = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("jlflnixmttpmelev")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("amfnxuoayijdwyic")
    public suspend fun systemDiskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskDescription = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("cipwujxliyrnfbbt")
    public suspend fun systemDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskName = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `system_disk` instead.
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("dqpyhtxkbuvinokf")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to instance, block storage, and elastic network.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("bvbqvhcaqwqwomhh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to instance, block storage, and elastic network.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("ltbpwprsoqwtrqgt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The template resource group id.
     */
    @JvmName("bdevcrouboksefjv")
    public suspend fun templateResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateResourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the launch template.
     */
    @JvmName("brbrlgrbemsxtcdr")
    public suspend fun templateTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateTags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the launch template.
     */
    @JvmName("mphwcscvqxekauhf")
    public fun templateTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateTags = mapped
    }

    /**
     * @param value The User Data.
     */
    @JvmName("yokkkfuavdhffoja")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value It has been deprecated from version 1.120.0, and use field `user_data` instead.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    @JvmName("ccawlcxlcosjdgrf")
    public suspend fun userdata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userdata = mapped
    }

    /**
     * @param value The description of the launch template version. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("ufiwaiklnfnbdjwb")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("hvylblyapbmkeijd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    @JvmName("kaofidsqdppiafif")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("sqpwlgvpcmjdxekq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): EcsLaunchTemplateArgs = EcsLaunchTemplateArgs(
        autoReleaseTime = autoReleaseTime,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        dataDisks = dataDisks,
        deploymentSetId = deploymentSetId,
        description = description,
        enableVmOsConfig = enableVmOsConfig,
        hostName = hostName,
        imageId = imageId,
        imageOwnerAlias = imageOwnerAlias,
        instanceChargeType = instanceChargeType,
        instanceName = instanceName,
        instanceType = instanceType,
        internetChargeType = internetChargeType,
        internetMaxBandwidthIn = internetMaxBandwidthIn,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        ioOptimized = ioOptimized,
        keyPairName = keyPairName,
        launchTemplateName = launchTemplateName,
        name = name,
        networkInterfaces = networkInterfaces,
        networkType = networkType,
        passwordInherit = passwordInherit,
        period = period,
        periodUnit = periodUnit,
        privateIpAddress = privateIpAddress,
        ramRoleName = ramRoleName,
        resourceGroupId = resourceGroupId,
        securityEnhancementStrategy = securityEnhancementStrategy,
        securityGroupId = securityGroupId,
        securityGroupIds = securityGroupIds,
        spotDuration = spotDuration,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        systemDisk = systemDisk,
        systemDiskCategory = systemDiskCategory,
        systemDiskDescription = systemDiskDescription,
        systemDiskName = systemDiskName,
        systemDiskSize = systemDiskSize,
        tags = tags,
        templateResourceGroupId = templateResourceGroupId,
        templateTags = templateTags,
        userData = userData,
        userdata = userdata,
        versionDescription = versionDescription,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
