@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Network Interface resource.
 * For information about ECS Network Interface and how to use it, see [What is Network Interface](https://www.alibabacloud.com/help/en/doc-detail/58504.htm).
 * > **NOTE:** Available since v1.123.1.
 * > **NOTE** Only one of `private_ip_addresses` or `secondary_private_ip_address_count` can be specified when assign private IPs.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/24",
 * });
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "192.168.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultEcsNetworkInterface = new alicloud.ecs.EcsNetworkInterface("default", {
 *     networkInterfaceName: name,
 *     vswitchId: defaultSwitch.id,
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 *     description: "Basic test",
 *     primaryIpAddress: "192.168.0.2",
 *     tags: {
 *         Created: "TF",
 *         For: "Test",
 *     },
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/24")
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="192.168.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vpc_id=default_network.id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
 *     network_interface_name=name,
 *     vswitch_id=default_switch.id,
 *     security_group_ids=[default_security_group&#46;id],
 *     description="Basic test",
 *     primary_ip_address="192.168.0.2",
 *     tags={
 *         "Created": "TF",
 *         "For": "Test",
 *     },
 *     resource_group_id=default_get_resource_groups.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/24",
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "192.168.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultEcsNetworkInterface = new AliCloud.Ecs.EcsNetworkInterface("default", new()
 *     {
 *         NetworkInterfaceName = name,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         Description = "Basic test",
 *         PrimaryIpAddress = "192.168.0.2",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "Test" },
 *         },
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VpcId:       defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEcsNetworkInterface(ctx, "default", &ecs.EcsNetworkInterfaceArgs{
 * 			NetworkInterfaceName: pulumi.String(name),
 * 			VswitchId:            defaultSwitch.ID(),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			Description:      pulumi.String("Basic test"),
 * 			PrimaryIpAddress: pulumi.String("192.168.0.2"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("Test"),
 * 			},
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterface;
 * import com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("192.168.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultEcsNetworkInterface = new EcsNetworkInterface("defaultEcsNetworkInterface", EcsNetworkInterfaceArgs.builder()
 *             .networkInterfaceName(name)
 *             .vswitchId(defaultSwitch.id())
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .description("Basic test")
 *             .primaryIpAddress("192.168.0.2")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "Test")
 *             ))
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 192.168.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultEcsNetworkInterface:
 *     type: alicloud:ecs:EcsNetworkInterface
 *     name: default
 *     properties:
 *       networkInterfaceName: ${name}
 *       vswitchId: ${defaultSwitch.id}
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *       description: Basic test
 *       primaryIpAddress: 192.168.0.2
 *       tags:
 *         Created: TF
 *         For: Test
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Network Interface can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsNetworkInterface:EcsNetworkInterface example eni-abcd12345
 * ```
 * @property description The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property instanceType The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
 * @property ipv4PrefixCount The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
 * @property ipv4Prefixes A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
 * @property ipv6AddressCount The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
 * @property ipv6Addresses A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
 * @property name Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
 * @property networkInterfaceName The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
 * @property networkInterfaceTrafficMode The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
 * @property primaryIpAddress The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
 * @property privateIp Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
 * @property privateIpAddresses Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
 * @property privateIps Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
 * @property privateIpsCount Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
 * @property queueNumber The queue number of the ENI.
 * @property resourceGroupId The resource group id.
 * @property secondaryPrivateIpAddressCount The number of private IP addresses that can be automatically created by ECS.
 * @property securityGroupIds The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added.
 * @property securityGroups Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
 */
public data class EcsNetworkInterfaceArgs(
    public val description: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val ipv4PrefixCount: Output<Int>? = null,
    public val ipv4Prefixes: Output<List<String>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val networkInterfaceTrafficMode: Output<String>? = null,
    public val primaryIpAddress: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: Output<String>? = null,
    public val privateIpAddresses: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    public val privateIps: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    public val privateIpsCount: Output<Int>? = null,
    public val queueNumber: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val secondaryPrivateIpAddressCount: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    public val securityGroups: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs =
        com.pulumi.alicloud.ecs.EcsNetworkInterfaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .ipv4PrefixCount(ipv4PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv4Prefixes(ipv4Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .networkInterfaceTrafficMode(networkInterfaceTrafficMode?.applyValue({ args0 -> args0 }))
            .primaryIpAddress(primaryIpAddress?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .privateIpAddresses(privateIpAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIps(privateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIpsCount(privateIpsCount?.applyValue({ args0 -> args0 }))
            .queueNumber(queueNumber?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsNetworkInterfaceArgs].
 */
@PulumiTagMarker
public class EcsNetworkInterfaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var ipv4PrefixCount: Output<Int>? = null

    private var ipv4Prefixes: Output<List<String>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var networkInterfaceTrafficMode: Output<String>? = null

    private var primaryIpAddress: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var privateIpAddresses: Output<List<String>>? = null

    private var privateIps: Output<List<String>>? = null

    private var privateIpsCount: Output<Int>? = null

    private var queueNumber: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var secondaryPrivateIpAddressCount: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityGroups: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("flkvkratblbeqrvm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
     */
    @JvmName("xjdfktxxasvcneja")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
     */
    @JvmName("mffmrywtaeuvgmxj")
    public suspend fun ipv4PrefixCount(`value`: Output<Int>) {
        this.ipv4PrefixCount = value
    }

    /**
     * @param value A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
     */
    @JvmName("lrmfcpgmygxbbnao")
    public suspend fun ipv4Prefixes(`value`: Output<List<String>>) {
        this.ipv4Prefixes = value
    }

    @JvmName("tdlxuhuuuhseitfb")
    public suspend fun ipv4Prefixes(vararg values: Output<String>) {
        this.ipv4Prefixes = Output.all(values.asList())
    }

    /**
     * @param values A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
     */
    @JvmName("lhffkgbbtmfooykt")
    public suspend fun ipv4Prefixes(values: List<Output<String>>) {
        this.ipv4Prefixes = Output.all(values)
    }

    /**
     * @param value The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
     */
    @JvmName("qtjyusndqsklcasx")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("hrflxwqmyerbphpu")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("hhqgnjfwtqbekprj")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("rydmamrqpxvlasij")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("xyoqyvkycgnyqhga")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
     */
    @JvmName("vwecbkqcwhccjyrn")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
     */
    @JvmName("euvjitwegnivgxgj")
    public suspend fun networkInterfaceTrafficMode(`value`: Output<String>) {
        this.networkInterfaceTrafficMode = value
    }

    /**
     * @param value The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
     */
    @JvmName("nipjvjwcukxkmphq")
    public suspend fun primaryIpAddress(`value`: Output<String>) {
        this.primaryIpAddress = value
    }

    /**
     * @param value Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("agohywijimmwogso")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
     */
    @JvmName("rnbvdyxulyxxrcqb")
    public suspend fun privateIpAddresses(`value`: Output<List<String>>) {
        this.privateIpAddresses = value
    }

    @JvmName("nueuwaabgqnresxp")
    public suspend fun privateIpAddresses(vararg values: Output<String>) {
        this.privateIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
     */
    @JvmName("sqrumebxelffnyxm")
    public suspend fun privateIpAddresses(values: List<Output<String>>) {
        this.privateIpAddresses = Output.all(values)
    }

    /**
     * @param value Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("vmevxudejpdqogfw")
    public suspend fun privateIps(`value`: Output<List<String>>) {
        this.privateIps = value
    }

    @JvmName("siyaqvmjddrithhe")
    public suspend fun privateIps(vararg values: Output<String>) {
        this.privateIps = Output.all(values.asList())
    }

    /**
     * @param values Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("nsngbvoyngjsrord")
    public suspend fun privateIps(values: List<Output<String>>) {
        this.privateIps = Output.all(values)
    }

    /**
     * @param value Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    @JvmName("bnhplxygoyacjapk")
    public suspend fun privateIpsCount(`value`: Output<Int>) {
        this.privateIpsCount = value
    }

    /**
     * @param value The queue number of the ENI.
     */
    @JvmName("ypcsnqxlbmbvwajv")
    public suspend fun queueNumber(`value`: Output<Int>) {
        this.queueNumber = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("klejwdnrdrrgtnma")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The number of private IP addresses that can be automatically created by ECS.
     */
    @JvmName("wruqlbxiuqtpymgt")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Output<Int>) {
        this.secondaryPrivateIpAddressCount = value
    }

    /**
     * @param value The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added.
     */
    @JvmName("tflycgkulnpdwpcs")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("sprabgyonrqedulp")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added.
     */
    @JvmName("cxiaupffbujtwbce")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("fqthebboryrmclde")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("yrqahpjhevmoybew")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("jgjxfrtynudwpjxp")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ngiqbcnycmselphy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
     */
    @JvmName("pfxgjvnvwwcurhxs")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("vbonmnexldslimlm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
     */
    @JvmName("bferkvtnucesuhwf")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
     */
    @JvmName("xnlpqbssedgrngyr")
    public suspend fun ipv4PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4PrefixCount = mapped
    }

    /**
     * @param value A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
     */
    @JvmName("vugeprkxwxsgqjwb")
    public suspend fun ipv4Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param values A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
     */
    @JvmName("olgbukmqbkugnmce")
    public suspend fun ipv4Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param value The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
     */
    @JvmName("avteedjayttimjvf")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("wotcmubwxajsqujf")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("icwciydtqcvwdyiy")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("iwbaawqbvideykrn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
     */
    @JvmName("glwfvgcldpvuurty")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
     */
    @JvmName("idwkwisnwoaexxus")
    public suspend fun networkInterfaceTrafficMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceTrafficMode = mapped
    }

    /**
     * @param value The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
     */
    @JvmName("mukchquuqwrnicim")
    public suspend fun primaryIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpAddress = mapped
    }

    /**
     * @param value Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("xkhpvwfvqgecetbd")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
     */
    @JvmName("qajvmuusswwnkiae")
    public suspend fun privateIpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddresses = mapped
    }

    /**
     * @param values Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
     */
    @JvmName("ypxlwsoufdlocbyt")
    public suspend fun privateIpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpAddresses = mapped
    }

    /**
     * @param value Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("ciwcdhvjirebkyfu")
    public suspend fun privateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param values Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips' has been deprecated from provider version 1.123.1. New field
      'private_ip_addresses' instead
  """,
    )
    @JvmName("ucbuhxtgquyebhvr")
    public suspend fun privateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param value Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
     */
    @Deprecated(
        message = """
  Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field
      'secondary_private_ip_address_count' instead
  """,
    )
    @JvmName("jbvjaexcshlurncb")
    public suspend fun privateIpsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpsCount = mapped
    }

    /**
     * @param value The queue number of the ENI.
     */
    @JvmName("ujumwjnrqfundprr")
    public suspend fun queueNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueNumber = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("nlocbuafmdkmrcfr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The number of private IP addresses that can be automatically created by ECS.
     */
    @JvmName("isnvcfhbuwsmixfw")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddressCount = mapped
    }

    /**
     * @param value The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added.
     */
    @JvmName("ahiogifgibqfddme")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added.
     */
    @JvmName("nddfbywocavjyfmb")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("kcndgkrwlxxbbfik")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead
     */
    @Deprecated(
        message = """
  Field 'security_groups' has been deprecated from provider version 1.123.1. New field
      'security_group_ids' instead
  """,
    )
    @JvmName("sgiyyyhaipvjhtxf")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("oipborxtegacjkbj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("onlbspkigbxwijro")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
     */
    @JvmName("wktayhijrycsxolq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): EcsNetworkInterfaceArgs = EcsNetworkInterfaceArgs(
        description = description,
        instanceType = instanceType,
        ipv4PrefixCount = ipv4PrefixCount,
        ipv4Prefixes = ipv4Prefixes,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        name = name,
        networkInterfaceName = networkInterfaceName,
        networkInterfaceTrafficMode = networkInterfaceTrafficMode,
        primaryIpAddress = primaryIpAddress,
        privateIp = privateIp,
        privateIpAddresses = privateIpAddresses,
        privateIps = privateIps,
        privateIpsCount = privateIpsCount,
        queueNumber = queueNumber,
        resourceGroupId = resourceGroupId,
        secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount,
        securityGroupIds = securityGroupIds,
        securityGroups = securityGroups,
        tags = tags,
        vswitchId = vswitchId,
    )
}
