@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EcsNetworkInterfacePermission].
 */
@PulumiTagMarker
public class EcsNetworkInterfacePermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsNetworkInterfacePermissionArgs = EcsNetworkInterfacePermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsNetworkInterfacePermissionArgsBuilder.() -> Unit) {
        val builder = EcsNetworkInterfacePermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsNetworkInterfacePermission {
        val builtJavaResource =
            com.pulumi.alicloud.ecs.EcsNetworkInterfacePermission(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EcsNetworkInterfacePermission(builtJavaResource)
    }
}

/**
 * Provides a ECS Network Interface Permission resource.
 * For information about ECS Network Interface Permission and how to use it, see [What is Network Interface Permission](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/elastic-network-interfaces-overview).
 * > **NOTE:** Available in v1.166.0+.
 * ## Import
 * ECS Network Interface Permission can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission example <id>
 * ```
 */
public class EcsNetworkInterfacePermission internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsNetworkInterfacePermission,
) : KotlinCustomResource(javaResource, EcsNetworkInterfacePermissionMapper) {
    /**
     * Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Whether to force deletion of Network Interface Permission. Default value: `true`.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the network interface.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
     */
    public val permission: Output<String>
        get() = javaResource.permission().applyValue({ args0 -> args0 })

    /**
     * The Status of the Network Interface Permissions. Valid values: `Pending`, `Granted`, `Revoking`, `Revoked`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EcsNetworkInterfacePermissionMapper : ResourceMapper<EcsNetworkInterfacePermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsNetworkInterfacePermission::class == javaResource::class

    override fun map(javaResource: Resource): EcsNetworkInterfacePermission =
        EcsNetworkInterfacePermission(
            javaResource as
                com.pulumi.alicloud.ecs.EcsNetworkInterfacePermission,
        )
}

/**
 * @see [EcsNetworkInterfacePermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsNetworkInterfacePermission].
 */
public suspend fun ecsNetworkInterfacePermission(
    name: String,
    block: suspend EcsNetworkInterfacePermissionResourceBuilder.() -> Unit,
): EcsNetworkInterfacePermission {
    val builder = EcsNetworkInterfacePermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsNetworkInterfacePermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsNetworkInterfacePermission(name: String): EcsNetworkInterfacePermission {
    val builder = EcsNetworkInterfacePermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
