@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsNetworkInterfacePermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Network Interface Permission resource.
 * For information about ECS Network Interface Permission and how to use it, see [What is Network Interface Permission](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/elastic-network-interfaces-overview).
 * > **NOTE:** Available in v1.166.0+.
 * ## Import
 * ECS Network Interface Permission can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsNetworkInterfacePermission:EcsNetworkInterfacePermission example <id>
 * ```
 * @property accountId Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
 * @property force Whether to force deletion of Network Interface Permission. Default value: `true`.
 * @property networkInterfaceId The ID of the network interface.
 * @property permission The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
 */
public data class EcsNetworkInterfacePermissionArgs(
    public val accountId: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val permission: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsNetworkInterfacePermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsNetworkInterfacePermissionArgs =
        com.pulumi.alicloud.ecs.EcsNetworkInterfacePermissionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .permission(permission?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsNetworkInterfacePermissionArgs].
 */
@PulumiTagMarker
public class EcsNetworkInterfacePermissionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var networkInterfaceId: Output<String>? = null

    private var permission: Output<String>? = null

    /**
     * @param value Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
     */
    @JvmName("hoiqvcacdxhgluav")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Whether to force deletion of Network Interface Permission. Default value: `true`.
     */
    @JvmName("gmsjputnxrdopxhg")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The ID of the network interface.
     */
    @JvmName("ofodksndplgdstcs")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
     */
    @JvmName("glmqsvtlvkjdkqwl")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
     */
    @JvmName("ltrdfbjhehlpegwf")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Whether to force deletion of Network Interface Permission. Default value: `true`.
     */
    @JvmName("kgakqckawfmowrkl")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The ID of the network interface.
     */
    @JvmName("gdnkcpjmitjaudgv")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The permissions of the Network Interface. Valid values: `InstanceAttach`. `InstanceAttach`: Allows authorized users to mount your ENI to the other ECS instance. The ECS instance must be in the same zone as the ENI.
     */
    @JvmName("cwbvboftwammnkir")
    public suspend fun permission(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    internal fun build(): EcsNetworkInterfacePermissionArgs = EcsNetworkInterfacePermissionArgs(
        accountId = accountId,
        force = force,
        networkInterfaceId = networkInterfaceId,
        permission = permission,
    )
}
