@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.EcsPrefixListEntry
import com.pulumi.alicloud.ecs.kotlin.outputs.EcsPrefixListEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EcsPrefixList].
 */
@PulumiTagMarker
public class EcsPrefixListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsPrefixListArgs = EcsPrefixListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsPrefixListArgsBuilder.() -> Unit) {
        val builder = EcsPrefixListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsPrefixList {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsPrefixList(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsPrefixList(builtJavaResource)
    }
}

/**
 * Provides a ECS Prefix List resource.
 * For information about ECS Prefix List and how to use it, see [What is Prefix List&#46;](https://www.alibabacloud.com/help/en/doc-detail/207969.html).
 * > **NOTE:** Available in v1.152.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsPrefixList("default", {
 *     addressFamily: "IPv4",
 *     maxEntries: 2,
 *     prefixListName: "tftest",
 *     description: "description",
 *     entries: [{
 *         cidr: "192.168.0.0/24",
 *         description: "description",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsPrefixList("default",
 *     address_family="IPv4",
 *     max_entries=2,
 *     prefix_list_name="tftest",
 *     description="description",
 *     entries=[{
 *         "cidr": "192.168.0.0/24",
 *         "description": "description",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsPrefixList("default", new()
 *     {
 *         AddressFamily = "IPv4",
 *         MaxEntries = 2,
 *         PrefixListName = "tftest",
 *         Description = "description",
 *         Entries = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.EcsPrefixListEntryArgs
 *             {
 *                 Cidr = "192.168.0.0/24",
 *                 Description = "description",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsPrefixList(ctx, "default", &ecs.EcsPrefixListArgs{
 * 			AddressFamily:  pulumi.String("IPv4"),
 * 			MaxEntries:     pulumi.Int(2),
 * 			PrefixListName: pulumi.String("tftest"),
 * 			Description:    pulumi.String("description"),
 * 			Entries: ecs.EcsPrefixListEntryArray{
 * 				&ecs.EcsPrefixListEntryArgs{
 * 					Cidr:        pulumi.String("192.168.0.0/24"),
 * 					Description: pulumi.String("description"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsPrefixList;
 * import com.pulumi.alicloud.ecs.EcsPrefixListArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsPrefixList("default", EcsPrefixListArgs.builder()
 *             .addressFamily("IPv4")
 *             .maxEntries(2)
 *             .prefixListName("tftest")
 *             .description("description")
 *             .entries(EcsPrefixListEntryArgs.builder()
 *                 .cidr("192.168.0.0/24")
 *                 .description("description")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsPrefixList
 *     properties:
 *       addressFamily: IPv4
 *       maxEntries: 2
 *       prefixListName: tftest
 *       description: description
 *       entries:
 *         - cidr: 192.168.0.0/24
 *           description: description
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Prefix List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsPrefixList:EcsPrefixList example <id>
 * ```
 */
public class EcsPrefixList internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsPrefixList,
) : KotlinCustomResource(javaResource, EcsPrefixListMapper) {
    /**
     * The IP address family. Valid values: `IPv4`,`IPv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The description of the prefix list. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Entry. The details see Block `entry`.
     */
    public val entries: Output<List<EcsPrefixListEntry>>
        get() = javaResource.entries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The maximum number of entries that the prefix list can contain.  Valid values: 1 to 200.
     */
    public val maxEntries: Output<Int>
        get() = javaResource.maxEntries().applyValue({ args0 -> args0 })

    /**
     * The name of the prefix. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://`, `https://`, `com.aliyun`, or `com.alibabacloud`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
     */
    public val prefixListName: Output<String>
        get() = javaResource.prefixListName().applyValue({ args0 -> args0 })
}

public object EcsPrefixListMapper : ResourceMapper<EcsPrefixList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsPrefixList::class == javaResource::class

    override fun map(javaResource: Resource): EcsPrefixList = EcsPrefixList(
        javaResource as
            com.pulumi.alicloud.ecs.EcsPrefixList,
    )
}

/**
 * @see [EcsPrefixList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsPrefixList].
 */
public suspend fun ecsPrefixList(
    name: String,
    block: suspend EcsPrefixListResourceBuilder.() -> Unit,
): EcsPrefixList {
    val builder = EcsPrefixListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsPrefixList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsPrefixList(name: String): EcsPrefixList {
    val builder = EcsPrefixListResourceBuilder()
    builder.name(name)
    return builder.build()
}
