@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsPrefixListArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsPrefixListEntryArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.EcsPrefixListEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECS Prefix List resource.
 * For information about ECS Prefix List and how to use it, see [What is Prefix List&#46;](https://www.alibabacloud.com/help/en/doc-detail/207969.html).
 * > **NOTE:** Available in v1.152.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsPrefixList("default", {
 *     addressFamily: "IPv4",
 *     maxEntries: 2,
 *     prefixListName: "tftest",
 *     description: "description",
 *     entries: [{
 *         cidr: "192.168.0.0/24",
 *         description: "description",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsPrefixList("default",
 *     address_family="IPv4",
 *     max_entries=2,
 *     prefix_list_name="tftest",
 *     description="description",
 *     entries=[{
 *         "cidr": "192.168.0.0/24",
 *         "description": "description",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsPrefixList("default", new()
 *     {
 *         AddressFamily = "IPv4",
 *         MaxEntries = 2,
 *         PrefixListName = "tftest",
 *         Description = "description",
 *         Entries = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.EcsPrefixListEntryArgs
 *             {
 *                 Cidr = "192.168.0.0/24",
 *                 Description = "description",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsPrefixList(ctx, "default", &ecs.EcsPrefixListArgs{
 * 			AddressFamily:  pulumi.String("IPv4"),
 * 			MaxEntries:     pulumi.Int(2),
 * 			PrefixListName: pulumi.String("tftest"),
 * 			Description:    pulumi.String("description"),
 * 			Entries: ecs.EcsPrefixListEntryArray{
 * 				&ecs.EcsPrefixListEntryArgs{
 * 					Cidr:        pulumi.String("192.168.0.0/24"),
 * 					Description: pulumi.String("description"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsPrefixList;
 * import com.pulumi.alicloud.ecs.EcsPrefixListArgs;
 * import com.pulumi.alicloud.ecs.inputs.EcsPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsPrefixList("default", EcsPrefixListArgs.builder()
 *             .addressFamily("IPv4")
 *             .maxEntries(2)
 *             .prefixListName("tftest")
 *             .description("description")
 *             .entries(EcsPrefixListEntryArgs.builder()
 *                 .cidr("192.168.0.0/24")
 *                 .description("description")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsPrefixList
 *     properties:
 *       addressFamily: IPv4
 *       maxEntries: 2
 *       prefixListName: tftest
 *       description: description
 *       entries:
 *         - cidr: 192.168.0.0/24
 *           description: description
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Prefix List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsPrefixList:EcsPrefixList example <id>
 * ```
 * @property addressFamily The IP address family. Valid values: `IPv4`,`IPv6`.
 * @property description The description of the prefix list. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
 * @property entries The Entry. The details see Block `entry`.
 * @property maxEntries The maximum number of entries that the prefix list can contain.  Valid values: 1 to 200.
 * @property prefixListName The name of the prefix. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://`, `https://`, `com.aliyun`, or `com.alibabacloud`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
 */
public data class EcsPrefixListArgs(
    public val addressFamily: Output<String>? = null,
    public val description: Output<String>? = null,
    public val entries: Output<List<EcsPrefixListEntryArgs>>? = null,
    public val maxEntries: Output<Int>? = null,
    public val prefixListName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsPrefixListArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsPrefixListArgs =
        com.pulumi.alicloud.ecs.EcsPrefixListArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .entries(
                entries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maxEntries(maxEntries?.applyValue({ args0 -> args0 }))
            .prefixListName(prefixListName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsPrefixListArgs].
 */
@PulumiTagMarker
public class EcsPrefixListArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var description: Output<String>? = null

    private var entries: Output<List<EcsPrefixListEntryArgs>>? = null

    private var maxEntries: Output<Int>? = null

    private var prefixListName: Output<String>? = null

    /**
     * @param value The IP address family. Valid values: `IPv4`,`IPv6`.
     */
    @JvmName("gblethyhmtebkcug")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The description of the prefix list. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("rdxmvbeuylihlelg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Entry. The details see Block `entry`.
     */
    @JvmName("dsueounxiarlvged")
    public suspend fun entries(`value`: Output<List<EcsPrefixListEntryArgs>>) {
        this.entries = value
    }

    @JvmName("tyweyxevccvsdeux")
    public suspend fun entries(vararg values: Output<EcsPrefixListEntryArgs>) {
        this.entries = Output.all(values.asList())
    }

    /**
     * @param values The Entry. The details see Block `entry`.
     */
    @JvmName("tbomdbekknwmaxhr")
    public suspend fun entries(values: List<Output<EcsPrefixListEntryArgs>>) {
        this.entries = Output.all(values)
    }

    /**
     * @param value The maximum number of entries that the prefix list can contain.  Valid values: 1 to 200.
     */
    @JvmName("fhguehfsuaknuwpn")
    public suspend fun maxEntries(`value`: Output<Int>) {
        this.maxEntries = value
    }

    /**
     * @param value The name of the prefix. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://`, `https://`, `com.aliyun`, or `com.alibabacloud`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
     */
    @JvmName("rxlyrybixcobtufb")
    public suspend fun prefixListName(`value`: Output<String>) {
        this.prefixListName = value
    }

    /**
     * @param value The IP address family. Valid values: `IPv4`,`IPv6`.
     */
    @JvmName("omdxfbkwuracbeje")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The description of the prefix list. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("sytsbjgakfstyuyq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Entry. The details see Block `entry`.
     */
    @JvmName("ygrtbrjbmdnobitp")
    public suspend fun entries(`value`: List<EcsPrefixListEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entries = mapped
    }

    /**
     * @param argument The Entry. The details see Block `entry`.
     */
    @JvmName("ofbnekpxpymfyjav")
    public suspend fun entries(argument: List<suspend EcsPrefixListEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcsPrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param argument The Entry. The details see Block `entry`.
     */
    @JvmName("oifrgfhkyfhjhnpr")
    public suspend fun entries(vararg argument: suspend EcsPrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcsPrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param argument The Entry. The details see Block `entry`.
     */
    @JvmName("qilrjoagwejdkyfp")
    public suspend fun entries(argument: suspend EcsPrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EcsPrefixListEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param values The Entry. The details see Block `entry`.
     */
    @JvmName("jnhsacaurkiqfcux")
    public suspend fun entries(vararg values: EcsPrefixListEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entries = mapped
    }

    /**
     * @param value The maximum number of entries that the prefix list can contain.  Valid values: 1 to 200.
     */
    @JvmName("dalnrhoxirsgswbh")
    public suspend fun maxEntries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEntries = mapped
    }

    /**
     * @param value The name of the prefix. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with `http://`, `https://`, `com.aliyun`, or `com.alibabacloud`. It can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-).
     */
    @JvmName("hcacfgtlwrbhbadx")
    public suspend fun prefixListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListName = mapped
    }

    internal fun build(): EcsPrefixListArgs = EcsPrefixListArgs(
        addressFamily = addressFamily,
        description = description,
        entries = entries,
        maxEntries = maxEntries,
        prefixListName = prefixListName,
    )
}
