@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EcsSessionManagerStatus].
 */
@PulumiTagMarker
public class EcsSessionManagerStatusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsSessionManagerStatusArgs = EcsSessionManagerStatusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsSessionManagerStatusArgsBuilder.() -> Unit) {
        val builder = EcsSessionManagerStatusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsSessionManagerStatus {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsSessionManagerStatus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsSessionManagerStatus(builtJavaResource)
    }
}

/**
 * Provides a ECS Session Manager Status resource.
 * For information about ECS Session Manager Status and how to use it, see [What is Session Manager Status](https://www.alibabacloud.com/help/zh/doc-detail/337915.html).
 * > **NOTE:** Available in v1.148.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsSessionManagerStatus("default", {
 *     sessionManagerStatusName: "sessionManagerStatus",
 *     status: "Disabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsSessionManagerStatus("default",
 *     session_manager_status_name="sessionManagerStatus",
 *     status="Disabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsSessionManagerStatus("default", new()
 *     {
 *         SessionManagerStatusName = "sessionManagerStatus",
 *         Status = "Disabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsSessionManagerStatus(ctx, "default", &ecs.EcsSessionManagerStatusArgs{
 * 			SessionManagerStatusName: pulumi.String("sessionManagerStatus"),
 * 			Status:                   pulumi.String("Disabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsSessionManagerStatus;
 * import com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsSessionManagerStatus("default", EcsSessionManagerStatusArgs.builder()
 *             .sessionManagerStatusName("sessionManagerStatus")
 *             .status("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsSessionManagerStatus
 *     properties:
 *       sessionManagerStatusName: sessionManagerStatus
 *       status: Disabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Session Manager Status can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsSessionManagerStatus:EcsSessionManagerStatus example <session_manager_status_name>
 * ```
 */
public class EcsSessionManagerStatus internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsSessionManagerStatus,
) : KotlinCustomResource(javaResource, EcsSessionManagerStatusMapper) {
    /**
     * The name of the resource. Valid values: `sessionManagerStatus`.
     */
    public val sessionManagerStatusName: Output<String>
        get() = javaResource.sessionManagerStatusName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EcsSessionManagerStatusMapper : ResourceMapper<EcsSessionManagerStatus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsSessionManagerStatus::class == javaResource::class

    override fun map(javaResource: Resource): EcsSessionManagerStatus =
        EcsSessionManagerStatus(javaResource as com.pulumi.alicloud.ecs.EcsSessionManagerStatus)
}

/**
 * @see [EcsSessionManagerStatus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsSessionManagerStatus].
 */
public suspend fun ecsSessionManagerStatus(
    name: String,
    block: suspend EcsSessionManagerStatusResourceBuilder.() -> Unit,
): EcsSessionManagerStatus {
    val builder = EcsSessionManagerStatusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsSessionManagerStatus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsSessionManagerStatus(name: String): EcsSessionManagerStatus {
    val builder = EcsSessionManagerStatusResourceBuilder()
    builder.name(name)
    return builder.build()
}
