@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Session Manager Status resource.
 * For information about ECS Session Manager Status and how to use it, see [What is Session Manager Status](https://www.alibabacloud.com/help/zh/doc-detail/337915.html).
 * > **NOTE:** Available in v1.148.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.EcsSessionManagerStatus("default", {
 *     sessionManagerStatusName: "sessionManagerStatus",
 *     status: "Disabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.EcsSessionManagerStatus("default",
 *     session_manager_status_name="sessionManagerStatus",
 *     status="Disabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.EcsSessionManagerStatus("default", new()
 *     {
 *         SessionManagerStatusName = "sessionManagerStatus",
 *         Status = "Disabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewEcsSessionManagerStatus(ctx, "default", &ecs.EcsSessionManagerStatusArgs{
 * 			SessionManagerStatusName: pulumi.String("sessionManagerStatus"),
 * 			Status:                   pulumi.String("Disabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsSessionManagerStatus;
 * import com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcsSessionManagerStatus("default", EcsSessionManagerStatusArgs.builder()
 *             .sessionManagerStatusName("sessionManagerStatus")
 *             .status("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:EcsSessionManagerStatus
 *     properties:
 *       sessionManagerStatusName: sessionManagerStatus
 *       status: Disabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Session Manager Status can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsSessionManagerStatus:EcsSessionManagerStatus example <session_manager_status_name>
 * ```
 * @property sessionManagerStatusName The name of the resource. Valid values: `sessionManagerStatus`.
 * @property status The status of the resource. Valid values: `Disabled`, `Enabled`.
 */
public data class EcsSessionManagerStatusArgs(
    public val sessionManagerStatusName: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs =
        com.pulumi.alicloud.ecs.EcsSessionManagerStatusArgs.builder()
            .sessionManagerStatusName(sessionManagerStatusName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsSessionManagerStatusArgs].
 */
@PulumiTagMarker
public class EcsSessionManagerStatusArgsBuilder internal constructor() {
    private var sessionManagerStatusName: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the resource. Valid values: `sessionManagerStatus`.
     */
    @JvmName("upkhaqeqcnxniewa")
    public suspend fun sessionManagerStatusName(`value`: Output<String>) {
        this.sessionManagerStatusName = value
    }

    /**
     * @param value The status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("jbkonjeqihrxmjfv")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the resource. Valid values: `sessionManagerStatus`.
     */
    @JvmName("vcanxlklvrgcxfjg")
    public suspend fun sessionManagerStatusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionManagerStatusName = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Disabled`, `Enabled`.
     */
    @JvmName("ylgyvfhqxapdoxap")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EcsSessionManagerStatusArgs = EcsSessionManagerStatusArgs(
        sessionManagerStatusName = sessionManagerStatusName,
        status = status,
    )
}
