@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EcsSnapshot].
 */
@PulumiTagMarker
public class EcsSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcsSnapshotArgs = EcsSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcsSnapshotArgsBuilder.() -> Unit) {
        val builder = EcsSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcsSnapshot {
        val builtJavaResource = com.pulumi.alicloud.ecs.EcsSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcsSnapshot(builtJavaResource)
    }
}

/**
 * Provides a ECS Snapshot resource.
 * For information about ECS Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/doc-detail/25524.htm).
 * > **NOTE:** Available in v1.120.0+.
 * ## Import
 * ECS Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsSnapshot:EcsSnapshot example <id>
 * ```
 */
public class EcsSnapshot internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EcsSnapshot,
) : KotlinCustomResource(javaResource, EcsSnapshotMapper) {
    /**
     * The category of the snapshot. Valid Values: `standard` and `flash`.
     */
    public val category: Output<String>?
        get() = javaResource.category().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The description of the snapshot.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the disk.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to forcibly delete the snapshot that has been used to create disks.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to enable the instant access feature.
     */
    public val instantAccess: Output<Boolean>?
        get() = javaResource.instantAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
     */
    public val instantAccessRetentionDays: Output<Int>?
        get() = javaResource.instantAccessRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `name` has been deprecated from provider version 1.120.0. New field `snapshot_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource group id.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The retention period of the snapshot.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the snapshot.
     */
    public val snapshotName: Output<String>
        get() = javaResource.snapshotName().applyValue({ args0 -> args0 })

    /**
     * The status of snapshot.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the snapshot.
     * > **NOTE:** If `force` is true, After an snapshot is deleted, the disks created from this snapshot cannot be re-initialized.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object EcsSnapshotMapper : ResourceMapper<EcsSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EcsSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): EcsSnapshot = EcsSnapshot(
        javaResource as
            com.pulumi.alicloud.ecs.EcsSnapshot,
    )
}

/**
 * @see [EcsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcsSnapshot].
 */
public suspend fun ecsSnapshot(name: String, block: suspend EcsSnapshotResourceBuilder.() -> Unit): EcsSnapshot {
    val builder = EcsSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecsSnapshot(name: String): EcsSnapshot {
    val builder = EcsSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
