@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EcsSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Snapshot resource.
 * For information about ECS Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/doc-detail/25524.htm).
 * > **NOTE:** Available in v1.120.0+.
 * ## Import
 * ECS Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/ecsSnapshot:EcsSnapshot example <id>
 * ```
 * @property category The category of the snapshot. Valid Values: `standard` and `flash`.
 * @property description The description of the snapshot.
 * @property diskId The ID of the disk.
 * @property force Specifies whether to forcibly delete the snapshot that has been used to create disks.
 * @property instantAccess Specifies whether to enable the instant access feature.
 * @property instantAccessRetentionDays Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
 * @property name Field `name` has been deprecated from provider version 1.120.0. New field `snapshot_name` instead.
 * @property resourceGroupId The resource group id.
 * @property retentionDays The retention period of the snapshot.
 * @property snapshotName The name of the snapshot.
 * @property tags A mapping of tags to assign to the snapshot.
 * > **NOTE:** If `force` is true, After an snapshot is deleted, the disks created from this snapshot cannot be re-initialized.
 */
public data class EcsSnapshotArgs(
    public val category: Output<String>? = null,
    public val description: Output<String>? = null,
    public val diskId: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val instantAccess: Output<Boolean>? = null,
    public val instantAccessRetentionDays: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val snapshotName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EcsSnapshotArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EcsSnapshotArgs =
        com.pulumi.alicloud.ecs.EcsSnapshotArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .instantAccess(instantAccess?.applyValue({ args0 -> args0 }))
            .instantAccessRetentionDays(instantAccessRetentionDays?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EcsSnapshotArgs].
 */
@PulumiTagMarker
public class EcsSnapshotArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var description: Output<String>? = null

    private var diskId: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var instantAccess: Output<Boolean>? = null

    private var instantAccessRetentionDays: Output<Int>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var snapshotName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The category of the snapshot. Valid Values: `standard` and `flash`.
     */
    @JvmName("jnyeiqhxlvcbdntq")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The description of the snapshot.
     */
    @JvmName("kgmgagchkqdaodbx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the disk.
     */
    @JvmName("qdxbcavehabtiast")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value Specifies whether to forcibly delete the snapshot that has been used to create disks.
     */
    @JvmName("kidjqvnovsdaxcki")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Specifies whether to enable the instant access feature.
     */
    @JvmName("vikrysiqcxqxtefi")
    public suspend fun instantAccess(`value`: Output<Boolean>) {
        this.instantAccess = value
    }

    /**
     * @param value Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
     */
    @JvmName("krujmaubdhtvumit")
    public suspend fun instantAccessRetentionDays(`value`: Output<Int>) {
        this.instantAccessRetentionDays = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.120.0. New field `snapshot_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    @JvmName("decogxvfpwqlblro")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("kancykfpbkbeupnx")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The retention period of the snapshot.
     */
    @JvmName("omtbijmtkllghrcx")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("cfdslkgnfujxwcxl")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value A mapping of tags to assign to the snapshot.
     * > **NOTE:** If `force` is true, After an snapshot is deleted, the disks created from this snapshot cannot be re-initialized.
     */
    @JvmName("xtxdlhordoklsijj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The category of the snapshot. Valid Values: `standard` and `flash`.
     */
    @JvmName("xcykkgnxkccvaatr")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The description of the snapshot.
     */
    @JvmName("rmxlvjfwbhmdranx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the disk.
     */
    @JvmName("qagusqifjtdfshac")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value Specifies whether to forcibly delete the snapshot that has been used to create disks.
     */
    @JvmName("scwdvjaamxtpvaxo")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Specifies whether to enable the instant access feature.
     */
    @JvmName("psovgfivfkyrbnas")
    public suspend fun instantAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantAccess = mapped
    }

    /**
     * @param value Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
     */
    @JvmName("fnkqcoqhlinnqatd")
    public suspend fun instantAccessRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantAccessRetentionDays = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.120.0. New field `snapshot_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    @JvmName("rfmiywxqasrybksu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("ymfdeivfvacoltaf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The retention period of the snapshot.
     */
    @JvmName("grylqslrdqoqpyca")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("gwmnekijsboiynwa")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the snapshot.
     * > **NOTE:** If `force` is true, After an snapshot is deleted, the disks created from this snapshot cannot be re-initialized.
     */
    @JvmName("xxnfgjrauqamcohf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the snapshot.
     * > **NOTE:** If `force` is true, After an snapshot is deleted, the disks created from this snapshot cannot be re-initialized.
     */
    @JvmName("puxmhvlbtuaiqovo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EcsSnapshotArgs = EcsSnapshotArgs(
        category = category,
        description = description,
        diskId = diskId,
        force = force,
        instantAccess = instantAccess,
        instantAccessRetentionDays = instantAccessRetentionDays,
        name = name,
        resourceGroupId = resourceGroupId,
        retentionDays = retentionDays,
        snapshotName = snapshotName,
        tags = tags,
    )
}
