@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Eip].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
public class EipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipArgs = EipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipArgsBuilder.() -> Unit) {
        val builder = EipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Eip {
        val builtJavaResource = com.pulumi.alicloud.ecs.Eip(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Eip(builtJavaResource)
    }
}

/**
 * Provides an elastic IP resource.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.126.0`. Please use new resource alicloud_eip_address.
 * > **NOTE:** The resource only supports to create `PostPaid PayByTraffic`  or `PrePaid PayByBandwidth` elastic IP for international account. Otherwise, you will happened error `COMMODITY.INVALID_COMPONENT`.
 * Your account is international if you can use it to login in [International Web Console](https://account.alibabacloud.com/login/login.htm).
 * > **NOTE:** From version 1.10.1, this resource supports creating "PrePaid" EIP. In addition, it supports setting EIP name and description.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new EIP.
 * const example = new alicloud.ecs.Eip("example", {
 *     bandwidth: "10",
 *     internetChargeType: "PayByBandwidth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new EIP.
 * example = alicloud.ecs.Eip("example",
 *     bandwidth="10",
 *     internet_charge_type="PayByBandwidth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new EIP.
 *     var example = new AliCloud.Ecs.Eip("example", new()
 *     {
 *         Bandwidth = "10",
 *         InternetChargeType = "PayByBandwidth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new EIP.
 * 		_, err := ecs.NewEip(ctx, "example", &ecs.EipArgs{
 * 			Bandwidth:          pulumi.String("10"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Eip;
 * import com.pulumi.alicloud.ecs.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new EIP.
 *         var example = new Eip("example", EipArgs.builder()
 *             .bandwidth("10")
 *             .internetChargeType("PayByBandwidth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new EIP.
 *   example:
 *     type: alicloud:ecs:Eip
 *     properties:
 *       bandwidth: '10'
 *       internetChargeType: PayByBandwidth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing eip module
 * to create several EIP instances and associate them with other resources one-click, like ECS instances, SLB, Nat Gateway and so on.
 * ## Import
 * Elastic IP address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eip:Eip example eip-abc12345678
 * ```
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
public class Eip internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.Eip,
) : KotlinCustomResource(javaResource, EipMapper) {
    public val activityId: Output<String>?
        get() = javaResource.activityId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
     */
    public val addressName: Output<String>
        get() = javaResource.addressName().applyValue({ args0 -> args0 })

    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    public val deletionProtection: Output<Boolean>
        get() = javaResource.deletionProtection().applyValue({ args0 -> args0 })

    /**
     * Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val highDefinitionMonitorLogStatus: Output<String>
        get() = javaResource.highDefinitionMonitorLogStatus().applyValue({ args0 -> args0 })

    /**
     * (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * The elastic ip address
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
     */
    public val isp: Output<String>
        get() = javaResource.isp().applyValue({ args0 -> args0 })

    public val logProject: Output<String>?
        get() = javaResource.logProject().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val logStore: Output<String>?
        get() = javaResource.logStore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val netmode: Output<String>
        get() = javaResource.netmode().applyValue({ args0 -> args0 })

    /**
     * The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val publicIpAddressPoolId: Output<String>?
        get() = javaResource.publicIpAddressPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of resource group which the eip belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val securityProtectionTypes: Output<List<String>>?
        get() = javaResource.securityProtectionTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The EIP current status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val zone: Output<String>
        get() = javaResource.zone().applyValue({ args0 -> args0 })
}

public object EipMapper : ResourceMapper<Eip> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.Eip::class == javaResource::class

    override fun map(javaResource: Resource): Eip = Eip(javaResource as com.pulumi.alicloud.ecs.Eip)
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Eip].
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
public suspend fun eip(name: String, block: suspend EipResourceBuilder.() -> Unit): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
public fun eip(name: String): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    return builder.build()
}
