@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EipAddress].
 */
@PulumiTagMarker
public class EipAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipAddressArgs = EipAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipAddressArgsBuilder.() -> Unit) {
        val builder = EipAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EipAddress {
        val builtJavaResource = com.pulumi.alicloud.ecs.EipAddress(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EipAddress(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * EIP Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
 * ```
 */
public class EipAddress internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EipAddress,
) : KotlinCustomResource(javaResource, EipAddressMapper) {
    /**
     * The promotion code. This parameter is not required.
     */
    public val activityId: Output<String>?
        get() = javaResource.activityId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The EIP name.
     * The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-).
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    public val addressName: Output<String>
        get() = javaResource.addressName().applyValue({ args0 -> args0 })

    /**
     * The ID of the EIP instance.
     */
    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable automatic payment. Valid values:
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum bandwidth of the specified EIP. Unit: Mbit/s.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
     * - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
     * Default value: `5` Mbit /s.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The time when the EIP was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable deletion protection. Valid values:
     */
    public val deletionProtection: Output<Boolean>
        get() = javaResource.deletionProtection().applyValue({ args0 -> args0 })

    /**
     * The description of the EIP.
     * The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of fine-grained monitoring. Valid values:
     * - `ON`
     * - `OFF`
     */
    public val highDefinitionMonitorLogStatus: Output<String>
        get() = javaResource.highDefinitionMonitorLogStatus().applyValue({ args0 -> args0 })

    /**
     * . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * The metering method of the EIP. Valid values:
     * - `PayByBandwidth` (default): pay-by-bandwidth.
     * - `PayByTraffic`: pay-by-data-transfer.
     * When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
     * When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * The IP address of the EIP. Supports a maximum of 50 EIPs.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
     * If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    public val isp: Output<String>
        get() = javaResource.isp().applyValue({ args0 -> args0 })

    /**
     * The name of the Simple Log Service (SLS) project.
     */
    public val logProject: Output<String>?
        get() = javaResource.logProject().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Logstore.
     */
    public val logStore: Output<String>?
        get() = javaResource.logStore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The association mode. Valid values:
     * - `NAT` (default): NAT mode
     * - `MULTI_BINDED`: multi-EIP-to-ENI mode
     * - `BINDED`: cut-network interface controller mode
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network type. By default, this value is set to `public`, which specifies the public network type.
     */
    public val netmode: Output<String>
        get() = javaResource.netmode().applyValue({ args0 -> args0 })

    /**
     * The billing method of the EIP. Valid values:
     * - `Subscription`: subscription
     * - `PayAsYouGo` (default): pay-as-you-go
     * If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The billing cycle of the subscription EIP. Valid values:
     * - `Month` (default)
     * - `Year`
     * If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
     */
    public val publicIpAddressPoolId: Output<String>?
        get() = javaResource.publicIpAddressPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Security protection level.
     * - When the return is empty, the basic DDoS protection is specified.
     * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
     */
    public val securityProtectionTypes: Output<List<String>>?
        get() = javaResource.securityProtectionTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The state of the EIP.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html).
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val zone: Output<String>
        get() = javaResource.zone().applyValue({ args0 -> args0 })
}

public object EipAddressMapper : ResourceMapper<EipAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EipAddress::class == javaResource::class

    override fun map(javaResource: Resource): EipAddress = EipAddress(
        javaResource as
            com.pulumi.alicloud.ecs.EipAddress,
    )
}

/**
 * @see [EipAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EipAddress].
 */
public suspend fun eipAddress(name: String, block: suspend EipAddressResourceBuilder.() -> Unit): EipAddress {
    val builder = EipAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EipAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eipAddress(name: String): EipAddress {
    val builder = EipAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
