@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EipAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * EIP Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
 * ```
 * @property activityId The promotion code. This parameter is not required.
 * @property addressName The EIP name.
 * The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-).
 * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
 * @property allocationId The ID of the EIP instance.
 * @property autoPay Specifies whether to enable automatic payment. Valid values:
 * @property bandwidth The maximum bandwidth of the specified EIP. Unit: Mbit/s.
 * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
 * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
 * - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
 * Default value: `5` Mbit /s.
 * @property deletionProtection Specifies whether to enable deletion protection. Valid values:
 * @property description The description of the EIP.
 * The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
 * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
 * @property highDefinitionMonitorLogStatus The status of fine-grained monitoring. Valid values:
 * - `ON`
 * - `OFF`
 * @property instanceChargeType . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
 * @property internetChargeType The metering method of the EIP. Valid values:
 * - `PayByBandwidth` (default): pay-by-bandwidth.
 * - `PayByTraffic`: pay-by-data-transfer.
 * When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
 * When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
 * @property ipAddress The IP address of the EIP. Supports a maximum of 50 EIPs.
 * @property isp The line type. Valid values:
 * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
 * - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
 * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
 * If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
 * - `ChinaTelecom`
 * - `ChinaUnicom`
 * - `ChinaMobile`
 * - `ChinaTelecom_L2`
 * - `ChinaUnicom_L2`
 * - `ChinaMobile_L2`
 * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
 * @property logProject The name of the Simple Log Service (SLS) project.
 * @property logStore The name of the Logstore.
 * @property mode The association mode. Valid values:
 * - `NAT` (default): NAT mode
 * - `MULTI_BINDED`: multi-EIP-to-ENI mode
 * - `BINDED`: cut-network interface controller mode
 * @property name . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
 * @property netmode The network type. By default, this value is set to `public`, which specifies the public network type.
 * @property paymentType The billing method of the EIP. Valid values:
 * - `Subscription`: subscription
 * - `PayAsYouGo` (default): pay-as-you-go
 * If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
 * @property period Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
 * @property pricingCycle The billing cycle of the subscription EIP. Valid values:
 * - `Month` (default)
 * - `Year`
 * If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
 * @property publicIpAddressPoolId The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
 * @property resourceGroupId The ID of the resource group to which you want to move the resource.
 * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
 * @property securityProtectionTypes Security protection level.
 * - When the return is empty, the basic DDoS protection is specified.
 * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
 * @property tags The tag of the resource
 * @property zone The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html).
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class EipAddressArgs(
    public val activityId: Output<String>? = null,
    public val addressName: Output<String>? = null,
    public val allocationId: Output<String>? = null,
    public val autoPay: Output<Boolean>? = null,
    public val bandwidth: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val highDefinitionMonitorLogStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val isp: Output<String>? = null,
    public val logProject: Output<String>? = null,
    public val logStore: Output<String>? = null,
    public val mode: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val netmode: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val pricingCycle: Output<String>? = null,
    public val publicIpAddressPoolId: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityProtectionTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EipAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EipAddressArgs =
        com.pulumi.alicloud.ecs.EipAddressArgs.builder()
            .activityId(activityId?.applyValue({ args0 -> args0 }))
            .addressName(addressName?.applyValue({ args0 -> args0 }))
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .highDefinitionMonitorLogStatus(highDefinitionMonitorLogStatus?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .isp(isp?.applyValue({ args0 -> args0 }))
            .logProject(logProject?.applyValue({ args0 -> args0 }))
            .logStore(logStore?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .netmode(netmode?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .publicIpAddressPoolId(publicIpAddressPoolId?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityProtectionTypes(
                securityProtectionTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipAddressArgs].
 */
@PulumiTagMarker
public class EipAddressArgsBuilder internal constructor() {
    private var activityId: Output<String>? = null

    private var addressName: Output<String>? = null

    private var allocationId: Output<String>? = null

    private var autoPay: Output<Boolean>? = null

    private var bandwidth: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var highDefinitionMonitorLogStatus: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var isp: Output<String>? = null

    private var logProject: Output<String>? = null

    private var logStore: Output<String>? = null

    private var mode: Output<String>? = null

    private var name: Output<String>? = null

    private var netmode: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var pricingCycle: Output<String>? = null

    private var publicIpAddressPoolId: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityProtectionTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zone: Output<String>? = null

    /**
     * @param value The promotion code. This parameter is not required.
     */
    @JvmName("hblnmyyqexmeovvp")
    public suspend fun activityId(`value`: Output<String>) {
        this.activityId = value
    }

    /**
     * @param value The EIP name.
     * The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-).
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    @JvmName("qwuhqrhofnttslxn")
    public suspend fun addressName(`value`: Output<String>) {
        this.addressName = value
    }

    /**
     * @param value The ID of the EIP instance.
     */
    @JvmName("ddktofkhulcphmbo")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value Specifies whether to enable automatic payment. Valid values:
     */
    @JvmName("mdffeblmnafmawju")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value The maximum bandwidth of the specified EIP. Unit: Mbit/s.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
     * - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
     * Default value: `5` Mbit /s.
     */
    @JvmName("bywovapjkkepswjb")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value Specifies whether to enable deletion protection. Valid values:
     */
    @JvmName("ftfgnmemgyckleyx")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The description of the EIP.
     * The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    @JvmName("vyggchxrwcioqwpn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The status of fine-grained monitoring. Valid values:
     * - `ON`
     * - `OFF`
     */
    @JvmName("abdymelinocvgomf")
    public suspend fun highDefinitionMonitorLogStatus(`value`: Output<String>) {
        this.highDefinitionMonitorLogStatus = value
    }

    /**
     * @param value . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("lfdxmhddyefsynyb")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The metering method of the EIP. Valid values:
     * - `PayByBandwidth` (default): pay-by-bandwidth.
     * - `PayByTraffic`: pay-by-data-transfer.
     * When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
     * When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    @JvmName("jttjfmyhsaehvouy")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The IP address of the EIP. Supports a maximum of 50 EIPs.
     */
    @JvmName("hqlkodaerivqgeon")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
     * If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    @JvmName("guohlbrndudpwtjt")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value The name of the Simple Log Service (SLS) project.
     */
    @JvmName("tjbovgpmrihepypg")
    public suspend fun logProject(`value`: Output<String>) {
        this.logProject = value
    }

    /**
     * @param value The name of the Logstore.
     */
    @JvmName("ntludxfgiexjaskv")
    public suspend fun logStore(`value`: Output<String>) {
        this.logStore = value
    }

    /**
     * @param value The association mode. Valid values:
     * - `NAT` (default): NAT mode
     * - `MULTI_BINDED`: multi-EIP-to-ENI mode
     * - `BINDED`: cut-network interface controller mode
     */
    @JvmName("rholvolowjtwjspc")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    @JvmName("mjcodmxpvdskmgnn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network type. By default, this value is set to `public`, which specifies the public network type.
     */
    @JvmName("hgbygcnwexruudbf")
    public suspend fun netmode(`value`: Output<String>) {
        this.netmode = value
    }

    /**
     * @param value The billing method of the EIP. Valid values:
     * - `Subscription`: subscription
     * - `PayAsYouGo` (default): pay-as-you-go
     * If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    @JvmName("jusqcsqbfdjdltnk")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
     */
    @JvmName("qwfupjoypndegavy")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The billing cycle of the subscription EIP. Valid values:
     * - `Month` (default)
     * - `Year`
     * If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
     */
    @JvmName("quvtrawixeuktojq")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
     */
    @JvmName("mvbmkpmdpqcvgvrt")
    public suspend fun publicIpAddressPoolId(`value`: Output<String>) {
        this.publicIpAddressPoolId = value
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("mxiqgfusymormwpu")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Security protection level.
     * - When the return is empty, the basic DDoS protection is specified.
     * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
     */
    @JvmName("babhrlgrlcbdsipu")
    public suspend fun securityProtectionTypes(`value`: Output<List<String>>) {
        this.securityProtectionTypes = value
    }

    @JvmName("biioqawbscsjqogf")
    public suspend fun securityProtectionTypes(vararg values: Output<String>) {
        this.securityProtectionTypes = Output.all(values.asList())
    }

    /**
     * @param values Security protection level.
     * - When the return is empty, the basic DDoS protection is specified.
     * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
     */
    @JvmName("aptgbfmrbkcrgyvq")
    public suspend fun securityProtectionTypes(values: List<Output<String>>) {
        this.securityProtectionTypes = Output.all(values)
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("whgflygiyepwcaxr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html).
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("oiwshglkirkmesas")
    public suspend fun zone(`value`: Output<String>) {
        this.zone = value
    }

    /**
     * @param value The promotion code. This parameter is not required.
     */
    @JvmName("qanhoxcyupelnikr")
    public suspend fun activityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activityId = mapped
    }

    /**
     * @param value The EIP name.
     * The name must be 1 to 128 characters in length and start with a letter, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-).
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    @JvmName("hbheilyyghaowdbb")
    public suspend fun addressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressName = mapped
    }

    /**
     * @param value The ID of the EIP instance.
     */
    @JvmName("rfewiailnwjjorml")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value Specifies whether to enable automatic payment. Valid values:
     */
    @JvmName("lhhddpwmskueqwau")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value The maximum bandwidth of the specified EIP. Unit: Mbit/s.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByBandwidth`, valid values for `bandwidth` are `1` to `500`.
     * - When `payment_type` is set to `PayAsYouGo` and `internet_charge_type` is set to `PayByTraffic`, valid values for `bandwidth` are `1` to `200`.
     * - When `payment_type` is set to `Subscription`, valid values for `bandwidth` are `1` to `1000`.
     * Default value: `5` Mbit /s.
     */
    @JvmName("lsrhmebdfvwiivre")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Specifies whether to enable deletion protection. Valid values:
     */
    @JvmName("chdpbfswpxkhxqvv")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The description of the EIP.
     * The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
     * > **NOTE:**   You cannot specify this parameter if you create a subscription EIP.
     */
    @JvmName("yjierwupbolnrdxy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The status of fine-grained monitoring. Valid values:
     * - `ON`
     * - `OFF`
     */
    @JvmName("xdtxjhihroxwqqfw")
    public suspend fun highDefinitionMonitorLogStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highDefinitionMonitorLogStatus = mapped
    }

    /**
     * @param value . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("bhcjtdlpuoawljpu")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The metering method of the EIP. Valid values:
     * - `PayByBandwidth` (default): pay-by-bandwidth.
     * - `PayByTraffic`: pay-by-data-transfer.
     * When `payment_type` is set to `Subscription`, you must set `internet_charge_type` to `PayByBandwidth`.
     * When `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    @JvmName("jqxkxinlqupahoja")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The IP address of the EIP. Supports a maximum of 50 EIPs.
     */
    @JvmName("wrdnmaewnlmtsniy")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line The BGP (Multi-ISP) Pro line is supported in the China (Hong Kong), Singapore, Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see the "Line types" section of [What is EIP?](https://www.alibabacloud.com/help/en/doc-detail/32321.html)
     * If you are allowed to use single-ISP bandwidth, you can also choose one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    @JvmName("mhefvbkqwjfrtvvg")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value The name of the Simple Log Service (SLS) project.
     */
    @JvmName("cchmlrcnhmdgucgr")
    public suspend fun logProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logProject = mapped
    }

    /**
     * @param value The name of the Logstore.
     */
    @JvmName("bsjfjrccvhcimuge")
    public suspend fun logStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStore = mapped
    }

    /**
     * @param value The association mode. Valid values:
     * - `NAT` (default): NAT mode
     * - `MULTI_BINDED`: multi-EIP-to-ENI mode
     * - `BINDED`: cut-network interface controller mode
     */
    @JvmName("eqqlapqruoxlfkfw")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    @JvmName("kwymhnswimfrgldp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network type. By default, this value is set to `public`, which specifies the public network type.
     */
    @JvmName("dibxywlquwubvion")
    public suspend fun netmode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmode = mapped
    }

    /**
     * @param value The billing method of the EIP. Valid values:
     * - `Subscription`: subscription
     * - `PayAsYouGo` (default): pay-as-you-go
     * If `payment_type` is set to `Subscription`, set `internet_charge_type` to `PayByBandwidth`. If `payment_type` is set to `PayAsYouGo`, set `internet_charge_type` to `PayByBandwidth` or `PayByTraffic`.
     */
    @JvmName("rdpokpopmqefihmn")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Duration of purchase. When the value of `pricing_cycle` is `Month`, the value range of `period` is `1` to `9`. When the value of `pricing_cycle` is `Year`, the value range of `period` is `1` to `5`. If the value of the `payment_type` parameter is `Subscription`, this parameter is required. If the value of the `payment_type` parameter is `PayAsYouGo`, this parameter is left blank.
     */
    @JvmName("ogabgqmqikidittr")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The billing cycle of the subscription EIP. Valid values:
     * - `Month` (default)
     * - `Year`
     * If `payment_type` is set to `Subscription`, this parameter is required. If `payment_type` is set to `PayAsYouGo`, this parameter is not required.
     */
    @JvmName("vhiogunesfombrjy")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The ID of the IP address pool. The EIP is allocated from the IP address pool. By default, the IP address pool feature is unavailable. To use the IP address pool, apply for the privilege in the Quota Center console. For more information, see the "Request a quota increase in the Quota Center console" section in [Manage EIP quotas](https://www.alibabacloud.com/help/en/doc-detail/108213.html).
     */
    @JvmName("vajuetqkwhmawyiw")
    public suspend fun publicIpAddressPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressPoolId = mapped
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("ljurtgjllcwtlvau")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Security protection level.
     * - When the return is empty, the basic DDoS protection is specified.
     * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
     */
    @JvmName("tcnvriibbojtdmmd")
    public suspend fun securityProtectionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param values Security protection level.
     * - When the return is empty, the basic DDoS protection is specified.
     * - When `antidos_enhanced` is returned, it indicates DDoS protection (enhanced version).
     */
    @JvmName("cbyphoqknwodpwgp")
    public suspend fun securityProtectionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("vwbbwxemskvhprbn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource
     */
    @JvmName("dtaqojbssctmlxuw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The zone of the EIP. When the service type of the IP address pool specified by `PublicIpAddressPoolId` is CloudBox, the default value is the zone of the IP address pool. For more information, see [ListPublicIpAddressPools](https://www.alibabacloud.com/help/en/doc-detail/429433.html).
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("duewwaviljmsaupw")
    public suspend fun zone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): EipAddressArgs = EipAddressArgs(
        activityId = activityId,
        addressName = addressName,
        allocationId = allocationId,
        autoPay = autoPay,
        bandwidth = bandwidth,
        deletionProtection = deletionProtection,
        description = description,
        highDefinitionMonitorLogStatus = highDefinitionMonitorLogStatus,
        instanceChargeType = instanceChargeType,
        internetChargeType = internetChargeType,
        ipAddress = ipAddress,
        isp = isp,
        logProject = logProject,
        logStore = logStore,
        mode = mode,
        name = name,
        netmode = netmode,
        paymentType = paymentType,
        period = period,
        pricingCycle = pricingCycle,
        publicIpAddressPoolId = publicIpAddressPoolId,
        resourceGroupId = resourceGroupId,
        securityProtectionTypes = securityProtectionTypes,
        tags = tags,
        zone = zone,
    )
}
