@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an elastic IP resource.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.126.0`. Please use new resource alicloud_eip_address.
 * > **NOTE:** The resource only supports to create `PostPaid PayByTraffic`  or `PrePaid PayByBandwidth` elastic IP for international account. Otherwise, you will happened error `COMMODITY.INVALID_COMPONENT`.
 * Your account is international if you can use it to login in [International Web Console](https://account.alibabacloud.com/login/login.htm).
 * > **NOTE:** From version 1.10.1, this resource supports creating "PrePaid" EIP. In addition, it supports setting EIP name and description.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new EIP.
 * const example = new alicloud.ecs.Eip("example", {
 *     bandwidth: "10",
 *     internetChargeType: "PayByBandwidth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new EIP.
 * example = alicloud.ecs.Eip("example",
 *     bandwidth="10",
 *     internet_charge_type="PayByBandwidth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new EIP.
 *     var example = new AliCloud.Ecs.Eip("example", new()
 *     {
 *         Bandwidth = "10",
 *         InternetChargeType = "PayByBandwidth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new EIP.
 * 		_, err := ecs.NewEip(ctx, "example", &ecs.EipArgs{
 * 			Bandwidth:          pulumi.String("10"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Eip;
 * import com.pulumi.alicloud.ecs.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new EIP.
 *         var example = new Eip("example", EipArgs.builder()
 *             .bandwidth("10")
 *             .internetChargeType("PayByBandwidth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new EIP.
 *   example:
 *     type: alicloud:ecs:Eip
 *     properties:
 *       bandwidth: '10'
 *       internetChargeType: PayByBandwidth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing eip module
 * to create several EIP instances and associate them with other resources one-click, like ECS instances, SLB, Nat Gateway and so on.
 * ## Import
 * Elastic IP address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eip:Eip example eip-abc12345678
 * ```
 * @property activityId
 * @property addressName The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
 * @property allocationId
 * @property autoPay
 * @property bandwidth Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
 * @property deletionProtection Whether enable the deletion protection or not. Default value: `false`.
 * - true: Enable deletion protection.
 * - false: Disable deletion protection.
 * @property description Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property highDefinitionMonitorLogStatus
 * @property instanceChargeType (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
 * @property internetChargeType Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
 * @property ipAddress The elastic ip address
 * @property isp The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
 * @property logProject
 * @property logStore
 * @property mode
 * @property name It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
 * @property netmode
 * @property paymentType The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
 * @property period The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
 * **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property pricingCycle
 * @property publicIpAddressPoolId
 * @property resourceGroupId The Id of resource group which the eip belongs.
 * @property securityProtectionTypes
 * @property tags A mapping of tags to assign to the resource.
 * @property zone
 */
public data class EipArgs
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
constructor(
    public val activityId: Output<String>? = null,
    public val addressName: Output<String>? = null,
    public val allocationId: Output<String>? = null,
    public val autoPay: Output<Boolean>? = null,
    public val bandwidth: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val highDefinitionMonitorLogStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val isp: Output<String>? = null,
    public val logProject: Output<String>? = null,
    public val logStore: Output<String>? = null,
    public val mode: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val netmode: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val pricingCycle: Output<String>? = null,
    public val publicIpAddressPoolId: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityProtectionTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EipArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EipArgs = com.pulumi.alicloud.ecs.EipArgs.builder()
        .activityId(activityId?.applyValue({ args0 -> args0 }))
        .addressName(addressName?.applyValue({ args0 -> args0 }))
        .allocationId(allocationId?.applyValue({ args0 -> args0 }))
        .autoPay(autoPay?.applyValue({ args0 -> args0 }))
        .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
        .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .highDefinitionMonitorLogStatus(highDefinitionMonitorLogStatus?.applyValue({ args0 -> args0 }))
        .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
        .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
        .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
        .isp(isp?.applyValue({ args0 -> args0 }))
        .logProject(logProject?.applyValue({ args0 -> args0 }))
        .logStore(logStore?.applyValue({ args0 -> args0 }))
        .mode(mode?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .netmode(netmode?.applyValue({ args0 -> args0 }))
        .paymentType(paymentType?.applyValue({ args0 -> args0 }))
        .period(period?.applyValue({ args0 -> args0 }))
        .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
        .publicIpAddressPoolId(publicIpAddressPoolId?.applyValue({ args0 -> args0 }))
        .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
        .securityProtectionTypes(
            securityProtectionTypes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of the EipAddress resource
""",
)
public class EipArgsBuilder internal constructor() {
    private var activityId: Output<String>? = null

    private var addressName: Output<String>? = null

    private var allocationId: Output<String>? = null

    private var autoPay: Output<Boolean>? = null

    private var bandwidth: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var highDefinitionMonitorLogStatus: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var isp: Output<String>? = null

    private var logProject: Output<String>? = null

    private var logStore: Output<String>? = null

    private var mode: Output<String>? = null

    private var name: Output<String>? = null

    private var netmode: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var pricingCycle: Output<String>? = null

    private var publicIpAddressPoolId: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityProtectionTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zone: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yqlfcpxldycmdqbe")
    public suspend fun activityId(`value`: Output<String>) {
        this.activityId = value
    }

    /**
     * @param value The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
     */
    @JvmName("deyqxyqlxkrfsule")
    public suspend fun addressName(`value`: Output<String>) {
        this.addressName = value
    }

    /**
     * @param value
     */
    @JvmName("nsfuaqxurylygyox")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value
     */
    @JvmName("ogdepiahxyrdartk")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
     */
    @JvmName("hkeekasqpmxubvjt")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("ichprqnboewcvxwk")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("vfhgegwsmwmqqtef")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("jwgwofnqkuyppjgk")
    public suspend fun highDefinitionMonitorLogStatus(`value`: Output<String>) {
        this.highDefinitionMonitorLogStatus = value
    }

    /**
     * @param value (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("vhxsjbxgbvqsvdah")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
     */
    @JvmName("tgnxbxcnknpddoky")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The elastic ip address
     */
    @JvmName("tqlcdvegkmiwlrml")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
     */
    @JvmName("lmxmbxncpsxhjpsr")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value
     */
    @JvmName("ckwimborbgnymiyr")
    public suspend fun logProject(`value`: Output<String>) {
        this.logProject = value
    }

    /**
     * @param value
     */
    @JvmName("enrmgrxebojdanno")
    public suspend fun logStore(`value`: Output<String>) {
        this.logStore = value
    }

    /**
     * @param value
     */
    @JvmName("sroaokueqovfmeqk")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    @JvmName("nvgupkiiblyqtfnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("tsqbjjrjwtcgkjvc")
    public suspend fun netmode(`value`: Output<String>) {
        this.netmode = value
    }

    /**
     * @param value The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
     */
    @JvmName("sqmlifcdjrogbrya")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("ktxkrygfwopwlajj")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value
     */
    @JvmName("wpjxfqdhsrfeensm")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value
     */
    @JvmName("rdhdgxdncmhyyvxo")
    public suspend fun publicIpAddressPoolId(`value`: Output<String>) {
        this.publicIpAddressPoolId = value
    }

    /**
     * @param value The Id of resource group which the eip belongs.
     */
    @JvmName("pxhxfftgiddquwgr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("ubigixlmxlhyofpx")
    public suspend fun securityProtectionTypes(`value`: Output<List<String>>) {
        this.securityProtectionTypes = value
    }

    @JvmName("evloiusirymkucba")
    public suspend fun securityProtectionTypes(vararg values: Output<String>) {
        this.securityProtectionTypes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tggwwyquirapogyh")
    public suspend fun securityProtectionTypes(values: List<Output<String>>) {
        this.securityProtectionTypes = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("yohcljfyosoypcim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("jxwmdjdemeahkjye")
    public suspend fun zone(`value`: Output<String>) {
        this.zone = value
    }

    /**
     * @param value
     */
    @JvmName("twcwrcpvthxaoqjh")
    public suspend fun activityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activityId = mapped
    }

    /**
     * @param value The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
     */
    @JvmName("epoybvllihtanmat")
    public suspend fun addressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressName = mapped
    }

    /**
     * @param value
     */
    @JvmName("rstosdlxnliiytom")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("nbxnwdreokbfcvuw")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
     */
    @JvmName("niuxdsfjxgsndvda")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Whether enable the deletion protection or not. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("tcwvusfccxmhvpun")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("ycqwcglsycsvevra")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("irmlsnwsjonwkfts")
    public suspend fun highDefinitionMonitorLogStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highDefinitionMonitorLogStatus = mapped
    }

    /**
     * @param value (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field
      'payment_type' instead.
  """,
    )
    @JvmName("ivslhoxutmkxwcfi")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
     */
    @JvmName("llwocuhnrfleemid")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The elastic ip address
     */
    @JvmName("vqwiwwbjdunfgrkg")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
     */
    @JvmName("kcpdbbyxurpiqfyx")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value
     */
    @JvmName("jtaqngmkmcrcekyj")
    public suspend fun logProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logProject = mapped
    }

    /**
     * @param value
     */
    @JvmName("nxjfyskbakqscuen")
    public suspend fun logStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("djjcqcxhcheywpof")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.
  """,
    )
    @JvmName("kbaudrpgpterlfjx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("dupbvqbonouxylob")
    public suspend fun netmode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmode = mapped
    }

    /**
     * @param value The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
     */
    @JvmName("mcjhpivjlfjnwvbx")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
     * **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("omwqwfretkixyjfg")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value
     */
    @JvmName("rvxrerwegbwcfibr")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value
     */
    @JvmName("soyxmkxhxcuqnybw")
    public suspend fun publicIpAddressPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressPoolId = mapped
    }

    /**
     * @param value The Id of resource group which the eip belongs.
     */
    @JvmName("vjkqewdgrwasnnfh")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggdhxrgpmushasya")
    public suspend fun securityProtectionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param values
     */
    @JvmName("dsushyklgmkuydnf")
    public suspend fun securityProtectionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bckopnfvhptfgpkt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("wlkpotenkdxbqhkn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("avvhwvfxuijhkwma")
    public suspend fun zone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): EipArgs = EipArgs(
        activityId = activityId,
        addressName = addressName,
        allocationId = allocationId,
        autoPay = autoPay,
        bandwidth = bandwidth,
        deletionProtection = deletionProtection,
        description = description,
        highDefinitionMonitorLogStatus = highDefinitionMonitorLogStatus,
        instanceChargeType = instanceChargeType,
        internetChargeType = internetChargeType,
        ipAddress = ipAddress,
        isp = isp,
        logProject = logProject,
        logStore = logStore,
        mode = mode,
        name = name,
        netmode = netmode,
        paymentType = paymentType,
        period = period,
        pricingCycle = pricingCycle,
        publicIpAddressPoolId = publicIpAddressPoolId,
        resourceGroupId = resourceGroupId,
        securityProtectionTypes = securityProtectionTypes,
        tags = tags,
        zone = zone,
    )
}
