@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EipSegmentAddress].
 */
@PulumiTagMarker
public class EipSegmentAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipSegmentAddressArgs = EipSegmentAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipSegmentAddressArgsBuilder.() -> Unit) {
        val builder = EipSegmentAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EipSegmentAddress {
        val builtJavaResource = com.pulumi.alicloud.ecs.EipSegmentAddress(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EipSegmentAddress(builtJavaResource)
    }
}

/**
 * Provides a EIP Segment Address resource.
 * For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).
 * > **NOTE:** Available since v1.207.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ecs.EipSegmentAddress("default", {
 *     eipMask: "28",
 *     bandwidth: "5",
 *     isp: "BGP",
 *     internetChargeType: "PayByBandwidth",
 *     netmode: "public",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ecs.EipSegmentAddress("default",
 *     eip_mask="28",
 *     bandwidth="5",
 *     isp="BGP",
 *     internet_charge_type="PayByBandwidth",
 *     netmode="public")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ecs.EipSegmentAddress("default", new()
 *     {
 *         EipMask = "28",
 *         Bandwidth = "5",
 *         Isp = "BGP",
 *         InternetChargeType = "PayByBandwidth",
 *         Netmode = "public",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEipSegmentAddress(ctx, "default", &ecs.EipSegmentAddressArgs{
 * 			EipMask:            pulumi.String("28"),
 * 			Bandwidth:          pulumi.String("5"),
 * 			Isp:                pulumi.String("BGP"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 			Netmode:            pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EipSegmentAddress;
 * import com.pulumi.alicloud.ecs.EipSegmentAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new EipSegmentAddress("default", EipSegmentAddressArgs.builder()
 *             .eipMask("28")
 *             .bandwidth("5")
 *             .isp("BGP")
 *             .internetChargeType("PayByBandwidth")
 *             .netmode("public")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ecs:EipSegmentAddress
 *     properties:
 *       eipMask: '28'
 *       bandwidth: '5'
 *       isp: BGP
 *       internetChargeType: PayByBandwidth
 *       netmode: public
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EIP Segment Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
 * ```
 */
public class EipSegmentAddress internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.EipSegmentAddress,
) : KotlinCustomResource(javaResource, EipSegmentAddressMapper) {
    /**
     * The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
     * - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
     * Default value: `5`. Unit: Mbit/s.
     */
    public val bandwidth: Output<String>?
        get() = javaResource.bandwidth().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The subnet mask of the contiguous EIP group. Valid values:
     */
    public val eipMask: Output<String>
        get() = javaResource.eipMask().applyValue({ args0 -> args0 })

    /**
     * The metering method of the contiguous EIP group. Valid values:
     * - `PayByBandwidth` (default)
     * - `PayByTraffic`
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    public val isp: Output<String>?
        get() = javaResource.isp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The network type. Set the value to `public`, which specifies the public network type.
     */
    public val netmode: Output<String>?
        get() = javaResource.netmode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource group ID.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the contiguous Elastic IP address group.
     */
    public val segmentAddressName: Output<String>
        get() = javaResource.segmentAddressName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The zone of the contiguous EIP group.
     */
    public val zone: Output<String>
        get() = javaResource.zone().applyValue({ args0 -> args0 })
}

public object EipSegmentAddressMapper : ResourceMapper<EipSegmentAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.EipSegmentAddress::class == javaResource::class

    override fun map(javaResource: Resource): EipSegmentAddress = EipSegmentAddress(
        javaResource as
            com.pulumi.alicloud.ecs.EipSegmentAddress,
    )
}

/**
 * @see [EipSegmentAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EipSegmentAddress].
 */
public suspend fun eipSegmentAddress(
    name: String,
    block: suspend EipSegmentAddressResourceBuilder.() -> Unit,
): EipSegmentAddress {
    val builder = EipSegmentAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EipSegmentAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eipSegmentAddress(name: String): EipSegmentAddress {
    val builder = EipSegmentAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
