@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.EipSegmentAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a EIP Segment Address resource.
 * For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).
 * > **NOTE:** Available since v1.207.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ecs.EipSegmentAddress("default", {
 *     eipMask: "28",
 *     bandwidth: "5",
 *     isp: "BGP",
 *     internetChargeType: "PayByBandwidth",
 *     netmode: "public",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ecs.EipSegmentAddress("default",
 *     eip_mask="28",
 *     bandwidth="5",
 *     isp="BGP",
 *     internet_charge_type="PayByBandwidth",
 *     netmode="public")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ecs.EipSegmentAddress("default", new()
 *     {
 *         EipMask = "28",
 *         Bandwidth = "5",
 *         Isp = "BGP",
 *         InternetChargeType = "PayByBandwidth",
 *         Netmode = "public",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEipSegmentAddress(ctx, "default", &ecs.EipSegmentAddressArgs{
 * 			EipMask:            pulumi.String("28"),
 * 			Bandwidth:          pulumi.String("5"),
 * 			Isp:                pulumi.String("BGP"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 			Netmode:            pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EipSegmentAddress;
 * import com.pulumi.alicloud.ecs.EipSegmentAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new EipSegmentAddress("default", EipSegmentAddressArgs.builder()
 *             .eipMask("28")
 *             .bandwidth("5")
 *             .isp("BGP")
 *             .internetChargeType("PayByBandwidth")
 *             .netmode("public")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ecs:EipSegmentAddress
 *     properties:
 *       eipMask: '28'
 *       bandwidth: '5'
 *       isp: BGP
 *       internetChargeType: PayByBandwidth
 *       netmode: public
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EIP Segment Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
 * ```
 * @property bandwidth The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
 * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
 * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
 * - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
 * Default value: `5`. Unit: Mbit/s.
 * @property eipMask The subnet mask of the contiguous EIP group. Valid values:
 * @property internetChargeType The metering method of the contiguous EIP group. Valid values:
 * - `PayByBandwidth` (default)
 * - `PayByTraffic`
 * @property isp The line type. Valid values:
 * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
 * - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
 * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
 * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
 * - `ChinaTelecom`
 * - `ChinaUnicom`
 * - `ChinaMobile`
 * - `ChinaTelecom_L2`
 * - `ChinaUnicom_L2`
 * - `ChinaMobile_L2`
 * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
 * @property netmode The network type. Set the value to `public`, which specifies the public network type.
 * @property resourceGroupId The resource group ID.
 * @property zone The zone of the contiguous EIP group.
 */
public data class EipSegmentAddressArgs(
    public val bandwidth: Output<String>? = null,
    public val eipMask: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val isp: Output<String>? = null,
    public val netmode: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val zone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.EipSegmentAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.EipSegmentAddressArgs =
        com.pulumi.alicloud.ecs.EipSegmentAddressArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .eipMask(eipMask?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .isp(isp?.applyValue({ args0 -> args0 }))
            .netmode(netmode?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipSegmentAddressArgs].
 */
@PulumiTagMarker
public class EipSegmentAddressArgsBuilder internal constructor() {
    private var bandwidth: Output<String>? = null

    private var eipMask: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var isp: Output<String>? = null

    private var netmode: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var zone: Output<String>? = null

    /**
     * @param value The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
     * - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
     * Default value: `5`. Unit: Mbit/s.
     */
    @JvmName("ejrfisbpbqsbxkux")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The subnet mask of the contiguous EIP group. Valid values:
     */
    @JvmName("rnijefbldyhxcutg")
    public suspend fun eipMask(`value`: Output<String>) {
        this.eipMask = value
    }

    /**
     * @param value The metering method of the contiguous EIP group. Valid values:
     * - `PayByBandwidth` (default)
     * - `PayByTraffic`
     */
    @JvmName("nvkpyxdviskddytn")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    @JvmName("hjmgfojwdjdinjpe")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value The network type. Set the value to `public`, which specifies the public network type.
     */
    @JvmName("mknmygxliuijmwrb")
    public suspend fun netmode(`value`: Output<String>) {
        this.netmode = value
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("dvvwobryhxnqwplp")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The zone of the contiguous EIP group.
     */
    @JvmName("bahbjkjfyjqoyfyv")
    public suspend fun zone(`value`: Output<String>) {
        this.zone = value
    }

    /**
     * @param value The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
     * - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
     * - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
     * Default value: `5`. Unit: Mbit/s.
     */
    @JvmName("mrqndjgfyatdmcgq")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The subnet mask of the contiguous EIP group. Valid values:
     */
    @JvmName("kphcromjgserosjm")
    public suspend fun eipMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipMask = mapped
    }

    /**
     * @param value The metering method of the contiguous EIP group. Valid values:
     * - `PayByBandwidth` (default)
     * - `PayByTraffic`
     */
    @JvmName("gyrudeqfswqldcfy")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
     * - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
     */
    @JvmName("bsqegsxasgjnbgxx")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value The network type. Set the value to `public`, which specifies the public network type.
     */
    @JvmName("napyxmkuvtlmwcgv")
    public suspend fun netmode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmode = mapped
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("nrrblfdmuerdnfnm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The zone of the contiguous EIP group.
     */
    @JvmName("yscwmplaekhojjol")
    public suspend fun zone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): EipSegmentAddressArgs = EipSegmentAddressArgs(
        bandwidth = bandwidth,
        eipMask = eipMask,
        internetChargeType = internetChargeType,
        isp = isp,
        netmode = netmode,
        resourceGroupId = resourceGroupId,
        zone = zone,
    )
}
