@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ElasticityAssurance].
 */
@PulumiTagMarker
public class ElasticityAssuranceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ElasticityAssuranceArgs = ElasticityAssuranceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ElasticityAssuranceArgsBuilder.() -> Unit) {
        val builder = ElasticityAssuranceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ElasticityAssurance {
        val builtJavaResource = com.pulumi.alicloud.ecs.ElasticityAssurance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ElasticityAssurance(builtJavaResource)
    }
}

/**
 * Provides a Ecs Elasticity Assurance resource.
 * For information about Ecs Elasticity Assurance and how to use it, see [What is Elasticity Assurance](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createelasticityassurance).
 * > **NOTE:** Available in v1.196.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.c6",
 * });
 * const defaultElasticityAssurance = new alicloud.ecs.ElasticityAssurance("default", {
 *     instanceAmount: 1,
 *     description: "before",
 *     zoneIds: [defaultGetZones&#46;then(defaultGetZones => defaultGetZones&#46;zones?&#46;[2]?&#46;id)],
 *     privatePoolOptionsName: "test_before",
 *     period: 1,
 *     privatePoolOptionsMatchCriteria: "Open",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     periodUnit: "Month",
 *     assuranceTimes: "Unlimited",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_get_zones = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.c6")
 * default_elasticity_assurance = alicloud.ecs.ElasticityAssurance("default",
 *     instance_amount=1,
 *     description="before",
 *     zone_ids=[default_get_zones&#46;zones[2]&#46;id],
 *     private_pool_options_name="test_before",
 *     period=1,
 *     private_pool_options_match_criteria="Open",
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     period_unit="Month",
 *     assurance_times="Unlimited",
 *     resource_group_id=default.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.c6",
 *     });
 *     var defaultElasticityAssurance = new AliCloud.Ecs.ElasticityAssurance("default", new()
 *     {
 *         InstanceAmount = 1,
 *         Description = "before",
 *         ZoneIds = new[]
 *         {
 *             defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[2]?.Id),
 *         },
 *         PrivatePoolOptionsName = "test_before",
 *         Period = 1,
 *         PrivatePoolOptionsMatchCriteria = "Open",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         PeriodUnit = "Month",
 *         AssuranceTimes = "Unlimited",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.c6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewElasticityAssurance(ctx, "default", &ecs.ElasticityAssuranceArgs{
 * 			InstanceAmount: pulumi.Int(1),
 * 			Description:    pulumi.String("before"),
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetZones.Zones[2].Id),
 * 			},
 * 			PrivatePoolOptionsName:          pulumi.String("test_before"),
 * 			Period:                          pulumi.Int(1),
 * 			PrivatePoolOptionsMatchCriteria: pulumi.String("Open"),
 * 			InstanceType:                    pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			PeriodUnit:                      pulumi.String("Month"),
 * 			AssuranceTimes:                  pulumi.String("Unlimited"),
 * 			ResourceGroupId:                 pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.ElasticityAssurance;
 * import com.pulumi.alicloud.ecs.ElasticityAssuranceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.c6")
 *             .build());
 *         var defaultElasticityAssurance = new ElasticityAssurance("defaultElasticityAssurance", ElasticityAssuranceArgs.builder()
 *             .instanceAmount(1)
 *             .description("before")
 *             .zoneIds(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[2].id()))
 *             .privatePoolOptionsName("test_before")
 *             .period(1)
 *             .privatePoolOptionsMatchCriteria("Open")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .periodUnit("Month")
 *             .assuranceTimes("Unlimited")
 *             .resourceGroupId(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultElasticityAssurance:
 *     type: alicloud:ecs:ElasticityAssurance
 *     name: default
 *     properties:
 *       instanceAmount: 1
 *       description: before
 *       zoneIds:
 *         - ${defaultGetZones.zones[2].id}
 *       privatePoolOptionsName: test_before
 *       period: 1
 *       privatePoolOptionsMatchCriteria: Open
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       periodUnit: Month
 *       assuranceTimes: Unlimited
 *       resourceGroupId: ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.c6
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Elasticity Assurance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/elasticityAssurance:ElasticityAssurance example <id>
 * ```
 */
public class ElasticityAssurance internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.ElasticityAssurance,
) : KotlinCustomResource(javaResource, ElasticityAssuranceMapper) {
    /**
     * The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
     */
    public val assuranceTimes: Output<String>
        get() = javaResource.assuranceTimes().applyValue({ args0 -> args0 })

    /**
     * Description of flexible guarantee service.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The first ID of the resource
     */
    public val elasticityAssuranceId: Output<String>
        get() = javaResource.elasticityAssuranceId().applyValue({ args0 -> args0 })

    /**
     * Flexible guarantee service failure time.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
     */
    public val instanceAmount: Output<Int>
        get() = javaResource.instanceAmount().applyValue({ args0 -> args0 })

    /**
     * The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * Instance type. Currently, only one instance type is supported.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
     * - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
     */
    public val privatePoolOptionsMatchCriteria: Output<String>
        get() = javaResource.privatePoolOptionsMatchCriteria().applyValue({ args0 -> args0 })

    /**
     * The name of the flexible protection service.
     */
    public val privatePoolOptionsName: Output<String>
        get() = javaResource.privatePoolOptionsName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flexible guarantee service effective time.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
     */
    public val startTimeType: Output<String>
        get() = javaResource.startTimeType().applyValue({ args0 -> args0 })

    /**
     * The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag key-value pair information bound by the elastic guarantee service.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * This parameter is not yet available.
     */
    public val usedAssuranceTimes: Output<Int>
        get() = javaResource.usedAssuranceTimes().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
     */
    public val zoneIds: Output<List<String>>
        get() = javaResource.zoneIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ElasticityAssuranceMapper : ResourceMapper<ElasticityAssurance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.ElasticityAssurance::class == javaResource::class

    override fun map(javaResource: Resource): ElasticityAssurance = ElasticityAssurance(
        javaResource
            as com.pulumi.alicloud.ecs.ElasticityAssurance,
    )
}

/**
 * @see [ElasticityAssurance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ElasticityAssurance].
 */
public suspend fun elasticityAssurance(
    name: String,
    block: suspend ElasticityAssuranceResourceBuilder.() -> Unit,
): ElasticityAssurance {
    val builder = ElasticityAssuranceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ElasticityAssurance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun elasticityAssurance(name: String): ElasticityAssurance {
    val builder = ElasticityAssuranceResourceBuilder()
    builder.name(name)
    return builder.build()
}
