@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.ElasticityAssuranceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Ecs Elasticity Assurance resource.
 * For information about Ecs Elasticity Assurance and how to use it, see [What is Elasticity Assurance](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createelasticityassurance).
 * > **NOTE:** Available in v1.196.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.c6",
 * });
 * const defaultElasticityAssurance = new alicloud.ecs.ElasticityAssurance("default", {
 *     instanceAmount: 1,
 *     description: "before",
 *     zoneIds: [defaultGetZones&#46;then(defaultGetZones => defaultGetZones&#46;zones?&#46;[2]?&#46;id)],
 *     privatePoolOptionsName: "test_before",
 *     period: 1,
 *     privatePoolOptionsMatchCriteria: "Open",
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     periodUnit: "Month",
 *     assuranceTimes: "Unlimited",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_get_zones = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.c6")
 * default_elasticity_assurance = alicloud.ecs.ElasticityAssurance("default",
 *     instance_amount=1,
 *     description="before",
 *     zone_ids=[default_get_zones&#46;zones[2]&#46;id],
 *     private_pool_options_name="test_before",
 *     period=1,
 *     private_pool_options_match_criteria="Open",
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     period_unit="Month",
 *     assurance_times="Unlimited",
 *     resource_group_id=default.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.c6",
 *     });
 *     var defaultElasticityAssurance = new AliCloud.Ecs.ElasticityAssurance("default", new()
 *     {
 *         InstanceAmount = 1,
 *         Description = "before",
 *         ZoneIds = new[]
 *         {
 *             defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[2]?.Id),
 *         },
 *         PrivatePoolOptionsName = "test_before",
 *         Period = 1,
 *         PrivatePoolOptionsMatchCriteria = "Open",
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         PeriodUnit = "Month",
 *         AssuranceTimes = "Unlimited",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.c6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewElasticityAssurance(ctx, "default", &ecs.ElasticityAssuranceArgs{
 * 			InstanceAmount: pulumi.Int(1),
 * 			Description:    pulumi.String("before"),
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetZones.Zones[2].Id),
 * 			},
 * 			PrivatePoolOptionsName:          pulumi.String("test_before"),
 * 			Period:                          pulumi.Int(1),
 * 			PrivatePoolOptionsMatchCriteria: pulumi.String("Open"),
 * 			InstanceType:                    pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			PeriodUnit:                      pulumi.String("Month"),
 * 			AssuranceTimes:                  pulumi.String("Unlimited"),
 * 			ResourceGroupId:                 pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.ElasticityAssurance;
 * import com.pulumi.alicloud.ecs.ElasticityAssuranceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.c6")
 *             .build());
 *         var defaultElasticityAssurance = new ElasticityAssurance("defaultElasticityAssurance", ElasticityAssuranceArgs.builder()
 *             .instanceAmount(1)
 *             .description("before")
 *             .zoneIds(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[2].id()))
 *             .privatePoolOptionsName("test_before")
 *             .period(1)
 *             .privatePoolOptionsMatchCriteria("Open")
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .periodUnit("Month")
 *             .assuranceTimes("Unlimited")
 *             .resourceGroupId(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultElasticityAssurance:
 *     type: alicloud:ecs:ElasticityAssurance
 *     name: default
 *     properties:
 *       instanceAmount: 1
 *       description: before
 *       zoneIds:
 *         - ${defaultGetZones.zones[2].id}
 *       privatePoolOptionsName: test_before
 *       period: 1
 *       privatePoolOptionsMatchCriteria: Open
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       periodUnit: Month
 *       assuranceTimes: Unlimited
 *       resourceGroupId: ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.c6
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ecs Elasticity Assurance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/elasticityAssurance:ElasticityAssurance example <id>
 * ```
 * @property assuranceTimes The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
 * @property description Description of flexible guarantee service.
 * @property instanceAmount The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
 * @property instanceType Instance type. Currently, only one instance type is supported.
 * @property period Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
 * - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
 * - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
 * @property periodUnit Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
 * @property privatePoolOptionsMatchCriteria The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
 * @property privatePoolOptionsName The name of the flexible protection service.
 * @property resourceGroupId The ID of the resource group.
 * @property startTime Flexible guarantee service effective time.
 * @property tags The tag key-value pair information bound by the elastic guarantee service.
 * @property zoneIds The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
 */
public data class ElasticityAssuranceArgs(
    public val assuranceTimes: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceAmount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val privatePoolOptionsMatchCriteria: Output<String>? = null,
    public val privatePoolOptionsName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.ElasticityAssuranceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.ElasticityAssuranceArgs =
        com.pulumi.alicloud.ecs.ElasticityAssuranceArgs.builder()
            .assuranceTimes(assuranceTimes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceAmount(instanceAmount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .privatePoolOptionsMatchCriteria(privatePoolOptionsMatchCriteria?.applyValue({ args0 -> args0 }))
            .privatePoolOptionsName(privatePoolOptionsName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneIds(zoneIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ElasticityAssuranceArgs].
 */
@PulumiTagMarker
public class ElasticityAssuranceArgsBuilder internal constructor() {
    private var assuranceTimes: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceAmount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var privatePoolOptionsMatchCriteria: Output<String>? = null

    private var privatePoolOptionsName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var startTime: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneIds: Output<List<String>>? = null

    /**
     * @param value The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
     */
    @JvmName("cfptsuyxecukcben")
    public suspend fun assuranceTimes(`value`: Output<String>) {
        this.assuranceTimes = value
    }

    /**
     * @param value Description of flexible guarantee service.
     */
    @JvmName("tghuvfulncyprmuw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
     */
    @JvmName("fawqcevtcaavqeff")
    public suspend fun instanceAmount(`value`: Output<Int>) {
        this.instanceAmount = value
    }

    /**
     * @param value Instance type. Currently, only one instance type is supported.
     */
    @JvmName("anqvxkqbquhgurgt")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
     * - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
     */
    @JvmName("hlvijrblwpcwfdyr")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
     */
    @JvmName("yqnxhjrdvepplbyd")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
     */
    @JvmName("kdjtuldokkevhegk")
    public suspend fun privatePoolOptionsMatchCriteria(`value`: Output<String>) {
        this.privatePoolOptionsMatchCriteria = value
    }

    /**
     * @param value The name of the flexible protection service.
     */
    @JvmName("canwfsylvypehqqx")
    public suspend fun privatePoolOptionsName(`value`: Output<String>) {
        this.privatePoolOptionsName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("gsvhsvdsknxhdwim")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Flexible guarantee service effective time.
     */
    @JvmName("qvkqvqjqcompinpu")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The tag key-value pair information bound by the elastic guarantee service.
     */
    @JvmName("dkfrvwxmepwcaggt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
     */
    @JvmName("gyalhrtyyyabxiev")
    public suspend fun zoneIds(`value`: Output<List<String>>) {
        this.zoneIds = value
    }

    @JvmName("dtovwdwpdawpmota")
    public suspend fun zoneIds(vararg values: Output<String>) {
        this.zoneIds = Output.all(values.asList())
    }

    /**
     * @param values The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
     */
    @JvmName("yshohssjexgyqcso")
    public suspend fun zoneIds(values: List<Output<String>>) {
        this.zoneIds = Output.all(values)
    }

    /**
     * @param value The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
     */
    @JvmName("cqlhahnpwmvfscbj")
    public suspend fun assuranceTimes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assuranceTimes = mapped
    }

    /**
     * @param value Description of flexible guarantee service.
     */
    @JvmName("xpxdbumijenlgprc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
     */
    @JvmName("mbraiagvvohpscup")
    public suspend fun instanceAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAmount = mapped
    }

    /**
     * @param value Instance type. Currently, only one instance type is supported.
     */
    @JvmName("pgmrgpwkbrhexfyj")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
     * - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
     */
    @JvmName("ihowwaogkwohcixy")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
     */
    @JvmName("vswyxlfseppjgnil")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
     */
    @JvmName("qiejbrvqmruqpopv")
    public suspend fun privatePoolOptionsMatchCriteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatePoolOptionsMatchCriteria = mapped
    }

    /**
     * @param value The name of the flexible protection service.
     */
    @JvmName("ckijirmwjtthqerk")
    public suspend fun privatePoolOptionsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatePoolOptionsName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("wtkycbagpussdbaj")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Flexible guarantee service effective time.
     */
    @JvmName("lflbujstopynaqkt")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The tag key-value pair information bound by the elastic guarantee service.
     */
    @JvmName("afhfxfdtgsobdosh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag key-value pair information bound by the elastic guarantee service.
     */
    @JvmName("qxufhtvknqojbcic")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
     */
    @JvmName("tgrriwamxhjcgxhr")
    public suspend fun zoneIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    /**
     * @param values The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
     */
    @JvmName("bdrhyrqutmapetfa")
    public suspend fun zoneIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    internal fun build(): ElasticityAssuranceArgs = ElasticityAssuranceArgs(
        assuranceTimes = assuranceTimes,
        description = description,
        instanceAmount = instanceAmount,
        instanceType = instanceType,
        period = period,
        periodUnit = periodUnit,
        privatePoolOptionsMatchCriteria = privatePoolOptionsMatchCriteria,
        privatePoolOptionsName = privatePoolOptionsName,
        resourceGroupId = resourceGroupId,
        startTime = startTime,
        tags = tags,
        zoneIds = zoneIds,
    )
}
