@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HpcCluster].
 */
@PulumiTagMarker
public class HpcClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HpcClusterArgs = HpcClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HpcClusterArgsBuilder.() -> Unit) {
        val builder = HpcClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HpcCluster {
        val builtJavaResource = com.pulumi.alicloud.ecs.HpcCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HpcCluster(builtJavaResource)
    }
}

/**
 * Provides a ECS Hpc Cluster resource.
 * For information about ECS Hpc Cluster and how to use it, see [What is Hpc Cluster](https://www.alibabacloud.com/help/en/doc-detail/109138.htm).
 * > **NOTE:** Available in v1.116.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.HpcCluster("example", {
 *     name: "tf-testAcc",
 *     description: "For Terraform Test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.HpcCluster("example",
 *     name="tf-testAcc",
 *     description="For Terraform Test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.HpcCluster("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         Description = "For Terraform Test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewHpcCluster(ctx, "example", &ecs.HpcClusterArgs{
 * 			Name:        pulumi.String("tf-testAcc"),
 * 			Description: pulumi.String("For Terraform Test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.HpcCluster;
 * import com.pulumi.alicloud.ecs.HpcClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HpcCluster("example", HpcClusterArgs.builder()
 *             .name("tf-testAcc")
 *             .description("For Terraform Test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:HpcCluster
 *     properties:
 *       name: tf-testAcc
 *       description: For Terraform Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Hpc Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/hpcCluster:HpcCluster example <id>
 * ```
 */
public class HpcCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.HpcCluster,
) : KotlinCustomResource(javaResource, HpcClusterMapper) {
    /**
     * The description of ECS Hpc Cluster.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of ECS Hpc Cluster.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object HpcClusterMapper : ResourceMapper<HpcCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.HpcCluster::class == javaResource::class

    override fun map(javaResource: Resource): HpcCluster = HpcCluster(
        javaResource as
            com.pulumi.alicloud.ecs.HpcCluster,
    )
}

/**
 * @see [HpcCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HpcCluster].
 */
public suspend fun hpcCluster(name: String, block: suspend HpcClusterResourceBuilder.() -> Unit): HpcCluster {
    val builder = HpcClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HpcCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hpcCluster(name: String): HpcCluster {
    val builder = HpcClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
