@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.HpcClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Hpc Cluster resource.
 * For information about ECS Hpc Cluster and how to use it, see [What is Hpc Cluster](https://www.alibabacloud.com/help/en/doc-detail/109138.htm).
 * > **NOTE:** Available in v1.116.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ecs.HpcCluster("example", {
 *     name: "tf-testAcc",
 *     description: "For Terraform Test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ecs.HpcCluster("example",
 *     name="tf-testAcc",
 *     description="For Terraform Test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ecs.HpcCluster("example", new()
 *     {
 *         Name = "tf-testAcc",
 *         Description = "For Terraform Test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewHpcCluster(ctx, "example", &ecs.HpcClusterArgs{
 * 			Name:        pulumi.String("tf-testAcc"),
 * 			Description: pulumi.String("For Terraform Test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.HpcCluster;
 * import com.pulumi.alicloud.ecs.HpcClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HpcCluster("example", HpcClusterArgs.builder()
 *             .name("tf-testAcc")
 *             .description("For Terraform Test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ecs:HpcCluster
 *     properties:
 *       name: tf-testAcc
 *       description: For Terraform Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Hpc Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/hpcCluster:HpcCluster example <id>
 * ```
 * @property description The description of ECS Hpc Cluster.
 * @property name The name of ECS Hpc Cluster.
 */
public data class HpcClusterArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.HpcClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.HpcClusterArgs =
        com.pulumi.alicloud.ecs.HpcClusterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HpcClusterArgs].
 */
@PulumiTagMarker
public class HpcClusterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The description of ECS Hpc Cluster.
     */
    @JvmName("awhncnrpnyhlrxlo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of ECS Hpc Cluster.
     */
    @JvmName("hgkcdmgqfefnigtl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The description of ECS Hpc Cluster.
     */
    @JvmName("boejeoyorisnrhmf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of ECS Hpc Cluster.
     */
    @JvmName("dcdkejekveysrtwe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): HpcClusterArgs = HpcClusterArgs(
        description = description,
        name = name,
    )
}
