@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.ImageArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.ImageDiskDeviceMappingArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.ImageDiskDeviceMappingArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.ImageFeaturesArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.ImageFeaturesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS Image resource.
 * > **NOTE:**  If you want to create a template from an ECS instance, you can specify the instance ID (InstanceId) to create a custom image. You must make sure that the status of the specified instance is Running or Stopped. After a successful invocation, each disk of the specified instance has a new snapshot created.
 * > **NOTE:**  If you want to create a custom image based on the system disk of your ECS instance, you can specify one of the system disk snapshots (SnapshotId) to create a custom image. However, the specified snapshot cannot be created on or before July 15, 2013.
 * > **NOTE:**  If you want to combine snapshots of multiple disks into an image template, you can specify DiskDeviceMapping to create a custom image.
 * For information about ECS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ecs-2014-05-26-createimage).
 * > **NOTE:** Available since v1.64.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.sn1ne",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: "terraform-example",
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: "terraform-example",
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.ids?.[0]),
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.ids?.[0]),
 *     internetMaxBandwidthOut: 10,
 * });
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultImage = new alicloud.ecs.Image("default", {
 *     instanceId: defaultInstance.id,
 *     imageName: `terraform-example-${defaultInteger.result}`,
 *     description: "terraform-example",
 *     architecture: "x86_64",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     tags: {
 *         FinanceDept: "FinanceDeptJoshua",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.sn1ne")
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name="terraform-example",
 *     vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name="terraform-example",
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id,
 *     instance_type=default_get_instance_types.ids[0],
 *     image_id=default_get_images.ids[0],
 *     internet_max_bandwidth_out=10)
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_image = alicloud.ecs.Image("default",
 *     instance_id=default_instance.id,
 *     image_name=f"terraform-example-{default_integer['result']}",
 *     description="terraform-example",
 *     architecture="x86_64",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     tags={
 *         "FinanceDept": "FinanceDeptJoshua",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.sn1ne",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = "terraform-example",
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.Ids[0]),
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Ids[0]),
 *         InternetMaxBandwidthOut = 10,
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultImage = new AliCloud.Ecs.Image("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         ImageName = $"terraform-example-{defaultInteger.Result}",
 *         Description = "terraform-example",
 *         Architecture = "x86_64",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         Tags =
 *         {
 *             { "FinanceDept", "FinanceDeptJoshua" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.sn1ne"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String("terraform-example"),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId:               defaultSwitch.ID(),
 * 			InstanceType:            pulumi.String(defaultGetInstanceTypes.Ids[0]),
 * 			ImageId:                 pulumi.String(defaultGetImages.Ids[0]),
 * 			InternetMaxBandwidthOut: pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewImage(ctx, "default", &ecs.ImageArgs{
 * 			InstanceId:      defaultInstance.ID(),
 * 			ImageName:       pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 			Description:     pulumi.String("terraform-example"),
 * 			Architecture:    pulumi.String("x86_64"),
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			Tags: pulumi.StringMap{
 * 				"FinanceDept": pulumi.String("FinanceDeptJoshua"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ecs.Image;
 * import com.pulumi.alicloud.ecs.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.sn1ne")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName("terraform-example")
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.ids()[0]))
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.ids()[0]))
 *             .internetMaxBandwidthOut(10)
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultImage = new Image("defaultImage", ImageArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .imageName(String.format("terraform-example-%s", defaultInteger.result()))
 *             .description("terraform-example")
 *             .architecture("x86_64")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .tags(Map.of("FinanceDept", "FinanceDeptJoshua"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: terraform-example
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: terraform-example
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *       instanceType: ${defaultGetInstanceTypes.ids[0]}
 *       imageId: ${defaultGetImages.ids[0]}
 *       internetMaxBandwidthOut: 10
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultImage:
 *     type: alicloud:ecs:Image
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       imageName: terraform-example-${defaultInteger.result}
 *       description: terraform-example
 *       architecture: x86_64
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 *       tags:
 *         FinanceDept: FinanceDeptJoshua
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.sn1ne
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Image can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/image:Image example <id>
 * ```
 * @property architecture The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\_64`, `arm64`. Default value: `x86\_64`.
 * @property bootMode The new boot mode of the image. Valid values:
 * *   BIOS: Basic Input/Output System (BIOS)
 * *   UEFI: Unified Extensible Firmware Interface (UEFI)
 * *   UEFI-Preferred: BIOS and UEFI
 * > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
 * > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
 * @property deleteAutoSnapshot Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
 * @property description The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
 * @property detectionStrategy The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
 * > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www&#46;alibabacloud&#46;com/help/en/doc-detail/439819&#46;html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
 * @property diskDeviceMappings Snapshot information for the image See `disk_device_mapping` below.
 * @property features Features See `features` below.
 * @property force Whether to perform forced deletion. Value range:
 * - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
 * - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
 * Default value: false
 * @property imageFamily The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty.
 * @property imageName The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
 * @property imageVersion The image version.
 * > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
 * @property instanceId The instance ID.
 * @property licenseType The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
 * @property name . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
 * @property platform The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
 * @property resourceGroupId The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
 * > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
 * @property snapshotId The ID of the snapshot that you want to use to create the custom image.
 * @property tags The tag
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class ImageArgs(
    public val architecture: Output<String>? = null,
    public val bootMode: Output<String>? = null,
    public val deleteAutoSnapshot: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val detectionStrategy: Output<String>? = null,
    public val diskDeviceMappings: Output<List<ImageDiskDeviceMappingArgs>>? = null,
    public val features: Output<ImageFeaturesArgs>? = null,
    public val force: Output<Boolean>? = null,
    public val imageFamily: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val imageVersion: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val licenseType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.ImageArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.ImageArgs =
        com.pulumi.alicloud.ecs.ImageArgs.builder()
            .architecture(architecture?.applyValue({ args0 -> args0 }))
            .bootMode(bootMode?.applyValue({ args0 -> args0 }))
            .deleteAutoSnapshot(deleteAutoSnapshot?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .detectionStrategy(detectionStrategy?.applyValue({ args0 -> args0 }))
            .diskDeviceMappings(
                diskDeviceMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .features(features?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .force(force?.applyValue({ args0 -> args0 }))
            .imageFamily(imageFamily?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .imageVersion(imageVersion?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var architecture: Output<String>? = null

    private var bootMode: Output<String>? = null

    private var deleteAutoSnapshot: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var detectionStrategy: Output<String>? = null

    private var diskDeviceMappings: Output<List<ImageDiskDeviceMappingArgs>>? = null

    private var features: Output<ImageFeaturesArgs>? = null

    private var force: Output<Boolean>? = null

    private var imageFamily: Output<String>? = null

    private var imageName: Output<String>? = null

    private var imageVersion: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var licenseType: Output<String>? = null

    private var name: Output<String>? = null

    private var platform: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\_64`, `arm64`. Default value: `x86\_64`.
     */
    @JvmName("lbqfopjruorbhhsl")
    public suspend fun architecture(`value`: Output<String>) {
        this.architecture = value
    }

    /**
     * @param value The new boot mode of the image. Valid values:
     * *   BIOS: Basic Input/Output System (BIOS)
     * *   UEFI: Unified Extensible Firmware Interface (UEFI)
     * *   UEFI-Preferred: BIOS and UEFI
     * > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
     * > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
     */
    @JvmName("xmkaalncgmbubiic")
    public suspend fun bootMode(`value`: Output<String>) {
        this.bootMode = value
    }

    /**
     * @param value Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
     */
    @JvmName("ctvicyxufmddmrid")
    public suspend fun deleteAutoSnapshot(`value`: Output<Boolean>) {
        this.deleteAutoSnapshot = value
    }

    /**
     * @param value The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
     */
    @JvmName("qraakjximguaaecc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
     * > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www&#46;alibabacloud&#46;com/help/en/doc-detail/439819&#46;html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
     */
    @JvmName("irexxaucsrmxjsgh")
    public suspend fun detectionStrategy(`value`: Output<String>) {
        this.detectionStrategy = value
    }

    /**
     * @param value Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("jvwytgadsftgqcnp")
    public suspend fun diskDeviceMappings(`value`: Output<List<ImageDiskDeviceMappingArgs>>) {
        this.diskDeviceMappings = value
    }

    @JvmName("pukockhvensbujnd")
    public suspend fun diskDeviceMappings(vararg values: Output<ImageDiskDeviceMappingArgs>) {
        this.diskDeviceMappings = Output.all(values.asList())
    }

    /**
     * @param values Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("bxotottawgpgynfl")
    public suspend fun diskDeviceMappings(values: List<Output<ImageDiskDeviceMappingArgs>>) {
        this.diskDeviceMappings = Output.all(values)
    }

    /**
     * @param value Features See `features` below.
     */
    @JvmName("koxvxpabtphbhbxe")
    public suspend fun features(`value`: Output<ImageFeaturesArgs>) {
        this.features = value
    }

    /**
     * @param value Whether to perform forced deletion. Value range:
     * - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
     * - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
     * Default value: false
     */
    @JvmName("oeqdxjhdiiypmlvd")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty.
     */
    @JvmName("iygkwnawkuekmdcu")
    public suspend fun imageFamily(`value`: Output<String>) {
        this.imageFamily = value
    }

    /**
     * @param value The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
     */
    @JvmName("osnthokbrygorpgl")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The image version.
     * > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
     */
    @JvmName("yqcnhldgelpbawbv")
    public suspend fun imageVersion(`value`: Output<String>) {
        this.imageVersion = value
    }

    /**
     * @param value The instance ID.
     */
    @JvmName("jphekxbpjafxyogu")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
     */
    @JvmName("ddcmebmhckbwxhxn")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.
  """,
    )
    @JvmName("bxutdvoktgkplvtu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
     */
    @JvmName("tfcjjtjdwghxdbfr")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
     * > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
     */
    @JvmName("kwlwxgytjbimddcy")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the snapshot that you want to use to create the custom image.
     */
    @JvmName("xdurwwhuqvwmdmvo")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The tag
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("eabyxajoobjbmuwc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\_64`, `arm64`. Default value: `x86\_64`.
     */
    @JvmName("ysrelwulwvjnxawx")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The new boot mode of the image. Valid values:
     * *   BIOS: Basic Input/Output System (BIOS)
     * *   UEFI: Unified Extensible Firmware Interface (UEFI)
     * *   UEFI-Preferred: BIOS and UEFI
     * > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
     * > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
     */
    @JvmName("tqghouxudovujita")
    public suspend fun bootMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootMode = mapped
    }

    /**
     * @param value Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
     */
    @JvmName("uadnqufoxtmgyeci")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
     */
    @JvmName("hahhmndbdypwxgvf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
     * > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www&#46;alibabacloud&#46;com/help/en/doc-detail/439819&#46;html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
     */
    @JvmName("evorxjrllyxyyhpd")
    public suspend fun detectionStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectionStrategy = mapped
    }

    /**
     * @param value Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("uttmkpshvbmbimkf")
    public suspend fun diskDeviceMappings(`value`: List<ImageDiskDeviceMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskDeviceMappings = mapped
    }

    /**
     * @param argument Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("btqesxoqrvwrkkvx")
    public suspend fun diskDeviceMappings(argument: List<suspend ImageDiskDeviceMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageDiskDeviceMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.diskDeviceMappings = mapped
    }

    /**
     * @param argument Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("deskelydoiemksup")
    public suspend fun diskDeviceMappings(vararg argument: suspend ImageDiskDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageDiskDeviceMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.diskDeviceMappings = mapped
    }

    /**
     * @param argument Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("nhwnkfushrgdfncc")
    public suspend fun diskDeviceMappings(argument: suspend ImageDiskDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageDiskDeviceMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.diskDeviceMappings = mapped
    }

    /**
     * @param values Snapshot information for the image See `disk_device_mapping` below.
     */
    @JvmName("gcdxetfgbveksdrp")
    public suspend fun diskDeviceMappings(vararg values: ImageDiskDeviceMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskDeviceMappings = mapped
    }

    /**
     * @param value Features See `features` below.
     */
    @JvmName("ayfmxhpndkctlewo")
    public suspend fun features(`value`: ImageFeaturesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument Features See `features` below.
     */
    @JvmName("luiglfavoplvnuht")
    public suspend fun features(argument: suspend ImageFeaturesArgsBuilder.() -> Unit) {
        val toBeMapped = ImageFeaturesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param value Whether to perform forced deletion. Value range:
     * - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
     * - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
     * Default value: false
     */
    @JvmName("hphmmpsjxoyftjmu")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty.
     */
    @JvmName("ddjyxbndnwxdqvpg")
    public suspend fun imageFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageFamily = mapped
    }

    /**
     * @param value The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
     */
    @JvmName("yebmedbfqlyhbqgg")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The image version.
     * > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
     */
    @JvmName("vkihuurkevgefbys")
    public suspend fun imageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageVersion = mapped
    }

    /**
     * @param value The instance ID.
     */
    @JvmName("ptgjfrnmfmhllmkv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
     */
    @JvmName("lhydcfddacrhoprr")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.
  """,
    )
    @JvmName("hmcyvmhmpqeatmvs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
     */
    @JvmName("hqcryprhcnjjjxig")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
     * > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
     */
    @JvmName("fohldvaxiajudebp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the snapshot that you want to use to create the custom image.
     */
    @JvmName("fxdtsnpxlqgaxlfm")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The tag
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("bnwrluljtfbaeugy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("fnwmkssearputoda")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        architecture = architecture,
        bootMode = bootMode,
        deleteAutoSnapshot = deleteAutoSnapshot,
        description = description,
        detectionStrategy = detectionStrategy,
        diskDeviceMappings = diskDeviceMappings,
        features = features,
        force = force,
        imageFamily = imageFamily,
        imageName = imageName,
        imageVersion = imageVersion,
        instanceId = instanceId,
        licenseType = licenseType,
        name = name,
        platform = platform,
        resourceGroupId = resourceGroupId,
        snapshotId = snapshotId,
        tags = tags,
    )
}
