@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceDataDisk
import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceMaintenanceTime
import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceNetworkInterfaces
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceDataDisk.Companion.toKotlin as instanceDataDiskToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceMaintenanceTime.Companion.toKotlin as instanceMaintenanceTimeToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.InstanceNetworkInterfaces.Companion.toKotlin as instanceNetworkInterfacesToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.ecs.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a ECS instance resource.
 * > **NOTE:** Available since v1.0.0
 * > **NOTE:** From version v1.213.0, you can specify `launch_template_id` and `launch_template_version` to use a launch template. This eliminates the need to configure a large number of parameters every time you create instances.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const instanceType = config.get("instanceType") || "ecs.n4.large";
 * const imageId = config.get("imageId") || "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 * // Create a new ECS instance for VPC
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * // Create a new ECS instance for a VPC
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: name,
 *     description: "foo",
 *     vpcId: vpc.id,
 * });
 * const key = new alicloud.kms.Key("key", {
 *     description: "Hello KMS",
 *     pendingWindowInDays: 7,
 *     status: "Enabled",
 * });
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 *     availableInstanceType: instanceType,
 * });
 * const vswitch = new alicloud.vpc.Switch("vswitch", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const instance = new alicloud.ecs.Instance("instance", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     securityGroups: [group].map(__item => __item.id),
 *     instanceType: instanceType,
 *     systemDiskCategory: "cloud_efficiency",
 *     systemDiskName: name,
 *     systemDiskDescription: "test_foo_system_disk_description",
 *     imageId: imageId,
 *     instanceName: name,
 *     vswitchId: vswitch.id,
 *     internetMaxBandwidthOut: 10,
 *     dataDisks: [{
 *         name: "disk2",
 *         size: 20,
 *         category: "cloud_efficiency",
 *         description: "disk2",
 *         encrypted: true,
 *         kmsKeyId: key.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * instance_type = config.get("instanceType")
 * if instance_type is None:
 *     instance_type = "ecs.n4.large"
 * image_id = config.get("imageId")
 * if image_id is None:
 *     image_id = "ubuntu_18_04_64_20G_alibase_20190624.vhd"
 * # Create a new ECS instance for VPC
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * # Create a new ECS instance for a VPC
 * group = alicloud.ecs.SecurityGroup("group",
 *     name=name,
 *     description="foo",
 *     vpc_id=vpc.id)
 * key = alicloud.kms.Key("key",
 *     description="Hello KMS",
 *     pending_window_in_days=7,
 *     status="Enabled")
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch",
 *     available_instance_type=instance_type)
 * vswitch = alicloud.vpc.Switch("vswitch",
 *     vpc_id=vpc.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * instance = alicloud.ecs.Instance("instance",
 *     availability_zone=default.zones[0].id,
 *     security_groups=[__item&#46;id for __item in [group]],
 *     instance_type=instance_type,
 *     system_disk_category="cloud_efficiency",
 *     system_disk_name=name,
 *     system_disk_description="test_foo_system_disk_description",
 *     image_id=image_id,
 *     instance_name=name,
 *     vswitch_id=vswitch.id,
 *     internet_max_bandwidth_out=10,
 *     data_disks=[{
 *         "name": "disk2",
 *         "size": 20,
 *         "category": "cloud_efficiency",
 *         "description": "disk2",
 *         "encrypted": True,
 *         "kms_key_id": key.id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var instanceType = config.Get("instanceType") ?? "ecs.n4.large";
 *     var imageId = config.Get("imageId") ?? "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 *     // Create a new ECS instance for VPC
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     // Create a new ECS instance for a VPC
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = name,
 *         Description = "foo",
 *         VpcId = vpc.Id,
 *     });
 *     var key = new AliCloud.Kms.Key("key", new()
 *     {
 *         Description = "Hello KMS",
 *         PendingWindowInDays = 7,
 *         Status = "Enabled",
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *         AvailableInstanceType = instanceType,
 *     });
 *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var instance = new AliCloud.Ecs.Instance("instance", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         SecurityGroups = new[]
 *         {
 *             @group,
 *         }.Select(__item => __item.Id).ToList(),
 *         InstanceType = instanceType,
 *         SystemDiskCategory = "cloud_efficiency",
 *         SystemDiskName = name,
 *         SystemDiskDescription = "test_foo_system_disk_description",
 *         ImageId = imageId,
 *         InstanceName = name,
 *         VswitchId = vswitch.Id,
 *         InternetMaxBandwidthOut = 10,
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.InstanceDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Size = 20,
 *                 Category = "cloud_efficiency",
 *                 Description = "disk2",
 *                 Encrypted = true,
 *                 KmsKeyId = key.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "terraform-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * instanceType := "ecs.n4.large";
 * if param := cfg.Get("instanceType"); param != ""{
 * instanceType = param
 * }
 * imageId := "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 * if param := cfg.Get("imageId"); param != ""{
 * imageId = param
 * }
 * // Create a new ECS instance for VPC
 * vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * VpcName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.16.0.0/16"),
 * })
 * if err != nil {
 * return err
 * }
 * // Create a new ECS instance for a VPC
 * group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(name),
 * Description: pulumi.String("foo"),
 * VpcId: vpc.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
 * Description: pulumi.String("Hello KMS"),
 * PendingWindowInDays: pulumi.Int(7),
 * Status: pulumi.String("Enabled"),
 * })
 * if err != nil {
 * return err
 * }
 * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * AvailableInstanceType: pulumi.StringRef(instanceType),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
 * VpcId: vpc.ID(),
 * CidrBlock: pulumi.String("172.16.0.0/24"),
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * VswitchName: pulumi.String(name),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * _, err = ecs.NewInstance(ctx, "instance", &ecs.InstanceArgs{
 * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * SecurityGroups: splat0,
 * InstanceType: pulumi.String(instanceType),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * SystemDiskName: pulumi.String(name),
 * SystemDiskDescription: pulumi.String("test_foo_system_disk_description"),
 * ImageId: pulumi.String(imageId),
 * InstanceName: pulumi.String(name),
 * VswitchId: vswitch.ID(),
 * InternetMaxBandwidthOut: pulumi.Int(10),
 * DataDisks: ecs.InstanceDataDiskArray{
 * &ecs.InstanceDataDiskArgs{
 * Name: pulumi.String("disk2"),
 * Size: pulumi.Int(20),
 * Category: pulumi.String("cloud_efficiency"),
 * Description: pulumi.String("disk2"),
 * Encrypted: pulumi.Bool(true),
 * KmsKeyId: key.ID(),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var instanceType = config.get("instanceType").orElse("ecs.n4.large");
 *         final var imageId = config.get("imageId").orElse("ubuntu_18_04_64_20G_alibase_20190624.vhd");
 *         // Create a new ECS instance for VPC
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         // Create a new ECS instance for a VPC
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description("foo")
 *             .vpcId(vpc.id())
 *             .build());
 *         var key = new Key("key", KeyArgs.builder()
 *             .description("Hello KMS")
 *             .pendingWindowInDays("7")
 *             .status("Enabled")
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .availableInstanceType(instanceType)
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .securityGroups(group.stream().map(element -> element.id()).collect(toList()))
 *             .instanceType(instanceType)
 *             .systemDiskCategory("cloud_efficiency")
 *             .systemDiskName(name)
 *             .systemDiskDescription("test_foo_system_disk_description")
 *             .imageId(imageId)
 *             .instanceName(name)
 *             .vswitchId(vswitch.id())
 *             .internetMaxBandwidthOut(10)
 *             .dataDisks(InstanceDataDiskArgs.builder()
 *                 .name("disk2")
 *                 .size(20)
 *                 .category("cloud_efficiency")
 *                 .description("disk2")
 *                 .encrypted(true)
 *                 .kmsKeyId(key.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing ecs-instance module
 * to create several ECS instances one-click.
 * ## Import
 * Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/instance:Instance example i-abc12345678
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
     */
    @Deprecated(
        message = """
  Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting
      'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.
  """,
    )
    public val allocatePublicIp: Output<Boolean>?
        get() = javaResource.allocatePublicIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The automatic release time of the `PostPaid` instance.
     * The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
     * Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
     */
    public val autoReleaseTime: Output<String>?
        get() = javaResource.autoReleaseTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
     * - [1, 2, 3, 6, 12] when `period_unit` in "Month"
     * - [1, 2, 3] when `period_unit` in "Week"
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The number of vCPUs.
     */
    public val cpu: Output<Int>
        get() = javaResource.cpu().applyValue({ args0 -> args0 })

    /**
     * Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
     */
    public val creditSpecification: Output<String>
        get() = javaResource.creditSpecification().applyValue({ args0 -> args0 })

    /**
     * The list of data disks created with instance. See `data_disks` below.
     */
    public val dataDisks: Output<List<InstanceDataDisk>>?
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> instanceDataDiskToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
     */
    public val dedicatedHostId: Output<String>?
        get() = javaResource.dedicatedHostId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The group number of the instance in a deployment set when the deployment set is use.
     */
    public val deploymentSetGroupNo: Output<String>
        get() = javaResource.deploymentSetGroupNo().applyValue({ args0 -> args0 })

    /**
     * The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
     */
    public val deploymentSetId: Output<String>?
        get() = javaResource.deploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to send a dry-run request. Default to false.
     * - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
     * - false: A request is sent. If the validation succeeds, the instance is created.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
     */
    public val enableJumboFrame: Output<Boolean>
        get() = javaResource.enableJumboFrame().applyValue({ args0 -> args0 })

    /**
     * If it is true, the "PrePaid" instance will be change to "PostPaid" and then deleted forcibly.
     * However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
     * On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    public val hpcClusterId: Output<String>?
        get() = javaResource.hpcClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
     */
    public val httpEndpoint: Output<String>
        get() = javaResource.httpEndpoint().applyValue({ args0 -> args0 })

    /**
     * The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
     */
    public val httpPutResponseHopLimit: Output<Int>
        get() = javaResource.httpPutResponseHopLimit().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
     * - optional: does not forcefully use the security-enhanced mode (IMDSv2).
     * - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
     */
    public val httpTokens: Output<String>
        get() = javaResource.httpTokens().applyValue({ args0 -> args0 })

    /**
     * The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * Whether to change instance disks charge type when changing instance charge type.
     */
    public val includeDataDisks: Output<Boolean>?
        get() = javaResource.includeDataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are `PrePaid`, `PostPaid`, The default is `PostPaid`.
     * **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
     * However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
     * there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. Default is `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic".
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
     */
    @Deprecated(
        message = """
  The attribute is invalid and no any affect for the instance. So it has been deprecated since
      version v1.121.2.
  """,
    )
    public val internetMaxBandwidthIn: Output<Int>
        get() = javaResource.internetMaxBandwidthIn().applyValue({ args0 -> args0 })

    /**
     * Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. Default to 0 Mbps.
     */
    public val internetMaxBandwidthOut: Output<Int>
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 -> args0 })

    /**
     * The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
     */
    public val ipv6AddressCount: Output<Int>
        get() = javaResource.ipv6AddressCount().applyValue({ args0 -> args0 })

    /**
     * A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether to use outdated instance type. Default to false.
     */
    public val isOutdated: Output<Boolean>?
        get() = javaResource.isOutdated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    public val launchTemplateId: Output<String>?
        get() = javaResource.launchTemplateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the launch template.
     */
    public val launchTemplateName: Output<String>?
        get() = javaResource.launchTemplateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
     */
    public val launchTemplateVersion: Output<String>?
        get() = javaResource.launchTemplateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
     * * `Stop` : stops the instance.
     * * `AutoRecover` : automatically recovers the instance.
     * * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
     */
    public val maintenanceAction: Output<String>
        get() = javaResource.maintenanceAction().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
     */
    public val maintenanceNotify: Output<Boolean>?
        get() = javaResource.maintenanceNotify().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time of maintenance. See `maintenance_time` below.
     */
    public val maintenanceTime: Output<InstanceMaintenanceTime>?
        get() = javaResource.maintenanceTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceMaintenanceTimeToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The memory size of the instance. Unit: MiB.
     */
    public val memory: Output<Int>
        get() = javaResource.memory().applyValue({ args0 -> args0 })

    /**
     * The index of the network card for Primary ENI.
     */
    public val networkCardIndex: Output<Int>?
        get() = javaResource.networkCardIndex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Primary ENI.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
     * - `Standard`: Uses the TCP communication mode.
     * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
     */
    public val networkInterfaceTrafficMode: Output<String>
        get() = javaResource.networkInterfaceTrafficMode().applyValue({ args0 -> args0 })

    /**
     * The list of network interfaces created with instance. See `network_interfaces` below.
     */
    public val networkInterfaces: Output<InstanceNetworkInterfaces>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceNetworkInterfacesToKotlin(args0)
            })
        })

    /**
     * The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
     */
    public val operatorType: Output<String>?
        get() = javaResource.operatorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the operating system of the instance.
     */
    public val osName: Output<String>
        get() = javaResource.osName().applyValue({ args0 -> args0 })

    /**
     * The type of the operating system of the instance.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
     * - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
     * - [1-3] when `period_unit` in "Week"
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary private IP address of the ENI.
     */
    public val primaryIpAddress: Output<String>
        get() = javaResource.primaryIpAddress().applyValue({ args0 -> args0 })

    /**
     * Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * The instance public ip.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * The number of queues supported by the ERI.
     * > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     * > **NOTE:** From version 1.5.0, instance's charge type can be changed to "PrePaid" by specifying `period` and `period_unit`, but it is irreversible.
     * > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
     * > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
     * > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
     * Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
     * However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
     * > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
     */
    public val queuePairNumber: Output<Int>?
        get() = javaResource.queuePairNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    public val renewalStatus: Output<String>?
        get() = javaResource.renewalStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of resource group which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
     */
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
     */
    public val secondaryPrivateIpAddressCount: Output<Int>
        get() = javaResource.secondaryPrivateIpAddressCount().applyValue({ args0 -> args0 })

    /**
     * A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
     */
    public val secondaryPrivateIps: Output<List<String>>
        get() = javaResource.secondaryPrivateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The security enhancement strategy.
     * - Active: Enable security enhancement strategy, it only works on system images.
     * - Deactive: Disable security enhancement strategy, it works on all images.
     */
    public val securityEnhancementStrategy: Output<String>
        get() = javaResource.securityEnhancementStrategy().applyValue({ args0 -> args0 })

    /**
     * A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
     */
    public val spotDuration: Output<Int>
        get() = javaResource.spotDuration().applyValue({ args0 -> args0 })

    /**
     * The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    public val spotPriceLimit: Output<Double>
        get() = javaResource.spotPriceLimit().applyValue({ args0 -> args0 })

    /**
     * The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
     * - NoSpot: A regular Pay-As-You-Go instance.
     * - SpotWithPriceLimit: A price threshold for a spot instance
     * - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
     * Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
     */
    public val spotStrategy: Output<String>
        get() = javaResource.spotStrategy().applyValue({ args0 -> args0 })

    /**
     * The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
     * * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
     * * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
     */
    public val stoppedMode: Output<String>
        get() = javaResource.stoppedMode().applyValue({ args0 -> args0 })

    /**
     * The ID of the automatic snapshot policy applied to the system disk.
     */
    public val systemDiskAutoSnapshotPolicyId: Output<String>?
        get() = javaResource.systemDiskAutoSnapshotPolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
     */
    public val systemDiskCategory: Output<String>
        get() = javaResource.systemDiskCategory().applyValue({ args0 -> args0 })

    /**
     * The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    public val systemDiskDescription: Output<String>
        get() = javaResource.systemDiskDescription().applyValue({ args0 -> args0 })

    /**
     * The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
     */
    public val systemDiskEncryptAlgorithm: Output<String>?
        get() = javaResource.systemDiskEncryptAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
     */
    public val systemDiskEncrypted: Output<Boolean>
        get() = javaResource.systemDiskEncrypted().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.210.0) The ID of system disk.
     */
    public val systemDiskId: Output<String>
        get() = javaResource.systemDiskId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Key Management Service (KMS) key to be used for the system disk.
     */
    public val systemDiskKmsKeyId: Output<String>?
        get() = javaResource.systemDiskKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
     */
    public val systemDiskName: Output<String>
        get() = javaResource.systemDiskName().applyValue({ args0 -> args0 })

    /**
     * The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
     */
    public val systemDiskPerformanceLevel: Output<String>
        get() = javaResource.systemDiskPerformanceLevel().applyValue({ args0 -> args0 })

    /**
     * Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
     */
    public val systemDiskSize: Output<Int>
        get() = javaResource.systemDiskSize().applyValue({ args0 -> args0 })

    /**
     * The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
     */
    public val systemDiskStorageClusterId: Output<String>?
        get() = javaResource.systemDiskStorageClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
     * It supports to setting a base64-encoded value, and it is the recommended usage.
     * From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
     * Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A mapping of tags to assign to the devices created by the instance at launch time.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val volumeTags: Output<Map<String, String>>
        get() = javaResource.volumeTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.ecs.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
