@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.InstanceArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceDataDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceDataDiskArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceMaintenanceTimeArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceMaintenanceTimeArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceNetworkInterfacesArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.InstanceNetworkInterfacesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECS instance resource.
 * > **NOTE:** Available since v1.0.0
 * > **NOTE:** From version v1.213.0, you can specify `launch_template_id` and `launch_template_version` to use a launch template. This eliminates the need to configure a large number of parameters every time you create instances.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const instanceType = config.get("instanceType") || "ecs.n4.large";
 * const imageId = config.get("imageId") || "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 * // Create a new ECS instance for VPC
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * // Create a new ECS instance for a VPC
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: name,
 *     description: "foo",
 *     vpcId: vpc.id,
 * });
 * const key = new alicloud.kms.Key("key", {
 *     description: "Hello KMS",
 *     pendingWindowInDays: 7,
 *     status: "Enabled",
 * });
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 *     availableInstanceType: instanceType,
 * });
 * const vswitch = new alicloud.vpc.Switch("vswitch", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const instance = new alicloud.ecs.Instance("instance", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     securityGroups: [group].map(__item => __item.id),
 *     instanceType: instanceType,
 *     systemDiskCategory: "cloud_efficiency",
 *     systemDiskName: name,
 *     systemDiskDescription: "test_foo_system_disk_description",
 *     imageId: imageId,
 *     instanceName: name,
 *     vswitchId: vswitch.id,
 *     internetMaxBandwidthOut: 10,
 *     dataDisks: [{
 *         name: "disk2",
 *         size: 20,
 *         category: "cloud_efficiency",
 *         description: "disk2",
 *         encrypted: true,
 *         kmsKeyId: key.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * instance_type = config.get("instanceType")
 * if instance_type is None:
 *     instance_type = "ecs.n4.large"
 * image_id = config.get("imageId")
 * if image_id is None:
 *     image_id = "ubuntu_18_04_64_20G_alibase_20190624.vhd"
 * # Create a new ECS instance for VPC
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * # Create a new ECS instance for a VPC
 * group = alicloud.ecs.SecurityGroup("group",
 *     name=name,
 *     description="foo",
 *     vpc_id=vpc.id)
 * key = alicloud.kms.Key("key",
 *     description="Hello KMS",
 *     pending_window_in_days=7,
 *     status="Enabled")
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch",
 *     available_instance_type=instance_type)
 * vswitch = alicloud.vpc.Switch("vswitch",
 *     vpc_id=vpc.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * instance = alicloud.ecs.Instance("instance",
 *     availability_zone=default.zones[0].id,
 *     security_groups=[__item&#46;id for __item in [group]],
 *     instance_type=instance_type,
 *     system_disk_category="cloud_efficiency",
 *     system_disk_name=name,
 *     system_disk_description="test_foo_system_disk_description",
 *     image_id=image_id,
 *     instance_name=name,
 *     vswitch_id=vswitch.id,
 *     internet_max_bandwidth_out=10,
 *     data_disks=[{
 *         "name": "disk2",
 *         "size": 20,
 *         "category": "cloud_efficiency",
 *         "description": "disk2",
 *         "encrypted": True,
 *         "kms_key_id": key.id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var instanceType = config.Get("instanceType") ?? "ecs.n4.large";
 *     var imageId = config.Get("imageId") ?? "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 *     // Create a new ECS instance for VPC
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     // Create a new ECS instance for a VPC
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = name,
 *         Description = "foo",
 *         VpcId = vpc.Id,
 *     });
 *     var key = new AliCloud.Kms.Key("key", new()
 *     {
 *         Description = "Hello KMS",
 *         PendingWindowInDays = 7,
 *         Status = "Enabled",
 *     });
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *         AvailableInstanceType = instanceType,
 *     });
 *     var vswitch = new AliCloud.Vpc.Switch("vswitch", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var instance = new AliCloud.Ecs.Instance("instance", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         SecurityGroups = new[]
 *         {
 *             @group,
 *         }.Select(__item => __item.Id).ToList(),
 *         InstanceType = instanceType,
 *         SystemDiskCategory = "cloud_efficiency",
 *         SystemDiskName = name,
 *         SystemDiskDescription = "test_foo_system_disk_description",
 *         ImageId = imageId,
 *         InstanceName = name,
 *         VswitchId = vswitch.Id,
 *         InternetMaxBandwidthOut = 10,
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.InstanceDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Size = 20,
 *                 Category = "cloud_efficiency",
 *                 Description = "disk2",
 *                 Encrypted = true,
 *                 KmsKeyId = key.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "terraform-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * instanceType := "ecs.n4.large";
 * if param := cfg.Get("instanceType"); param != ""{
 * instanceType = param
 * }
 * imageId := "ubuntu_18_04_64_20G_alibase_20190624.vhd";
 * if param := cfg.Get("imageId"); param != ""{
 * imageId = param
 * }
 * // Create a new ECS instance for VPC
 * vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * VpcName: pulumi.String(name),
 * CidrBlock: pulumi.String("172.16.0.0/16"),
 * })
 * if err != nil {
 * return err
 * }
 * // Create a new ECS instance for a VPC
 * group, err := ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(name),
 * Description: pulumi.String("foo"),
 * VpcId: vpc.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
 * Description: pulumi.String("Hello KMS"),
 * PendingWindowInDays: pulumi.Int(7),
 * Status: pulumi.String("Enabled"),
 * })
 * if err != nil {
 * return err
 * }
 * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * AvailableInstanceType: pulumi.StringRef(instanceType),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * vswitch, err := vpc.NewSwitch(ctx, "vswitch", &vpc.SwitchArgs{
 * VpcId: vpc.ID(),
 * CidrBlock: pulumi.String("172.16.0.0/24"),
 * ZoneId: pulumi.String(_default.Zones[0].Id),
 * VswitchName: pulumi.String(name),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * _, err = ecs.NewInstance(ctx, "instance", &ecs.InstanceArgs{
 * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * SecurityGroups: splat0,
 * InstanceType: pulumi.String(instanceType),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * SystemDiskName: pulumi.String(name),
 * SystemDiskDescription: pulumi.String("test_foo_system_disk_description"),
 * ImageId: pulumi.String(imageId),
 * InstanceName: pulumi.String(name),
 * VswitchId: vswitch.ID(),
 * InternetMaxBandwidthOut: pulumi.Int(10),
 * DataDisks: ecs.InstanceDataDiskArray{
 * &ecs.InstanceDataDiskArgs{
 * Name: pulumi.String("disk2"),
 * Size: pulumi.Int(20),
 * Category: pulumi.String("cloud_efficiency"),
 * Description: pulumi.String("disk2"),
 * Encrypted: pulumi.Bool(true),
 * KmsKeyId: key.ID(),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var instanceType = config.get("instanceType").orElse("ecs.n4.large");
 *         final var imageId = config.get("imageId").orElse("ubuntu_18_04_64_20G_alibase_20190624.vhd");
 *         // Create a new ECS instance for VPC
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         // Create a new ECS instance for a VPC
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description("foo")
 *             .vpcId(vpc.id())
 *             .build());
 *         var key = new Key("key", KeyArgs.builder()
 *             .description("Hello KMS")
 *             .pendingWindowInDays("7")
 *             .status("Enabled")
 *             .build());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .availableInstanceType(instanceType)
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .securityGroups(group.stream().map(element -> element.id()).collect(toList()))
 *             .instanceType(instanceType)
 *             .systemDiskCategory("cloud_efficiency")
 *             .systemDiskName(name)
 *             .systemDiskDescription("test_foo_system_disk_description")
 *             .imageId(imageId)
 *             .instanceName(name)
 *             .vswitchId(vswitch.id())
 *             .internetMaxBandwidthOut(10)
 *             .dataDisks(InstanceDataDiskArgs.builder()
 *                 .name("disk2")
 *                 .size(20)
 *                 .category("cloud_efficiency")
 *                 .description("disk2")
 *                 .encrypted(true)
 *                 .kmsKeyId(key.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing ecs-instance module
 * to create several ECS instances one-click.
 * ## Import
 * Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/instance:Instance example i-abc12345678
 * ```
 * @property allocatePublicIp It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
 * @property autoReleaseTime The automatic release time of the `PostPaid` instance.
 * The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
 * Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
 * @property autoRenewPeriod Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
 * - [1, 2, 3, 6, 12] when `period_unit` in "Month"
 * - [1, 2, 3] when `period_unit` in "Week"
 * @property availabilityZone The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
 * @property creditSpecification Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
 * @property dataDisks The list of data disks created with instance. See `data_disks` below.
 * @property dedicatedHostId The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
 * @property deletionProtection Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
 * - true: Enable deletion protection.
 * - false: Disable deletion protection.
 * @property deploymentSetId The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
 * @property description Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property dryRun Specifies whether to send a dry-run request. Default to false.
 * - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
 * - false: A request is sent. If the validation succeeds, the instance is created.
 * @property enableJumboFrame Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
 * @property forceDelete If it is true, the "PrePaid" instance will be change to "PostPaid" and then deleted forcibly.
 * However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
 * @property hostName Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
 * On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
 * @property hpcClusterId The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
 * @property httpEndpoint Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
 * @property httpPutResponseHopLimit The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
 * @property httpTokens Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
 * - optional: does not forcefully use the security-enhanced mode (IMDSv2).
 * - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
 * @property imageId The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
 * @property includeDataDisks Whether to change instance disks charge type when changing instance charge type.
 * @property instanceChargeType Valid values are `PrePaid`, `PostPaid`, The default is `PostPaid`.
 * **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
 * However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
 * there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
 * @property instanceName
 * @property instanceType The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
 * @property internetChargeType Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. Default is `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic".
 * @property internetMaxBandwidthIn Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
 * @property internetMaxBandwidthOut Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. Default to 0 Mbps.
 * @property ipv6AddressCount The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
 * @property ipv6Addresses A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
 * @property isOutdated Whether to use outdated instance type. Default to false.
 * @property keyName The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
 * @property kmsEncryptedPassword An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
 * @property launchTemplateId The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
 * @property launchTemplateName The name of the launch template.
 * @property launchTemplateVersion The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
 * @property maintenanceAction The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
 * * `Stop` : stops the instance.
 * * `AutoRecover` : automatically recovers the instance.
 * * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
 * @property maintenanceNotify Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
 * @property maintenanceTime The time of maintenance. See `maintenance_time` below.
 * @property networkCardIndex The index of the network card for Primary ENI.
 * @property networkInterfaceTrafficMode The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
 * - `Standard`: Uses the TCP communication mode.
 * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
 * @property networkInterfaces The list of network interfaces created with instance. See `network_interfaces` below.
 * @property operatorType The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
 * @property password Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
 * @property period The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
 * - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
 * - [1-3] when `period_unit` in "Week"
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property periodUnit The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
 * @property privateIp Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
 * @property queuePairNumber The number of queues supported by the ERI.
 * > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
 * > **NOTE:** From version 1.5.0, instance's charge type can be changed to "PrePaid" by specifying `period` and `period_unit`, but it is irreversible.
 * > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
 * > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
 * > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
 * Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
 * However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
 * > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
 * @property renewalStatus Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
 * - `AutoRenewal`: Enable auto renewal.
 * - `Normal`: Disable auto renewal.
 * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
 * @property resourceGroupId The Id of resource group which the instance belongs.
 * @property roleName Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
 * @property secondaryPrivateIpAddressCount The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
 * @property secondaryPrivateIps A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
 * @property securityEnhancementStrategy The security enhancement strategy.
 * - Active: Enable security enhancement strategy, it only works on system images.
 * - Deactive: Disable security enhancement strategy, it works on all images.
 * @property securityGroups A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
 * @property spotDuration The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
 * @property spotPriceLimit The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
 * @property spotStrategy The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
 * - NoSpot: A regular Pay-As-You-Go instance.
 * - SpotWithPriceLimit: A price threshold for a spot instance
 * - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
 * Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
 * @property status The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
 * @property stoppedMode The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
 * * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
 * * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
 * @property systemDiskAutoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property systemDiskCategory Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
 * @property systemDiskDescription The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property systemDiskEncryptAlgorithm The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
 * @property systemDiskEncrypted Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
 * @property systemDiskKmsKeyId The ID of the Key Management Service (KMS) key to be used for the system disk.
 * @property systemDiskName The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
 * @property systemDiskPerformanceLevel The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
 * @property systemDiskSize Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
 * @property systemDiskStorageClusterId The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property userData User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
 * It supports to setting a base64-encoded value, and it is the recommended usage.
 * From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
 * Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
 * @property volumeTags A mapping of tags to assign to the devices created by the instance at launch time.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
 */
public data class InstanceArgs(
    @Deprecated(
        message = """
  Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting
      'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.
  """,
    )
    public val allocatePublicIp: Output<Boolean>? = null,
    public val autoReleaseTime: Output<String>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val availabilityZone: Output<String>? = null,
    public val creditSpecification: Output<String>? = null,
    public val dataDisks: Output<List<InstanceDataDiskArgs>>? = null,
    public val dedicatedHostId: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val deploymentSetId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val enableJumboFrame: Output<Boolean>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val hpcClusterId: Output<String>? = null,
    public val httpEndpoint: Output<String>? = null,
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val includeDataDisks: Output<Boolean>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    @Deprecated(
        message = """
  The attribute is invalid and no any affect for the instance. So it has been deprecated since
      version v1.121.2.
  """,
    )
    public val internetMaxBandwidthIn: Output<Int>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    public val isOutdated: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val launchTemplateVersion: Output<String>? = null,
    public val maintenanceAction: Output<String>? = null,
    public val maintenanceNotify: Output<Boolean>? = null,
    public val maintenanceTime: Output<InstanceMaintenanceTimeArgs>? = null,
    public val networkCardIndex: Output<Int>? = null,
    public val networkInterfaceTrafficMode: Output<String>? = null,
    public val networkInterfaces: Output<InstanceNetworkInterfacesArgs>? = null,
    public val operatorType: Output<String>? = null,
    public val password: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val privateIp: Output<String>? = null,
    public val queuePairNumber: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val secondaryPrivateIpAddressCount: Output<Int>? = null,
    public val secondaryPrivateIps: Output<List<String>>? = null,
    public val securityEnhancementStrategy: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val spotDuration: Output<Int>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val status: Output<String>? = null,
    public val stoppedMode: Output<String>? = null,
    public val systemDiskAutoSnapshotPolicyId: Output<String>? = null,
    public val systemDiskCategory: Output<String>? = null,
    public val systemDiskDescription: Output<String>? = null,
    public val systemDiskEncryptAlgorithm: Output<String>? = null,
    public val systemDiskEncrypted: Output<Boolean>? = null,
    public val systemDiskKmsKeyId: Output<String>? = null,
    public val systemDiskName: Output<String>? = null,
    public val systemDiskPerformanceLevel: Output<String>? = null,
    public val systemDiskSize: Output<Int>? = null,
    public val systemDiskStorageClusterId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val volumeTags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.InstanceArgs =
        com.pulumi.alicloud.ecs.InstanceArgs.builder()
            .allocatePublicIp(allocatePublicIp?.applyValue({ args0 -> args0 }))
            .autoReleaseTime(autoReleaseTime?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .creditSpecification(creditSpecification?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dedicatedHostId(dedicatedHostId?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .deploymentSetId(deploymentSetId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .enableJumboFrame(enableJumboFrame?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .hpcClusterId(hpcClusterId?.applyValue({ args0 -> args0 }))
            .httpEndpoint(httpEndpoint?.applyValue({ args0 -> args0 }))
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .includeDataDisks(includeDataDisks?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthIn(internetMaxBandwidthIn?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isOutdated(isOutdated?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .launchTemplateVersion(launchTemplateVersion?.applyValue({ args0 -> args0 }))
            .maintenanceAction(maintenanceAction?.applyValue({ args0 -> args0 }))
            .maintenanceNotify(maintenanceNotify?.applyValue({ args0 -> args0 }))
            .maintenanceTime(maintenanceTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkCardIndex(networkCardIndex?.applyValue({ args0 -> args0 }))
            .networkInterfaceTrafficMode(networkInterfaceTrafficMode?.applyValue({ args0 -> args0 }))
            .networkInterfaces(networkInterfaces?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .operatorType(operatorType?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .queuePairNumber(queuePairNumber?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIps(secondaryPrivateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityEnhancementStrategy(securityEnhancementStrategy?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotDuration(spotDuration?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .stoppedMode(stoppedMode?.applyValue({ args0 -> args0 }))
            .systemDiskAutoSnapshotPolicyId(systemDiskAutoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskDescription(systemDiskDescription?.applyValue({ args0 -> args0 }))
            .systemDiskEncryptAlgorithm(systemDiskEncryptAlgorithm?.applyValue({ args0 -> args0 }))
            .systemDiskEncrypted(systemDiskEncrypted?.applyValue({ args0 -> args0 }))
            .systemDiskKmsKeyId(systemDiskKmsKeyId?.applyValue({ args0 -> args0 }))
            .systemDiskName(systemDiskName?.applyValue({ args0 -> args0 }))
            .systemDiskPerformanceLevel(systemDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .systemDiskStorageClusterId(systemDiskStorageClusterId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .volumeTags(
                volumeTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var allocatePublicIp: Output<Boolean>? = null

    private var autoReleaseTime: Output<String>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var availabilityZone: Output<String>? = null

    private var creditSpecification: Output<String>? = null

    private var dataDisks: Output<List<InstanceDataDiskArgs>>? = null

    private var dedicatedHostId: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var deploymentSetId: Output<String>? = null

    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var enableJumboFrame: Output<Boolean>? = null

    private var forceDelete: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var hpcClusterId: Output<String>? = null

    private var httpEndpoint: Output<String>? = null

    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    private var imageId: Output<String>? = null

    private var includeDataDisks: Output<Boolean>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthIn: Output<Int>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var isOutdated: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var launchTemplateVersion: Output<String>? = null

    private var maintenanceAction: Output<String>? = null

    private var maintenanceNotify: Output<Boolean>? = null

    private var maintenanceTime: Output<InstanceMaintenanceTimeArgs>? = null

    private var networkCardIndex: Output<Int>? = null

    private var networkInterfaceTrafficMode: Output<String>? = null

    private var networkInterfaces: Output<InstanceNetworkInterfacesArgs>? = null

    private var operatorType: Output<String>? = null

    private var password: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var queuePairNumber: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var roleName: Output<String>? = null

    private var secondaryPrivateIpAddressCount: Output<Int>? = null

    private var secondaryPrivateIps: Output<List<String>>? = null

    private var securityEnhancementStrategy: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var spotDuration: Output<Int>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var status: Output<String>? = null

    private var stoppedMode: Output<String>? = null

    private var systemDiskAutoSnapshotPolicyId: Output<String>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskDescription: Output<String>? = null

    private var systemDiskEncryptAlgorithm: Output<String>? = null

    private var systemDiskEncrypted: Output<Boolean>? = null

    private var systemDiskKmsKeyId: Output<String>? = null

    private var systemDiskName: Output<String>? = null

    private var systemDiskPerformanceLevel: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var systemDiskStorageClusterId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var volumeTags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
     */
    @Deprecated(
        message = """
  Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting
      'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.
  """,
    )
    @JvmName("bbmkklmrdfootxee")
    public suspend fun allocatePublicIp(`value`: Output<Boolean>) {
        this.allocatePublicIp = value
    }

    /**
     * @param value The automatic release time of the `PostPaid` instance.
     * The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
     * Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
     */
    @JvmName("tytacommllmsqdho")
    public suspend fun autoReleaseTime(`value`: Output<String>) {
        this.autoReleaseTime = value
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
     * - [1, 2, 3, 6, 12] when `period_unit` in "Month"
     * - [1, 2, 3] when `period_unit` in "Week"
     */
    @JvmName("vijasrshcuujcxov")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
     */
    @JvmName("gqoxfrgyslueygrn")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
     */
    @JvmName("yvaytiwbxpabepbi")
    public suspend fun creditSpecification(`value`: Output<String>) {
        this.creditSpecification = value
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("exhevhgfmmnsqblp")
    public suspend fun dataDisks(`value`: Output<List<InstanceDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("pevcvmubiqgdcyxp")
    public suspend fun dataDisks(vararg values: Output<InstanceDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("matrjhimfmorgqlq")
    public suspend fun dataDisks(values: List<Output<InstanceDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
     */
    @JvmName("fyjrknnepjidkrlx")
    public suspend fun dedicatedHostId(`value`: Output<String>) {
        this.dedicatedHostId = value
    }

    /**
     * @param value Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("lhcplittywfsciso")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
     */
    @JvmName("qbokmepvrikjxsbl")
    public suspend fun deploymentSetId(`value`: Output<String>) {
        this.deploymentSetId = value
    }

    /**
     * @param value Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("hosojayvcfeopddb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to send a dry-run request. Default to false.
     * - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
     * - false: A request is sent. If the validation succeeds, the instance is created.
     */
    @JvmName("jmfhmntcelymjseb")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
     */
    @JvmName("oqgcvsplnjihlysr")
    public suspend fun enableJumboFrame(`value`: Output<Boolean>) {
        this.enableJumboFrame = value
    }

    /**
     * @param value If it is true, the "PrePaid" instance will be change to "PostPaid" and then deleted forcibly.
     * However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
     */
    @JvmName("cxlkwmapyuyqierg")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
     * On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("gbsotgggiwhbxgsc")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    @JvmName("kjgrltfmlryptces")
    public suspend fun hpcClusterId(`value`: Output<String>) {
        this.hpcClusterId = value
    }

    /**
     * @param value Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
     */
    @JvmName("kparrquwmeqrtvst")
    public suspend fun httpEndpoint(`value`: Output<String>) {
        this.httpEndpoint = value
    }

    /**
     * @param value The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
     */
    @JvmName("atqillvsgtubktoq")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
     * - optional: does not forcefully use the security-enhanced mode (IMDSv2).
     * - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
     */
    @JvmName("jpdndhtkxjnkppyv")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
     */
    @JvmName("ylcyxufnmmybjyrd")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Whether to change instance disks charge type when changing instance charge type.
     */
    @JvmName("tygetyiksqessver")
    public suspend fun includeDataDisks(`value`: Output<Boolean>) {
        this.includeDataDisks = value
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, The default is `PostPaid`.
     * **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
     * However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
     * there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
     */
    @JvmName("okrvrmfmvxtwsqpb")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value
     */
    @JvmName("ghhfabnjmamnyycf")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
     */
    @JvmName("caxfayyisflioter")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. Default is `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic".
     */
    @JvmName("abvdwagcoxmomvlm")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
     */
    @Deprecated(
        message = """
  The attribute is invalid and no any affect for the instance. So it has been deprecated since
      version v1.121.2.
  """,
    )
    @JvmName("ujoxbujoijhfwrcq")
    public suspend fun internetMaxBandwidthIn(`value`: Output<Int>) {
        this.internetMaxBandwidthIn = value
    }

    /**
     * @param value Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. Default to 0 Mbps.
     */
    @JvmName("hxaqbgkoasmkiopy")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
     */
    @JvmName("kunoghbtjgtsbjev")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("vxffhgttwbcilchf")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("omgndnymwrglqoxb")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("warefpcmaudljqbi")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Whether to use outdated instance type. Default to false.
     */
    @JvmName("xcnqrickyvgigyju")
    public suspend fun isOutdated(`value`: Output<Boolean>) {
        this.isOutdated = value
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
     */
    @JvmName("fjbspnernowreumn")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("cokaawtskfupflxp")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("eglqqnlaalekihwu")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    @JvmName("rlidrxkwxnlwaxpj")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The name of the launch template.
     */
    @JvmName("qgtrlflxmljxmhou")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
     */
    @JvmName("ekykutdcntttnvkw")
    public suspend fun launchTemplateVersion(`value`: Output<String>) {
        this.launchTemplateVersion = value
    }

    /**
     * @param value The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
     * * `Stop` : stops the instance.
     * * `AutoRecover` : automatically recovers the instance.
     * * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
     */
    @JvmName("aqswesojdyebslyo")
    public suspend fun maintenanceAction(`value`: Output<String>) {
        this.maintenanceAction = value
    }

    /**
     * @param value Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
     */
    @JvmName("pjlwyliyruurbpff")
    public suspend fun maintenanceNotify(`value`: Output<Boolean>) {
        this.maintenanceNotify = value
    }

    /**
     * @param value The time of maintenance. See `maintenance_time` below.
     */
    @JvmName("ucnygmrlykrdkngd")
    public suspend fun maintenanceTime(`value`: Output<InstanceMaintenanceTimeArgs>) {
        this.maintenanceTime = value
    }

    /**
     * @param value The index of the network card for Primary ENI.
     */
    @JvmName("yipfcolaxcwhcwfh")
    public suspend fun networkCardIndex(`value`: Output<Int>) {
        this.networkCardIndex = value
    }

    /**
     * @param value The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
     * - `Standard`: Uses the TCP communication mode.
     * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
     */
    @JvmName("crjrlqoldyomcjey")
    public suspend fun networkInterfaceTrafficMode(`value`: Output<String>) {
        this.networkInterfaceTrafficMode = value
    }

    /**
     * @param value The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("sxaghnfycxrhipgk")
    public suspend fun networkInterfaces(`value`: Output<InstanceNetworkInterfacesArgs>) {
        this.networkInterfaces = value
    }

    /**
     * @param value The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
     */
    @JvmName("ffewoyihkarbfybu")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("lgsahqvwnhbvospw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
     * - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
     * - [1-3] when `period_unit` in "Week"
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("osebvtdbesyyhdqt")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
     */
    @JvmName("oolyxbsgaiuvwhkg")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("xvwawbacnifpfmle")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value The number of queues supported by the ERI.
     * > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     * > **NOTE:** From version 1.5.0, instance's charge type can be changed to "PrePaid" by specifying `period` and `period_unit`, but it is irreversible.
     * > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
     * > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
     * > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
     * Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
     * However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
     * > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("abpsqdeduchtxswu")
    public suspend fun queuePairNumber(`value`: Output<Int>) {
        this.queuePairNumber = value
    }

    /**
     * @param value Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("ubiqyvfnwpakyiqw")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The Id of resource group which the instance belongs.
     */
    @JvmName("qribuoecamvrieos")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
     */
    @JvmName("rcfiwnllfgmdtaqy")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
     */
    @JvmName("qqwtkagmdiwyjmcp")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Output<Int>) {
        this.secondaryPrivateIpAddressCount = value
    }

    /**
     * @param value A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
     */
    @JvmName("geaeuclstbeksato")
    public suspend fun secondaryPrivateIps(`value`: Output<List<String>>) {
        this.secondaryPrivateIps = value
    }

    @JvmName("uleuvjgmedeojqpj")
    public suspend fun secondaryPrivateIps(vararg values: Output<String>) {
        this.secondaryPrivateIps = Output.all(values.asList())
    }

    /**
     * @param values A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
     */
    @JvmName("vdexslwxfgvrlwhe")
    public suspend fun secondaryPrivateIps(values: List<Output<String>>) {
        this.secondaryPrivateIps = Output.all(values)
    }

    /**
     * @param value The security enhancement strategy.
     * - Active: Enable security enhancement strategy, it only works on system images.
     * - Deactive: Disable security enhancement strategy, it works on all images.
     */
    @JvmName("excroankggpcjgyd")
    public suspend fun securityEnhancementStrategy(`value`: Output<String>) {
        this.securityEnhancementStrategy = value
    }

    /**
     * @param value A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
     */
    @JvmName("uekuysaukayugobt")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("tnttrlpbkwglggyk")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
     */
    @JvmName("qsoeokbrdbgarvyq")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
     */
    @JvmName("ehxrepalwbabqkco")
    public suspend fun spotDuration(`value`: Output<Int>) {
        this.spotDuration = value
    }

    /**
     * @param value The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    @JvmName("euqssydxrvgsgadb")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
     * - NoSpot: A regular Pay-As-You-Go instance.
     * - SpotWithPriceLimit: A price threshold for a spot instance
     * - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
     * Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
     */
    @JvmName("xrkjdcoxrldwoisk")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
     */
    @JvmName("rxdxousuvabjcojt")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
     * * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
     * * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
     */
    @JvmName("srkifmjhnjswfvlw")
    public suspend fun stoppedMode(`value`: Output<String>) {
        this.stoppedMode = value
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("cxqvrxdotpwntwts")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: Output<String>) {
        this.systemDiskAutoSnapshotPolicyId = value
    }

    /**
     * @param value Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
     */
    @JvmName("ruaclbaqsvlnfxnq")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("osxsrojvwuvlawaa")
    public suspend fun systemDiskDescription(`value`: Output<String>) {
        this.systemDiskDescription = value
    }

    /**
     * @param value The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
     */
    @JvmName("edohapedpalgaecp")
    public suspend fun systemDiskEncryptAlgorithm(`value`: Output<String>) {
        this.systemDiskEncryptAlgorithm = value
    }

    /**
     * @param value Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
     */
    @JvmName("mxidgkstqhfqustd")
    public suspend fun systemDiskEncrypted(`value`: Output<Boolean>) {
        this.systemDiskEncrypted = value
    }

    /**
     * @param value The ID of the Key Management Service (KMS) key to be used for the system disk.
     */
    @JvmName("qtxpoydqphwuoigc")
    public suspend fun systemDiskKmsKeyId(`value`: Output<String>) {
        this.systemDiskKmsKeyId = value
    }

    /**
     * @param value The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
     */
    @JvmName("akmplfpgksjxahnc")
    public suspend fun systemDiskName(`value`: Output<String>) {
        this.systemDiskName = value
    }

    /**
     * @param value The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
     */
    @JvmName("guqudabomlwbeyqi")
    public suspend fun systemDiskPerformanceLevel(`value`: Output<String>) {
        this.systemDiskPerformanceLevel = value
    }

    /**
     * @param value Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
     */
    @JvmName("akxwvegeltvqjqpp")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
     */
    @JvmName("nepqarnaldsefqhn")
    public suspend fun systemDiskStorageClusterId(`value`: Output<String>) {
        this.systemDiskStorageClusterId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("bkqwjaqmwtfvpcxf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
     * It supports to setting a base64-encoded value, and it is the recommended usage.
     * From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
     * Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
     */
    @JvmName("bwyxuxrncmrfiogj")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value A mapping of tags to assign to the devices created by the instance at launch time.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("qivyqjfommioxqnw")
    public suspend fun volumeTags(`value`: Output<Map<String, String>>) {
        this.volumeTags = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("xbjiklyddcxwnshm")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("vxiwkoysjcrewcql")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value It has been deprecated from version "1.7.0". Setting "internet_max_bandwidth_out" larger than 0 can allocate a public ip address for an instance.
     */
    @Deprecated(
        message = """
  Field 'allocate_public_ip' has been deprecated from provider version 1.6.1. Setting
      'internet_max_bandwidth_out' larger than 0 will allocate public ip for instance.
  """,
    )
    @JvmName("qhqnckfnthaiigju")
    public suspend fun allocatePublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocatePublicIp = mapped
    }

    /**
     * @param value The automatic release time of the `PostPaid` instance.
     * The time follows the ISO 8601 standard and is in UTC time. Format: yyyy-MM-ddTHH:mm:ssZ. It must be at least half an hour later than the current time and less than 3 years since the current time.
     * Setting it to null can cancel automatic release feature, and the ECS instance will not be released automatically.
     */
    @JvmName("gdcwyooqusslkjrk")
    public suspend fun autoReleaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReleaseTime = mapped
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`. Default to 1. Valid value:
     * - [1, 2, 3, 6, 12] when `period_unit` in "Month"
     * - [1, 2, 3] when `period_unit` in "Week"
     */
    @JvmName("ygnfxfaigumijwpa")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The Zone to start the instance in. It is ignored and will be computed when set `vswitch_id`.
     */
    @JvmName("jmjayimvfsujdpyq")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
     */
    @JvmName("fepkoildrpxasjhm")
    public suspend fun creditSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creditSpecification = mapped
    }

    /**
     * @param value The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("vjigitnpsiiighnx")
    public suspend fun dataDisks(`value`: List<InstanceDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("pytacqkouxovkoqr")
    public suspend fun dataDisks(argument: List<suspend InstanceDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("mxnnbxtxahxveglb")
    public suspend fun dataDisks(vararg argument: suspend InstanceDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("xxtacbuabqqmqrmk")
    public suspend fun dataDisks(argument: suspend InstanceDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values The list of data disks created with instance. See `data_disks` below.
     */
    @JvmName("qrsfbpqngimqxqnb")
    public suspend fun dataDisks(vararg values: InstanceDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The ID of the dedicated host on which to create the instance. If you set the DedicatedHostId parameter, the `spot_strategy` and `spot_price_limit` parameters cannot be set. This is because preemptible instances cannot be created on dedicated hosts.
     */
    @JvmName("kvdbcpwivamifmou")
    public suspend fun dedicatedHostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostId = mapped
    }

    /**
     * @param value Whether enable the deletion protection or not. It does not work when the instance is spot. Default value: `false`.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("oheddcavhbrdypia")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The ID of the deployment set to which to deploy the instance. **NOTE:** From version 1.176.0, instance's deploymentSetId can be removed when 'deployment_set_id' = "".
     */
    @JvmName("egkxkmgcnaeixtvx")
    public suspend fun deploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetId = mapped
    }

    /**
     * @param value Description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("excekejgkgqjccvn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to send a dry-run request. Default to false.
     * - true: Only a dry-run request is sent and no instance is created. The system checks whether the required parameters are set, and validates the request format, service permissions, and available ECS instances. If the validation fails, the corresponding error code is returned. If the validation succeeds, the `DryRunOperation` error code is returned.
     * - false: A request is sent. If the validation succeeds, the instance is created.
     */
    @JvmName("nucgrlomnkigaqyj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Specifies whether to enable the Jumbo Frames feature for the instance. Valid values: `true`, `false`.
     */
    @JvmName("kuutiwcvcrcjfalr")
    public suspend fun enableJumboFrame(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableJumboFrame = mapped
    }

    /**
     * @param value If it is true, the "PrePaid" instance will be change to "PostPaid" and then deleted forcibly.
     * However, because of changing instance charge type has CPU core count quota limitation, so strongly recommand that "Don't modify instance charge type frequentlly in one month".
     */
    @JvmName("iqogilxctmfgiwkv")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value Host name of the ECS, which is a string of at least two characters. “hostname” cannot start or end with “.” or “-“. In addition, two or more consecutive “.” or “-“ symbols are not allowed. On Windows, the host name can contain a maximum of 15 characters, which can be a combination of uppercase/lowercase letters, numerals, and “-“. The host name cannot contain dots (“.”) or contain only numeric characters. When it is changed, the instance will reboot to make the change take effect.
     * On other OSs such as Linux, the host name can contain a maximum of 64 characters, which can be segments separated by dots (“.”), where each segment can contain uppercase/lowercase letters, numerals, or “_“. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("baydaxfswhtbyedj")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
     */
    @JvmName("btseixusjcxkevmu")
    public suspend fun hpcClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hpcClusterId = mapped
    }

    /**
     * @param value Specifies whether to enable the access channel for instance metadata. Valid values: `enabled`, `disabled`. Default value: `enabled`.
     */
    @JvmName("lvmqcdekurtfkgyu")
    public suspend fun httpEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpoint = mapped
    }

    /**
     * @param value The HTTP PUT response hop limit for accessing instance metadata. Valid values: 1 to 64. Default value: 1.
     */
    @JvmName("okqmvkbqrryttxcd")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value Specifies whether to forcefully use the security-enhanced mode (IMDSv2) to access instance metadata. Default value: optional. Valid values:
     * - optional: does not forcefully use the security-enhanced mode (IMDSv2).
     * - required: forcefully uses the security-enhanced mode (IMDSv2). After you set this parameter to required, you cannot access instance metadata in normal mode.
     */
    @JvmName("mlvedfhlcebfpcnh")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    /**
     * @param value The Image to use for the instance. ECS instance's image can be replaced via changing `image_id`. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `image_id`.
     */
    @JvmName("qbepltejquejmbbt")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Whether to change instance disks charge type when changing instance charge type.
     */
    @JvmName("hyhbmivatdusivck")
    public suspend fun includeDataDisks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeDataDisks = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, The default is `PostPaid`.
     * **NOTE:** Since 1.9.6, it can be changed each other between `PostPaid` and `PrePaid`.
     * However, since [some limitation about CPU core count in one month](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/modifyinstancechargetype),
     * there strongly recommends that `Don't change instance_charge_type frequentlly in one month`.
     */
    @JvmName("aioieswrvkfdauaw")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("xjproqbnljcilnau")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The type of instance to start. When it is changed, the instance will reboot to make the change take effect. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `instance_type`.
     */
    @JvmName("mdhbxtfrqpdreggk")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Internet charge type of the instance, Valid values are `PayByBandwidth`, `PayByTraffic`. Default is `PayByTraffic`. At present, 'PrePaid' instance cannot change the value to "PayByBandwidth" from "PayByTraffic".
     */
    @JvmName("rivminrqifbcfstk")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). Value range: [1, 200]. If this value is not specified, then automatically sets it to 200 Mbps.
     */
    @Deprecated(
        message = """
  The attribute is invalid and no any affect for the instance. So it has been deprecated since
      version v1.121.2.
  """,
    )
    @JvmName("ukvweyaoykbobytw")
    public suspend fun internetMaxBandwidthIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthIn = mapped
    }

    /**
     * @param value Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Value range:  [0, 100]. Default to 0 Mbps.
     */
    @JvmName("hqyussrtldsunrat")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
     */
    @JvmName("mrdkttlpioqiypin")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("inyjikubtqreylfy")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
     */
    @JvmName("paqnqfeoftpirqlr")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Whether to use outdated instance type. Default to false.
     */
    @JvmName("gisdlvaorybhgnrh")
    public suspend fun isOutdated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOutdated = mapped
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
     */
    @JvmName("toqkknetlbwiwpob")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("yhuccyjwlemlxmdp")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("wysaslxqipucuhev")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating an instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("vqlvbgrlsqhjomyx")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The ID of the launch template. For more information, see [DescribeLaunchTemplates](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-describelaunchtemplates).To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
     */
    @JvmName("qcjgskfbeitbkick")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The name of the launch template.
     */
    @JvmName("vtmgwfsnsjgxukiw")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value The version of the launch template. If you set `launch_template_id` or `launch_template_name` parameter but do not set the version number of the launch template, the default template version is used.
     */
    @JvmName("pmimljkdhyjnermr")
    public suspend fun launchTemplateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateVersion = mapped
    }

    /**
     * @param value The maintenance action. Valid values: `Stop`, `AutoRecover` and `AutoRedeploy`.
     * * `Stop` : stops the instance.
     * * `AutoRecover` : automatically recovers the instance.
     * * `AutoRedeploy` : fails the instance over, which may cause damage to the data disks attached to the instance.
     */
    @JvmName("xkkgpnminwmfjqsb")
    public suspend fun maintenanceAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceAction = mapped
    }

    /**
     * @param value Specifies whether to send an event notification before instance shutdown. Valid values: `true`, `false`. Default value: `false`.
     */
    @JvmName("olexuqudvtncfjyh")
    public suspend fun maintenanceNotify(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceNotify = mapped
    }

    /**
     * @param value The time of maintenance. See `maintenance_time` below.
     */
    @JvmName("rxfpcjqwckijnaid")
    public suspend fun maintenanceTime(`value`: InstanceMaintenanceTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceTime = mapped
    }

    /**
     * @param argument The time of maintenance. See `maintenance_time` below.
     */
    @JvmName("hkaggaqrudolwyas")
    public suspend fun maintenanceTime(argument: suspend InstanceMaintenanceTimeArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceMaintenanceTimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceTime = mapped
    }

    /**
     * @param value The index of the network card for Primary ENI.
     */
    @JvmName("wnxgcmstlswhktcs")
    public suspend fun networkCardIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCardIndex = mapped
    }

    /**
     * @param value The communication mode of the Primary ENI. Default value: `Standard`. Valid values:
     * - `Standard`: Uses the TCP communication mode.
     * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
     */
    @JvmName("abcoudonujonraut")
    public suspend fun networkInterfaceTrafficMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceTrafficMode = mapped
    }

    /**
     * @param value The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("hisqrbkjjbcqhikh")
    public suspend fun networkInterfaces(`value`: InstanceNetworkInterfacesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interfaces created with instance. See `network_interfaces` below.
     */
    @JvmName("lkbkactrogljeyfx")
    public suspend fun networkInterfaces(argument: suspend InstanceNetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceNetworkInterfacesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param value The operation type. It is valid when `instance_charge_type` is `PrePaid`. Default value: `upgrade`. Valid values: `upgrade`, `downgrade`. **NOTE:**  When the new instance type specified by the `instance_type` parameter has lower specifications than the current instance type, you must set `operator_type` to `downgrade`.
     */
    @JvmName("yvjpmtrxsgpelaks")
    public suspend fun operatorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value Password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("mavjdhaagvumgcpi")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid and required when `instance_charge_type` is `PrePaid`. Valid values:
     * - [1-9, 12, 24, 36, 48, 60] when `period_unit` in "Month"
     * - [1-3] when `period_unit` in "Week"
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("ppwsvylamntvanmp")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: ["Week", "Month"]. Default to "Month".
     */
    @JvmName("qojhlrijpctgeekf")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value Instance private IP address can be specified when you creating new instance. It is valid when `vswitch_id` is specified. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("lntwoiwegkisjcot")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value The number of queues supported by the ERI.
     * > **NOTE:** System disk category `cloud` has been outdated and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
     * > **NOTE:** From version 1.5.0, instance's charge type can be changed to "PrePaid" by specifying `period` and `period_unit`, but it is irreversible.
     * > **NOTE:** From version 1.5.0, instance's private IP address can be specified when creating VPC network instance.
     * > **NOTE:** From version 1.5.0, instance's vswitch and private IP can be changed in the same availability zone. When they are changed, the instance will reboot to make the change take effect.
     * > **NOTE:** From version 1.7.0, setting "internet_max_bandwidth_out" larger than 0 can allocate a public IP for an instance.
     * Setting "internet_max_bandwidth_out" to 0 can release allocated public IP for VPC instance(For Classic instnace, its public IP cannot be release once it allocated, even thougth its bandwidth out is 0).
     * However, at present, 'PrePaid' instance cannot narrow its max bandwidth out when its 'internet_charge_type' is "PayByBandwidth".
     * > **NOTE:** From version 1.7.0, instance's type can be changed. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("vjlnjcyicxboghmy")
    public suspend fun queuePairNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queuePairNumber = mapped
    }

    /**
     * @param value Whether to renew an ECS instance automatically or not. It is valid when `instance_charge_type` is `PrePaid`. Default to "Normal". Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("vminqxgdpggcpfmd")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The Id of resource group which the instance belongs.
     */
    @JvmName("ijkjqsjtmraqhkvb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
     */
    @JvmName("bcucfbewnjvlvukc")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The number of private IP addresses to be automatically assigned from within the CIDR block of the vswitch. **NOTE:** To assign secondary private IP addresses, you must specify `secondary_private_ips` or `secondary_private_ip_address_count` but not both.
     */
    @JvmName("falppqwofitnjrno")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddressCount = mapped
    }

    /**
     * @param value A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
     */
    @JvmName("avlqgpdujhqqphme")
    public suspend fun secondaryPrivateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param values A list of Secondary private IP addresses which is selected from within the CIDR block of the vSwitch.
     */
    @JvmName("thqapnvruvihprga")
    public suspend fun secondaryPrivateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param value The security enhancement strategy.
     * - Active: Enable security enhancement strategy, it only works on system images.
     * - Deactive: Disable security enhancement strategy, it works on all images.
     */
    @JvmName("uijufuvhysdvmfic")
    public suspend fun securityEnhancementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityEnhancementStrategy = mapped
    }

    /**
     * @param value A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
     */
    @JvmName("omgudgyuxwxqplbj")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group ids to associate with. If you do not use `launch_template_id` or `launch_template_name` to specify a launch template, you must specify `security_groups`.
     */
    @JvmName("fcttfkykosajwwls")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The retention time of the preemptive instance in hours. Valid values: `0`, `1`, `2`, `3`, `4`, `5`, `6`. Retention duration 2~6 is under invitation test, please submit a work order if you need to open. If the value is `0`, the mode is no protection period. Default value is `1`.
     */
    @JvmName("teqkgrxircspmrsi")
    public suspend fun spotDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotDuration = mapped
    }

    /**
     * @param value The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
     */
    @JvmName("vnqesvyutohqujuo")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'. Value range:
     * - NoSpot: A regular Pay-As-You-Go instance.
     * - SpotWithPriceLimit: A price threshold for a spot instance
     * - SpotAsPriceGo: A price that is based on the highest Pay-As-You-Go instance
     * Default to NoSpot. Note: Currently, the spot instance only supports domestic site account.
     */
    @JvmName("nklptrnscrmxuyng")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value The instance status. Valid values: ["Running", "Stopped"]. You can control the instance start and stop through this parameter. Default to `Running`.
     */
    @JvmName("vscehajpwyubqkrq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The stop mode of the pay-as-you-go instance. Valid values: `StopCharging`,`KeepCharging`, `Not-applicable`. Default value: If the prerequisites required for enabling the economical mode are met, and you have enabled this mode in the ECS console, the default value is `StopCharging`. For more information, see "Enable the economical mode" in [Economical mode](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/economical-mode). Otherwise, the default value is `KeepCharging`. **Note:** `Not-applicable`: Economical mode is not applicable to the instance.`
     * * `KeepCharging`: standard mode. Billing of the instance continues after the instance is stopped, and resources are retained for the instance.
     * * `StopCharging`: economical mode. Billing of some resources of the instance stops after the instance is stopped. When the instance is stopped, its resources such as vCPUs, memory, and public IP address are released. You may be unable to restart the instance if some types of resources are out of stock in the current region.
     */
    @JvmName("iwsxjlaqsuxltfum")
    public suspend fun stoppedMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stoppedMode = mapped
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("gqdunuilgihxyhll")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskAutoSnapshotPolicyId = mapped
    }

    /**
     * @param value Valid values are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`, `cloud_auto`, `cloud_essd_entry`. only is used to some none I/O optimized instance. Valid values `cloud_auto` Available since v1.184.0.
     */
    @JvmName("fljjryfvbvlcgprq")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("iqcllalskhmvjpoq")
    public suspend fun systemDiskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskDescription = mapped
    }

    /**
     * @param value The algorithm to be used to encrypt the system disk. Valid values are `aes-256`, `sm4-128`. Default value is `aes-256`.
     */
    @JvmName("inurukfkrpkurqtu")
    public suspend fun systemDiskEncryptAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskEncryptAlgorithm = mapped
    }

    /**
     * @param value Specifies whether to encrypt the system disk. Valid values: `true`,`false`. Default value: `false`.
     */
    @JvmName("igrqlwdyxqexmxys")
    public suspend fun systemDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskEncrypted = mapped
    }

    /**
     * @param value The ID of the Key Management Service (KMS) key to be used for the system disk.
     */
    @JvmName("qamgsacfvvjvchjm")
    public suspend fun systemDiskKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskKmsKeyId = mapped
    }

    /**
     * @param value The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
     */
    @JvmName("bofmcouwlfsljiwo")
    public suspend fun systemDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskName = mapped
    }

    /**
     * @param value The performance level of the ESSD used as the system disk, Valid values: `PL0`, `PL1`, `PL2`, `PL3`, Default to `PL1`;For more information about ESSD, See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/122389.htm).
     */
    @JvmName("wumukrhuwiqxxyka")
    public suspend fun systemDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskPerformanceLevel = mapped
    }

    /**
     * @param value Size of the system disk, measured in GiB. Value range: [20, 500]. The specified value must be equal to or greater than max{20, Imagesize}. Default value: max{40, ImageSize}.
     */
    @JvmName("ewsfyiajpjbgglws")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value The ID of the dedicated block storage cluster. If you want to use disks in a dedicated block storage cluster as system disks when you create instances, you must specify this parameter. For more information about dedicated block storage clusters.
     */
    @JvmName("xqndajlipkmatvyv")
    public suspend fun systemDiskStorageClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskStorageClusterId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("nbntqiuinpwhnrop")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("nvpsiqcskshkdgwu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value User-defined data to customize the startup behaviors of an ECS instance and to pass data into an ECS instance.
     * It supports to setting a base64-encoded value, and it is the recommended usage.
     * From version 1.60.0, it can be updated in-place. If updated, the instance will reboot to make the change take effect.
     * Note: Not all changes will take effect, and it depends on [cloud-init module type](https://cloudinit.readthedocs.io/en/latest/topics/modules.html).
     */
    @JvmName("vaooivmxiedlottb")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value A mapping of tags to assign to the devices created by the instance at launch time.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("kywmohuvdqpjxsay")
    public suspend fun volumeTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the devices created by the instance at launch time.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("srlkmjtrprhelegg")
    public fun volumeTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("uexjtuvagwvgkbar")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch in VPC. This parameter must be set unless you can create classic network instances. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("sgdwjykkpnddyree")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        allocatePublicIp = allocatePublicIp,
        autoReleaseTime = autoReleaseTime,
        autoRenewPeriod = autoRenewPeriod,
        availabilityZone = availabilityZone,
        creditSpecification = creditSpecification,
        dataDisks = dataDisks,
        dedicatedHostId = dedicatedHostId,
        deletionProtection = deletionProtection,
        deploymentSetId = deploymentSetId,
        description = description,
        dryRun = dryRun,
        enableJumboFrame = enableJumboFrame,
        forceDelete = forceDelete,
        hostName = hostName,
        hpcClusterId = hpcClusterId,
        httpEndpoint = httpEndpoint,
        httpPutResponseHopLimit = httpPutResponseHopLimit,
        httpTokens = httpTokens,
        imageId = imageId,
        includeDataDisks = includeDataDisks,
        instanceChargeType = instanceChargeType,
        instanceName = instanceName,
        instanceType = instanceType,
        internetChargeType = internetChargeType,
        internetMaxBandwidthIn = internetMaxBandwidthIn,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        isOutdated = isOutdated,
        keyName = keyName,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        launchTemplateId = launchTemplateId,
        launchTemplateName = launchTemplateName,
        launchTemplateVersion = launchTemplateVersion,
        maintenanceAction = maintenanceAction,
        maintenanceNotify = maintenanceNotify,
        maintenanceTime = maintenanceTime,
        networkCardIndex = networkCardIndex,
        networkInterfaceTrafficMode = networkInterfaceTrafficMode,
        networkInterfaces = networkInterfaces,
        operatorType = operatorType,
        password = password,
        period = period,
        periodUnit = periodUnit,
        privateIp = privateIp,
        queuePairNumber = queuePairNumber,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        roleName = roleName,
        secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount,
        secondaryPrivateIps = secondaryPrivateIps,
        securityEnhancementStrategy = securityEnhancementStrategy,
        securityGroups = securityGroups,
        spotDuration = spotDuration,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        status = status,
        stoppedMode = stoppedMode,
        systemDiskAutoSnapshotPolicyId = systemDiskAutoSnapshotPolicyId,
        systemDiskCategory = systemDiskCategory,
        systemDiskDescription = systemDiskDescription,
        systemDiskEncryptAlgorithm = systemDiskEncryptAlgorithm,
        systemDiskEncrypted = systemDiskEncrypted,
        systemDiskKmsKeyId = systemDiskKmsKeyId,
        systemDiskName = systemDiskName,
        systemDiskPerformanceLevel = systemDiskPerformanceLevel,
        systemDiskSize = systemDiskSize,
        systemDiskStorageClusterId = systemDiskStorageClusterId,
        tags = tags,
        userData = userData,
        volumeTags = volumeTags,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
