@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [KeyPair].
 */
@PulumiTagMarker
public class KeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairArgs = KeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairArgsBuilder.() -> Unit) {
        val builder = KeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyPair {
        val builtJavaResource = com.pulumi.alicloud.ecs.KeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPair(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsKeyPair from version 1.121.0.
 * Provides a key pair resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const basic = new alicloud.ecs.KeyPair("basic", {keyName: "terraform-test-key-pair"});
 * // Using name prefix to build key pair
 * const prefix = new alicloud.ecs.KeyPair("prefix", {keyNamePrefix: "terraform-test-key-pair-prefix"});
 * // Import an existing public key to build a alicloud key pair
 * const publickey = new alicloud.ecs.KeyPair("publickey", {
 *     keyName: "my_public_key",
 *     publicKey: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * basic = alicloud.ecs.KeyPair("basic", key_name="terraform-test-key-pair")
 * # Using name prefix to build key pair
 * prefix = alicloud.ecs.KeyPair("prefix", key_name_prefix="terraform-test-key-pair-prefix")
 * # Import an existing public key to build a alicloud key pair
 * publickey = alicloud.ecs.KeyPair("publickey",
 *     key_name="my_public_key",
 *     public_key="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var basic = new AliCloud.Ecs.KeyPair("basic", new()
 *     {
 *         KeyName = "terraform-test-key-pair",
 *     });
 *     // Using name prefix to build key pair
 *     var prefix = new AliCloud.Ecs.KeyPair("prefix", new()
 *     {
 *         KeyNamePrefix = "terraform-test-key-pair-prefix",
 *     });
 *     // Import an existing public key to build a alicloud key pair
 *     var publickey = new AliCloud.Ecs.KeyPair("publickey", new()
 *     {
 *         KeyName = "my_public_key",
 *         PublicKey = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewKeyPair(ctx, "basic", &ecs.KeyPairArgs{
 * 			KeyName: pulumi.String("terraform-test-key-pair"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Using name prefix to build key pair
 * 		_, err = ecs.NewKeyPair(ctx, "prefix", &ecs.KeyPairArgs{
 * 			KeyNamePrefix: pulumi.String("terraform-test-key-pair-prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Import an existing public key to build a alicloud key pair
 * 		_, err = ecs.NewKeyPair(ctx, "publickey", &ecs.KeyPairArgs{
 * 			KeyName:   pulumi.String("my_public_key"),
 * 			PublicKey: pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.KeyPair;
 * import com.pulumi.alicloud.ecs.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var basic = new KeyPair("basic", KeyPairArgs.builder()
 *             .keyName("terraform-test-key-pair")
 *             .build());
 *         // Using name prefix to build key pair
 *         var prefix = new KeyPair("prefix", KeyPairArgs.builder()
 *             .keyNamePrefix("terraform-test-key-pair-prefix")
 *             .build());
 *         // Import an existing public key to build a alicloud key pair
 *         var publickey = new KeyPair("publickey", KeyPairArgs.builder()
 *             .keyName("my_public_key")
 *             .publicKey("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   basic:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyName: terraform-test-key-pair
 *   # Using name prefix to build key pair
 *   prefix:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyNamePrefix: terraform-test-key-pair-prefix
 *   # Import an existing public key to build a alicloud key pair
 *   publickey:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyName: my_public_key
 *       publicKey: ssh-rsa AAAAB3Nza12345678qwertyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Key pair can be imported using the name, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/keyPair:KeyPair example my_public_key
 * ```
 */
public class KeyPair internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.KeyPair,
) : KotlinCustomResource(javaResource, KeyPairMapper) {
    public val fingerPrint: Output<String>
        get() = javaResource.fingerPrint().applyValue({ args0 -> args0 })

    /**
     * The name of file to save your new key pair's private key. Strongly suggest you to specified it when you creating key pair, otherwise, you wouldn't get its private key ever.
     */
    public val keyFile: Output<String>?
        get() = javaResource.keyFile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The key pair's name. It is the only in one Alicloud account.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    public val keyNamePrefix: Output<String>?
        get() = javaResource.keyNamePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val keyPairName: Output<String>
        get() = javaResource.keyPairName().applyValue({ args0 -> args0 })

    /**
     * You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Id of resource group which the key pair belongs.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object KeyPairMapper : ResourceMapper<KeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.KeyPair::class == javaResource::class

    override fun map(javaResource: Resource): KeyPair = KeyPair(
        javaResource as
            com.pulumi.alicloud.ecs.KeyPair,
    )
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPair].
 */
public suspend fun keyPair(name: String, block: suspend KeyPairResourceBuilder.() -> Unit): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPair(name: String): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
