@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.KeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsKeyPair from version 1.121.0.
 * Provides a key pair resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const basic = new alicloud.ecs.KeyPair("basic", {keyName: "terraform-test-key-pair"});
 * // Using name prefix to build key pair
 * const prefix = new alicloud.ecs.KeyPair("prefix", {keyNamePrefix: "terraform-test-key-pair-prefix"});
 * // Import an existing public key to build a alicloud key pair
 * const publickey = new alicloud.ecs.KeyPair("publickey", {
 *     keyName: "my_public_key",
 *     publicKey: "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * basic = alicloud.ecs.KeyPair("basic", key_name="terraform-test-key-pair")
 * # Using name prefix to build key pair
 * prefix = alicloud.ecs.KeyPair("prefix", key_name_prefix="terraform-test-key-pair-prefix")
 * # Import an existing public key to build a alicloud key pair
 * publickey = alicloud.ecs.KeyPair("publickey",
 *     key_name="my_public_key",
 *     public_key="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var basic = new AliCloud.Ecs.KeyPair("basic", new()
 *     {
 *         KeyName = "terraform-test-key-pair",
 *     });
 *     // Using name prefix to build key pair
 *     var prefix = new AliCloud.Ecs.KeyPair("prefix", new()
 *     {
 *         KeyNamePrefix = "terraform-test-key-pair-prefix",
 *     });
 *     // Import an existing public key to build a alicloud key pair
 *     var publickey = new AliCloud.Ecs.KeyPair("publickey", new()
 *     {
 *         KeyName = "my_public_key",
 *         PublicKey = "ssh-rsa AAAAB3Nza12345678qwertyuudsfsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewKeyPair(ctx, "basic", &ecs.KeyPairArgs{
 * 			KeyName: pulumi.String("terraform-test-key-pair"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Using name prefix to build key pair
 * 		_, err = ecs.NewKeyPair(ctx, "prefix", &ecs.KeyPairArgs{
 * 			KeyNamePrefix: pulumi.String("terraform-test-key-pair-prefix"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Import an existing public key to build a alicloud key pair
 * 		_, err = ecs.NewKeyPair(ctx, "publickey", &ecs.KeyPairArgs{
 * 			KeyName:   pulumi.String("my_public_key"),
 * 			PublicKey: pulumi.String("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.KeyPair;
 * import com.pulumi.alicloud.ecs.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var basic = new KeyPair("basic", KeyPairArgs.builder()
 *             .keyName("terraform-test-key-pair")
 *             .build());
 *         // Using name prefix to build key pair
 *         var prefix = new KeyPair("prefix", KeyPairArgs.builder()
 *             .keyNamePrefix("terraform-test-key-pair-prefix")
 *             .build());
 *         // Import an existing public key to build a alicloud key pair
 *         var publickey = new KeyPair("publickey", KeyPairArgs.builder()
 *             .keyName("my_public_key")
 *             .publicKey("ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   basic:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyName: terraform-test-key-pair
 *   # Using name prefix to build key pair
 *   prefix:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyNamePrefix: terraform-test-key-pair-prefix
 *   # Import an existing public key to build a alicloud key pair
 *   publickey:
 *     type: alicloud:ecs:KeyPair
 *     properties:
 *       keyName: my_public_key
 *       publicKey: ssh-rsa AAAAB3Nza12345678qwertyuudsfsg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Key pair can be imported using the name, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/keyPair:KeyPair example my_public_key
 * ```
 * @property keyFile The name of file to save your new key pair's private key. Strongly suggest you to specified it when you creating key pair, otherwise, you wouldn't get its private key ever.
 * @property keyName The key pair's name. It is the only in one Alicloud account.
 * @property keyNamePrefix
 * @property keyPairName
 * @property publicKey You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
 * @property resourceGroupId The Id of resource group which the key pair belongs.
 * @property tags
 */
public data class KeyPairArgs(
    public val keyFile: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>? = null,
    public val keyNamePrefix: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.KeyPairArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.KeyPairArgs =
        com.pulumi.alicloud.ecs.KeyPairArgs.builder()
            .keyFile(keyFile?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyNamePrefix(keyNamePrefix?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KeyPairArgs].
 */
@PulumiTagMarker
public class KeyPairArgsBuilder internal constructor() {
    private var keyFile: Output<String>? = null

    private var keyName: Output<String>? = null

    private var keyNamePrefix: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of file to save your new key pair's private key. Strongly suggest you to specified it when you creating key pair, otherwise, you wouldn't get its private key ever.
     */
    @JvmName("knntfgvpmpdhwyxu")
    public suspend fun keyFile(`value`: Output<String>) {
        this.keyFile = value
    }

    /**
     * @param value The key pair's name. It is the only in one Alicloud account.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("jvpqhrqgpovmlqxv")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value
     */
    @JvmName("wvqaerxqyluexqmh")
    public suspend fun keyNamePrefix(`value`: Output<String>) {
        this.keyNamePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("barjwtbvhesraemx")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    @JvmName("qcfvabqlpmnmwdmr")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The Id of resource group which the key pair belongs.
     */
    @JvmName("ushtfwpkfuvqnatm")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("cbuenkgqddeeultf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of file to save your new key pair's private key. Strongly suggest you to specified it when you creating key pair, otherwise, you wouldn't get its private key ever.
     */
    @JvmName("armvqycdikyjfbsk")
    public suspend fun keyFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFile = mapped
    }

    /**
     * @param value The key pair's name. It is the only in one Alicloud account.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("kxjrksccypstjwdp")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bfbgefdiefxafeyc")
    public suspend fun keyNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyNamePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqtlbcbabuhddrkr")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value You can import an existing public key and using Alicloud key pair to manage it. If this parameter is specified, `resource_group_id` is the key pair belongs.
     */
    @JvmName("feqdxbmqjjgrvujx")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The Id of resource group which the key pair belongs.
     */
    @JvmName("kwkqkaxvvcegeylr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("iilrywoxoknokngq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("miwcpfxnrimoeymx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KeyPairArgs = KeyPairArgs(
        keyFile = keyFile,
        keyName = keyName,
        keyNamePrefix = keyNamePrefix,
        keyPairName = keyPairName,
        publicKey = publicKey,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
