@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KeyPairAttachment].
 */
@PulumiTagMarker
public class KeyPairAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairAttachmentArgs = KeyPairAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairAttachmentArgsBuilder.() -> Unit) {
        val builder = KeyPairAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyPairAttachment {
        val builtJavaResource = com.pulumi.alicloud.ecs.KeyPairAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPairAttachment(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsKeyPairAttachment from version 1.121.0.
 * Provides a key pair attachment resource to bind key pair for several ECS instances.
 * > **NOTE:** After the key pair is attached with sone instances, there instances must be rebooted to make the key pair affect.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.KeyPair;
 * import com.pulumi.alicloud.ecs.KeyPairArgs;
 * import com.pulumi.alicloud.ecs.KeyPairAttachment;
 * import com.pulumi.alicloud.ecs.KeyPairAttachmentArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_ssd")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var type = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .avaiabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var images = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var name = config.get("name").orElse("keyPairAttachmentName");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description("New security group")
 *             .vpcId(vpc.id())
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new Instance("instance-" + i, InstanceArgs.builder()
 *                 .instanceName(String.format("%s-%s", name,range.value() + 1))
 *                 .imageId(images.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *                 .instanceType(type.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *                 .securityGroups(group.id())
 *                 .vswitchId(vswitch.id())
 *                 .internetChargeType("PayByTraffic")
 *                 .internetMaxBandwidthOut(5)
 *                 .password("Test12345")
 *                 .instanceChargeType("PostPaid")
 *                 .systemDiskCategory("cloud_ssd")
 *                 .build());
 * }
 *         var pair = new KeyPair("pair", KeyPairArgs.builder()
 *             .keyName(name)
 *             .build());
 *         var attachment = new KeyPairAttachment("attachment", KeyPairAttachmentArgs.builder()
 *             .keyName(pair.id())
 *             .instanceIds(instance.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class KeyPairAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.KeyPairAttachment,
) : KotlinCustomResource(javaResource, KeyPairAttachmentMapper) {
    /**
     * Set it to true and it will reboot instances which attached with the key pair to make key pair affect immediately.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of ECS instance's IDs.
     */
    public val instanceIds: Output<List<String>>
        get() = javaResource.instanceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of key pair used to bind.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    public val keyPairName: Output<String>
        get() = javaResource.keyPairName().applyValue({ args0 -> args0 })
}

public object KeyPairAttachmentMapper : ResourceMapper<KeyPairAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.KeyPairAttachment::class == javaResource::class

    override fun map(javaResource: Resource): KeyPairAttachment = KeyPairAttachment(
        javaResource as
            com.pulumi.alicloud.ecs.KeyPairAttachment,
    )
}

/**
 * @see [KeyPairAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPairAttachment].
 */
public suspend fun keyPairAttachment(
    name: String,
    block: suspend KeyPairAttachmentResourceBuilder.() -> Unit,
): KeyPairAttachment {
    val builder = KeyPairAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPairAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPairAttachment(name: String): KeyPairAttachment {
    val builder = KeyPairAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
