@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.KeyPairAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsKeyPairAttachment from version 1.121.0.
 * Provides a key pair attachment resource to bind key pair for several ECS instances.
 * > **NOTE:** After the key pair is attached with sone instances, there instances must be rebooted to make the key pair affect.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ecs.KeyPair;
 * import com.pulumi.alicloud.ecs.KeyPairArgs;
 * import com.pulumi.alicloud.ecs.KeyPairAttachment;
 * import com.pulumi.alicloud.ecs.KeyPairAttachmentArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_ssd")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var type = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .avaiabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var images = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var name = config.get("name").orElse("keyPairAttachmentName");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var vswitch = new Switch("vswitch", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description("New security group")
 *             .vpcId(vpc.id())
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new Instance("instance-" + i, InstanceArgs.builder()
 *                 .instanceName(String.format("%s-%s", name,range.value() + 1))
 *                 .imageId(images.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *                 .instanceType(type.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *                 .securityGroups(group.id())
 *                 .vswitchId(vswitch.id())
 *                 .internetChargeType("PayByTraffic")
 *                 .internetMaxBandwidthOut(5)
 *                 .password("Test12345")
 *                 .instanceChargeType("PostPaid")
 *                 .systemDiskCategory("cloud_ssd")
 *                 .build());
 * }
 *         var pair = new KeyPair("pair", KeyPairArgs.builder()
 *             .keyName(name)
 *             .build());
 *         var attachment = new KeyPairAttachment("attachment", KeyPairAttachmentArgs.builder()
 *             .keyName(pair.id())
 *             .instanceIds(instance.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * @property force Set it to true and it will reboot instances which attached with the key pair to make key pair affect immediately.
 * @property instanceIds The list of ECS instance's IDs.
 * @property keyName The name of key pair used to bind.
 * @property keyPairName
 */
public data class KeyPairAttachmentArgs(
    public val force: Output<Boolean>? = null,
    public val instanceIds: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    public val keyName: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.KeyPairAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.KeyPairAttachmentArgs =
        com.pulumi.alicloud.ecs.KeyPairAttachmentArgs.builder()
            .force(force?.applyValue({ args0 -> args0 }))
            .instanceIds(instanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPairAttachmentArgs].
 */
@PulumiTagMarker
public class KeyPairAttachmentArgsBuilder internal constructor() {
    private var force: Output<Boolean>? = null

    private var instanceIds: Output<List<String>>? = null

    private var keyName: Output<String>? = null

    private var keyPairName: Output<String>? = null

    /**
     * @param value Set it to true and it will reboot instances which attached with the key pair to make key pair affect immediately.
     */
    @JvmName("giagdqpfiocklfah")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The list of ECS instance's IDs.
     */
    @JvmName("dafrsfvjexnuilbi")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("xswdbftbotvoohkw")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values The list of ECS instance's IDs.
     */
    @JvmName("bomoiskgsgwlvvvv")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value The name of key pair used to bind.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("vwdrixtkbxlayeku")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value
     */
    @JvmName("mfmqcsvvqubireuo")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value Set it to true and it will reboot instances which attached with the key pair to make key pair affect immediately.
     */
    @JvmName("fodoqnfqwiytpbcm")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The list of ECS instance's IDs.
     */
    @JvmName("etjxuvwpqsnlxjdg")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values The list of ECS instance's IDs.
     */
    @JvmName("lqdutbvryvoclabw")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value The name of key pair used to bind.
     */
    @Deprecated(
        message = """
  Field 'key_name' has been deprecated from provider version 1.121.0. New field 'key_pair_name'
      instead.
  """,
    )
    @JvmName("tuaqblpgwtmtiysd")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vxjplgahqrkerxln")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    internal fun build(): KeyPairAttachmentArgs = KeyPairAttachmentArgs(
        force = force,
        instanceIds = instanceIds,
        keyName = keyName,
        keyPairName = keyPairName,
    )
}
