@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateDataDisk
import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateNetworkInterfaces
import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateSystemDisk
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateDataDisk.Companion.toKotlin as launchTemplateDataDiskToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateNetworkInterfaces.Companion.toKotlin as launchTemplateNetworkInterfacesToKotlin
import com.pulumi.alicloud.ecs.kotlin.outputs.LaunchTemplateSystemDisk.Companion.toKotlin as launchTemplateSystemDiskToKotlin

/**
 * Builder for [LaunchTemplate].
 */
@PulumiTagMarker
public class LaunchTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LaunchTemplateArgs = LaunchTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LaunchTemplateArgsBuilder.() -> Unit) {
        val builder = LaunchTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LaunchTemplate {
        val builtJavaResource = com.pulumi.alicloud.ecs.LaunchTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LaunchTemplate(builtJavaResource)
    }
}

/**
 * Provides an ECS Launch Template resource.
 * For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const images = alicloud.ecs.getImages({
 *     owners: "system",
 * });
 * const instances = alicloud.ecs.getInstances({});
 * const template = new alicloud.ecs.LaunchTemplate("template", {
 *     name: "tf-test-template",
 *     description: "test1",
 *     imageId: images.then(images => images.images?.[0]?.id),
 *     hostName: "tf-test-host",
 *     instanceChargeType: "PrePaid",
 *     instanceName: "tf-instance-name",
 *     instanceType: instances.then(instances => instances.instances?.[0]?.instanceType),
 *     internetChargeType: "PayByBandwidth",
 *     internetMaxBandwidthIn: 5,
 *     internetMaxBandwidthOut: 0,
 *     ioOptimized: "none",
 *     keyPairName: "test-key-pair",
 *     ramRoleName: "xxxxx",
 *     networkType: "vpc",
 *     securityEnhancementStrategy: "Active",
 *     spotPriceLimit: 5,
 *     spotStrategy: "SpotWithPriceLimit",
 *     securityGroupId: "sg-zxcvj0lasdf102350asdf9a",
 *     systemDiskCategory: "cloud_ssd",
 *     systemDiskDescription: "test disk",
 *     systemDiskName: "hello",
 *     systemDiskSize: 40,
 *     resourceGroupId: "rg-zkdfjahg9zxncv0",
 *     userdata: "xxxxxxxxxxxxxx",
 *     vswitchId: "sw-ljkngaksdjfj0nnasdf",
 *     vpcId: "vpc-asdfnbg0as8dfk1nb2",
 *     zoneId: "beijing-a",
 *     tags: {
 *         tag1: "hello",
 *         tag2: "world",
 *     },
 *     networkInterfaces: {
 *         name: "eth0",
 *         description: "hello1",
 *         primaryIp: "10.0.0.2",
 *         securityGroupId: "xxxx",
 *         vswitchId: "xxxxxxx",
 *     },
 *     dataDisks: [
 *         {
 *             name: "disk1",
 *             description: "test1",
 *         },
 *         {
 *             name: "disk2",
 *             description: "test2",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * images = alicloud.ecs.get_images(owners="system")
 * instances = alicloud.ecs.get_instances()
 * template = alicloud.ecs.LaunchTemplate("template",
 *     name="tf-test-template",
 *     description="test1",
 *     image_id=images.images[0].id,
 *     host_name="tf-test-host",
 *     instance_charge_type="PrePaid",
 *     instance_name="tf-instance-name",
 *     instance_type=instances.instances[0].instance_type,
 *     internet_charge_type="PayByBandwidth",
 *     internet_max_bandwidth_in=5,
 *     internet_max_bandwidth_out=0,
 *     io_optimized="none",
 *     key_pair_name="test-key-pair",
 *     ram_role_name="xxxxx",
 *     network_type="vpc",
 *     security_enhancement_strategy="Active",
 *     spot_price_limit=5,
 *     spot_strategy="SpotWithPriceLimit",
 *     security_group_id="sg-zxcvj0lasdf102350asdf9a",
 *     system_disk_category="cloud_ssd",
 *     system_disk_description="test disk",
 *     system_disk_name="hello",
 *     system_disk_size=40,
 *     resource_group_id="rg-zkdfjahg9zxncv0",
 *     userdata="xxxxxxxxxxxxxx",
 *     vswitch_id="sw-ljkngaksdjfj0nnasdf",
 *     vpc_id="vpc-asdfnbg0as8dfk1nb2",
 *     zone_id="beijing-a",
 *     tags={
 *         "tag1": "hello",
 *         "tag2": "world",
 *     },
 *     network_interfaces={
 *         "name": "eth0",
 *         "description": "hello1",
 *         "primary_ip": "10.0.0.2",
 *         "security_group_id": "xxxx",
 *         "vswitch_id": "xxxxxxx",
 *     },
 *     data_disks=[
 *         {
 *             "name": "disk1",
 *             "description": "test1",
 *         },
 *         {
 *             "name": "disk2",
 *             "description": "test2",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var images = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         Owners = "system",
 *     });
 *     var instances = AliCloud.Ecs.GetInstances.Invoke();
 *     var template = new AliCloud.Ecs.LaunchTemplate("template", new()
 *     {
 *         Name = "tf-test-template",
 *         Description = "test1",
 *         ImageId = images.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         HostName = "tf-test-host",
 *         InstanceChargeType = "PrePaid",
 *         InstanceName = "tf-instance-name",
 *         InstanceType = instances.Apply(getInstancesResult => getInstancesResult.Instances[0]?.InstanceType),
 *         InternetChargeType = "PayByBandwidth",
 *         InternetMaxBandwidthIn = 5,
 *         InternetMaxBandwidthOut = 0,
 *         IoOptimized = "none",
 *         KeyPairName = "test-key-pair",
 *         RamRoleName = "xxxxx",
 *         NetworkType = "vpc",
 *         SecurityEnhancementStrategy = "Active",
 *         SpotPriceLimit = 5,
 *         SpotStrategy = "SpotWithPriceLimit",
 *         SecurityGroupId = "sg-zxcvj0lasdf102350asdf9a",
 *         SystemDiskCategory = "cloud_ssd",
 *         SystemDiskDescription = "test disk",
 *         SystemDiskName = "hello",
 *         SystemDiskSize = 40,
 *         ResourceGroupId = "rg-zkdfjahg9zxncv0",
 *         Userdata = "xxxxxxxxxxxxxx",
 *         VswitchId = "sw-ljkngaksdjfj0nnasdf",
 *         VpcId = "vpc-asdfnbg0as8dfk1nb2",
 *         ZoneId = "beijing-a",
 *         Tags =
 *         {
 *             { "tag1", "hello" },
 *             { "tag2", "world" },
 *         },
 *         NetworkInterfaces = new AliCloud.Ecs.Inputs.LaunchTemplateNetworkInterfacesArgs
 *         {
 *             Name = "eth0",
 *             Description = "hello1",
 *             PrimaryIp = "10.0.0.2",
 *             SecurityGroupId = "xxxx",
 *             VswitchId = "xxxxxxx",
 *         },
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.LaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk1",
 *                 Description = "test1",
 *             },
 *             new AliCloud.Ecs.Inputs.LaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Description = "test2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		images, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			Owners: pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instances, err := ecs.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewLaunchTemplate(ctx, "template", &ecs.LaunchTemplateArgs{
 * 			Name:                        pulumi.String("tf-test-template"),
 * 			Description:                 pulumi.String("test1"),
 * 			ImageId:                     pulumi.String(images.Images[0].Id),
 * 			HostName:                    pulumi.String("tf-test-host"),
 * 			InstanceChargeType:          pulumi.String("PrePaid"),
 * 			InstanceName:                pulumi.String("tf-instance-name"),
 * 			InstanceType:                pulumi.String(instances.Instances[0].InstanceType),
 * 			InternetChargeType:          pulumi.String("PayByBandwidth"),
 * 			InternetMaxBandwidthIn:      pulumi.Int(5),
 * 			InternetMaxBandwidthOut:     pulumi.Int(0),
 * 			IoOptimized:                 pulumi.String("none"),
 * 			KeyPairName:                 pulumi.String("test-key-pair"),
 * 			RamRoleName:                 pulumi.String("xxxxx"),
 * 			NetworkType:                 pulumi.String("vpc"),
 * 			SecurityEnhancementStrategy: pulumi.String("Active"),
 * 			SpotPriceLimit:              pulumi.Float64(5),
 * 			SpotStrategy:                pulumi.String("SpotWithPriceLimit"),
 * 			SecurityGroupId:             pulumi.String("sg-zxcvj0lasdf102350asdf9a"),
 * 			SystemDiskCategory:          pulumi.String("cloud_ssd"),
 * 			SystemDiskDescription:       pulumi.String("test disk"),
 * 			SystemDiskName:              pulumi.String("hello"),
 * 			SystemDiskSize:              pulumi.Int(40),
 * 			ResourceGroupId:             pulumi.String("rg-zkdfjahg9zxncv0"),
 * 			Userdata:                    pulumi.String("xxxxxxxxxxxxxx"),
 * 			VswitchId:                   pulumi.String("sw-ljkngaksdjfj0nnasdf"),
 * 			VpcId:                       pulumi.String("vpc-asdfnbg0as8dfk1nb2"),
 * 			ZoneId:                      pulumi.String("beijing-a"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("hello"),
 * 				"tag2": pulumi.String("world"),
 * 			},
 * 			NetworkInterfaces: &ecs.LaunchTemplateNetworkInterfacesArgs{
 * 				Name:            pulumi.String("eth0"),
 * 				Description:     pulumi.String("hello1"),
 * 				PrimaryIp:       pulumi.String("10.0.0.2"),
 * 				SecurityGroupId: pulumi.String("xxxx"),
 * 				VswitchId:       pulumi.String("xxxxxxx"),
 * 			},
 * 			DataDisks: ecs.LaunchTemplateDataDiskArray{
 * 				&ecs.LaunchTemplateDataDiskArgs{
 * 					Name:        pulumi.String("disk1"),
 * 					Description: pulumi.String("test1"),
 * 				},
 * 				&ecs.LaunchTemplateDataDiskArgs{
 * 					Name:        pulumi.String("disk2"),
 * 					Description: pulumi.String("test2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.ecs.LaunchTemplate;
 * import com.pulumi.alicloud.ecs.LaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs;
 * import com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var images = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .owners("system")
 *             .build());
 *         final var instances = EcsFunctions.getInstances();
 *         var template = new LaunchTemplate("template", LaunchTemplateArgs.builder()
 *             .name("tf-test-template")
 *             .description("test1")
 *             .imageId(images.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .hostName("tf-test-host")
 *             .instanceChargeType("PrePaid")
 *             .instanceName("tf-instance-name")
 *             .instanceType(instances.applyValue(getInstancesResult -> getInstancesResult.instances()[0].instanceType()))
 *             .internetChargeType("PayByBandwidth")
 *             .internetMaxBandwidthIn(5)
 *             .internetMaxBandwidthOut(0)
 *             .ioOptimized("none")
 *             .keyPairName("test-key-pair")
 *             .ramRoleName("xxxxx")
 *             .networkType("vpc")
 *             .securityEnhancementStrategy("Active")
 *             .spotPriceLimit(5)
 *             .spotStrategy("SpotWithPriceLimit")
 *             .securityGroupId("sg-zxcvj0lasdf102350asdf9a")
 *             .systemDiskCategory("cloud_ssd")
 *             .systemDiskDescription("test disk")
 *             .systemDiskName("hello")
 *             .systemDiskSize(40)
 *             .resourceGroupId("rg-zkdfjahg9zxncv0")
 *             .userdata("xxxxxxxxxxxxxx")
 *             .vswitchId("sw-ljkngaksdjfj0nnasdf")
 *             .vpcId("vpc-asdfnbg0as8dfk1nb2")
 *             .zoneId("beijing-a")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "hello"),
 *                 Map.entry("tag2", "world")
 *             ))
 *             .networkInterfaces(LaunchTemplateNetworkInterfacesArgs.builder()
 *                 .name("eth0")
 *                 .description("hello1")
 *                 .primaryIp("10.0.0.2")
 *                 .securityGroupId("xxxx")
 *                 .vswitchId("xxxxxxx")
 *                 .build())
 *             .dataDisks(
 *                 LaunchTemplateDataDiskArgs.builder()
 *                     .name("disk1")
 *                     .description("test1")
 *                     .build(),
 *                 LaunchTemplateDataDiskArgs.builder()
 *                     .name("disk2")
 *                     .description("test2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   template:
 *     type: alicloud:ecs:LaunchTemplate
 *     properties:
 *       name: tf-test-template
 *       description: test1
 *       imageId: ${images.images[0].id}
 *       hostName: tf-test-host
 *       instanceChargeType: PrePaid
 *       instanceName: tf-instance-name
 *       instanceType: ${instances.instances[0].instanceType}
 *       internetChargeType: PayByBandwidth
 *       internetMaxBandwidthIn: 5
 *       internetMaxBandwidthOut: 0
 *       ioOptimized: none
 *       keyPairName: test-key-pair
 *       ramRoleName: xxxxx
 *       networkType: vpc
 *       securityEnhancementStrategy: Active
 *       spotPriceLimit: 5
 *       spotStrategy: SpotWithPriceLimit
 *       securityGroupId: sg-zxcvj0lasdf102350asdf9a
 *       systemDiskCategory: cloud_ssd
 *       systemDiskDescription: test disk
 *       systemDiskName: hello
 *       systemDiskSize: 40
 *       resourceGroupId: rg-zkdfjahg9zxncv0
 *       userdata: xxxxxxxxxxxxxx
 *       vswitchId: sw-ljkngaksdjfj0nnasdf
 *       vpcId: vpc-asdfnbg0as8dfk1nb2
 *       zoneId: beijing-a
 *       tags:
 *         tag1: hello
 *         tag2: world
 *       networkInterfaces:
 *         name: eth0
 *         description: hello1
 *         primaryIp: 10.0.0.2
 *         securityGroupId: xxxx
 *         vswitchId: xxxxxxx
 *       dataDisks:
 *         - name: disk1
 *           description: test1
 *         - name: disk2
 *           description: test2
 * variables:
 *   images:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         owners: system
 *   instances:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Launch Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
 * ```
 */
public class LaunchTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.LaunchTemplate,
) : KotlinCustomResource(javaResource, LaunchTemplateMapper) {
    /**
     * Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    public val autoReleaseTime: Output<String>?
        get() = javaResource.autoReleaseTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val autoRenew: Output<Boolean>
        get() = javaResource.autoRenew().applyValue({ args0 -> args0 })

    public val autoRenewPeriod: Output<Int>
        get() = javaResource.autoRenewPeriod().applyValue({ args0 -> args0 })

    /**
     * The list of data disks created with instance.
     */
    public val dataDisks: Output<List<LaunchTemplateDataDisk>>?
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> launchTemplateDataDiskToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val deploymentSetId: Output<String>?
        get() = javaResource.deploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableVmOsConfig: Output<Boolean>?
        get() = javaResource.enableVmOsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    public val hostName: Output<String>?
        get() = javaResource.hostName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Image ID.
     */
    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val imageOwnerAlias: Output<String>?
        get() = javaResource.imageOwnerAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Billing methods. Optional values:
     * - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
     * - PostPaid: Pay-As-You-Go.
     * Default value: PostPaid.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    public val internetMaxBandwidthIn: Output<Int>
        get() = javaResource.internetMaxBandwidthIn().applyValue({ args0 -> args0 })

    /**
     * Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    public val internetMaxBandwidthOut: Output<Int>?
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether it is an I/O-optimized instance or not. Optional values:
     * - none
     * - optimized
     */
    public val ioOptimized: Output<String>?
        get() = javaResource.ioOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val launchTemplateName: Output<String>
        get() = javaResource.launchTemplateName().applyValue({ args0 -> args0 })

    /**
     * Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of network interfaces created with instance.
     */
    public val networkInterfaces: Output<LaunchTemplateNetworkInterfaces>?
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateNetworkInterfacesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Network type of the instance. Value options: `classic` | `vpc`.
     */
    public val networkType: Output<String>?
        get() = javaResource.networkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val passwordInherit: Output<Boolean>?
        get() = javaResource.passwordInherit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    public val periodUnit: Output<String>
        get() = javaResource.periodUnit().applyValue({ args0 -> args0 })

    public val privateIpAddress: Output<String>?
        get() = javaResource.privateIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
     */
    public val securityEnhancementStrategy: Output<String>?
        get() = javaResource.securityEnhancementStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The security group ID.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val spotDuration: Output<String>?
        get() = javaResource.spotDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    public val spotPriceLimit: Output<Double>?
        get() = javaResource.spotPriceLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
     * - NoSpot: Normal Pay-As-You-Go instance.
     * - SpotWithPriceLimit: Sets the maximum price for a spot instance.
     * - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
     */
    public val spotStrategy: Output<String>?
        get() = javaResource.spotStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val systemDisk: Output<LaunchTemplateSystemDisk>
        get() = javaResource.systemDisk().applyValue({ args0 ->
            args0.let({ args0 ->
                launchTemplateSystemDiskToKotlin(args0)
            })
        })

    /**
     * The category of the system disk. System disk type. Optional values:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskCategory: Output<String>
        get() = javaResource.systemDiskCategory().applyValue({ args0 -> args0 })

    /**
     * System disk description. It cannot begin with http:// or https://.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskDescription: Output<String>
        get() = javaResource.systemDiskDescription().applyValue({ args0 -> args0 })

    /**
     * System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskName: Output<String>
        get() = javaResource.systemDiskName().applyValue({ args0 -> args0 })

    /**
     * Size of the system disk, measured in GB. Value range: [20, 500].
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskSize: Output<Int>
        get() = javaResource.systemDiskSize().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val templateResourceGroupId: Output<String>?
        get() = javaResource.templateResourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val templateTags: Output<Map<String, String>>?
        get() = javaResource.templateTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val userData: Output<String>
        get() = javaResource.userData().applyValue({ args0 -> args0 })

    /**
     * User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    public val userdata: Output<String>
        get() = javaResource.userdata().applyValue({ args0 -> args0 })

    public val versionDescription: Output<String>?
        get() = javaResource.versionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The zone ID of the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object LaunchTemplateMapper : ResourceMapper<LaunchTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.LaunchTemplate::class == javaResource::class

    override fun map(javaResource: Resource): LaunchTemplate = LaunchTemplate(
        javaResource as
            com.pulumi.alicloud.ecs.LaunchTemplate,
    )
}

/**
 * @see [LaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LaunchTemplate].
 */
public suspend fun launchTemplate(
    name: String,
    block: suspend LaunchTemplateResourceBuilder.() -> Unit,
): LaunchTemplate {
    val builder = LaunchTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun launchTemplate(name: String): LaunchTemplate {
    val builder = LaunchTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
