@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.LaunchTemplateArgs.builder
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateDataDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateDataDiskArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateNetworkInterfacesArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateNetworkInterfacesArgsBuilder
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateSystemDiskArgs
import com.pulumi.alicloud.ecs.kotlin.inputs.LaunchTemplateSystemDiskArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ECS Launch Template resource.
 * For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const images = alicloud.ecs.getImages({
 *     owners: "system",
 * });
 * const instances = alicloud.ecs.getInstances({});
 * const template = new alicloud.ecs.LaunchTemplate("template", {
 *     name: "tf-test-template",
 *     description: "test1",
 *     imageId: images.then(images => images.images?.[0]?.id),
 *     hostName: "tf-test-host",
 *     instanceChargeType: "PrePaid",
 *     instanceName: "tf-instance-name",
 *     instanceType: instances.then(instances => instances.instances?.[0]?.instanceType),
 *     internetChargeType: "PayByBandwidth",
 *     internetMaxBandwidthIn: 5,
 *     internetMaxBandwidthOut: 0,
 *     ioOptimized: "none",
 *     keyPairName: "test-key-pair",
 *     ramRoleName: "xxxxx",
 *     networkType: "vpc",
 *     securityEnhancementStrategy: "Active",
 *     spotPriceLimit: 5,
 *     spotStrategy: "SpotWithPriceLimit",
 *     securityGroupId: "sg-zxcvj0lasdf102350asdf9a",
 *     systemDiskCategory: "cloud_ssd",
 *     systemDiskDescription: "test disk",
 *     systemDiskName: "hello",
 *     systemDiskSize: 40,
 *     resourceGroupId: "rg-zkdfjahg9zxncv0",
 *     userdata: "xxxxxxxxxxxxxx",
 *     vswitchId: "sw-ljkngaksdjfj0nnasdf",
 *     vpcId: "vpc-asdfnbg0as8dfk1nb2",
 *     zoneId: "beijing-a",
 *     tags: {
 *         tag1: "hello",
 *         tag2: "world",
 *     },
 *     networkInterfaces: {
 *         name: "eth0",
 *         description: "hello1",
 *         primaryIp: "10.0.0.2",
 *         securityGroupId: "xxxx",
 *         vswitchId: "xxxxxxx",
 *     },
 *     dataDisks: [
 *         {
 *             name: "disk1",
 *             description: "test1",
 *         },
 *         {
 *             name: "disk2",
 *             description: "test2",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * images = alicloud.ecs.get_images(owners="system")
 * instances = alicloud.ecs.get_instances()
 * template = alicloud.ecs.LaunchTemplate("template",
 *     name="tf-test-template",
 *     description="test1",
 *     image_id=images.images[0].id,
 *     host_name="tf-test-host",
 *     instance_charge_type="PrePaid",
 *     instance_name="tf-instance-name",
 *     instance_type=instances.instances[0].instance_type,
 *     internet_charge_type="PayByBandwidth",
 *     internet_max_bandwidth_in=5,
 *     internet_max_bandwidth_out=0,
 *     io_optimized="none",
 *     key_pair_name="test-key-pair",
 *     ram_role_name="xxxxx",
 *     network_type="vpc",
 *     security_enhancement_strategy="Active",
 *     spot_price_limit=5,
 *     spot_strategy="SpotWithPriceLimit",
 *     security_group_id="sg-zxcvj0lasdf102350asdf9a",
 *     system_disk_category="cloud_ssd",
 *     system_disk_description="test disk",
 *     system_disk_name="hello",
 *     system_disk_size=40,
 *     resource_group_id="rg-zkdfjahg9zxncv0",
 *     userdata="xxxxxxxxxxxxxx",
 *     vswitch_id="sw-ljkngaksdjfj0nnasdf",
 *     vpc_id="vpc-asdfnbg0as8dfk1nb2",
 *     zone_id="beijing-a",
 *     tags={
 *         "tag1": "hello",
 *         "tag2": "world",
 *     },
 *     network_interfaces={
 *         "name": "eth0",
 *         "description": "hello1",
 *         "primary_ip": "10.0.0.2",
 *         "security_group_id": "xxxx",
 *         "vswitch_id": "xxxxxxx",
 *     },
 *     data_disks=[
 *         {
 *             "name": "disk1",
 *             "description": "test1",
 *         },
 *         {
 *             "name": "disk2",
 *             "description": "test2",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var images = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         Owners = "system",
 *     });
 *     var instances = AliCloud.Ecs.GetInstances.Invoke();
 *     var template = new AliCloud.Ecs.LaunchTemplate("template", new()
 *     {
 *         Name = "tf-test-template",
 *         Description = "test1",
 *         ImageId = images.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         HostName = "tf-test-host",
 *         InstanceChargeType = "PrePaid",
 *         InstanceName = "tf-instance-name",
 *         InstanceType = instances.Apply(getInstancesResult => getInstancesResult.Instances[0]?.InstanceType),
 *         InternetChargeType = "PayByBandwidth",
 *         InternetMaxBandwidthIn = 5,
 *         InternetMaxBandwidthOut = 0,
 *         IoOptimized = "none",
 *         KeyPairName = "test-key-pair",
 *         RamRoleName = "xxxxx",
 *         NetworkType = "vpc",
 *         SecurityEnhancementStrategy = "Active",
 *         SpotPriceLimit = 5,
 *         SpotStrategy = "SpotWithPriceLimit",
 *         SecurityGroupId = "sg-zxcvj0lasdf102350asdf9a",
 *         SystemDiskCategory = "cloud_ssd",
 *         SystemDiskDescription = "test disk",
 *         SystemDiskName = "hello",
 *         SystemDiskSize = 40,
 *         ResourceGroupId = "rg-zkdfjahg9zxncv0",
 *         Userdata = "xxxxxxxxxxxxxx",
 *         VswitchId = "sw-ljkngaksdjfj0nnasdf",
 *         VpcId = "vpc-asdfnbg0as8dfk1nb2",
 *         ZoneId = "beijing-a",
 *         Tags =
 *         {
 *             { "tag1", "hello" },
 *             { "tag2", "world" },
 *         },
 *         NetworkInterfaces = new AliCloud.Ecs.Inputs.LaunchTemplateNetworkInterfacesArgs
 *         {
 *             Name = "eth0",
 *             Description = "hello1",
 *             PrimaryIp = "10.0.0.2",
 *             SecurityGroupId = "xxxx",
 *             VswitchId = "xxxxxxx",
 *         },
 *         DataDisks = new[]
 *         {
 *             new AliCloud.Ecs.Inputs.LaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk1",
 *                 Description = "test1",
 *             },
 *             new AliCloud.Ecs.Inputs.LaunchTemplateDataDiskArgs
 *             {
 *                 Name = "disk2",
 *                 Description = "test2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		images, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			Owners: pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instances, err := ecs.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewLaunchTemplate(ctx, "template", &ecs.LaunchTemplateArgs{
 * 			Name:                        pulumi.String("tf-test-template"),
 * 			Description:                 pulumi.String("test1"),
 * 			ImageId:                     pulumi.String(images.Images[0].Id),
 * 			HostName:                    pulumi.String("tf-test-host"),
 * 			InstanceChargeType:          pulumi.String("PrePaid"),
 * 			InstanceName:                pulumi.String("tf-instance-name"),
 * 			InstanceType:                pulumi.String(instances.Instances[0].InstanceType),
 * 			InternetChargeType:          pulumi.String("PayByBandwidth"),
 * 			InternetMaxBandwidthIn:      pulumi.Int(5),
 * 			InternetMaxBandwidthOut:     pulumi.Int(0),
 * 			IoOptimized:                 pulumi.String("none"),
 * 			KeyPairName:                 pulumi.String("test-key-pair"),
 * 			RamRoleName:                 pulumi.String("xxxxx"),
 * 			NetworkType:                 pulumi.String("vpc"),
 * 			SecurityEnhancementStrategy: pulumi.String("Active"),
 * 			SpotPriceLimit:              pulumi.Float64(5),
 * 			SpotStrategy:                pulumi.String("SpotWithPriceLimit"),
 * 			SecurityGroupId:             pulumi.String("sg-zxcvj0lasdf102350asdf9a"),
 * 			SystemDiskCategory:          pulumi.String("cloud_ssd"),
 * 			SystemDiskDescription:       pulumi.String("test disk"),
 * 			SystemDiskName:              pulumi.String("hello"),
 * 			SystemDiskSize:              pulumi.Int(40),
 * 			ResourceGroupId:             pulumi.String("rg-zkdfjahg9zxncv0"),
 * 			Userdata:                    pulumi.String("xxxxxxxxxxxxxx"),
 * 			VswitchId:                   pulumi.String("sw-ljkngaksdjfj0nnasdf"),
 * 			VpcId:                       pulumi.String("vpc-asdfnbg0as8dfk1nb2"),
 * 			ZoneId:                      pulumi.String("beijing-a"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("hello"),
 * 				"tag2": pulumi.String("world"),
 * 			},
 * 			NetworkInterfaces: &ecs.LaunchTemplateNetworkInterfacesArgs{
 * 				Name:            pulumi.String("eth0"),
 * 				Description:     pulumi.String("hello1"),
 * 				PrimaryIp:       pulumi.String("10.0.0.2"),
 * 				SecurityGroupId: pulumi.String("xxxx"),
 * 				VswitchId:       pulumi.String("xxxxxxx"),
 * 			},
 * 			DataDisks: ecs.LaunchTemplateDataDiskArray{
 * 				&ecs.LaunchTemplateDataDiskArgs{
 * 					Name:        pulumi.String("disk1"),
 * 					Description: pulumi.String("test1"),
 * 				},
 * 				&ecs.LaunchTemplateDataDiskArgs{
 * 					Name:        pulumi.String("disk2"),
 * 					Description: pulumi.String("test2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.ecs.LaunchTemplate;
 * import com.pulumi.alicloud.ecs.LaunchTemplateArgs;
 * import com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs;
 * import com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var images = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .owners("system")
 *             .build());
 *         final var instances = EcsFunctions.getInstances();
 *         var template = new LaunchTemplate("template", LaunchTemplateArgs.builder()
 *             .name("tf-test-template")
 *             .description("test1")
 *             .imageId(images.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .hostName("tf-test-host")
 *             .instanceChargeType("PrePaid")
 *             .instanceName("tf-instance-name")
 *             .instanceType(instances.applyValue(getInstancesResult -> getInstancesResult.instances()[0].instanceType()))
 *             .internetChargeType("PayByBandwidth")
 *             .internetMaxBandwidthIn(5)
 *             .internetMaxBandwidthOut(0)
 *             .ioOptimized("none")
 *             .keyPairName("test-key-pair")
 *             .ramRoleName("xxxxx")
 *             .networkType("vpc")
 *             .securityEnhancementStrategy("Active")
 *             .spotPriceLimit(5)
 *             .spotStrategy("SpotWithPriceLimit")
 *             .securityGroupId("sg-zxcvj0lasdf102350asdf9a")
 *             .systemDiskCategory("cloud_ssd")
 *             .systemDiskDescription("test disk")
 *             .systemDiskName("hello")
 *             .systemDiskSize(40)
 *             .resourceGroupId("rg-zkdfjahg9zxncv0")
 *             .userdata("xxxxxxxxxxxxxx")
 *             .vswitchId("sw-ljkngaksdjfj0nnasdf")
 *             .vpcId("vpc-asdfnbg0as8dfk1nb2")
 *             .zoneId("beijing-a")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "hello"),
 *                 Map.entry("tag2", "world")
 *             ))
 *             .networkInterfaces(LaunchTemplateNetworkInterfacesArgs.builder()
 *                 .name("eth0")
 *                 .description("hello1")
 *                 .primaryIp("10.0.0.2")
 *                 .securityGroupId("xxxx")
 *                 .vswitchId("xxxxxxx")
 *                 .build())
 *             .dataDisks(
 *                 LaunchTemplateDataDiskArgs.builder()
 *                     .name("disk1")
 *                     .description("test1")
 *                     .build(),
 *                 LaunchTemplateDataDiskArgs.builder()
 *                     .name("disk2")
 *                     .description("test2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   template:
 *     type: alicloud:ecs:LaunchTemplate
 *     properties:
 *       name: tf-test-template
 *       description: test1
 *       imageId: ${images.images[0].id}
 *       hostName: tf-test-host
 *       instanceChargeType: PrePaid
 *       instanceName: tf-instance-name
 *       instanceType: ${instances.instances[0].instanceType}
 *       internetChargeType: PayByBandwidth
 *       internetMaxBandwidthIn: 5
 *       internetMaxBandwidthOut: 0
 *       ioOptimized: none
 *       keyPairName: test-key-pair
 *       ramRoleName: xxxxx
 *       networkType: vpc
 *       securityEnhancementStrategy: Active
 *       spotPriceLimit: 5
 *       spotStrategy: SpotWithPriceLimit
 *       securityGroupId: sg-zxcvj0lasdf102350asdf9a
 *       systemDiskCategory: cloud_ssd
 *       systemDiskDescription: test disk
 *       systemDiskName: hello
 *       systemDiskSize: 40
 *       resourceGroupId: rg-zkdfjahg9zxncv0
 *       userdata: xxxxxxxxxxxxxx
 *       vswitchId: sw-ljkngaksdjfj0nnasdf
 *       vpcId: vpc-asdfnbg0as8dfk1nb2
 *       zoneId: beijing-a
 *       tags:
 *         tag1: hello
 *         tag2: world
 *       networkInterfaces:
 *         name: eth0
 *         description: hello1
 *         primaryIp: 10.0.0.2
 *         securityGroupId: xxxx
 *         vswitchId: xxxxxxx
 *       dataDisks:
 *         - name: disk1
 *           description: test1
 *         - name: disk2
 *           description: test2
 * variables:
 *   images:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         owners: system
 *   instances:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Launch Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
 * ```
 * @property autoReleaseTime Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
 * @property autoRenew
 * @property autoRenewPeriod
 * @property dataDisks The list of data disks created with instance.
 * @property deploymentSetId
 * @property description Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
 * @property enableVmOsConfig
 * @property hostName Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
 * @property imageId Image ID.
 * @property imageOwnerAlias
 * @property instanceChargeType Billing methods. Optional values:
 * - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
 * - PostPaid: Pay-As-You-Go.
 * Default value: PostPaid.
 * @property instanceName The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
 * @property instanceType Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
 * @property internetChargeType Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
 * @property internetMaxBandwidthIn The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
 * @property internetMaxBandwidthOut Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
 * @property ioOptimized Whether it is an I/O-optimized instance or not. Optional values:
 * - none
 * - optimized
 * @property keyPairName The name of the key pair.
 * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
 * - The password logon method for Linux instances is set to forbidden upon initialization.
 * @property launchTemplateName
 * @property name Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
 * @property networkInterfaces The list of network interfaces created with instance.
 * @property networkType Network type of the instance. Value options: `classic` | `vpc`.
 * @property passwordInherit
 * @property period
 * @property periodUnit
 * @property privateIpAddress
 * @property ramRoleName The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
 * @property resourceGroupId
 * @property securityEnhancementStrategy Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
 * @property securityGroupId The security group ID.
 * @property securityGroupIds
 * @property spotDuration
 * @property spotPriceLimit Sets the maximum hourly instance price. Supports up to three decimal places.
 * @property spotStrategy The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
 * - NoSpot: Normal Pay-As-You-Go instance.
 * - SpotWithPriceLimit: Sets the maximum price for a spot instance.
 * - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
 * @property systemDisk
 * @property systemDiskCategory The category of the system disk. System disk type. Optional values:
 * - cloud: Basic cloud disk.
 * - cloud_efficiency: Ultra cloud disk.
 * - cloud_ssd: SSD cloud Disks.
 * - ephemeral_ssd: local SSD Disks
 * - cloud_essd: ESSD cloud Disks.
 * @property systemDiskDescription System disk description. It cannot begin with http:// or https://.
 * @property systemDiskName System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
 * @property systemDiskSize Size of the system disk, measured in GB. Value range: [20, 500].
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property templateResourceGroupId
 * @property templateTags
 * @property userData
 * @property userdata User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
 * @property versionDescription
 * @property vpcId
 * @property vswitchId When creating a VPC-Connected instance, you must specify its VSwitch ID.
 * @property zoneId The zone ID of the instance.
 */
public data class LaunchTemplateArgs(
    public val autoReleaseTime: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val dataDisks: Output<List<LaunchTemplateDataDiskArgs>>? = null,
    public val deploymentSetId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableVmOsConfig: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val imageOwnerAlias: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthIn: Output<Int>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val ioOptimized: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val networkInterfaces: Output<LaunchTemplateNetworkInterfacesArgs>? = null,
    public val networkType: Output<String>? = null,
    public val passwordInherit: Output<Boolean>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val ramRoleName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityEnhancementStrategy: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val spotDuration: Output<String>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val systemDisk: Output<LaunchTemplateSystemDiskArgs>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskCategory: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskDescription: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    public val systemDiskSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateResourceGroupId: Output<String>? = null,
    public val templateTags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    public val userdata: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.LaunchTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.LaunchTemplateArgs =
        com.pulumi.alicloud.ecs.LaunchTemplateArgs.builder()
            .autoReleaseTime(autoReleaseTime?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentSetId(deploymentSetId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableVmOsConfig(enableVmOsConfig?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageOwnerAlias(imageOwnerAlias?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthIn(internetMaxBandwidthIn?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .ioOptimized(ioOptimized?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterfaces(networkInterfaces?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityEnhancementStrategy(securityEnhancementStrategy?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotDuration(spotDuration?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .systemDisk(systemDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskDescription(systemDiskDescription?.applyValue({ args0 -> args0 }))
            .systemDiskName(systemDiskName?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateResourceGroupId(templateResourceGroupId?.applyValue({ args0 -> args0 }))
            .templateTags(
                templateTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .userData(userData?.applyValue({ args0 -> args0 }))
            .userdata(userdata?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateArgs].
 */
@PulumiTagMarker
public class LaunchTemplateArgsBuilder internal constructor() {
    private var autoReleaseTime: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var dataDisks: Output<List<LaunchTemplateDataDiskArgs>>? = null

    private var deploymentSetId: Output<String>? = null

    private var description: Output<String>? = null

    private var enableVmOsConfig: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var imageId: Output<String>? = null

    private var imageOwnerAlias: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthIn: Output<Int>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var ioOptimized: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var name: Output<String>? = null

    private var networkInterfaces: Output<LaunchTemplateNetworkInterfacesArgs>? = null

    private var networkType: Output<String>? = null

    private var passwordInherit: Output<Boolean>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var ramRoleName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityEnhancementStrategy: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var spotDuration: Output<String>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var systemDisk: Output<LaunchTemplateSystemDiskArgs>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskDescription: Output<String>? = null

    private var systemDiskName: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateResourceGroupId: Output<String>? = null

    private var templateTags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var userdata: Output<String>? = null

    private var versionDescription: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    @JvmName("deftijodxqnumlgo")
    public suspend fun autoReleaseTime(`value`: Output<String>) {
        this.autoReleaseTime = value
    }

    /**
     * @param value
     */
    @JvmName("cmhkbobeprcdkghm")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value
     */
    @JvmName("curcbcmndfarnnsg")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The list of data disks created with instance.
     */
    @JvmName("btaebparjtmsujgu")
    public suspend fun dataDisks(`value`: Output<List<LaunchTemplateDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("mmbqgkgcpnpcxfdr")
    public suspend fun dataDisks(vararg values: Output<LaunchTemplateDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of data disks created with instance.
     */
    @JvmName("oqqthjldrorpdrkf")
    public suspend fun dataDisks(values: List<Output<LaunchTemplateDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kanojqwobnhjuefl")
    public suspend fun deploymentSetId(`value`: Output<String>) {
        this.deploymentSetId = value
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("hpnrbybybbxjprhh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("fstycyyttdkpiiiu")
    public suspend fun enableVmOsConfig(`value`: Output<Boolean>) {
        this.enableVmOsConfig = value
    }

    /**
     * @param value Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    @JvmName("pinrekgliqqbedwx")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Image ID.
     */
    @JvmName("papfxctoewtgkvnp")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value
     */
    @JvmName("kwjheroxeufqsdte")
    public suspend fun imageOwnerAlias(`value`: Output<String>) {
        this.imageOwnerAlias = value
    }

    /**
     * @param value Billing methods. Optional values:
     * - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
     * - PostPaid: Pay-As-You-Go.
     * Default value: PostPaid.
     */
    @JvmName("wcqajyxrxkxdxool")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("tcjkfiwxilgomwty")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    @JvmName("itsrsmjnafkkbsor")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
     */
    @JvmName("psibknosgvrbrdxm")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    @JvmName("qlfgleemfqxtnjeu")
    public suspend fun internetMaxBandwidthIn(`value`: Output<Int>) {
        this.internetMaxBandwidthIn = value
    }

    /**
     * @param value Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    @JvmName("jqiilggjwdbidlwu")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value Whether it is an I/O-optimized instance or not. Optional values:
     * - none
     * - optimized
     */
    @JvmName("tqvwyiykotnbnwbo")
    public suspend fun ioOptimized(`value`: Output<String>) {
        this.ioOptimized = value
    }

    /**
     * @param value The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    @JvmName("etcmytjrtknsibcw")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value
     */
    @JvmName("axxrpuccnwttuajw")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    @JvmName("lriifyprtbxvwnua")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The list of network interfaces created with instance.
     */
    @JvmName("tibwbotaklvxnkxp")
    public suspend fun networkInterfaces(`value`: Output<LaunchTemplateNetworkInterfacesArgs>) {
        this.networkInterfaces = value
    }

    /**
     * @param value Network type of the instance. Value options: `classic` | `vpc`.
     */
    @JvmName("djrgcpeklotmlrmc")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value
     */
    @JvmName("xykrfsikikltyeqq")
    public suspend fun passwordInherit(`value`: Output<Boolean>) {
        this.passwordInherit = value
    }

    /**
     * @param value
     */
    @JvmName("kpjsysrnmddfkvvj")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value
     */
    @JvmName("dnljatfgxoqdubri")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value
     */
    @JvmName("djoeenrtuksxoonq")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    @JvmName("sofykegrictmaobq")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value
     */
    @JvmName("hgkepacuxtcxnwns")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
     */
    @JvmName("llhqedmmwjtqldye")
    public suspend fun securityEnhancementStrategy(`value`: Output<String>) {
        this.securityEnhancementStrategy = value
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("hwqyeubsvcklecbw")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("ffjjhwdnkmlykklt")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("afgbxfoeqskhibix")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("edhctkwsopklkwka")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ofcaofxwufedyeud")
    public suspend fun spotDuration(`value`: Output<String>) {
        this.spotDuration = value
    }

    /**
     * @param value Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    @JvmName("dtwtbermjrlnxuke")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
     * - NoSpot: Normal Pay-As-You-Go instance.
     * - SpotWithPriceLimit: Sets the maximum price for a spot instance.
     * - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
     */
    @JvmName("shrxtgwhjpxhkefp")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value
     */
    @JvmName("didkmvtvcmrcpvgs")
    public suspend fun systemDisk(`value`: Output<LaunchTemplateSystemDiskArgs>) {
        this.systemDisk = value
    }

    /**
     * @param value The category of the system disk. System disk type. Optional values:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("qklcxsqqqbkxcqve")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value System disk description. It cannot begin with http:// or https://.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("jyoduadffxlkmgec")
    public suspend fun systemDiskDescription(`value`: Output<String>) {
        this.systemDiskDescription = value
    }

    /**
     * @param value System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("dovudwxgwpoxidac")
    public suspend fun systemDiskName(`value`: Output<String>) {
        this.systemDiskName = value
    }

    /**
     * @param value Size of the system disk, measured in GB. Value range: [20, 500].
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("ubfcgfujhfffxudf")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("lryjmjvyxpwdqiol")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("osnecxckplakawmd")
    public suspend fun templateResourceGroupId(`value`: Output<String>) {
        this.templateResourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("iqyamysuxwxjafct")
    public suspend fun templateTags(`value`: Output<Map<String, String>>) {
        this.templateTags = value
    }

    /**
     * @param value
     */
    @JvmName("dlwlomobjqidriwg")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    @JvmName("wpbfynlxnceghmdv")
    public suspend fun userdata(`value`: Output<String>) {
        this.userdata = value
    }

    /**
     * @param value
     */
    @JvmName("rdwtsprhxjrfxekn")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value
     */
    @JvmName("cshsbglyrtcmvyak")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    @JvmName("xaakaxgkoweesnwj")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("qdjghjqwsdsonkqr")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
     */
    @JvmName("hcnsitkpcfqatvtx")
    public suspend fun autoReleaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReleaseTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("scfbbdnpwrphqhvs")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwfswhnmxhjebsmt")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The list of data disks created with instance.
     */
    @JvmName("fpqtwfuapcolvldj")
    public suspend fun dataDisks(`value`: List<LaunchTemplateDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance.
     */
    @JvmName("jwgqqfhnqwagdujd")
    public suspend fun dataDisks(argument: List<suspend LaunchTemplateDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance.
     */
    @JvmName("dkvthvfgsgjrmrgg")
    public suspend fun dataDisks(vararg argument: suspend LaunchTemplateDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument The list of data disks created with instance.
     */
    @JvmName("wotditborpeejuir")
    public suspend fun dataDisks(argument: suspend LaunchTemplateDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LaunchTemplateDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values The list of data disks created with instance.
     */
    @JvmName("cukbothueldnlaxm")
    public suspend fun dataDisks(vararg values: LaunchTemplateDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value
     */
    @JvmName("wnaqiglcklannagw")
    public suspend fun deploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetId = mapped
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("eqahgjvwuhruoiio")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("whqyiorlbiabscmv")
    public suspend fun enableVmOsConfig(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVmOsConfig = mapped
    }

    /**
     * @param value Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length&#46; It can contain A-Z, a-z, numbers, periods (&#46;), and hyphens (-)&#46; It cannot only contain numbers&#46; For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
     */
    @JvmName("xuqceqmuehankgha")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Image ID.
     */
    @JvmName("xsgcajldwomkwchs")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value
     */
    @JvmName("svsmmmoshejpmyfs")
    public suspend fun imageOwnerAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageOwnerAlias = mapped
    }

    /**
     * @param value Billing methods. Optional values:
     * - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
     * - PostPaid: Pay-As-You-Go.
     * Default value: PostPaid.
     */
    @JvmName("wylxrbwhdcmjlrpn")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("hetfcltvemaxdavn")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
     */
    @JvmName("hjyjbjklauhxmlrs")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
     */
    @JvmName("xghuyjlwqgkvlbdv")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
     */
    @JvmName("xxksagcwicmwfbul")
    public suspend fun internetMaxBandwidthIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthIn = mapped
    }

    /**
     * @param value Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
     */
    @JvmName("eqhowpshtswbotpy")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value Whether it is an I/O-optimized instance or not. Optional values:
     * - none
     * - optimized
     */
    @JvmName("uodlbrejdbqkyiws")
    public suspend fun ioOptimized(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioOptimized = mapped
    }

    /**
     * @param value The name of the key pair.
     * - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
     * - The password logon method for Linux instances is set to forbidden upon initialization.
     */
    @JvmName("aiuaenivgphqgrro")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value
     */
    @JvmName("mkwuduurvaqjfcig")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name'
      instead.
  """,
    )
    @JvmName("gyrnojjwufbqaikr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The list of network interfaces created with instance.
     */
    @JvmName("cectqqdnalemtxxf")
    public suspend fun networkInterfaces(`value`: LaunchTemplateNetworkInterfacesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument The list of network interfaces created with instance.
     */
    @JvmName("wkvjkrdqwvxmasty")
    public suspend fun networkInterfaces(argument: suspend LaunchTemplateNetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateNetworkInterfacesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param value Network type of the instance. Value options: `classic` | `vpc`.
     */
    @JvmName("oyaxlkhsbpxsbaly")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value
     */
    @JvmName("wcnlypnpvbwayein")
    public suspend fun passwordInherit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value
     */
    @JvmName("wobevvbhjmaremmp")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value
     */
    @JvmName("vrpjykiddxmokncv")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfbvcrbnjsxowbhc")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
     */
    @JvmName("pxgkhogidhhosrep")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kwbqwlgxtapfqoaf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
     */
    @JvmName("oufjiowcotyqqoho")
    public suspend fun securityEnhancementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityEnhancementStrategy = mapped
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("fypnhubdgmuxthtg")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kcnxeytebymterui")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("yetktrnmdexhfyvw")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("bnqvcbjqihhuufhm")
    public suspend fun spotDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotDuration = mapped
    }

    /**
     * @param value Sets the maximum hourly instance price. Supports up to three decimal places.
     */
    @JvmName("yifgdvqgbjvcrrwd")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
     * - NoSpot: Normal Pay-As-You-Go instance.
     * - SpotWithPriceLimit: Sets the maximum price for a spot instance.
     * - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
     */
    @JvmName("xcapiuvyiuixqkkn")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value
     */
    @JvmName("yhntnnqalrpitefc")
    public suspend fun systemDisk(`value`: LaunchTemplateSystemDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDisk = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rsjpumhclohrsbik")
    public suspend fun systemDisk(argument: suspend LaunchTemplateSystemDiskArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateSystemDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemDisk = mapped
    }

    /**
     * @param value The category of the system disk. System disk type. Optional values:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     */
    @Deprecated(
        message = """
  Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("eskjmqnbevjxhaaa")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value System disk description. It cannot begin with http:// or https://.
     */
    @Deprecated(
        message = """
  Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("hiablkmigvamorbj")
    public suspend fun systemDiskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskDescription = mapped
    }

    /**
     * @param value System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @Deprecated(
        message = """
  Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("ywdnfjypnebujixh")
    public suspend fun systemDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskName = mapped
    }

    /**
     * @param value Size of the system disk, measured in GB. Value range: [20, 500].
     */
    @Deprecated(
        message = """
  Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field
      'system_disk' instead.
  """,
    )
    @JvmName("wvrumyexajuseqop")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("eolwccslbtsbtxoe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("fnywetglrapygtma")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hjsjqeaumfbnyjgn")
    public suspend fun templateResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateResourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("lbtqmccloypmqbis")
    public suspend fun templateTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateTags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hkxkxdehixsnbnal")
    public fun templateTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ayxiuxcfhrqixwev")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
     */
    @Deprecated(
        message = """
  Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.
  """,
    )
    @JvmName("pgfflovgfatxicld")
    public suspend fun userdata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userdata = mapped
    }

    /**
     * @param value
     */
    @JvmName("vacbkwjlotyurmjh")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    /**
     * @param value
     */
    @JvmName("scsroohyxsxggusg")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value When creating a VPC-Connected instance, you must specify its VSwitch ID.
     */
    @JvmName("hauwpkaeaawipnpm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("dtxunnegrrcqahyt")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): LaunchTemplateArgs = LaunchTemplateArgs(
        autoReleaseTime = autoReleaseTime,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        dataDisks = dataDisks,
        deploymentSetId = deploymentSetId,
        description = description,
        enableVmOsConfig = enableVmOsConfig,
        hostName = hostName,
        imageId = imageId,
        imageOwnerAlias = imageOwnerAlias,
        instanceChargeType = instanceChargeType,
        instanceName = instanceName,
        instanceType = instanceType,
        internetChargeType = internetChargeType,
        internetMaxBandwidthIn = internetMaxBandwidthIn,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        ioOptimized = ioOptimized,
        keyPairName = keyPairName,
        launchTemplateName = launchTemplateName,
        name = name,
        networkInterfaces = networkInterfaces,
        networkType = networkType,
        passwordInherit = passwordInherit,
        period = period,
        periodUnit = periodUnit,
        privateIpAddress = privateIpAddress,
        ramRoleName = ramRoleName,
        resourceGroupId = resourceGroupId,
        securityEnhancementStrategy = securityEnhancementStrategy,
        securityGroupId = securityGroupId,
        securityGroupIds = securityGroupIds,
        spotDuration = spotDuration,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        systemDisk = systemDisk,
        systemDiskCategory = systemDiskCategory,
        systemDiskDescription = systemDiskDescription,
        systemDiskName = systemDiskName,
        systemDiskSize = systemDiskSize,
        tags = tags,
        templateResourceGroupId = templateResourceGroupId,
        templateTags = templateTags,
        userData = userData,
        userdata = userdata,
        versionDescription = versionDescription,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
