@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.kotlin.outputs.ReservedInstanceOperationLock
import com.pulumi.alicloud.ecs.kotlin.outputs.ReservedInstanceOperationLock.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReservedInstance].
 */
@PulumiTagMarker
public class ReservedInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReservedInstanceArgs = ReservedInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReservedInstanceArgsBuilder.() -> Unit) {
        val builder = ReservedInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReservedInstance {
        val builtJavaResource = com.pulumi.alicloud.ecs.ReservedInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReservedInstance(builtJavaResource)
    }
}

/**
 * Provides an Reserved Instance resource.
 * > **NOTE:** Available in 1.65.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.g6",
 * });
 * const defaultReservedInstance = new alicloud.ecs.ReservedInstance("default", {
 *     instanceType: _default.then(_default => _default.instanceTypes?.[0]?.id),
 *     instanceAmount: 1,
 *     periodUnit: "Month",
 *     offeringType: "All Upfront",
 *     reservedInstanceName: "terraform-example",
 *     description: "ReservedInstance",
 *     zoneId: _default.then(_default => _default.instanceTypes?.[0]?&#46;availabilityZones?&#46;[0]),
 *     scope: "Zone",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g6")
 * default_reserved_instance = alicloud.ecs.ReservedInstance("default",
 *     instance_type=default.instance_types[0].id,
 *     instance_amount=1,
 *     period_unit="Month",
 *     offering_type="All Upfront",
 *     reserved_instance_name="terraform-example",
 *     description="ReservedInstance",
 *     zone_id=default.instance_types[0]&#46;availability_zones[0],
 *     scope="Zone")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.g6",
 *     });
 *     var defaultReservedInstance = new AliCloud.Ecs.ReservedInstance("default", new()
 *     {
 *         InstanceType = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id)),
 *         InstanceAmount = 1,
 *         PeriodUnit = "Month",
 *         OfferingType = "All Upfront",
 *         ReservedInstanceName = "terraform-example",
 *         Description = "ReservedInstance",
 *         ZoneId = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?&#46;AvailabilityZones[0])),
 *         Scope = "Zone",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.g6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewReservedInstance(ctx, "default", &ecs.ReservedInstanceArgs{
 * 			InstanceType:         pulumi.String(_default.InstanceTypes[0].Id),
 * 			InstanceAmount:       pulumi.Int(1),
 * 			PeriodUnit:           pulumi.String("Month"),
 * 			OfferingType:         pulumi.String("All Upfront"),
 * 			ReservedInstanceName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("ReservedInstance"),
 * 			ZoneId:               pulumi.String(_default.InstanceTypes[0]&#46;AvailabilityZones[0]),
 * 			Scope:                pulumi.String("Zone"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.ReservedInstance;
 * import com.pulumi.alicloud.ecs.ReservedInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.g6")
 *             .build());
 *         var defaultReservedInstance = new ReservedInstance("defaultReservedInstance", ReservedInstanceArgs.builder()
 *             .instanceType(default_.instanceTypes()[0].id())
 *             .instanceAmount("1")
 *             .periodUnit("Month")
 *             .offeringType("All Upfront")
 *             .reservedInstanceName("terraform-example")
 *             .description("ReservedInstance")
 *             .zoneId(default_.instanceTypes()[0]&#46;availabilityZones()[0])
 *             .scope("Zone")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultReservedInstance:
 *     type: alicloud:ecs:ReservedInstance
 *     name: default
 *     properties:
 *       instanceType: ${default.instanceTypes[0].id}
 *       instanceAmount: '1'
 *       periodUnit: Month
 *       offeringType: All Upfront
 *       reservedInstanceName: terraform-example
 *       description: ReservedInstance
 *       zoneId: ${default.instanceTypes[0]&#46;availabilityZones[0]}
 *       scope: Zone
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.g6
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * reservedInstance can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/reservedInstance:ReservedInstance default ecsri-uf6df4xm0h3licit****
 * ```
 */
public class ReservedInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.ReservedInstance,
) : KotlinCustomResource(javaResource, ReservedInstanceMapper) {
    /**
     * Indicates the sharing status of the reserved instance when the AllocationType parameter is set to Shared. Valid values: `allocated`: The reserved instance is allocated to another account. `beAllocated`: The reserved instance is allocated by another account.
     */
    public val allocationStatus: Output<String>
        get() = javaResource.allocationStatus().applyValue({ args0 -> args0 })

    /**
     * The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
     */
    public val autoRenewPeriod: Output<Int>
        get() = javaResource.autoRenewPeriod().applyValue({ args0 -> args0 })

    /**
     * The time when the reserved instance was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the reserved instance expires.
     */
    public val expiredTime: Output<String>
        get() = javaResource.expiredTime().applyValue({ args0 -> args0 })

    /**
     * Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
     */
    public val instanceAmount: Output<Int>
        get() = javaResource.instanceAmount().applyValue({ args0 -> args0 })

    /**
     * Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Payment type of the RI. Default value: `All Upfront`. Valid values:
     * - `No Upfront`: No upfront payment.
     * - `Partial Upfront`: A portion of upfront payment.
     * - `All Upfront`: Full upfront payment.
     */
    public val offeringType: Output<String>
        get() = javaResource.offeringType().applyValue({ args0 -> args0 })

    /**
     * Details about the lock status of the reserved instance.
     */
    public val operationLocks: Output<List<ReservedInstanceOperationLock>>
        get() = javaResource.operationLocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
     * - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
     * - When `period_unit` is `Month`, Valid values: `1`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
     */
    public val reservedInstanceName: Output<String>
        get() = javaResource.reservedInstanceName().applyValue({ args0 -> args0 })

    /**
     * Resource group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * The time when the reserved instance took effect.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The status of the reserved instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
     */
    public val zoneId: Output<String>?
        get() = javaResource.zoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ReservedInstanceMapper : ResourceMapper<ReservedInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.ReservedInstance::class == javaResource::class

    override fun map(javaResource: Resource): ReservedInstance = ReservedInstance(
        javaResource as
            com.pulumi.alicloud.ecs.ReservedInstance,
    )
}

/**
 * @see [ReservedInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReservedInstance].
 */
public suspend fun reservedInstance(
    name: String,
    block: suspend ReservedInstanceResourceBuilder.() -> Unit,
): ReservedInstance {
    val builder = ReservedInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReservedInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reservedInstance(name: String): ReservedInstance {
    val builder = ReservedInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
