@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.ReservedInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Reserved Instance resource.
 * > **NOTE:** Available in 1.65.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.ecs.getInstanceTypes({
 *     instanceTypeFamily: "ecs.g6",
 * });
 * const defaultReservedInstance = new alicloud.ecs.ReservedInstance("default", {
 *     instanceType: _default.then(_default => _default.instanceTypes?.[0]?.id),
 *     instanceAmount: 1,
 *     periodUnit: "Month",
 *     offeringType: "All Upfront",
 *     reservedInstanceName: "terraform-example",
 *     description: "ReservedInstance",
 *     zoneId: _default.then(_default => _default.instanceTypes?.[0]?&#46;availabilityZones?&#46;[0]),
 *     scope: "Zone",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g6")
 * default_reserved_instance = alicloud.ecs.ReservedInstance("default",
 *     instance_type=default.instance_types[0].id,
 *     instance_amount=1,
 *     period_unit="Month",
 *     offering_type="All Upfront",
 *     reserved_instance_name="terraform-example",
 *     description="ReservedInstance",
 *     zone_id=default.instance_types[0]&#46;availability_zones[0],
 *     scope="Zone")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "ecs.g6",
 *     });
 *     var defaultReservedInstance = new AliCloud.Ecs.ReservedInstance("default", new()
 *     {
 *         InstanceType = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id)),
 *         InstanceAmount = 1,
 *         PeriodUnit = "Month",
 *         OfferingType = "All Upfront",
 *         ReservedInstanceName = "terraform-example",
 *         Description = "ReservedInstance",
 *         ZoneId = @default.Apply(@default => @default.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?&#46;AvailabilityZones[0])),
 *         Scope = "Zone",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("ecs.g6"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewReservedInstance(ctx, "default", &ecs.ReservedInstanceArgs{
 * 			InstanceType:         pulumi.String(_default.InstanceTypes[0].Id),
 * 			InstanceAmount:       pulumi.Int(1),
 * 			PeriodUnit:           pulumi.String("Month"),
 * 			OfferingType:         pulumi.String("All Upfront"),
 * 			ReservedInstanceName: pulumi.String("terraform-example"),
 * 			Description:          pulumi.String("ReservedInstance"),
 * 			ZoneId:               pulumi.String(_default.InstanceTypes[0]&#46;AvailabilityZones[0]),
 * 			Scope:                pulumi.String("Zone"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.ReservedInstance;
 * import com.pulumi.alicloud.ecs.ReservedInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .instanceTypeFamily("ecs.g6")
 *             .build());
 *         var defaultReservedInstance = new ReservedInstance("defaultReservedInstance", ReservedInstanceArgs.builder()
 *             .instanceType(default_.instanceTypes()[0].id())
 *             .instanceAmount("1")
 *             .periodUnit("Month")
 *             .offeringType("All Upfront")
 *             .reservedInstanceName("terraform-example")
 *             .description("ReservedInstance")
 *             .zoneId(default_.instanceTypes()[0]&#46;availabilityZones()[0])
 *             .scope("Zone")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultReservedInstance:
 *     type: alicloud:ecs:ReservedInstance
 *     name: default
 *     properties:
 *       instanceType: ${default.instanceTypes[0].id}
 *       instanceAmount: '1'
 *       periodUnit: Month
 *       offeringType: All Upfront
 *       reservedInstanceName: terraform-example
 *       description: ReservedInstance
 *       zoneId: ${default.instanceTypes[0]&#46;availabilityZones[0]}
 *       scope: Zone
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         instanceTypeFamily: ecs.g6
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * reservedInstance can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/reservedInstance:ReservedInstance default ecsri-uf6df4xm0h3licit****
 * ```
 * @property autoRenewPeriod The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
 * @property description Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
 * @property instanceAmount Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
 * @property instanceType Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
 * @property name Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
 * @property offeringType Payment type of the RI. Default value: `All Upfront`. Valid values:
 * - `No Upfront`: No upfront payment.
 * - `Partial Upfront`: A portion of upfront payment.
 * - `All Upfront`: Full upfront payment.
 * @property period The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
 * - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
 * - When `period_unit` is `Month`, Valid values: `1`.
 * @property periodUnit The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
 * @property platform The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
 * @property reservedInstanceName Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
 * @property resourceGroupId Resource group ID.
 * @property scope Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
 */
public data class ReservedInstanceArgs(
    public val autoRenewPeriod: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val instanceAmount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val offeringType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val reservedInstanceName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.ReservedInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.ReservedInstanceArgs =
        com.pulumi.alicloud.ecs.ReservedInstanceArgs.builder()
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceAmount(instanceAmount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .offeringType(offeringType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .reservedInstanceName(reservedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReservedInstanceArgs].
 */
@PulumiTagMarker
public class ReservedInstanceArgsBuilder internal constructor() {
    private var autoRenewPeriod: Output<Int>? = null

    private var description: Output<String>? = null

    private var instanceAmount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    private var offeringType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var platform: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var reservedInstanceName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
     */
    @JvmName("okvuldsmunfvqpul")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
     */
    @JvmName("ehyhfjtoxjixglad")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
     */
    @JvmName("xmwyeyhbjohknohq")
    public suspend fun instanceAmount(`value`: Output<Int>) {
        this.instanceAmount = value
    }

    /**
     * @param value Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
     */
    @JvmName("koxjfikauhmhnkyx")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name'
      instead.
  """,
    )
    @JvmName("wqwyobdvinhypbgo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Payment type of the RI. Default value: `All Upfront`. Valid values:
     * - `No Upfront`: No upfront payment.
     * - `Partial Upfront`: A portion of upfront payment.
     * - `All Upfront`: Full upfront payment.
     */
    @JvmName("vlcvlervwuhiamdf")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
     * - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
     * - When `period_unit` is `Month`, Valid values: `1`.
     */
    @JvmName("ikrhcmbdnkgymysc")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
     */
    @JvmName("byfmurjsuttdxjro")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
     */
    @JvmName("atchbsskoerquygr")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
     */
    @JvmName("sxsqrakwmxvqqtnb")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
     */
    @JvmName("mxelvmtungojwyqf")
    public suspend fun reservedInstanceName(`value`: Output<String>) {
        this.reservedInstanceName = value
    }

    /**
     * @param value Resource group ID.
     */
    @JvmName("kxckeymjcagqglhb")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
     */
    @JvmName("bfavjjcovhwmrjll")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("evrqfhtntweryatf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
     */
    @JvmName("efmupsqlfngjgfug")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
     */
    @JvmName("qlghvuhulyfibqri")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
     */
    @JvmName("ncylnlnmddbgmigw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
     */
    @JvmName("oxemaawescmpewey")
    public suspend fun instanceAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAmount = mapped
    }

    /**
     * @param value Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
     */
    @JvmName("ealmvciahtrahxxb")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name'
      instead.
  """,
    )
    @JvmName("rhkdkebnuqpotufi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Payment type of the RI. Default value: `All Upfront`. Valid values:
     * - `No Upfront`: No upfront payment.
     * - `Partial Upfront`: A portion of upfront payment.
     * - `All Upfront`: Full upfront payment.
     */
    @JvmName("pbenheyhpyelkpis")
    public suspend fun offeringType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
     * - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
     * - When `period_unit` is `Month`, Valid values: `1`.
     */
    @JvmName("gmmvcuysfecnffxv")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
     */
    @JvmName("erislpkmndjxsald")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
     */
    @JvmName("mntwrqqsfmyosysv")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
     */
    @JvmName("waugfgsrftqcsxxg")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
     */
    @JvmName("kcmvahxgpgiemxnj")
    public suspend fun reservedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedInstanceName = mapped
    }

    /**
     * @param value Resource group ID.
     */
    @JvmName("decpltontwyxqcia")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
     */
    @JvmName("llyllnguksveypmu")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("xxxhlobjhuxjehnx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("bhdepvuspggupqpd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
     */
    @JvmName("icuhvkomhwptmspm")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ReservedInstanceArgs = ReservedInstanceArgs(
        autoRenewPeriod = autoRenewPeriod,
        description = description,
        instanceAmount = instanceAmount,
        instanceType = instanceType,
        name = name,
        offeringType = offeringType,
        period = period,
        periodUnit = periodUnit,
        platform = platform,
        renewalStatus = renewalStatus,
        reservedInstanceName = reservedInstanceName,
        resourceGroupId = resourceGroupId,
        scope = scope,
        tags = tags,
        zoneId = zoneId,
    )
}
