@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SecurityGroup].
 */
@PulumiTagMarker
public class SecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupArgs = SecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupArgsBuilder.() -> Unit) {
        val builder = SecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityGroup {
        val builtJavaResource = com.pulumi.alicloud.ecs.SecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroup(builtJavaResource)
    }
}

/**
 * Provides a Security Group resource.
 * For information about Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-createsecuritygroup).
 * > **NOTE:** Available since v1.0.0.
 * > **NOTE:** `alicloud.ecs.SecurityGroup` is used to build and manage a security group, and `alicloud.ecs.SecurityGroupRule` can define ingress or egress rules for it.
 * > **NOTE:** From version 1.7.2, `alicloud.ecs.SecurityGroup` has supported to segregate different ECS instance in which the same security group.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.SecurityGroup("default", {
 *     name: "terraform-example",
 *     description: "New security group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.SecurityGroup("default",
 *     name="terraform-example",
 *     description="New security group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "terraform-example",
 *         Description = "New security group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String("terraform-example"),
 * 			Description: pulumi.String("New security group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .description("New security group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: terraform-example
 *       description: New security group
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for VPC
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "10.1.0.0/21",
 * });
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: "terraform-example",
 *     vpcId: vpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="10.1.0.0/21")
 * group = alicloud.ecs.SecurityGroup("group",
 *     name="terraform-example",
 *     vpc_id=vpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "10.1.0.0/21",
 *     });
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = vpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("10.1.0.0/21"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(vpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 10.1.0.0/21
 *   group:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: terraform-example
 *       vpcId: ${vpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing security-group module
 * to create a security group and add several rules one-click.
 * ## Import
 * Security Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/securityGroup:SecurityGroup example sg-abc123456
 * ```
 */
public class SecurityGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.SecurityGroup,
) : KotlinCustomResource(javaResource, SecurityGroupMapper) {
    /**
     * The security group description. Defaults to null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
     * Combining security group rules, the policy can define multiple application scenario. Default to true. It is valid from version `1.7.2`.
     */
    @Deprecated(
        message = """
  Field `inner_access` has been deprecated from provider version 1.55.3. Use `inner_access_policy`
      replaces it.
  """,
    )
    public val innerAccess: Output<Boolean>
        get() = javaResource.innerAccess().applyValue({ args0 -> args0 })

    /**
     * The internal access control policy of the security group. Valid values: `Accept`, `Drop`.
     */
    public val innerAccessPolicy: Output<String>
        get() = javaResource.innerAccessPolicy().applyValue({ args0 -> args0 })

    /**
     * The name of the security group. Defaults to null.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the security group. Valid values:
     */
    public val securityGroupType: Output<String>
        get() = javaResource.securityGroupType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SecurityGroupMapper : ResourceMapper<SecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.SecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroup = SecurityGroup(
        javaResource as
            com.pulumi.alicloud.ecs.SecurityGroup,
    )
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroup].
 */
public suspend fun securityGroup(
    name: String,
    block: suspend SecurityGroupResourceBuilder.() -> Unit,
): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroup(name: String): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
