@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.SecurityGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Security Group resource.
 * For information about Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-createsecuritygroup).
 * > **NOTE:** Available since v1.0.0.
 * > **NOTE:** `alicloud.ecs.SecurityGroup` is used to build and manage a security group, and `alicloud.ecs.SecurityGroupRule` can define ingress or egress rules for it.
 * > **NOTE:** From version 1.7.2, `alicloud.ecs.SecurityGroup` has supported to segregate different ECS instance in which the same security group.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.SecurityGroup("default", {
 *     name: "terraform-example",
 *     description: "New security group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.SecurityGroup("default",
 *     name="terraform-example",
 *     description="New security group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "terraform-example",
 *         Description = "New security group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String("terraform-example"),
 * 			Description: pulumi.String("New security group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .description("New security group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: terraform-example
 *       description: New security group
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for VPC
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "10.1.0.0/21",
 * });
 * const group = new alicloud.ecs.SecurityGroup("group", {
 *     name: "terraform-example",
 *     vpcId: vpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * vpc = alicloud.vpc.Network("vpc",
 *     vpc_name="terraform-example",
 *     cidr_block="10.1.0.0/21")
 * group = alicloud.ecs.SecurityGroup("group",
 *     name="terraform-example",
 *     vpc_id=vpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "10.1.0.0/21",
 *     });
 *     var @group = new AliCloud.Ecs.SecurityGroup("group", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = vpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("10.1.0.0/21"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroup(ctx, "group", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var group = new SecurityGroup("group", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(vpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 10.1.0.0/21
 *   group:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: terraform-example
 *       vpcId: ${vpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing security-group module
 * to create a security group and add several rules one-click.
 * ## Import
 * Security Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/securityGroup:SecurityGroup example sg-abc123456
 * ```
 * @property description The security group description. Defaults to null.
 * @property innerAccess Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
 * Combining security group rules, the policy can define multiple application scenario. Default to true. It is valid from version `1.7.2`.
 * @property innerAccessPolicy The internal access control policy of the security group. Valid values: `Accept`, `Drop`.
 * @property name The name of the security group. Defaults to null.
 * @property resourceGroupId The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
 * @property securityGroupType The type of the security group. Valid values:
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC.
 */
public data class SecurityGroupArgs(
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field `inner_access` has been deprecated from provider version 1.55.3. Use `inner_access_policy`
      replaces it.
  """,
    )
    public val innerAccess: Output<Boolean>? = null,
    public val innerAccessPolicy: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.SecurityGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.SecurityGroupArgs =
        com.pulumi.alicloud.ecs.SecurityGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .innerAccess(innerAccess?.applyValue({ args0 -> args0 }))
            .innerAccessPolicy(innerAccessPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupType(securityGroupType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupArgs].
 */
@PulumiTagMarker
public class SecurityGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var innerAccess: Output<Boolean>? = null

    private var innerAccessPolicy: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The security group description. Defaults to null.
     */
    @JvmName("idwxplcumyigmtrr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
     * Combining security group rules, the policy can define multiple application scenario. Default to true. It is valid from version `1.7.2`.
     */
    @Deprecated(
        message = """
  Field `inner_access` has been deprecated from provider version 1.55.3. Use `inner_access_policy`
      replaces it.
  """,
    )
    @JvmName("pclqpupqhoxsnysj")
    public suspend fun innerAccess(`value`: Output<Boolean>) {
        this.innerAccess = value
    }

    /**
     * @param value The internal access control policy of the security group. Valid values: `Accept`, `Drop`.
     */
    @JvmName("hhmwpfqeqjvlapvd")
    public suspend fun innerAccessPolicy(`value`: Output<String>) {
        this.innerAccessPolicy = value
    }

    /**
     * @param value The name of the security group. Defaults to null.
     */
    @JvmName("ademqbfvnglmnbqk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
     */
    @JvmName("bsysvjputpfhfwsk")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The type of the security group. Valid values:
     */
    @JvmName("tflgeogouxxlrcfw")
    public suspend fun securityGroupType(`value`: Output<String>) {
        this.securityGroupType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jotskbxnhvjurwel")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("gucomasprtjgkbar")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The security group description. Defaults to null.
     */
    @JvmName("xppaevxnasbsctii")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Field `inner_access` has been deprecated from provider version 1.55.3. New field `inner_access_policy` instead.
     * Combining security group rules, the policy can define multiple application scenario. Default to true. It is valid from version `1.7.2`.
     */
    @Deprecated(
        message = """
  Field `inner_access` has been deprecated from provider version 1.55.3. Use `inner_access_policy`
      replaces it.
  """,
    )
    @JvmName("kugysyjgrgmjonug")
    public suspend fun innerAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.innerAccess = mapped
    }

    /**
     * @param value The internal access control policy of the security group. Valid values: `Accept`, `Drop`.
     */
    @JvmName("fdfjvxwdjnftggnv")
    public suspend fun innerAccessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.innerAccessPolicy = mapped
    }

    /**
     * @param value The name of the security group. Defaults to null.
     */
    @JvmName("xeidjyjijubxyyey")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the resource group to which the security group belongs. **NOTE:** From version 1.115.0, `resource_group_id` can be modified.
     */
    @JvmName("ycfhyutccvsqvstf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The type of the security group. Valid values:
     */
    @JvmName("kerdxkkxbjgcoggv")
    public suspend fun securityGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("sxbrqnqprnushqxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("aaougvtrrqdcoshl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("egtkbpfptqgenurm")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): SecurityGroupArgs = SecurityGroupArgs(
        description = description,
        innerAccess = innerAccess,
        innerAccessPolicy = innerAccessPolicy,
        name = name,
        resourceGroupId = resourceGroupId,
        securityGroupType = securityGroupType,
        tags = tags,
        vpcId = vpcId,
    )
}
