@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityGroupRule].
 */
@PulumiTagMarker
public class SecurityGroupRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupRuleArgs = SecurityGroupRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupRuleArgsBuilder.() -> Unit) {
        val builder = SecurityGroupRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityGroupRule {
        val builtJavaResource = com.pulumi.alicloud.ecs.SecurityGroupRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroupRule(builtJavaResource)
    }
}

/**
 * Provides a Security Group Rule resource.
 * For information about Security Group Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/ecs/user-guide/security-group-rules).
 * > **NOTE:** Available since v0.1.0.
 * Represents a single `ingress` or `egress` group rule, which can be added to external Security Groups.
 * > **NOTE:**  `nic_type` should set to `intranet` when security group type is `vpc` or specifying the `source_security_group_id`. In this situation it does not distinguish between intranet and internet, the rule is effective on them both.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.SecurityGroup("default", {name: "default"});
 * const allowAllTcp = new alicloud.ecs.SecurityGroupRule("allow_all_tcp", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "internet",
 *     policy: "accept",
 *     portRange: "1/65535",
 *     priority: 1,
 *     securityGroupId: _default.id,
 *     cidrIp: "0.0.0.0/0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.SecurityGroup("default", name="default")
 * allow_all_tcp = alicloud.ecs.SecurityGroupRule("allow_all_tcp",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="internet",
 *     policy="accept",
 *     port_range="1/65535",
 *     priority=1,
 *     security_group_id=default.id,
 *     cidr_ip="0.0.0.0/0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "default",
 *     });
 *     var allowAllTcp = new AliCloud.Ecs.SecurityGroupRule("allow_all_tcp", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "internet",
 *         Policy = "accept",
 *         PortRange = "1/65535",
 *         Priority = 1,
 *         SecurityGroupId = @default.Id,
 *         CidrIp = "0.0.0.0/0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "allow_all_tcp", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("internet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("1/65535"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: _default.ID(),
 * 			CidrIp:          pulumi.String("0.0.0.0/0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .name("default")
 *             .build());
 *         var allowAllTcp = new SecurityGroupRule("allowAllTcp", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("internet")
 *             .policy("accept")
 *             .portRange("1/65535")
 *             .priority(1)
 *             .securityGroupId(default_.id())
 *             .cidrIp("0.0.0.0/0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: default
 *   allowAllTcp:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: allow_all_tcp
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: internet
 *       policy: accept
 *       portRange: 1/65535
 *       priority: 1
 *       securityGroupId: ${default.id}
 *       cidrIp: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing security-group module
 * to create a security group and add several rules one-click.
 * ## Import
 * Security Group Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/securityGroupRule:SecurityGroupRule example <id>
 * ```
 */
public class SecurityGroupRule internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.SecurityGroupRule,
) : KotlinCustomResource(javaResource, SecurityGroupRuleMapper) {
    /**
     * The target IP address range. The default value is 0.0.0.0/0 (which means no restriction will be applied). Other supported formats include 10.159.6.18/12. Only IPv4 is supported.
     */
    public val cidrIp: Output<String>?
        get() = javaResource.cidrIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The description of the security group rule. The description can be up to 1 to 512 characters in length. Defaults to null.
     * > **NOTE:**  You must specify one of the following field: `cidr_ip`,`source_security_group_id`,`prefix_list_id`,`ipv6_cidr_ip`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The transport layer protocol of the Security Group Rule. Valid values: `tcp`, `udp`, `icmp`, `gre`, `all`.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * Source IPv6 CIDR address block that requires access. Supports IP address ranges in CIDR format and IPv6 format. **NOTE:** This parameter cannot be set at the same time as the `cidr_ip` parameter.
     */
    public val ipv6CidrIp: Output<String>?
        get() = javaResource.ipv6CidrIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Network type, can be either `internet` or `intranet`, the default value is `internet`.
     */
    public val nicType: Output<String>
        get() = javaResource.nicType().applyValue({ args0 -> args0 })

    /**
     * The action of the Security Group Rule that determines whether to allow inbound access. Default value: `accept`. Valid values: `accept`, `drop`.
     */
    public val policy: Output<String>?
        get() = javaResource.policy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The range of port numbers relevant to the IP protocol. Default to "-1/-1". When the protocol is tcp or udp, each side port number range from 1 to 65535 and '-1/-1' will be invalid.
     * For example, `1/200` means that the range of the port numbers is 1-200. Other protocols' 'port_range' can only be "-1/-1", and other values will be invalid.
     */
    public val portRange: Output<String>?
        get() = javaResource.portRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the source/destination prefix list to which you want to control access. **NOTE:** If you specify `cidr_ip`,`source_security_group_id`,`ipv6_cidr_ip` parameter, this parameter is ignored.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })

    /**
     * The priority of the Security Group Rule. Default value: `1`. Valid values: `1` to `100`.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the Security Group.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The Alibaba Cloud user account Id of the target security group when security groups are authorized across accounts.  This parameter is invalid if `cidr_ip` has already been set.
     */
    public val sourceGroupOwnerAccount: Output<String>?
        get() = javaResource.sourceGroupOwnerAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target security group ID within the same region. If this field is specified, the `nic_type` can only select `intranet`.
     */
    public val sourceSecurityGroupId: Output<String>?
        get() = javaResource.sourceSecurityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the Security Group Rule. Valid values:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityGroupRuleMapper : ResourceMapper<SecurityGroupRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.SecurityGroupRule::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroupRule = SecurityGroupRule(
        javaResource as
            com.pulumi.alicloud.ecs.SecurityGroupRule,
    )
}

/**
 * @see [SecurityGroupRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroupRule].
 */
public suspend fun securityGroupRule(
    name: String,
    block: suspend SecurityGroupRuleResourceBuilder.() -> Unit,
): SecurityGroupRule {
    val builder = SecurityGroupRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroupRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroupRule(name: String): SecurityGroupRule {
    val builder = SecurityGroupRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
