@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Security Group Rule resource.
 * For information about Security Group Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/ecs/user-guide/security-group-rules).
 * > **NOTE:** Available since v0.1.0.
 * Represents a single `ingress` or `egress` group rule, which can be added to external Security Groups.
 * > **NOTE:**  `nic_type` should set to `intranet` when security group type is `vpc` or specifying the `source_security_group_id`. In this situation it does not distinguish between intranet and internet, the rule is effective on them both.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.SecurityGroup("default", {name: "default"});
 * const allowAllTcp = new alicloud.ecs.SecurityGroupRule("allow_all_tcp", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "internet",
 *     policy: "accept",
 *     portRange: "1/65535",
 *     priority: 1,
 *     securityGroupId: _default.id,
 *     cidrIp: "0.0.0.0/0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.SecurityGroup("default", name="default")
 * allow_all_tcp = alicloud.ecs.SecurityGroupRule("allow_all_tcp",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="internet",
 *     policy="accept",
 *     port_range="1/65535",
 *     priority=1,
 *     security_group_id=default.id,
 *     cidr_ip="0.0.0.0/0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = "default",
 *     });
 *     var allowAllTcp = new AliCloud.Ecs.SecurityGroupRule("allow_all_tcp", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "internet",
 *         Policy = "accept",
 *         PortRange = "1/65535",
 *         Priority = 1,
 *         SecurityGroupId = @default.Id,
 *         CidrIp = "0.0.0.0/0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "allow_all_tcp", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("internet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("1/65535"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: _default.ID(),
 * 			CidrIp:          pulumi.String("0.0.0.0/0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .name("default")
 *             .build());
 *         var allowAllTcp = new SecurityGroupRule("allowAllTcp", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("internet")
 *             .policy("accept")
 *             .portRange("1/65535")
 *             .priority(1)
 *             .securityGroupId(default_.id())
 *             .cidrIp("0.0.0.0/0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: default
 *   allowAllTcp:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: allow_all_tcp
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: internet
 *       policy: accept
 *       portRange: 1/65535
 *       priority: 1
 *       securityGroupId: ${default.id}
 *       cidrIp: 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing security-group module
 * to create a security group and add several rules one-click.
 * ## Import
 * Security Group Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/securityGroupRule:SecurityGroupRule example <id>
 * ```
 * @property cidrIp The target IP address range. The default value is 0.0.0.0/0 (which means no restriction will be applied). Other supported formats include 10.159.6.18/12. Only IPv4 is supported.
 * @property description The description of the security group rule. The description can be up to 1 to 512 characters in length. Defaults to null.
 * > **NOTE:**  You must specify one of the following field: `cidr_ip`,`source_security_group_id`,`prefix_list_id`,`ipv6_cidr_ip`.
 * @property ipProtocol The transport layer protocol of the Security Group Rule. Valid values: `tcp`, `udp`, `icmp`, `gre`, `all`.
 * @property ipv6CidrIp Source IPv6 CIDR address block that requires access. Supports IP address ranges in CIDR format and IPv6 format. **NOTE:** This parameter cannot be set at the same time as the `cidr_ip` parameter.
 * @property nicType Network type, can be either `internet` or `intranet`, the default value is `internet`.
 * @property policy The action of the Security Group Rule that determines whether to allow inbound access. Default value: `accept`. Valid values: `accept`, `drop`.
 * @property portRange The range of port numbers relevant to the IP protocol. Default to "-1/-1". When the protocol is tcp or udp, each side port number range from 1 to 65535 and '-1/-1' will be invalid.
 * For example, `1/200` means that the range of the port numbers is 1-200. Other protocols' 'port_range' can only be "-1/-1", and other values will be invalid.
 * @property prefixListId The ID of the source/destination prefix list to which you want to control access. **NOTE:** If you specify `cidr_ip`,`source_security_group_id`,`ipv6_cidr_ip` parameter, this parameter is ignored.
 * @property priority The priority of the Security Group Rule. Default value: `1`. Valid values: `1` to `100`.
 * @property securityGroupId The ID of the Security Group.
 * @property sourceGroupOwnerAccount The Alibaba Cloud user account Id of the target security group when security groups are authorized across accounts.  This parameter is invalid if `cidr_ip` has already been set.
 * @property sourceSecurityGroupId The target security group ID within the same region. If this field is specified, the `nic_type` can only select `intranet`.
 * @property type The type of the Security Group Rule. Valid values:
 */
public data class SecurityGroupRuleArgs(
    public val cidrIp: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ipProtocol: Output<String>? = null,
    public val ipv6CidrIp: Output<String>? = null,
    public val nicType: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val portRange: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val securityGroupId: Output<String>? = null,
    public val sourceGroupOwnerAccount: Output<String>? = null,
    public val sourceSecurityGroupId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.SecurityGroupRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.SecurityGroupRuleArgs =
        com.pulumi.alicloud.ecs.SecurityGroupRuleArgs.builder()
            .cidrIp(cidrIp?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .ipv6CidrIp(ipv6CidrIp?.applyValue({ args0 -> args0 }))
            .nicType(nicType?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .portRange(portRange?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .sourceGroupOwnerAccount(sourceGroupOwnerAccount?.applyValue({ args0 -> args0 }))
            .sourceSecurityGroupId(sourceSecurityGroupId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupRuleArgsBuilder internal constructor() {
    private var cidrIp: Output<String>? = null

    private var description: Output<String>? = null

    private var ipProtocol: Output<String>? = null

    private var ipv6CidrIp: Output<String>? = null

    private var nicType: Output<String>? = null

    private var policy: Output<String>? = null

    private var portRange: Output<String>? = null

    private var prefixListId: Output<String>? = null

    private var priority: Output<Int>? = null

    private var securityGroupId: Output<String>? = null

    private var sourceGroupOwnerAccount: Output<String>? = null

    private var sourceSecurityGroupId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The target IP address range. The default value is 0.0.0.0/0 (which means no restriction will be applied). Other supported formats include 10.159.6.18/12. Only IPv4 is supported.
     */
    @JvmName("jadwejobqignjyqe")
    public suspend fun cidrIp(`value`: Output<String>) {
        this.cidrIp = value
    }

    /**
     * @param value The description of the security group rule. The description can be up to 1 to 512 characters in length. Defaults to null.
     * > **NOTE:**  You must specify one of the following field: `cidr_ip`,`source_security_group_id`,`prefix_list_id`,`ipv6_cidr_ip`.
     */
    @JvmName("abgxjvwbybjrngbm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The transport layer protocol of the Security Group Rule. Valid values: `tcp`, `udp`, `icmp`, `gre`, `all`.
     */
    @JvmName("uyawmqyefsvnwnvw")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value Source IPv6 CIDR address block that requires access. Supports IP address ranges in CIDR format and IPv6 format. **NOTE:** This parameter cannot be set at the same time as the `cidr_ip` parameter.
     */
    @JvmName("riyctqlmbfonjsva")
    public suspend fun ipv6CidrIp(`value`: Output<String>) {
        this.ipv6CidrIp = value
    }

    /**
     * @param value Network type, can be either `internet` or `intranet`, the default value is `internet`.
     */
    @JvmName("snaedhadjvannlxc")
    public suspend fun nicType(`value`: Output<String>) {
        this.nicType = value
    }

    /**
     * @param value The action of the Security Group Rule that determines whether to allow inbound access. Default value: `accept`. Valid values: `accept`, `drop`.
     */
    @JvmName("sfpsjldrxdujnrbj")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The range of port numbers relevant to the IP protocol. Default to "-1/-1". When the protocol is tcp or udp, each side port number range from 1 to 65535 and '-1/-1' will be invalid.
     * For example, `1/200` means that the range of the port numbers is 1-200. Other protocols' 'port_range' can only be "-1/-1", and other values will be invalid.
     */
    @JvmName("vneumdxcuimffsmn")
    public suspend fun portRange(`value`: Output<String>) {
        this.portRange = value
    }

    /**
     * @param value The ID of the source/destination prefix list to which you want to control access. **NOTE:** If you specify `cidr_ip`,`source_security_group_id`,`ipv6_cidr_ip` parameter, this parameter is ignored.
     */
    @JvmName("srmfnhjldrdiqqku")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value The priority of the Security Group Rule. Default value: `1`. Valid values: `1` to `100`.
     */
    @JvmName("vumvtwevspqavqkf")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ID of the Security Group.
     */
    @JvmName("ufbtmyyfsusflxir")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The Alibaba Cloud user account Id of the target security group when security groups are authorized across accounts.  This parameter is invalid if `cidr_ip` has already been set.
     */
    @JvmName("mltuilfcefqhocsx")
    public suspend fun sourceGroupOwnerAccount(`value`: Output<String>) {
        this.sourceGroupOwnerAccount = value
    }

    /**
     * @param value The target security group ID within the same region. If this field is specified, the `nic_type` can only select `intranet`.
     */
    @JvmName("uowtxcnffdkctksu")
    public suspend fun sourceSecurityGroupId(`value`: Output<String>) {
        this.sourceSecurityGroupId = value
    }

    /**
     * @param value The type of the Security Group Rule. Valid values:
     */
    @JvmName("xptdatjyejlxarya")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The target IP address range. The default value is 0.0.0.0/0 (which means no restriction will be applied). Other supported formats include 10.159.6.18/12. Only IPv4 is supported.
     */
    @JvmName("soewjjpacanuacmo")
    public suspend fun cidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIp = mapped
    }

    /**
     * @param value The description of the security group rule. The description can be up to 1 to 512 characters in length. Defaults to null.
     * > **NOTE:**  You must specify one of the following field: `cidr_ip`,`source_security_group_id`,`prefix_list_id`,`ipv6_cidr_ip`.
     */
    @JvmName("pqcucnogqkoijipn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The transport layer protocol of the Security Group Rule. Valid values: `tcp`, `udp`, `icmp`, `gre`, `all`.
     */
    @JvmName("xmxnolojmmnrqanb")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value Source IPv6 CIDR address block that requires access. Supports IP address ranges in CIDR format and IPv6 format. **NOTE:** This parameter cannot be set at the same time as the `cidr_ip` parameter.
     */
    @JvmName("isrdsengnbgayclf")
    public suspend fun ipv6CidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrIp = mapped
    }

    /**
     * @param value Network type, can be either `internet` or `intranet`, the default value is `internet`.
     */
    @JvmName("bcashwwkvrbfvkcg")
    public suspend fun nicType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value The action of the Security Group Rule that determines whether to allow inbound access. Default value: `accept`. Valid values: `accept`, `drop`.
     */
    @JvmName("jlentvhqebhqylmg")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The range of port numbers relevant to the IP protocol. Default to "-1/-1". When the protocol is tcp or udp, each side port number range from 1 to 65535 and '-1/-1' will be invalid.
     * For example, `1/200` means that the range of the port numbers is 1-200. Other protocols' 'port_range' can only be "-1/-1", and other values will be invalid.
     */
    @JvmName("fuhljrjibkbybxii")
    public suspend fun portRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRange = mapped
    }

    /**
     * @param value The ID of the source/destination prefix list to which you want to control access. **NOTE:** If you specify `cidr_ip`,`source_security_group_id`,`ipv6_cidr_ip` parameter, this parameter is ignored.
     */
    @JvmName("miwxsipivcahvvht")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value The priority of the Security Group Rule. Default value: `1`. Valid values: `1` to `100`.
     */
    @JvmName("tmlsltcrsvpqwoog")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ID of the Security Group.
     */
    @JvmName("wogkiryqumhjvtxn")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The Alibaba Cloud user account Id of the target security group when security groups are authorized across accounts.  This parameter is invalid if `cidr_ip` has already been set.
     */
    @JvmName("seaugxkgrlvbgcsw")
    public suspend fun sourceGroupOwnerAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceGroupOwnerAccount = mapped
    }

    /**
     * @param value The target security group ID within the same region. If this field is specified, the `nic_type` can only select `intranet`.
     */
    @JvmName("utrqrgjwlednyxns")
    public suspend fun sourceSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityGroupId = mapped
    }

    /**
     * @param value The type of the Security Group Rule. Valid values:
     */
    @JvmName("igqiqjwcejkcfglq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecurityGroupRuleArgs = SecurityGroupRuleArgs(
        cidrIp = cidrIp,
        description = description,
        ipProtocol = ipProtocol,
        ipv6CidrIp = ipv6CidrIp,
        nicType = nicType,
        policy = policy,
        portRange = portRange,
        prefixListId = prefixListId,
        priority = priority,
        securityGroupId = securityGroupId,
        sourceGroupOwnerAccount = sourceGroupOwnerAccount,
        sourceSecurityGroupId = sourceSecurityGroupId,
        type = type,
    )
}
