@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.EcsSnapshot from version 1.120.0.
 * Provides an ECS snapshot resource.
 * For information about snapshot and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const snapshot = new alicloud.ecs.Snapshot("snapshot", {
 *     diskId: instance_attachment.diskId,
 *     name: "test-snapshot",
 *     description: "this snapshot is created for testing",
 *     tags: {
 *         version: "1.2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * snapshot = alicloud.ecs.Snapshot("snapshot",
 *     disk_id=instance_attachment["diskId"],
 *     name="test-snapshot",
 *     description="this snapshot is created for testing",
 *     tags={
 *         "version": "1.2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AliCloud.Ecs.Snapshot("snapshot", new()
 *     {
 *         DiskId = instance_attachment.DiskId,
 *         Name = "test-snapshot",
 *         Description = "this snapshot is created for testing",
 *         Tags =
 *         {
 *             { "version", "1.2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSnapshot(ctx, "snapshot", &ecs.SnapshotArgs{
 * 			DiskId:      pulumi.Any(instance_attachment.DiskId),
 * 			Name:        pulumi.String("test-snapshot"),
 * 			Description: pulumi.String("this snapshot is created for testing"),
 * 			Tags: pulumi.StringMap{
 * 				"version": pulumi.String("1.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.Snapshot;
 * import com.pulumi.alicloud.ecs.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .diskId(instance_attachment.diskId())
 *             .name("test-snapshot")
 *             .description("this snapshot is created for testing")
 *             .tags(Map.of("version", "1.2"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   snapshot:
 *     type: alicloud:ecs:Snapshot
 *     properties:
 *       diskId: ${["instance-attachment"].diskId}
 *       name: test-snapshot
 *       description: this snapshot is created for testing
 *       tags:
 *         version: '1.2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/snapshot:Snapshot snapshot s-abc1234567890000
 * ```
 * @property category
 * @property description Description of the snapshot. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
 * @property diskId The source disk ID.
 * @property force
 * @property instantAccess
 * @property instantAccessRetentionDays
 * @property name The name of the snapshot to be created. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
 * It cannot start with auto, because snapshot names starting with auto are recognized as automatic snapshots.
 * @property resourceGroupId The ID of the resource group.
 * @property retentionDays
 * @property snapshotName
 * @property tags A mapping of tags to assign to the resource.
 */
public data class SnapshotArgs(
    public val category: Output<String>? = null,
    public val description: Output<String>? = null,
    public val diskId: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val instantAccess: Output<Boolean>? = null,
    public val instantAccessRetentionDays: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val snapshotName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.SnapshotArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.SnapshotArgs =
        com.pulumi.alicloud.ecs.SnapshotArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .instantAccess(instantAccess?.applyValue({ args0 -> args0 }))
            .instantAccessRetentionDays(instantAccessRetentionDays?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var description: Output<String>? = null

    private var diskId: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var instantAccess: Output<Boolean>? = null

    private var instantAccessRetentionDays: Output<Int>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var snapshotName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("jkynccfpybmqwvkh")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Description of the snapshot. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("kecmfdafbrktvxvi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The source disk ID.
     */
    @JvmName("tdjmsuvjwiamovio")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value
     */
    @JvmName("vhkqhdyqbuhbmphd")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value
     */
    @JvmName("uxargtosxqknlghi")
    public suspend fun instantAccess(`value`: Output<Boolean>) {
        this.instantAccess = value
    }

    /**
     * @param value
     */
    @JvmName("bnqndcentphvoxxk")
    public suspend fun instantAccessRetentionDays(`value`: Output<Int>) {
        this.instantAccessRetentionDays = value
    }

    /**
     * @param value The name of the snapshot to be created. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     * It cannot start with auto, because snapshot names starting with auto are recognized as automatic snapshots.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    @JvmName("yvrldlqrxenovixj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("uycowrbutjenmfry")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("wefdvkhedebkixdg")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value
     */
    @JvmName("cpmubeogycxqpvot")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("lockaucwbrsqcanq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("kdrjceluyifaravj")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Description of the snapshot. This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
     */
    @JvmName("ktiubwwxuqmqvwmd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The source disk ID.
     */
    @JvmName("ujsqxilbwfmyeari")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value
     */
    @JvmName("subwyqbmrmwgamcy")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxyosufymvfoglgo")
    public suspend fun instantAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("cxeyorynlbxygnnt")
    public suspend fun instantAccessRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantAccessRetentionDays = mapped
    }

    /**
     * @param value The name of the snapshot to be created. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     * It cannot start with auto, because snapshot names starting with auto are recognized as automatic snapshots.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.120.0. New field 'snapshot_name' instead.
  """,
    )
    @JvmName("ybvdrqeghdurocrv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("cpuitibsxtlmsken")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("owkgytabstfwkivl")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("tmqfhglcsfxqtdpt")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("dchliineeiodbrmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ihwbkiygosvgbtjj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        category = category,
        description = description,
        diskId = diskId,
        force = force,
        instantAccess = instantAccess,
        instantAccessRetentionDays = instantAccessRetentionDays,
        name = name,
        resourceGroupId = resourceGroupId,
        retentionDays = retentionDays,
        snapshotName = snapshotName,
        tags = tags,
    )
}
